﻿DECLARE fks cursor for
select 'alter table ['+ object_name(parent_obj) + '] drop constraint ['+name+']; '
from sysobjects where xtype = 'F' and name like 'spb_%'
open fks
declare @dfk varchar(8000)
fetch next from fks into @dfk
while(@@fetch_status=0)
begin
exec(@dfk)
fetch next from fks into @dfk
end
close fks
deallocate fks
GO
declare @sc_Item varchar(500)
declare @xtype varchar(10)
declare schame cursor
for select [name],[xtype] from sysobjects where xtype = 'P' or xtype = 'U' or xtype = 'V' and name like 'spb_%'
open schame
fetch next from schame into @sc_Item,@xtype
while @@fetch_status = 0
begin
if @xtype = 'U'
exec('drop table ' + @sc_Item)
else if @xtype = 'P'
exec('drop procedure ' + @sc_Item)
else if @xtype = 'V'
exec('drop View ' + @sc_Item)
fetch next from schame into @sc_Item,@xtype
end
close schame
deallocate schame
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_CodeSets](
	[Code] [varchar](20) NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[IsMultileve] [bit] NOT NULL,
	[AllowAddDelete] [bit] NOT NULL,
	[AllowEdit] [bit] NOT NULL,
 CONSTRAINT [PK_spb_CodeSets] PRIMARY KEY CLUSTERED 
(
	[Code] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsThreads](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[SectionID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Contributor] [nvarchar](64) NOT NULL,
	[Title] [nvarchar](256) NOT NULL,
	[Subtitle] [nvarchar](256) NOT NULL,
	[PrefixID] [int] NOT NULL,
	[Body] [ntext] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[LastRepliedDate] [datetime] NOT NULL,
	[IsLocked] [bit] NOT NULL,
	[IsEssential] [bit] NOT NULL,
	[IsContributed] [bit] NOT NULL,
	[StickyDate] [datetime] NOT NULL,
	[SpecialOrder] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[RssViewTimes] [int] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[StageCommentCount] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
	[RatingSum] [int] NOT NULL,
	[TotalRatings] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[PointConsumption] [int] NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_NewsThreads] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsThreads_CommentCount] ON [dbo].[spb_NewsThreads] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsThreads_HitTimes] ON [dbo].[spb_NewsThreads] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsThreads_SectionID] ON [dbo].[spb_NewsThreads] 
(
	[SectionID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsThreads_SpecialOrder_LastRepliedDate] ON [dbo].[spb_NewsThreads] 
(
	[SpecialOrder] DESC,
	[LastRepliedDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsThreads_SpecialOrder_PostDate] ON [dbo].[spb_NewsThreads] 
(
	[SpecialOrder] DESC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsThreads_StageCommentCount] ON [dbo].[spb_NewsThreads] 
(
	[StageCommentCount] DESC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsThreads_StageHitTimes] ON [dbo].[spb_NewsThreads] 
(
	[StageHitTimes] DESC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsThreads_UserID] ON [dbo].[spb_NewsThreads] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogUserDatas](
	[UserID] [int] NOT NULL,
	[MostRecentThreadID] [int] NULL,
	[MostRecentThreadBody] [nvarchar](4000) NULL,
	[MostRecentThreadDate] [datetime] NULL,
	[ThreadCount] [int] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[FollowerCount] [int] NOT NULL,
	[FollowCount] [int] NOT NULL,
	[StageFollowerCount] [int] NOT NULL,
	[Theme] [nvarchar](128) NOT NULL,
	[ThemeAppearance] [nvarchar](128) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogUserDatas] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogsUserDatas_FollowCount] ON [dbo].[spb_MicroBlogUserDatas] 
(
	[FollowCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogsUserDatas_FollowerCount] ON [dbo].[spb_MicroBlogUserDatas] 
(
	[FollowerCount] ASC
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_MicroBlogsUserDatas_UserID] ON [dbo].[spb_MicroBlogUserDatas] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsThread_UpdateStickyStatus]
( 
    @ThreadID int,
    @SpecialOrder int,
	@StickyDate datetime = ''
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if @SpecialOrder > 0
	update spb_NewsThreads set SpecialOrder=@SpecialOrder,StickyDate=@StickyDate where ThreadID=@ThreadID
else
	update spb_NewsThreads set SpecialOrder=@SpecialOrder where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**
<summary>
根据UserID获取UserIdentifier
</summary>
**/

CREATE PROCEDURE [dbo].[spb_UserIdentifier_Get]
(
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

  SELECT UserID,UserName,CommonName,Nickname,PrivateEmail
  FROM spb_Users 
  WHERE  UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE procedure [dbo].[spb_ItemsInApplicationTags_Delete]
(
	@TagsTableName nvarchar(64),
	@ItemInTagsTableName nvarchar(64),
	@ItemID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @sql nvarchar(1000)
set @sql='update '+@TagsTableName+' set ItemCount=ItemCount-1 where TagName in(select TagName from '+@ItemInTagsTableName+' where ItemID=@ItemID)
		  delete '+@ItemInTagsTableName+' where ItemID=@ItemID'
exec sp_executesql @sql,N'@ItemID int',@ItemID=@ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 批量设置资讯栏目 */

CREATE PROCEDURE [dbo].[spb_NewsThread_UpdateSiteCategory]
( 
    @ThreadID int,
    @SectionID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_NewsThreads set SectionID=@SectionID where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ApplicationInAvailablePresentAreas](
	[ApplicationID] [int] NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[IsBuiltIn] [bit] NOT NULL,
	[IsDataEntry] [bit] NOT NULL,
 CONSTRAINT [PK_spb_ApplicationInAvailablePresentAreas] PRIMARY KEY CLUSTERED 
(
	[ApplicationID] ASC,
	[PresentAreaID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除朋友的所属类别 **/

CREATE PROCEDURE [dbo].[spb_UserCategoriesOfItem_Delete]
(
	@CategoriesTableName nvarchar(64),
	@UserItemTableName nvarchar(64),
    @ItemID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
	declare @sql nvarchar(1100)
    set @sql='UPDATE '+@CategoriesTableName+' SET ItemCount = ItemCount - 1 WHERE (ItemCount>0) and CategoryID in 
              (select CategoryID from '+@UserItemTableName+' with (nolock) where ItemID=@ItemID)
			  DELETE FROM '+@UserItemTableName+' WHERE (ItemID = @ItemID)'
	exec sp_executesql @sql,N'@ItemID int',@ItemID=@ItemID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_MicroBlogSimpleFollows_GetAll]
(
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

Create table #TempSimpleFollows(
   FollowID int,
   UserID int,
   ItemID int,
   UserName nvarchar(64),
   CommonName nvarchar(64),
   Nickname nvarchar(64),
)

Create table #TempUserCategories(
   FollowID int,
   CategoryID int
)

insert into #TempSimpleFollows(FollowID,UserID,ItemID,UserName,CommonName,Nickname) 
SELECT F.FollowID,F.UserID, F.ItemID,U.UserName,U.CommonName,U.Nickname
FROM spb_MicroBlogFollows F inner join spb_Users U on U.UserID = F.ItemID
WHERE  F.UserID = @UserID
create clustered index idx_tmp On #TempSimpleFollows(FollowID) with FILLFACTOR = 100
select * from #TempSimpleFollows

declare @iRwCnt int
declare @TempID int
set @iRwCnt = 1
while @iRwCnt > 0
Begin
  select top 1 @TempID = FollowID from #TempSimpleFollows
  insert into #TempUserCategories(FollowID,CategoryID) select @TempID,CategoryID from spb_MicroBlogFollowsInUserCategories where ItemID = @TempID
  delete from #TempSimpleFollows where FollowID = @TempID
  set @iRwCnt = @@ROWCOUNT
  set @TempID = 0
End
select * from #TempUserCategories 
drop table #TempSimpleFollows
drop table #TempUserCategories
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogTopicesFavorites](
	[UserID] [int] NOT NULL,
	[Keyword] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogTopicesFavorites] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[Keyword] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_CodeItems](
	[CodeSetCode] [varchar](20) NOT NULL,
	[ItemID] [int] NOT NULL,
	[ParentItemID] [int] NOT NULL,
	[Name] [nvarchar](100) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Depth] [int] NOT NULL,
 CONSTRAINT [PK_spb_CodeItems] PRIMARY KEY CLUSTERED 
(
	[CodeSetCode] ASC,
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_CodeItems_ItemID] ON [dbo].[spb_CodeItems] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_RecommendedItemTypes_Res](
	[TypeID] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[Name] [nvarchar](128) NOT NULL,
 CONSTRAINT [PK_spb_RecommendedItemTypes_Res] PRIMARY KEY CLUSTERED 
(
	[TypeID] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取某个用户的所有类别ID **/

create PROCEDURE [dbo].[spb_UserCategories_GetIDs]
(
  @CategoriesTableName nvarchar(64),
  @UserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @sql nvarchar(200)
set @sql='SELECT CategoryID FROM '+@CategoriesTableName+' WHERE  UserID = @UserID ORDER BY DisplayOrder asc'
exec sp_executesql @sql,N'@UserID int',@UserID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_RecommendedItemTypes](
	[TypeID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[Name] [nvarchar](256) NOT NULL,
	[Description] [nvarchar](2048) NOT NULL,
 CONSTRAINT [PK_spb_RecommendedItemTypes_1] PRIMARY KEY CLUSTERED 
(
	[TypeID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_RecommendedItemTypes_ApplicationID] ON [dbo].[spb_RecommendedItemTypes] 
(
	[ApplicationID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**
<summary>
根据UserID获取SimpleFriend
</summary>
**/

CREATE PROCEDURE [dbo].[spb_Friends_GetAll]
(
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

Create table #TempFriends(
   FriendID int,
   UserID int,
   FriendUserID int,
   NoteName nvarchar(64),
   Friendliness int,
   UserName nvarchar(64),
   CommonName nvarchar(64),
   Nickname nvarchar(64),
   PrivateEmail nvarchar(64)
)

Create table #TempUserCategories(
   FriendID int,
   CategoryID int
)

insert into #TempFriends(FriendID,UserID,FriendUserID,NoteName,Friendliness,UserName,CommonName,Nickname,PrivateEmail) 
SELECT F.FriendID,F.UserID, F.FriendUserID,F.NoteName,F.Friendliness,U.UserName,U.CommonName,U.Nickname,U.PrivateEmail
FROM spb_Friends F inner join spb_Users U on U.UserID = F.FriendUserID
WHERE  F.UserID = @UserID
create clustered index idx_tmp On #TempFriends(FriendID) with FILLFACTOR = 100
select * from #TempFriends

declare @iRwCnt int
declare @TempID int
set @iRwCnt = 1
while @iRwCnt > 0
Begin
  select top 1 @TempID = FriendID from #TempFriends
  insert into #TempUserCategories(FriendID,CategoryID) select @TempID,CategoryID from spb_FriendsInUserCategories where ItemID = @TempID
  delete from #TempFriends where FriendID = @TempID
  set @iRwCnt = @@ROWCOUNT
  set @TempID = 0
End
select * from #TempUserCategories 
drop table #TempFriends
drop table #TempUserCategories
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsThread_Get]
( 
    @ThreadID int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_NewsThreads WITH (NOLOCK) where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Languages](
	[LanguageCode] [varchar](20) NOT NULL,
	[NativeName] [nvarchar](100) NOT NULL,
	[IsEnabled] [bit] NOT NULL,
 CONSTRAINT [PK_spb_Languages] PRIMARY KEY CLUSTERED 
(
	[LanguageCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogScreenFavorites](
	[FavoriteID] [int] IDENTITY(1,1) NOT NULL,
	[ScreenID] [int] NOT NULL,
	[SerialNumber] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogScreenFavorites] PRIMARY KEY CLUSTERED 
(
	[FavoriteID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogScreenFavorites_SectionID_SerialNumber] ON [dbo].[spb_MicroBlogScreenFavorites] 
(
	[ScreenID] ASC,
	[SerialNumber] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE procedure [dbo].[spb_ItemsInApplicationTags_Update]
(
	@TagsTableName nvarchar(64),
	@ItemInTagsTableName nvarchar(64),
	@ItemID int,
	@TagName nvarchar(64)=''
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @sql nvarchar(300)
set @sql='insert into '+@ItemInTagsTableName+'(TagName,ItemID)values(@TagName,@ItemID)
		  update '+@TagsTableName+' set ItemCount=ItemCount+1 where TagName=@TagName'
exec sp_executesql @sql,N'@ItemID int,@TagName nvarchar(64)',@ItemID=@ItemID,@TagName=@TagName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据UserID，获取UserName **/

CREATE procedure [dbo].[spb_User_GetUserNameByUserID]
(
	@UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
SELECT UserName from dbo.spb_users with (nolock) WHERE UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Invitations](
	[InvitationID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[SenderUserID] [int] NOT NULL,
	[Sender] [nvarchar](64) NOT NULL,
	[ReceiverUserID] [int] NOT NULL,
	[Receiver] [nvarchar](64) NOT NULL,
	[RelativeItemID] [int] NOT NULL,
	[RelativeItemName] [nvarchar](256) NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[Status] [int] NOT NULL,
	[TransportMode] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_Invitations] PRIMARY KEY CLUSTERED 
(
	[InvitationID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Invitations_RelativeItemID] ON [dbo].[spb_Invitations] 
(
	[RelativeItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserPointItems](
	[ItemID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[ItemKey] [nvarchar](64) NOT NULL,
	[ItemName] [nvarchar](64) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_spb_UserPointItems] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_UserPointItems_ItemKey] ON [dbo].[spb_UserPointItems] 
(
	[ItemKey] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserLinkCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[CategoryName] [nvarchar](256) NOT NULL,
	[Description] [nvarchar](1024) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_spb_UserLinkCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserLinkCategories_UserID_DisplayOrder] ON [dbo].[spb_UserLinkCategories] 
(
	[UserID] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除Item与用户标签的关联 **/
CREATE PROCEDURE [dbo].[spb_ItemsInUserTag_Delete]
(
	@UserTagsTableName nvarchar(64),
	@SiteTagsTableName nvarchar(64),
	@InUserTagsTableName nvarchar(64),
	@ItemID int
)
AS
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED
declare @strSql nvarchar(1200)
set @strSql='update '+@UserTagsTableName+' set ItemCount=ItemCount-1 where TagName in (select TagName from '+@InUserTagsTableName+' where ItemID=@ItemID)
			 update '+@SiteTagsTableName+' set ItemCount=ItemCount-1 where TagName in (select TagName from '+@UserTagsTableName+' where TagName in (select TagName from '+@InUserTagsTableName+' where ItemID=@ItemID))
			 delete from '+@InUserTagsTableName+' where ItemID=@ItemID'
exec sp_executesql @strSql,N'@ItemID int',@ItemID=@ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumRatings](
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Rate] [int] NOT NULL,
 CONSTRAINT [PK_spb_ForumRatings] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumRatings_UserID] ON [dbo].[spb_ForumRatings] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_JobSorts](
	[Code] [nchar](4) NOT NULL,
	[Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_spb_JobSorts] PRIMARY KEY CLUSTERED 
(
	[Code] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ShareThreads](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[URL] [nvarchar](512) NOT NULL,
	[URLSalt] [nvarchar](128) NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[ThumbnailUrl] [nvarchar](512) NOT NULL,
	[SiteCategoryID] [int] NOT NULL,
	[MediaType] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[DayHitTimes] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[BackerCount] [int] NOT NULL,
	[DissenterCount] [int] NOT NULL,
	[UserCount] [int] NOT NULL,
	[DayUserCount] [int] NOT NULL,
	[StageUserCount] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ShareThreads] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_BackerCount] ON [dbo].[spb_ShareThreads] 
(
	[BackerCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_CommentCount] ON [dbo].[spb_ShareThreads] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_DayHitTimes] ON [dbo].[spb_ShareThreads] 
(
	[DayHitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_DayUserCount] ON [dbo].[spb_ShareThreads] 
(
	[DayUserCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_DissenterCount] ON [dbo].[spb_ShareThreads] 
(
	[DissenterCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_HitTimes] ON [dbo].[spb_ShareThreads] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_MediaTypeID] ON [dbo].[spb_ShareThreads] 
(
	[MediaType] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_ShareCategoryID_ApplicationID] ON [dbo].[spb_ShareThreads] 
(
	[SiteCategoryID] ASC,
	[ApplicationID] ASC
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_ShareThreads_URLSalt] ON [dbo].[spb_ShareThreads] 
(
	[URLSalt] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_UserCount] ON [dbo].[spb_ShareThreads] 
(
	[UserCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_WeekHitTimes] ON [dbo].[spb_ShareThreads] 
(
	[StageHitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareThreads_WeekUserCount] ON [dbo].[spb_ShareThreads] 
(
	[StageUserCount] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserPointStatisticsPerDay](
	[UserID] [int] NOT NULL,
	[ItemID] [int] NOT NULL,
	[BasicPoints] [int] NOT NULL,
	[ReportPoints] [int] NOT NULL,
	[CreditPoints] [int] NOT NULL,
	[TradePoints] [int] NOT NULL,
 CONSTRAINT [PK_spb_UserPointStatisticsPerDay] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_IntegratedPointRules](
	[RuleID] [int] NOT NULL,
	[RuleItemName] [nvarchar](256) NOT NULL,
	[Description] [nvarchar](1024) NOT NULL,
	[ScoringRate] [float] NOT NULL,
 CONSTRAINT [PK_spb_IntegratedPointRules] PRIMARY KEY CLUSTERED 
(
	[RuleID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Advertisings](
	[AdvertisingID] [int] IDENTITY(1,1) NOT NULL,
	[OwnerID] [int] NOT NULL,
	[AdvertisingName] [nvarchar](256) NOT NULL,
	[Script] [ntext] NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[AdvertisingType] [int] NOT NULL,
	[DisplayTimes] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[EffectiveDateFrom] [datetime] NULL,
	[EffectiveDateTo] [datetime] NULL,
	[IsEnabled] [bit] NOT NULL,
	[UseredPositions] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_Advertisings] PRIMARY KEY CLUSTERED 
(
	[AdvertisingID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_JobSorts_Res](
	[Code] [nchar](4) NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[Name] [nvarchar](128) NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_JobSorts_Res_Code_LanguageCode] ON [dbo].[spb_JobSorts_Res] 
(
	[Code] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumPostAttachments](
	[AttachmentID] [int] IDENTITY(1,1) NOT NULL,
	[PostID] [int] NOT NULL,
	[SectionID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[FileName] [nvarchar](512) NOT NULL,
	[FriendlyFileName] [nvarchar](512) NOT NULL,
	[ContentType] [nvarchar](64) NOT NULL,
	[ContentSize] [int] NOT NULL,
	[Height] [int] NOT NULL,
	[Width] [int] NOT NULL,
	[IsRemote] [bit] NOT NULL,
	[Price] [int] NOT NULL,
	[IsHidden] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[DownloadCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_ForumPostAttments] PRIMARY KEY CLUSTERED 
(
	[AttachmentID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumPostAttachments_PostID] ON [dbo].[spb_ForumPostAttachments] 
(
	[PostID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Applications](
	[ApplicationID] [int] NOT NULL,
	[ApplicationType] [varchar](512) NOT NULL,
	[IsEnabled] [bit] NOT NULL,
	[TotalCount] [int] NOT NULL,
	[CountInPast24Hours] [int] NOT NULL,
	[NewestID] [int] NOT NULL,
	[ApplicationKey] [nvarchar](64) NOT NULL,
	[IsLocked] [bit] NOT NULL,
	[AllowPersonUser] [bit] NOT NULL,
	[AllowCompanyUser] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_Applications] PRIMARY KEY CLUSTERED 
(
	[ApplicationID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除spb_UserNavigations **/
CREATE PROCEDURE [dbo].[spb_UserNavigation_CreateUpdateDelete]
(
	@Action int,
	@NavigationID int output,
	@NavigationType int=0,
	@UserID int =0,
	@ApplicationID int=0,
	@NavigationText nvarchar(64)='',
	@NavigationUrl nvarchar(512)='',
	@NavigationTarget nvarchar(64)='',
	@DisplayOrder int=0,
	@IsEnabled bit = 1
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

if @Action = 2 --删除
    begin
		delete spb_UserNavigations where NavigationID = @NavigationID
    end

else if @Action =1 --更新
    begin
		update spb_UserNavigations set NavigationType = @NavigationType,UserID = @UserID,ApplicationID = @ApplicationID,
			NavigationText = @NavigationText,NavigationUrl = @NavigationUrl,NavigationTarget=@NavigationTarget,
			DisplayOrder = @DisplayOrder,IsEnabled = @IsEnabled where NavigationID=@NavigationID
    end
else
    begin
        insert into spb_UserNavigations(NavigationType,UserID,ApplicationID,NavigationText,NavigationUrl,NavigationTarget,DisplayOrder,IsEnabled)
			values(@NavigationType,@UserID,@ApplicationID,@NavigationText,@NavigationUrl,@NavigationTarget,@DisplayOrder,@IsEnabled)
	    set @NavigationID = SCOPE_IDENTITY()
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsSections_Res](
	[SectionID] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[SectionName] [nvarchar](256) NOT NULL,
 CONSTRAINT [PK_spb_NewsSections_Res] PRIMARY KEY CLUSTERED 
(
	[SectionID] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_NewsSections_Res_SectionID_LanguageCode] ON [dbo].[spb_NewsSections_Res] 
(
	[SectionID] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_UrlInfo_Get]
	@Alias nvarchar(16) = ''
AS
SET Transaction Isolation Level Read UNCOMMITTED
Select * From spb_UrlInfos Where Alias = @Alias
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 保存UserNavigation **/
CREATE PROCEDURE [dbo].[spb_UserNavigation_Save]
(
	@NavigationID int,
	@NavigationType int=0,
	@UserID int =0,
	@ApplicationID int=0,
	@NavigationText nvarchar(64)='',
	@NavigationUrl nvarchar(512)='',
	@NavigationTarget nvarchar(64)='',
	@DisplayOrder int=0,
	@IsEnabled bit = 1
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

if(@NavigationID>0) and exists(select NavigationID from spb_UserNavigations with (nolock) where NavigationID=@NavigationID and UserID=@UserID)
    begin
		update spb_UserNavigations set NavigationType = @NavigationType,ApplicationID = @ApplicationID,
			NavigationText = @NavigationText,NavigationUrl = @NavigationUrl,NavigationTarget=@NavigationTarget,
			DisplayOrder = @DisplayOrder,IsEnabled = @IsEnabled where NavigationID=@NavigationID
    end
else
    begin
        insert into spb_UserNavigations(NavigationType,UserID,ApplicationID,NavigationText,NavigationUrl,NavigationTarget,DisplayOrder,IsEnabled)
			values(@NavigationType,@UserID,@ApplicationID,@NavigationText,@NavigationUrl,@NavigationTarget,@DisplayOrder,@IsEnabled)	    
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FileAttachments](
	[AttachmentID] [int] IDENTITY(1,1) NOT NULL,
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[FileName] [nvarchar](512) NOT NULL,
	[FriendlyFileName] [nvarchar](512) NOT NULL,
	[ContentType] [nvarchar](64) NOT NULL,
	[ContentSize] [int] NOT NULL,
	[Height] [int] NOT NULL,
	[Width] [int] NOT NULL,
	[IsRemote] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_FileAttachments] PRIMARY KEY CLUSTERED 
(
	[AttachmentID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PermissionItemRolesInUserRoles](
	[ItemID] [int] NOT NULL,
	[RoleID] [int] NOT NULL,
	[AllowType] [int] NOT NULL,
	[AllowedValue] [float] NOT NULL,
	[IsLocked] [bit] NOT NULL,
 CONSTRAINT [PK_spb_PermissionItemRolesInUserRoles] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[RoleID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_PermissionItemRolesInUserRoles_ItemID_RoleID] ON [dbo].[spb_PermissionItemRolesInUserRoles] 
(
	[ItemID] ASC,
	[RoleID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Contacts](
	[ContactID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[DisplayName] [nvarchar](64) NOT NULL,
	[Gender] [int] NOT NULL,
	[PersonEmail] [nvarchar](64) NOT NULL,
	[Mobile] [nvarchar](64) NOT NULL,
	[HomeTel] [nvarchar](64) NOT NULL,
	[MsnIM] [nvarchar](64) NOT NULL,
	[YahooIM] [nvarchar](64) NOT NULL,
	[QQIM] [nvarchar](64) NOT NULL,
	[SkypeIM] [nvarchar](64) NOT NULL,
	[Title] [nvarchar](64) NOT NULL,
	[CompanyName] [nvarchar](256) NOT NULL,
	[WorkTel] [nvarchar](64) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[Source] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_Contacts] PRIMARY KEY CLUSTERED 
(
	[ContactID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Contacts_UserID] ON [dbo].[spb_Contacts] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取收藏 **/

CREATE PROCEDURE [dbo].[spb_Favorites_BatchDelete]
(
  @FavoriteTableName nvarchar(64),
  @ItemID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @sql nvarchar(1000)
set @sql='DELETE  FROM '+@FavoriteTableName+' WHERE  ItemID = @ItemID'
exec sp_executesql @sql,N'@ItemID int', @ItemID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserActivities](
	[ActivityID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[ActivityItemID] [int] NOT NULL,
	[LeadingActorUserID] [int] NOT NULL,
	[LeadingActor] [nvarchar](256) NOT NULL,
	[RelativeItemID] [int] NOT NULL,
	[RelativeItemName] [nvarchar](256) NOT NULL,
	[Subject] [nvarchar](2000) NULL,
	[Body] [ntext] NOT NULL,
	[IsPublic] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_UserActivities] PRIMARY KEY CLUSTERED 
(
	[ActivityID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserActivities_LeadingActorUserID_ApplicationID] ON [dbo].[spb_UserActivities] 
(
	[LeadingActorUserID] ASC,
	[ApplicationID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_DefaultNavigations](
	[DefaultNavigationID] [int] NOT NULL,
	[NavigationType] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[NavigationText] [nvarchar](64) NOT NULL,
	[NavigationUrl] [nvarchar](512) NOT NULL,
	[NavigationTarget] [nvarchar](64) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IsEnabled] [bit] NOT NULL,
	[OnlyOwnerVisible] [bit] NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[SecondaryID] [int] NOT NULL,
	[UrlRouteName] [nvarchar](64) NOT NULL,
	[IsLocked] [bit] NOT NULL,
 CONSTRAINT [PK_spb_DefaultNavigations] PRIMARY KEY CLUSTERED 
(
	[DefaultNavigationID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogThreadTypes](
	[TypeID] [int] IDENTITY(1,1) NOT NULL,
	[TypeName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_BlogThreadTypes] PRIMARY KEY CLUSTERED 
(
	[TypeID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumSections](
	[SectionID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[GroupID] [int] NOT NULL,
	[ParentIDList] [nvarchar](1024) NOT NULL,
	[ChildCount] [int] NOT NULL,
	[Depth] [int] NOT NULL,
	[SectionName] [nvarchar](512) NOT NULL,
	[Description] [nvarchar](2000) NOT NULL,
	[ForumType] [int] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IsActive] [bit] NOT NULL,
	[EnaleSearch] [bit] NOT NULL,
	[LogoUrl] [nvarchar](255) NOT NULL,
	[ThreadCategoryStatus] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[ThreadCount] [int] NOT NULL,
	[PostCount] [int] NOT NULL,
	[TodayPostCount] [int] NOT NULL,
	[MostRecentPostDate] [datetime] NULL,
	[MostRecentPostAuthor] [nvarchar](64) NULL,
	[MostRecentPostAuthorID] [int] NULL,
	[MostRecentPostID] [int] NULL,
	[MostRecentThreadID] [int] NULL,
	[MostRecentPostSubject] [nvarchar](512) NULL,
	[EnableAnonymousPosting] [bit] NOT NULL,
	[InheriteModerator] [bit] NOT NULL,
	[EnableRSS] [bit] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ForumSections] PRIMARY KEY CLUSTERED 
(
	[SectionID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EventThreadFavorites](
	[FavoriteID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[DisplayName] [nvarchar](64) NOT NULL,
	[ItemID] [int] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_EventThreadFavorites] PRIMARY KEY CLUSTERED 
(
	[FavoriteID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreadFavorites_ItemID] ON [dbo].[spb_EventThreadFavorites] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreadFavorites_UserID] ON [dbo].[spb_EventThreadFavorites] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Areas](
	[AreaCode] [varchar](8) NOT NULL,
	[ParentCode] [varchar](8) NOT NULL,
	[Name] [nvarchar](128) NOT NULL,
	[PostCode] [nvarchar](8) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Depth] [int] NOT NULL,
	[ChildCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_Areas] PRIMARY KEY CLUSTERED 
(
	[AreaCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Areas_DisplayOrder] ON [dbo].[spb_Areas] 
(
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogTimeLines](
	[UserID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[OriginalThreadID] [int] NOT NULL,
	[FollowUserID] [int] NOT NULL,
	[HasPhoto] [bit] NOT NULL,
	[HasVideo] [bit] NOT NULL,
	[HasMusic] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogTimeLine] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogTimeLine_DateCreated] ON [dbo].[spb_MicroBlogTimeLines] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogTimeLine_FollowUserID] ON [dbo].[spb_MicroBlogTimeLines] 
(
	[FollowUserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Themes](
	[PresentAreaID] [int] NOT NULL,
	[DirectoryName] [nvarchar](32) NOT NULL,
	[Parent] [nvarchar](32) NOT NULL,
	[DefaultAppearanceName] [nvarchar](32) NOT NULL,
	[EnableChangeLayout] [bit] NOT NULL,
	[EnablePrintCSS] [bit] NOT NULL,
	[IsEnabled] [bit] NOT NULL,
 CONSTRAINT [PK_spb_Themes] PRIMARY KEY CLUSTERED 
(
	[PresentAreaID] ASC,
	[DirectoryName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_AnonymousUsers](
	[UserGuid] [char](36) NOT NULL,
	[LastActivityDateTime] [datetime] NOT NULL,
	[LastAction] [nvarchar](1024) NOT NULL,
	[IPAddress] [nvarchar](32) NOT NULL,
 CONSTRAINT [PK_spb_AnonymousUsers] PRIMARY KEY CLUSTERED 
(
	[UserGuid] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_AnonymousUsers] ON [dbo].[spb_AnonymousUsers] 
(
	[UserGuid] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [dbo].[spb_UserPasswordQuestionAndAnswer_Update]
    @UserName              nvarchar(64),
    @NewPasswordQuestion   nvarchar(256),
    @NewPasswordAnswer     nvarchar(128)
AS
set nocount on
BEGIN
  update spb_Users set PasswordQuestion = @NewPasswordQuestion,PasswordAnswer=@NewPasswordAnswer
    where LoweredUserName = LOWER(@UserName)

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserGuestbookPosts](
	[PostID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ParentUserID] [int] NOT NULL,
	[IsPrivate] [bit] NOT NULL,
	[GuestbookID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[IsApproved] [bit] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_UserGuestbookPosts] PRIMARY KEY CLUSTERED 
(
	[PostID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserGuestbookPosts_GuestbookID] ON [dbo].[spb_UserGuestbookPosts] 
(
	[GuestbookID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserPointItemRules](
	[ItemID] [int] NOT NULL,
	[BasicPoints] [int] NOT NULL,
	[ReportPoints] [int] NOT NULL,
	[CreditPoints] [int] NOT NULL,
	[TradePoints] [int] NOT NULL,
	[BasicPointQuota] [int] NOT NULL,
	[ReportPointQuota] [int] NOT NULL,
	[CreditPointQuota] [int] NOT NULL,
	[TradePointQuota] [int] NOT NULL,
 CONSTRAINT [PK_spb_UserPointItemRules] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EventPosts](
	[PostID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ParentUserID] [int] NOT NULL,
	[EventID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Body] [ntext] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_EventPosts] PRIMARY KEY CLUSTERED 
(
	[PostID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventPosts_EventID] ON [dbo].[spb_EventPosts] 
(
	[EventID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogRatings](
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Rate] [int] NOT NULL,
 CONSTRAINT [PK_spb_BlogRatings] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogRatings_UserID] ON [dbo].[spb_BlogRatings] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_RecommendedItems](
	[CommendID] [int] IDENTITY(1,1) NOT NULL,
	[CommendTypeID] [int] NOT NULL,
	[ItemID] [int] NOT NULL,
	[ItemName] [nvarchar](256) NOT NULL,
	[Commender] [nvarchar](64) NOT NULL,
	[CommenderUserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[AuthorUserID] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[Deadline] [datetime] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_RecommendedItems] PRIMARY KEY CLUSTERED 
(
	[CommendID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_RecommendedItems_CommendTypeID] ON [dbo].[spb_RecommendedItems] 
(
	[CommendTypeID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_DeletionInFileSystem_Gets]
(
 @storageProviderName nvarchar(256)
)
As
begin
declare @sql nvarchar(4000)
set @sql='
Create table #Temp_FilesOfPendingDeletion_'+@storageProviderName+'(
    [id] int,
   	[StorageProviderName] [nvarchar](256),
	[FullDirectory] [nvarchar](1024),
	[FileName] [nvarchar](256)
)
if('''+@storageProviderName+'''=''All'')
insert into #Temp_FilesOfPendingDeletion_'+@storageProviderName+'(id,[StorageProviderName],[FullDirectory],[FileName]) 
  select top 1000 ID,[StorageProviderName],[FullDirectory],[FileName] from spb_FilesOfPendingDeletion with (nolock)
else
insert into #Temp_FilesOfPendingDeletion_'+@storageProviderName+'(id,[StorageProviderName],[FullDirectory],[FileName]) 
  select top 1000 ID,[StorageProviderName],[FullDirectory],[FileName] from spb_FilesOfPendingDeletion with (nolock) where StorageProviderName='''+@storageProviderName+'''
  
select * from #Temp_FilesOfPendingDeletion_'+@storageProviderName+'

delete from spb_FilesOfPendingDeletion where ID in (select id from #Temp_FilesOfPendingDeletion_'+@storageProviderName+')
drop table #Temp_FilesOfPendingDeletion_'+@storageProviderName
exec (@sql)
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_SiteLinkCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[CategoryName] [nvarchar](256) NOT NULL,
	[Description] [nvarchar](1024) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_spb_SiteLinkCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UsersOnline](
	[UserID] [int] NOT NULL,
	[DisplayName] [nvarchar](64) NOT NULL,
	[LastActivityDateTime] [datetime] NOT NULL,
	[LastAction] [nvarchar](1024) NOT NULL,
	[IPAddress] [nvarchar](32) NOT NULL,
 CONSTRAINT [PK_spb_UsersOnline] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UsersOnline_LastActivity] ON [dbo].[spb_UsersOnline] 
(
	[LastActivityDateTime] DESC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_VoteUserDatas](
	[UserID] [int] NOT NULL,
	[TotalThreadCount] [int] NOT NULL,
	[OverdueThreadCount] [int] NOT NULL,
	[ProgressThreadCount] [int] NOT NULL,
	[MostRecentThreadID] [int] NOT NULL,
	[MostRecentSubject] [nvarchar](64) NOT NULL,
	[MostRecentDateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_VoteUserDatas] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Schools](
	[SchoolID] [int] IDENTITY(1,1) NOT NULL,
	[SchoolName] [nvarchar](128) NOT NULL,
	[SchoolType] [int] NOT NULL,
	[AreaCode] [varchar](8) NOT NULL,
	[AreaName] [nvarchar](128) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_spb_Schools] PRIMARY KEY CLUSTERED 
(
	[SchoolID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Schools_AreaCode] ON [dbo].[spb_Schools] 
(
	[AreaCode] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Schools_AreaCode_DisplayOrder] ON [dbo].[spb_Schools] 
(
	[AreaCode] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PhotoRatings](
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Rate] [int] NOT NULL,
 CONSTRAINT [PK_spb_PhotoRatings] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoRatings_UserID] ON [dbo].[spb_PhotoRatings] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ActivityItems](
	[ItemID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[ItemKey] [nvarchar](64) NOT NULL,
	[ItemName] [nvarchar](64) NULL,
	[DisplayOrder] [int] NOT NULL,
	[OnlyOneTimePerDay] [bit] NOT NULL,
 CONSTRAINT [PK_spb_ActivityItems] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_ActivityItems_ItemKey] ON [dbo].[spb_ActivityItems] 
(
	[ItemKey] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FileThreads](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[LastRepliedDate] [datetime] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[Password] [nvarchar](64) NOT NULL,
	[IsLocked] [bit] NOT NULL,
	[IsEssential] [bit] NOT NULL,
	[Price] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
	[SpecialOrder] [int] NOT NULL,
	[StickyDate] [datetime] NOT NULL,
	[RssViewTimes] [int] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[DownloadCount] [int] NOT NULL,
	[StageDownloadCount] [int] NOT NULL,
	[RatingSum] [int] NOT NULL,
	[TotalRatings] [int] NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[SiteCategoryID] [int] NOT NULL,
	[UserCategoryID] [int] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[FileName] [nvarchar](512) NOT NULL,
	[ContentType] [nvarchar](64) NOT NULL,
	[ContentSize] [int] NOT NULL,
	[Height] [int] NOT NULL,
	[Width] [int] NOT NULL,
	[IsRemote] [bit] NOT NULL,
 CONSTRAINT [PK_spb_FileThreads] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_CommentCount] ON [dbo].[spb_FileThreads] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_DownloadCount] ON [dbo].[spb_FileThreads] 
(
	[DownloadCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_HitTimes] ON [dbo].[spb_FileThreads] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_LastRepliedDate] ON [dbo].[spb_FileThreads] 
(
	[LastRepliedDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_OwnerUserID_AuditingStatus_IsPublic_PostDate] ON [dbo].[spb_FileThreads] 
(
	[OwnerUserID] ASC,
	[AuditingStatus] ASC,
	[PrivacyStatus] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_PostDate] ON [dbo].[spb_FileThreads] 
(
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_RatingSum] ON [dbo].[spb_FileThreads] 
(
	[RatingSum] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_RssViewTimes] ON [dbo].[spb_FileThreads] 
(
	[RssViewTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_SiteCategoryID_AuditingStatus_IsPublic_PostDate] ON [dbo].[spb_FileThreads] 
(
	[SiteCategoryID] ASC,
	[AuditingStatus] ASC,
	[PrivacyStatus] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_SpecialOrder] ON [dbo].[spb_FileThreads] 
(
	[SpecialOrder] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_StageDownloadCount] ON [dbo].[spb_FileThreads] 
(
	[StageDownloadCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_StageHitTimes] ON [dbo].[spb_FileThreads] 
(
	[StageHitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileThreads_UserCategoryID] ON [dbo].[spb_FileThreads] 
(
	[UserCategoryID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_GlobalNoticeItemSettings](
	[ItemID] [int] NOT NULL,
	[NoticeWayCode] [nvarchar](16) NOT NULL,
 CONSTRAINT [PK_spb_GlobalNoticeItemSettings] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[NoticeWayCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserLinks](
	[LinkID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[CategoryID] [int] NOT NULL,
	[Title] [nvarchar](256) NOT NULL,
	[ImageUrl] [nvarchar](256) NOT NULL,
	[LinkTitle] [nvarchar](256) NOT NULL,
	[LinkHref] [nvarchar](256) NOT NULL,
	[LinkType] [int] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IsEnabled] [bit] NOT NULL,
 CONSTRAINT [PK_spb_UserLinks] PRIMARY KEY CLUSTERED 
(
	[LinkID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserLinks_CategoryID_DisplayOrder] ON [dbo].[spb_UserLinks] 
(
	[CategoryID] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserLinks_DisplayOrder] ON [dbo].[spb_UserLinks] 
(
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserLinks_UserID_CategoryID_DisplayOrder] ON [dbo].[spb_UserLinks] 
(
	[UserID] ASC,
	[CategoryID] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、用户每天执行任务
*/

Create PROCEDURE [dbo].[spb_Task_User_PerDay]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

exec spb_Task_User_Statistics
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogThreads](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[Excerpt] [nvarchar](256) NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[BlogThreadTypeID] [int] NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[SiteCategoryID] [int] NOT NULL,
	[UserCategoryID] [int] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[LastRepliedDate] [datetime] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[IsEssential] [bit] NOT NULL,
	[SpecialOrder] [int] NOT NULL,
	[StickyDate] [datetime] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[RssViewTimes] [int] NOT NULL,
	[RatingSum] [int] NOT NULL,
	[TotalRatings] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_BlogThreads] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreads_CommentCount] ON [dbo].[spb_BlogThreads] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreads_HitTimes] ON [dbo].[spb_BlogThreads] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreads_LastRepliedDate] ON [dbo].[spb_BlogThreads] 
(
	[LastRepliedDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreads_OwnerUserID_AuditingStatus] ON [dbo].[spb_BlogThreads] 
(
	[OwnerUserID] ASC,
	[AuditingStatus] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreads_PostDate] ON [dbo].[spb_BlogThreads] 
(
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreads_SiteCategoryID_AuditingStatus] ON [dbo].[spb_BlogThreads] 
(
	[SiteCategoryID] ASC,
	[AuditingStatus] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreads_TotalRatings] ON [dbo].[spb_BlogThreads] 
(
	[TotalRatings] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Friends](
	[FriendID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[FriendUserID] [int] NOT NULL,
	[Friendliness] [int] NOT NULL,
	[IsHidden] [bit] NOT NULL,
	[NoteName] [nvarchar](64) NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_Friends] PRIMARY KEY CLUSTERED 
(
	[FriendID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Friends_CreateDate] ON [dbo].[spb_Friends] 
(
	[DateCreated] DESC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Friends_Friendliness] ON [dbo].[spb_Friends] 
(
	[Friendliness] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Friends_FriendUserID] ON [dbo].[spb_Friends] 
(
	[FriendUserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Friends_NoteName] ON [dbo].[spb_Friends] 
(
	[NoteName] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Friends_UserID] ON [dbo].[spb_Friends] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、圈子每天执行任务
*/

Create PROCEDURE [dbo].[spb_Task_Club_PerDay]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

exec spb_Task_Club_Statistics
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserNoticeItemSettings](
	[UserID] [int] NOT NULL,
	[ItemID] [int] NOT NULL,
	[NoticeWayCode] [nvarchar](16) NOT NULL,
 CONSTRAINT [PK_spb_UserNoticeItemSettings] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ItemID] ASC,
	[NoticeWayCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PhotoSections](
	[OwnerUserID] [int] NOT NULL,
	[SectionName] [nvarchar](512) NOT NULL,
	[Description] [nvarchar](2000) NOT NULL,
	[IsActive] [bit] NOT NULL,
	[EnableSearch] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[MostRecentPostDate] [datetime] NULL,
	[MostRecentThreadID] [int] NULL,
	[MostRecentThreadSubject] [nvarchar](216) NULL,
	[MostRecentThreadSummary] [nvarchar](2000) NULL,
	[PhotoCount] [int] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[Points] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
 CONSTRAINT [PK_spb_PhotoSections] PRIMARY KEY CLUSTERED 
(
	[OwnerUserID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSections_CommentCount] ON [dbo].[spb_PhotoSections] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSections_DateCreated] ON [dbo].[spb_PhotoSections] 
(
	[DateCreated] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSections_HitTimes] ON [dbo].[spb_PhotoSections] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSections_MostRecentPostDate] ON [dbo].[spb_PhotoSections] 
(
	[MostRecentPostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSections_PhotoCount] ON [dbo].[spb_PhotoSections] 
(
	[PhotoCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSections_Points] ON [dbo].[spb_PhotoSections] 
(
	[Points] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSections_StageHitTimes] ON [dbo].[spb_PhotoSections] 
(
	[StageHitTimes] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 用户UserID的收藏列表 **/

CREATE PROCEDURE [dbo].[spb_Favorite_GetItemIDFavoriteIDsOfUserID]
(
  @FavoriteTableName nvarchar(64),
  @UserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @sql nvarchar(1000)
set @sql='SELECT ItemID,FavoriteID FROM '+@FavoriteTableName+' WHERE  UserID = @UserID '
exec sp_executesql @sql,N'@UserID int', @UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumTags](
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[OwnerID] [int] NOT NULL,
 CONSTRAINT [PK_spb_ForumTags_1] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumTags_ownerID] ON [dbo].[spb_ForumTags] 
(
	[OwnerID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NoticeRecords](
	[RecordID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[NoticeItemID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[LeadingActorUserID] [int] NOT NULL,
	[LeadingActor] [nvarchar](256) NOT NULL,
	[RelativeItemID] [int] NOT NULL,
	[RelativeItemName] [nvarchar](256) NOT NULL,
	[Subject] [nvarchar](512) NOT NULL,
	[Body] [ntext] NOT NULL,
	[IsReaded] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_Notices] PRIMARY KEY CLUSTERED 
(
	[RecordID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NoticeRecords_UserID] ON [dbo].[spb_NoticeRecords] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Notices_ApplicationID] ON [dbo].[spb_NoticeRecords] 
(
	[ApplicationID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Notices_NoticeItemID] ON [dbo].[spb_NoticeRecords] 
(
	[NoticeItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PresentAreas](
	[PresentAreaID] [int] NOT NULL,
	[Name] [nvarchar](64) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[CanAssignOwner] [bit] NOT NULL,
	[EnableThemes] [bit] NOT NULL,
	[DefaultTheme] [nvarchar](64) NOT NULL,
	[DefaultAppearance] [nvarchar](64) NOT NULL,
	[ThemeLocation] [nvarchar](512) NOT NULL,
	[WidgetLocation] [nvarchar](512) NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_PresentAreas_PresentAreaID] PRIMARY KEY CLUSTERED 
(
	[PresentAreaID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Areas_Res](
	[AreaCode] [varchar](8) NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[Name] [nvarchar](128) NOT NULL
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Areas_Res_AreaCode_LanguageCode] ON [dbo].[spb_Areas_Res] 
(
	[AreaCode] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取某实体的所属类别ID **/

create PROCEDURE [dbo].[spb_UserCategoriesOfItem_GetIDs]
(
  @CategoriesTableName nvarchar(64),
  @UserItemTableName nvarchar(64),
  @ItemID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @sql nvarchar(1000)
set @sql='SELECT FC.CategoryID FROM '+@CategoriesTableName+' AS FC INNER JOIN '+@UserItemTableName+' AS FIC ON FC.CategoryID = FIC.CategoryID WHERE (FIC.ItemID = @ItemID)'
exec sp_executesql @sql,N'@ItemID int',@ItemID=@ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有动态项集合 **/

CREATE PROCEDURE [dbo].[spb_ApplicationTag_GetByTagName]
(
	@TagsTableName nvarchar(64),
	@TagName nvarchar(64)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @sql nvarchar(1000)
set @sql='select * from '+@TagsTableName+' with (nolock) where TagName=@TagName'
exec sp_executesql @sql,N'@TagName nvarchar(64)',@TagName=@TagName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsThread_UpdateAuditingStatus]
( 
    @ThreadID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_NewsThreads set AuditingStatus=@AuditingStatus where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_CodeItems_Res](
	[CodeSetCode] [varchar](20) NOT NULL,
	[CodeItemID] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[Name] [nvarchar](100) NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_CodeItems_Res_CodeSetCode_CodeItemID_LanguageCode] ON [dbo].[spb_CodeItems_Res] 
(
	[CodeSetCode] ASC,
	[CodeItemID] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置活动留言审核状态 */

Create PROCEDURE [dbo].[spb_EventPost_UpdateAuditingStatus]
( 
    @PostID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_EventPosts set AuditingStatus=@AuditingStatus where PostID=@PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_DefaultNavigations_Res](
	[DefaultNavigationID] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[Name] [nvarchar](128) NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_DefaultNavigations_DefaultNavigationID_LanguageCode] ON [dbo].[spb_DefaultNavigations_Res] 
(
	[LanguageCode] ASC,
	[DefaultNavigationID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据PostID获取EventPost */

CREATE PROCEDURE [dbo].[spb_EventPost_Get]
(
    @PostID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     *
FROM       spb_EventPosts with (nolock)
WHERE     (PostID = @PostID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、用户应用每月执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_User_PerStage]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
    --重置周浏览量
    update spb_Users set StageHitTimes=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_InvitationOutbox](
	[InvitationID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
 CONSTRAINT [PK_spb_InvitationOutbox] PRIMARY KEY CLUSTERED 
(
	[InvitationID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_InvitationOutbox_UserID] ON [dbo].[spb_InvitationOutbox] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_InvitationOutbox_UserID_ApplicationID] ON [dbo].[spb_InvitationOutbox] 
(
	[UserID] ASC,
	[ApplicationID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumUserDatas](
	[UserID] [int] NOT NULL,
	[Signature] [nvarchar](1024) NOT NULL,
	[ThreadCount] [int] NOT NULL,
	[PostCount] [int] NOT NULL,
	[ExperiencePoints] [int] NOT NULL,
 CONSTRAINT [PK_spb_ForumUserDatas] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取应用标签集合 **/

CREATE procedure [dbo].[spb_ItemsInApplicationTags_GetByTagName]
(
	@TagsTableName nvarchar(64),
	@ItemInTagsTableName nvarchar(64),
	@TagName nvarchar(64),
	@MaxRecords int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @sql nvarchar(1000)
set @sql='select top '+ @MaxRecords +' i.ItemID from '+@TagsTableName+' t with (nolock) inner join '
+@ItemInTagsTableName+' i with (nolock) on t.TagName=i.TagName where t.TagName like @TagName '
exec sp_executesql @sql,N'@TagName nvarchar(64)',@TagName=@TagName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserActivityItemSettings](
	[UserID] [int] NOT NULL,
	[ItemID] [int] NOT NULL,
	[IsAllowSending] [bit] NOT NULL,
	[IsAllowReceiving] [bit] NOT NULL,
 CONSTRAINT [PK_spb_UserActivityItemSettings] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogAttachments](
	[AttachmentID] [int] IDENTITY(1,1) NOT NULL,
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[FileName] [nvarchar](512) NOT NULL,
	[FriendlyFileName] [nvarchar](512) NOT NULL,
	[ContentType] [nvarchar](64) NOT NULL,
	[ContentSize] [int] NOT NULL,
	[Height] [int] NOT NULL,
	[Width] [int] NOT NULL,
	[IsRemote] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_MiniBlogAttachments] PRIMARY KEY CLUSTERED 
(
	[AttachmentID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Clubs](
	[ClubID] [int] IDENTITY(1,1) NOT NULL,
	[ClubName] [nvarchar](256) NOT NULL,
	[DomainName] [nvarchar](256) NOT NULL,
	[Brief] [nvarchar](2000) NOT NULL,
	[CategoryID] [int] NOT NULL,
	[AreaCode] [varchar](8) NOT NULL,
	[IsPublic] [bit] NOT NULL,
	[IsMemberNeedAuthorize] [bit] NOT NULL,
	[News] [ntext] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[Points] [int] NOT NULL,
	[MemberCount] [int] NOT NULL,
	[RegisterCountByClub] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[ClubOwnerUserID] [int] NOT NULL,
	[HasLogo] [bit] NOT NULL,
	[Theme] [nvarchar](128) NOT NULL,
	[ThemeAppearance] [nvarchar](128) NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[IsEnabled] [bit] NOT NULL,
 CONSTRAINT [PK_spb_Clubs] PRIMARY KEY CLUSTERED 
(
	[ClubID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Clubs_AreaCode] ON [dbo].[spb_Clubs] 
(
	[AreaCode] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Clubs_CategoryID] ON [dbo].[spb_Clubs] 
(
	[CategoryID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Clubs_ClubOwnerUserID] ON [dbo].[spb_Clubs] 
(
	[ClubOwnerUserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Clubs_HitTimes] ON [dbo].[spb_Clubs] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Clubs_IsEnabled] ON [dbo].[spb_Clubs] 
(
	[IsEnabled] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Clubs_MemberCount] ON [dbo].[spb_Clubs] 
(
	[MemberCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Clubs_Points] ON [dbo].[spb_Clubs] 
(
	[Points] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Clubs_StageHitTimes] ON [dbo].[spb_Clubs] 
(
	[StageHitTimes] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsTags](
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[OwnerID] [int] NOT NULL,
 CONSTRAINT [PK_spb_NewsTags_1] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsTags_LastModified] ON [dbo].[spb_NewsTags] 
(
	[LastModified] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsTags_ownerID] ON [dbo].[spb_NewsTags] 
(
	[OwnerID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ConvertibleGift_ExchangeApplies](
	[ApplyID] [int] IDENTITY(1,1) NOT NULL,
	[GiftID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[UserDisplayName] [varchar](64) NOT NULL,
	[ApplyStatus] [int] NOT NULL,
	[Price] [int] NOT NULL,
	[TotalCount] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ConvertibleGift_ExchangeApplies] PRIMARY KEY CLUSTERED 
(
	[ApplyID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ConvertibleGift_ExchangeApplies_GiftID] ON [dbo].[spb_ConvertibleGift_ExchangeApplies] 
(
	[GiftID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ConvertibleGift_ExchangeApplies_UserID] ON [dbo].[spb_ConvertibleGift_ExchangeApplies] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogsOfScreens](
	[ItemID] [int] IDENTITY(1,1) NOT NULL,
	[ScreenID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[Status] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogsOfScreens] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogsOfScreens_ScreenID_ThreadID] ON [dbo].[spb_MicroBlogsOfScreens] 
(
	[ScreenID] ASC,
	[ThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PrivateMessagePosts](
	[PostID] [int] IDENTITY(1,1) NOT NULL,
	[ParentPostID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Subject] [nvarchar](512) NOT NULL,
	[Body] [nvarchar](3000) NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[PostDate] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_PrivateMessagePosts] PRIMARY KEY CLUSTERED 
(
	[PostID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PrivateMessagePosts_ThreadID_PostDate] ON [dbo].[spb_PrivateMessagePosts] 
(
	[ThreadID] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PhotoSiteTags](
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[UserCount] [int] NOT NULL,
	[LastModified] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_PhotoSiteTags] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSiteTags_ItemCount] ON [dbo].[spb_PhotoSiteTags] 
(
	[ItemCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSiteTags_LastModified] ON [dbo].[spb_PhotoSiteTags] 
(
	[LastModified] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoSiteTags_UserCount] ON [dbo].[spb_PhotoSiteTags] 
(
	[UserCount] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PersonsInUserTags](
	[ItemID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_PersonsInUserTags_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogThreadUserCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[CategoryName] [nvarchar](128) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[ItemCount] [int] NOT NULL,
	[MostRecentUpdateDate] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_BlogThreadUserCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreadUserCategories_UserID] ON [dbo].[spb_BlogThreadUserCategories] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogThreads](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[OriginalThreadID] [int] NOT NULL,
	[ForwardedThreadID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Body] [nvarchar](4000) NOT NULL,
	[ReplyCount] [int] NOT NULL,
	[ForwardedCount] [int] NOT NULL,
	[HasPhoto] [bit] NOT NULL,
	[HasVideo] [bit] NOT NULL,
	[HasMusic] [bit] NOT NULL,
	[MicroBlogTypes] [int] NOT NULL,
	[PostMode] [int] NOT NULL,
	[PostSource] [nvarchar](64) NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogThreads] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogThreads_OriginalThreadID] ON [dbo].[spb_MicroBlogThreads] 
(
	[OriginalThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogThreads_OwnerUserID] ON [dbo].[spb_MicroBlogThreads] 
(
	[OwnerUserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogFeaturedTopics](
	[TopicID] [int] NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[FileName] [nvarchar](255) NOT NULL,
	[UserNames] [varchar](200) NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogFeaturedTopics] PRIMARY KEY CLUSTERED 
(
	[TopicID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FileUserTags](
	[UserID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_FileUserTags_1] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileUserTags_ItemCount] ON [dbo].[spb_FileUserTags] 
(
	[ItemCount] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PhotoComments](
	[PostID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Body] [ntext] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[IsApproved] [bit] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[PostDate] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_PhotoComments] PRIMARY KEY CLUSTERED 
(
	[PostID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoComments_OwnerUserID_PostDate] ON [dbo].[spb_PhotoComments] 
(
	[OwnerUserID] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoComments_ThreadID_AuditingStatus_IsApproved] ON [dbo].[spb_PhotoComments] 
(
	[ThreadID] ASC,
	[AuditingStatus] ASC,
	[IsApproved] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoComments_UserID] ON [dbo].[spb_PhotoComments] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserActivitySettings](
	[UserID] [int] NOT NULL,
	[IgnoredFriendUsersForReceiveActivities] [nvarchar](2000) NOT NULL,
	[IgnoredClubsForReceiveClubActivities] [nvarchar](2000) NOT NULL,
 CONSTRAINT [PK_spb_UserActivitySettings] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PersonUserTags](
	[UserID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_PersonsUserTags_1] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ClubUserDatas](
	[UserID] [int] NOT NULL,
	[CreatedClubCount] [int] NOT NULL,
	[JoinedClubCount] [int] NOT NULL,
	[ExperiencePoints] [int] NOT NULL,
 CONSTRAINT [PK_spb_ClubUserDatas] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserPointRecords](
	[RecordID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[PointCategory] [smallint] NOT NULL,
	[PointItemName] [nvarchar](64) NOT NULL,
	[Points] [float] NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[IsIncome] [bit] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_UserPointRecords] PRIMARY KEY CLUSTERED 
(
	[RecordID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserPointRecords_UserID_PointCategory] ON [dbo].[spb_UserPointRecords] 
(
	[UserID] ASC,
	[PointCategory] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogFollowsInUserCategories](
	[CategoryID] [int] NOT NULL,
	[ItemID] [int] NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogFollowsInUserCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC,
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserSpecialPrivacyItemSettings](
	[UserID] [int] NOT NULL,
	[ToUserID] [int] NOT NULL,
	[ItemID] [int] NOT NULL,
	[IsAllowed] [bit] NOT NULL,
 CONSTRAINT [PK_spb_UserSpecialPrivacyItemSettings] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ToUserID] ASC,
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserSpecialPrivacyItemSettings_UserID_ToUserID] ON [dbo].[spb_UserSpecialPrivacyItemSettings] 
(
	[UserID] ASC,
	[ToUserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PrivateMessageOutbox](
	[UserID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[MessageType] [int] NOT NULL,
	[IsLocked] [bit] NOT NULL,
	[ReceiverUserID] [int] NOT NULL,
	[Receiver] [nvarchar](64) NOT NULL,
	[MostRecentPostDate] [datetime] NOT NULL,
	[MostRecentPostID] [int] NOT NULL,
	[MostRecentPostSubject] [nvarchar](512) NOT NULL,
	[MostRecentPostBody] [nvarchar](3000) NOT NULL,
 CONSTRAINT [PK_spb_PrivateMessageOutbox] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_StopedUsers](
	[UserID] [int] NOT NULL,
	[ToUserID] [int] NOT NULL,
	[ToUserDisplayName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_StopedUsers] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ToUserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ShareComments](
	[CommentID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[UserThreadID] [int] NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Body] [nvarchar](2000) NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ShareComments] PRIMARY KEY CLUSTERED 
(
	[CommentID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareComments_OwnerUserID] ON [dbo].[spb_ShareComments] 
(
	[OwnerUserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ShareComments_ThreadID_UserThreadID] ON [dbo].[spb_ShareComments] 
(
	[ThreadID] ASC,
	[UserThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 用户标签的 创建、更新、删除 **/
CREATE PROCEDURE [dbo].[spb_UserTag_CreateUpdateDelete]
(
	@UserTagsTableName nvarchar(64),
	@SiteTagsTableName nvarchar(64),
	@InUserTagsTableName nvarchar(64),
	@Action int,
	@UserID int=0,
	@TagName nvarchar(64)=''
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
--set nocount on
declare @SameTagUserCount int
declare @ItemCountInUserTag int
declare @OldTagName nvarchar(256)
set @ItemCountInUserTag=0
set @SameTagUserCount=0

if (@Action = 0) -- 添加
    begin
		declare @createStrSql nvarchar(1500)
		--存在重复的标签名称
        set @createStrSql='if exists (select top 1 TagName from '+@UserTagsTableName+' with (nolock) where UserID = @UserID and TagName = @TagName) select -1'
		exec sp_executesql @createStrSql,N'@UserID int,@TagName nvarchar(64)',@UserID=@UserID,@TagName=@TagName		

		--还有其他人定义了同样的Tag
        set @createStrSql='if exists (select top 1 TagName from '+@SiteTagsTableName+' with (nolock) where TagName = @TagName) 
								update '+@SiteTagsTableName+' set UserCount = UserCount+1 where TagName = @TagName
						   else
								insert '+@SiteTagsTableName+' (TagName) values (@TagName)'  
        exec sp_executesql @createStrSql,N'@TagName nvarchar(64)',@TagName=@TagName
    
        set @createStrSql='insert '+@UserTagsTableName+' (UserID,TagName) values (@UserID,@TagName) '
		exec sp_executesql @createStrSql,N'@UserID int,@TagName nvarchar(64)',@TagName=@TagName,@UserID=@UserID
		
		Select 1;
    end

else if(@Action = 2)
    begin
		declare @deleteStrSql nvarchar(1500)

        set @deleteStrSql='select @ItemCountInUserTag=ItemCount from '+@UserTagsTableName+' with (nolock) where TagName = @TagName'
		exec sp_executesql @deleteStrSql,N'@TagName nvarchar(64),@ItemCountInUserTag int output',@TagName=@TagName,@ItemCountInUserTag=@ItemCountInUserTag 
		
		set @deleteStrSql='select @SameTagUserCount = UserCount from '+@SiteTagsTableName+' with (nolock) where TagName = @TagName'
		exec sp_executesql @deleteStrSql,N'@SameTagUserCount int output,@TagName nvarchar(64)',@SameTagUserCount output,@TagName=@TagName
		
		--还有其他人定义了同样的Tag
        set @deleteStrSql='if (@SameTagUserCount >1)
							  update '+@SiteTagsTableName+' set UserCount = UserCount-1,ItemCount = ItemCount-@ItemCountInUserTag where TagName = @TagName
						   else
							  delete from '+@SiteTagsTableName+' where TagName = @TagName
						   delete from '+@InUserTagsTableName+' where TagName = @TagName
						   delete from '+@UserTagsTableName+' where TagName = @TagName'
		exec sp_executesql @deleteStrSql,N'@SameTagUserCount int,@ItemCountInUserTag int,@TagName nvarchar(64)',@SameTagUserCount=@SameTagUserCount,@ItemCountInUserTag=@ItemCountInUserTag,@TagName=@TagName
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_AccountBindings](
	[UserID] [int] NOT NULL,
	[AccountType] [int] NOT NULL,
	[Identification] [nvarchar](256) NOT NULL,
	[OauthToken] [nvarchar](256) NOT NULL,
	[OauthTokenSecret] [nvarchar](256) NOT NULL,
 CONSTRAINT [PK_spb_AccountBindings] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[AccountType] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserGuestbooks](
	[GuestbookID] [int] NOT NULL,
	[IsActive] [bit] NOT NULL,
	[MostRecentPostDate] [datetime] NULL,
	[EnableAnonymousPosting] [bit] NOT NULL,
	[PostCount] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_UserGuestbooks] PRIMARY KEY CLUSTERED 
(
	[GuestbookID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取UserID的所有标签 **/
CREATE PROCEDURE [dbo].[spb_UserTags_GetByUserID] 
(	@UserTagsTableName Nvarchar(64),
	@SiteTagsTableName Nvarchar(64),
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @strSql nvarchar(1500)
set @strSql='select u.*,s.UserCount,s.ItemCount as ItemCountOfSite  from '+@UserTagsTableName+' as u with (nolock) inner join '+@SiteTagsTableName +' as s with (nolock) on u.TagName = s.TagName  where u.UserID = @UserID'
exec sp_executesql @strSql,N'@UserID int',@UserID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_SiteSettings](
	[SettingsID] [int] IDENTITY(1,1) NOT NULL,
	[SettingsXML] [ntext] NULL,
	[SettingsKey] [uniqueidentifier] NOT NULL,
	[version] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_SiteSettings] PRIMARY KEY CLUSTERED 
(
	[SettingsID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ClubAreaStatistics](
	[AreaCode] [varchar](8) NOT NULL,
	[TotalCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_ClubAreaStatistics] PRIMARY KEY CLUSTERED 
(
	[AreaCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumThreads](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[SectionID] [int] NOT NULL,
	[CategoryID] [int] NOT NULL,
	[GroupID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[IsLocked] [bit] NOT NULL,
	[IsEssential] [bit] NOT NULL,
	[IsSticky] [bit] NOT NULL,
	[SpecialOrder] [int] NOT NULL,
	[StickyDate] [datetime] NOT NULL,
	[IsHidden] [bit] NOT NULL,
	[HighlightDate] [datetime] NOT NULL,
	[ThreadStatus] [int] NOT NULL,
	[EmoticonID] [int] NOT NULL,
	[Price] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
	[ReplyCount] [int] NOT NULL,
	[RssViewTimes] [int] NOT NULL,
	[RatingSum] [int] NOT NULL,
	[TotalRatings] [int] NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[LastRepliedDate] [datetime] NOT NULL,
	[MostRecentPostAuthorID] [int] NULL,
	[MostRecentPostAuthor] [nvarchar](64) NULL,
	[MostRecentPostID] [int] NULL,
	[StampID] [int] NOT NULL,
 CONSTRAINT [PK_spb_ForumThreads] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreads_GroupID_LastRepliedDate] ON [dbo].[spb_ForumThreads] 
(
	[GroupID] ASC,
	[LastRepliedDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreads_GroupID_SectionID_SpecialOrder] ON [dbo].[spb_ForumThreads] 
(
	[GroupID] ASC,
	[SectionID] ASC,
	[SpecialOrder] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreads_HitTimes] ON [dbo].[spb_ForumThreads] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreads_LastRepliedDate] ON [dbo].[spb_ForumThreads] 
(
	[LastRepliedDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreads_ReplyCount] ON [dbo].[spb_ForumThreads] 
(
	[ReplyCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreads_SectionID] ON [dbo].[spb_ForumThreads] 
(
	[SectionID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreads_UserID] ON [dbo].[spb_ForumThreads] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UrlInfos](
	[Alias] [nvarchar](16) NOT NULL,
	[Url] [nvarchar](512) NOT NULL,
	[UrlSalt] [nvarchar](32) NOT NULL,
	[ThumbnailUrl] [nvarchar](512) NOT NULL,
	[PlayUrl] [nvarchar](512) NOT NULL,
	[MediaType] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_UrlInfo] PRIMARY KEY CLUSTERED 
(
	[Alias] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据IP获取地区ID **/
CREATE PROCEDURE [dbo].[spb_AreaCode_GetByIP] 
(
	@IP bigint
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select AreaCode from spb_AreaIPs with (nolock) where IPStart <= @IP and IPEnd >= @IP
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有动态项集合 **/

CREATE PROCEDURE [dbo].[spb_ApplicationTag_GetByTagID]
(
	@TagsTableName nvarchar(64),
	@TagID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @sql nvarchar(1000)
set @sql='select * from '+@TagsTableName+' with (nolock) where TagID=@TagID'
exec sp_executesql @sql,N'@TagID int',@TagID=@TagID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新用户统计信息 **/
CREATE PROCEDURE [dbo].[spb_UserStatistics_Update]
(
    @UserID int,
    @BasicPoints float = 0,
    @TradePoints float = 0,
    @PrepayTradePoints float = 0,
    @ReportPoints float = 0,
    @CreditPoints float = 0,
    @ExpertPoints float = 0,
    @RMBMoney float = 0,
    @PrepayRMBMoney float = 0,
    @ProfileIntegrity float = 0,
    @Rank int=0,
    --@FriendCount int=0,
    @InviteFriendCount int=0,
    @loginTimes int=0,
    @HitTimes int=0,
    @StageHitTimes int=0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

BEGIN
  Update spb_Users 
  set BasicPoints=@BasicPoints,TradePoints=@TradePoints,PrepayTradePoints=@PrepayTradePoints,ReportPoints=@ReportPoints,
    CreditPoints=@CreditPoints,ExpertPoints=@ExpertPoints,RMBMoney=@RMBMoney,PrepayRMBMoney=@PrepayRMBMoney,ProfileIntegrity=@ProfileIntegrity,
    Rank=@Rank,InviteFriendCount=@InviteFriendCount,loginTimes=@loginTimes,HitTimes=@HitTimes,StageHitTimes=@StageHitTimes
  where 
    UserID=@UserID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_OwnerApplicationInPresentAreas](
	[OwnerID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[PresentAreaID] [int] NOT NULL,
 CONSTRAINT [PK_spb_OwnerApplicationInPresentAreas] PRIMARY KEY CLUSTERED 
(
	[OwnerID] ASC,
	[ApplicationID] ASC,
	[PresentAreaID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumPosts](
	[PostID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[SectionID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[HighlightStyle] [nvarchar](200) NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ForumPosts] PRIMARY KEY CLUSTERED 
(
	[PostID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumPosts_SectionID] ON [dbo].[spb_ForumPosts] 
(
	[SectionID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumPosts_ThreadID] ON [dbo].[spb_ForumPosts] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumPosts_UserID] ON [dbo].[spb_ForumPosts] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UsersInRoles](
	[UserID] [int] NOT NULL,
	[RoleID] [int] NOT NULL,
 CONSTRAINT [PK_spb_UsersInRoles] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[RoleID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UsersInRoles_RoleID] ON [dbo].[spb_UsersInRoles] 
(
	[RoleID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumModerators](
	[SectionID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Inherited] [bit] NOT NULL,
 CONSTRAINT [PK_spb_ForumModerators] PRIMARY KEY CLUSTERED 
(
	[SectionID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumModerators_UserID] ON [dbo].[spb_ForumModerators] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_InvitationInbox](
	[InvitationID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
 CONSTRAINT [PK_spb_InvitationInbox] PRIMARY KEY CLUSTERED 
(
	[InvitationID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_InvitationInbox_UserID] ON [dbo].[spb_InvitationInbox] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_InvitationInbox_UserID_ApplicationID] ON [dbo].[spb_InvitationInbox] 
(
	[UserID] ASC,
	[ApplicationID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_CodeSets_Res](
	[CodeSetCode] [varchar](20) NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[Name] [nvarchar](100) NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_CodeSets_Res_CodeSetCode_LanguageCode] ON [dbo].[spb_CodeSets_Res] 
(
	[CodeSetCode] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogThreadsInUserTags](
	[ItemID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_BlogThreadsInUserTags_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreadsInUserTags_ItemID] ON [dbo].[spb_BlogThreadsInUserTags] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 重置用户等级数据 */
create PROCEDURE [dbo].[spb_UserRank_ResetAllUserRanks]
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Users set Rank=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumThreadCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[SectionID] [int] NOT NULL,
	[CategoryName] [nvarchar](128) NOT NULL,
	[CategoryDescription] [nvarchar](1024) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[ThreadCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_ForumThreadCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreadCategories_SectionID_DisplayOrder] ON [dbo].[spb_ForumThreadCategories] 
(
	[SectionID] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserRanks_Res](
	[Rank] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[RankName1] [nvarchar](128) NOT NULL,
	[RankName2] [nvarchar](128) NOT NULL,
	[RankName3] [nvarchar](128) NOT NULL,
	[RankName4] [nvarchar](128) NOT NULL,
	[RankName5] [nvarchar](128) NOT NULL,
	[RankName6] [nvarchar](128) NOT NULL,
	[RankName7] [nvarchar](128) NOT NULL,
	[RankName8] [nvarchar](128) NOT NULL,
	[RankName9] [nvarchar](128) NOT NULL,
	[RankName10] [nvarchar](128) NOT NULL,
 CONSTRAINT [PK_spb_UserRanks_Res] PRIMARY KEY CLUSTERED 
(
	[Rank] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_OwnerNavigations](
	[OwnerNavigationID] [int] IDENTITY(1,1) NOT NULL,
	[DefaultNavigationID] [int] NOT NULL,
	[NavigationType] [int] NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[OwnerID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[secondaryID] [int] NOT NULL,
	[OnlyOwnerVisible] [bit] NOT NULL,
	[NavigationText] [nvarchar](64) NOT NULL,
	[UrlRouteName] [nvarchar](64) NOT NULL,
	[NavigationUrl] [nvarchar](512) NOT NULL,
	[NavigationTarget] [nvarchar](64) NOT NULL,
	[DisplayOrder] [float] NOT NULL,
	[IsEnabled] [bit] NOT NULL,
	[IsLocked] [bit] NOT NULL,
 CONSTRAINT [PK_spb_OwnerNavigations] PRIMARY KEY CLUSTERED 
(
	[OwnerNavigationID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_OwnerNavigations_OwnerID] ON [dbo].[spb_OwnerNavigations] 
(
	[OwnerID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Users](
	[UserID] [int] IDENTITY(1,1) NOT NULL,
	[UserName] [nvarchar](64) NOT NULL,
	[LoweredUserName] [nvarchar](64) NOT NULL,
	[Password] [nvarchar](128) NOT NULL,
	[PasswordSalt] [nvarchar](128) NOT NULL,
	[PasswordFormat] [int] NOT NULL,
	[PasswordQuestion] [nvarchar](64) NOT NULL,
	[PasswordAnswer] [nvarchar](128) NOT NULL,
	[PrivateEmail] [nvarchar](64) NOT NULL,
	[LoweredPrivateEmail] [nvarchar](64) NOT NULL,
	[MembershipID] [uniqueidentifier] NOT NULL,
	[CommonName] [nvarchar](64) NOT NULL,
	[Nickname] [nvarchar](64) NOT NULL,
	[ForceLogin] [bit] NOT NULL,
	[UserAccountStatus] [smallint] NOT NULL,
	[LastActivity] [datetime] NOT NULL,
	[LastAction] [nvarchar](1024) NOT NULL,
	[IPCreated] [nvarchar](32) NOT NULL,
	[IPLastActivity] [nvarchar](32) NOT NULL,
	[DatabaseQuota] [int] NOT NULL,
	[DatabaseQuotaUsed] [int] NOT NULL,
	[IsModerated] [bit] NOT NULL,
	[IsForceModerated] [bit] NOT NULL,
	[EnableAvatar] [bit] NOT NULL,
	[EnableDisplayInMemberList] [bit] NOT NULL,
	[EnableOnlineStatus] [bit] NOT NULL,
	[EnableEmail] [bit] NOT NULL,
	[EnableHtmlEmail] [bit] NOT NULL,
	[IsEmailVerified] [bit] NOT NULL,
	[IsAvatarApproved] [bit] NOT NULL,
	[UserRankType] [smallint] NOT NULL,
	[UserType] [smallint] NOT NULL,
	[PublicEmail] [nvarchar](64) NOT NULL,
	[Mobile] [nvarchar](64) NOT NULL,
	[MsnIM] [nvarchar](64) NOT NULL,
	[QQIM] [nvarchar](64) NOT NULL,
	[YahooIM] [nvarchar](64) NOT NULL,
	[SkypeIM] [nvarchar](64) NOT NULL,
	[PersonalHomepage] [nvarchar](256) NOT NULL,
	[InviteUserID] [int] NOT NULL,
	[InviteClubID] [int] NOT NULL,
	[Theme] [nvarchar](128) NOT NULL,
	[ThemeAppearance] [nvarchar](128) NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[MemberLevel] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[BasicPoints] [int] NOT NULL,
	[TradePoints] [int] NOT NULL,
	[PrepayTradePoints] [int] NOT NULL,
	[ReportPoints] [int] NOT NULL,
	[CreditPoints] [int] NOT NULL,
	[ExpertPoints] [int] NOT NULL,
	[Rank] [int] NOT NULL,
	[RMBMoney] [decimal](8, 2) NOT NULL,
	[PrepayRMBMoney] [decimal](8, 2) NOT NULL,
	[ProfileIntegrity] [float] NOT NULL,
	[FriendCount] [int] NOT NULL,
	[InviteFriendCount] [int] NOT NULL,
	[loginTimes] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
 CONSTRAINT [PK_spb_Users] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Users_EnableDisplayInMemberList_UserAccountStatus] ON [dbo].[spb_Users] 
(
	[EnableDisplayInMemberList] ASC,
	[UserAccountStatus] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Users_InviteClubID] ON [dbo].[spb_Users] 
(
	[InviteClubID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Users_InviteUserID] ON [dbo].[spb_Users] 
(
	[InviteUserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Users_LoweredPrivateEmail] ON [dbo].[spb_Users] 
(
	[LoweredPrivateEmail] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Users_LoweredUserName] ON [dbo].[spb_Users] 
(
	[LoweredUserName] ASC
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_Users_UserName] ON [dbo].[spb_Users] 
(
	[UserName] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 用户计数 **/
CREATE PROCEDURE [dbo].[spb_UserView_Add]
(
	@ItemID int,
	@WebViewCount int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Users set HitTimes = HitTimes+@WebViewCount,StageHitTimes = StageHitTimes+@WebViewCount where UserID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserRanks](
	[Rank] [int] NOT NULL,
	[PointUpper] [int] NOT NULL,
	[PointLower] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_UserRanks] PRIMARY KEY CLUSTERED 
(
	[Rank] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumThreadExchanges](
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[UserDisplayName] [nvarchar](256) NOT NULL,
	[Price] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_ForumThreadExchanges] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreadExchanges_threadID] ON [dbo].[spb_ForumThreadExchanges] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumThreadExchanges_UserID] ON [dbo].[spb_ForumThreadExchanges] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据UserName获取UserID **/

create procedure [dbo].[spb_User_GetUserIDByUserName]
(
	@UserName nvarchar(64)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
SELECT UserID from dbo.spb_users with (nolock) WHERE UserName = @UserName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取Photos中指定ThreadID前的记录数 **/

CREATE procedure [dbo].[spb_GetPreviousThreadCount_Get]
(
    @sqlCount ntext
)
AS
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED

 EXEC sp_executesql @sqlCount
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取ItemID的所有标签 **/
CREATE PROCEDURE [dbo].[spb_UserTags_GetByItemID] 
(	
	@InUserTagsTableName nvarchar(64),
    @ItemID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @strSql nvarchar(1000)
set @strSql='select I.TagName from '+@InUserTagsTableName+' I with (nolock) where i.ItemID = @ItemID'
exec sp_executesql @strSql,N'@ItemID int',@ItemID=@ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FileRatings](
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Rate] [int] NOT NULL,
 CONSTRAINT [PK_spb_FileRatings] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileRatings_UserID] ON [dbo].[spb_FileRatings] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取应用标签集合 **/

CREATE procedure [dbo].[spb_ApplicationTags_GetByItemID]
(
	@ItemInTagsTableName nvarchar(64),
	@ItemID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @sql nvarchar(1000)
set @sql='select i.TagName from '+@ItemInTagsTableName+' i with (nolock) where i.ItemID=@ItemID'
exec sp_executesql @sql,N'@ItemID int',@ItemID=@ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NoticeItems](
	[ItemID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[ItemKey] [nvarchar](64) NOT NULL,
	[ItemName] [nvarchar](64) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[AllowPersonUser] [bit] NOT NULL,
	[AllowCompanyUser] [bit] NOT NULL,
 CONSTRAINT [PK_spb_NoticeItems] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_NoticeItems_ItemKey] ON [dbo].[spb_NoticeItems] 
(
	[ItemKey] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**
<copyright>拓宇网络科技有限公司 2005-2008</copyright>
<version>V0.5</verion>
<createdate>2005-11-27</createdate>
<author>mazq</author>
<email>mazq@tunynet.com</email>
<log date="2005-11-27" version="0.5">创建</log>
<log date="2008-10-8" version="1.0">Spacebuilder2.0 yangmj</log>

<summary>
   设置用户账户的 帖子管制、账户、头像 状态
</summary>
**/

CREATE procedure [dbo].[spb_User_ToggleSettings]
(
	@UserID int,
	@IsModerated bit,
	@UserAccountStatus int,
	@ForceLogin bit = 0,
	@IsAvatarApproved bit,
	@ModeratorID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
BEGIN

	UPDATE 
		spb_Users
	SET
		UserAccountStatus = @UserAccountStatus,
		ForceLogin = @ForceLogin,
		IsModerated = @IsModerated,
		IsAvatarApproved = @IsAvatarApproved
	WHERE
		UserID = @UserID


    /** 暂时不记入日志
	IF @ModerationLevel = 0
	  exec spb_system_ModerationAction_AuditEntry 11, @ModeratorID, null, @UserID, null, @SettingsID
	ELSE	
	  exec spb_system_ModerationAction_AuditEntry 10, @ModeratorID, null, @UserID, null, @SettingsID

	IF @UserAccountStatus = 1
	  exec spb_system_ModerationAction_AuditEntry 13, @ModeratorID, null, @UserID, null, @SettingsID
	ELSE	
	  exec spb_system_ModerationAction_AuditEntry 12, @ModeratorID, null, @UserID, null, @SettingsID
	 **/

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumPostAttachmentExchanges](
	[AttachmentID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[UserDisplayName] [nvarchar](256) NOT NULL,
	[Price] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_ForumPostAttachmentExchanges] PRIMARY KEY CLUSTERED 
(
	[AttachmentID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumPostAttachmentExchanges_UserID] ON [dbo].[spb_ForumPostAttachmentExchanges] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [dbo].[spb_UserPasswordWithFormat_Get]
    @UserName nvarchar(64)
AS
set nocount on
BEGIN
  select Password, PasswordFormat, PasswordSalt, UserAccountStatus from spb_Users with (nolock) where LoweredUserName = lower(@UserName)
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ThemeAppearances](
	[PresentAreaID] [int] NOT NULL,
	[Theme] [nvarchar](32) NOT NULL,
	[DirectoryName] [nvarchar](32) NOT NULL,
	[Title] [nvarchar](64) NOT NULL,
	[Description] [nvarchar](1024) NOT NULL,
	[CssFileName] [nvarchar](256) NOT NULL,
	[PreviewImage] [nvarchar](256) NOT NULL,
	[PreviewLargeImage] [nvarchar](256) NOT NULL,
	[LogoUrl] [nvarchar](256) NOT NULL,
	[Roles] [nvarchar](256) NOT NULL,
	[RequiredRank] [int] NOT NULL,
	[TypeName] [nvarchar](64) NOT NULL,
	[Author] [nvarchar](128) NOT NULL,
	[Copyright] [nvarchar](256) NOT NULL,
	[ThemeVersion] [nvarchar](32) NOT NULL,
	[ForProductVersion] [nvarchar](32) NOT NULL,
	[DateCreated] [nvarchar](32) NOT NULL,
	[IsEnabled] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[UserCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_ThemeAppearances] PRIMARY KEY CLUSTERED 
(
	[PresentAreaID] ASC,
	[Theme] ASC,
	[DirectoryName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogScreens](
	[ScreenID] [int] IDENTITY(1,1) NOT NULL,
	[ScreenName] [nvarchar](64) NOT NULL,
	[UserID] [int] NOT NULL,
	[Keyword] [nvarchar](150) NULL,
	[IsFilter] [bit] NOT NULL,
	[IsDeadline] [bit] NOT NULL,
	[IsPause] [bit] NOT NULL,
	[StartDate] [datetime] NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogScreens] PRIMARY KEY CLUSTERED 
(
	[ScreenID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsAttachments](
	[AttachmentID] [int] IDENTITY(1,1) NOT NULL,
	[ThreadID] [int] NOT NULL,
	[SectionID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[FileName] [nvarchar](512) NOT NULL,
	[FriendlyFileName] [nvarchar](512) NOT NULL,
	[ContentType] [nvarchar](64) NOT NULL,
	[ContentSize] [int] NOT NULL,
	[Height] [int] NOT NULL,
	[Width] [int] NOT NULL,
	[IsRemote] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[DownloadCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_NewsAttachments] PRIMARY KEY CLUSTERED 
(
	[AttachmentID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除类别 */

CREATE PROCEDURE [dbo].[spb_UserCategory_CreateUpdateDelete]
( 
	@CategoriesTableName nvarchar(64)='',
    @Action int,
    @CategoryID	int output,
    @UserID	int=0,
    @CategoryName	nvarchar(128)='',
    @Description	nvarchar(512)='',
    @DisplayOrder	int=0,
    @PrivacyStatus int = 30,
    @PropertyNames	ntext=null,
    @PropertyValues	ntext=null	
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
		declare @delSql nvarchar(1000)
		set @delSql='delete from '+@CategoriesTableName+' where CategoryID = @CategoryID'
		exec sp_executesql @delSql,N'@CategoryID int',@CategoryID=@CategoryID
		return
    END
else if(@Action =1) --修改
    BEGIN
		--存在重复的类别名称

		declare @updateSql nvarchar(1500)
		set @updateSql='if exists (select top 1 CategoryID from '+@CategoriesTableName+' with (nolock) where UserID = @UserID and CategoryName = @CategoryName and CategoryID <> @CategoryID)
            return 
        UPDATE    '+@CategoriesTableName+'
        SET       CategoryName = @CategoryName, Description = @Description, DisplayOrder = @DisplayOrder,  
                  MostRecentUpdateDate = getdate(),PrivacyStatus=@PrivacyStatus,PropertyNames = @PropertyNames, PropertyValues = @PropertyValues
        WHERE     (CategoryID = @CategoryID)'
		exec sp_executesql @updateSql,N'@UserID int,@CategoryName nvarchar(128),@CategoryID int,@Description nvarchar(512),@DisplayOrder int,@PrivacyStatus int,@PropertyNames ntext, @PropertyValues ntext',@UserID=@UserID,@CategoryName=@CategoryName,@CategoryID=@CategoryID,@Description=@Description,@DisplayOrder=@DisplayOrder,
		@PrivacyStatus=@PrivacyStatus,@PropertyNames=@PropertyNames, @PropertyValues=@PropertyValues
		return
    END
else --添加
    BEGIN 
		--存在重复的类别名称
		declare @createSql nvarchar(1500)
		set @createSql='if exists (select top 1 CategoryID from '+@CategoriesTableName+' with (nolock) where UserID = @UserID and CategoryName = @CategoryName)
            return
        INSERT INTO '+@CategoriesTableName+'
                   (UserID, CategoryName, Description, DisplayOrder,PrivacyStatus,PropertyNames, PropertyValues)
        VALUES     (@UserID,@CategoryName,@Description,@DisplayOrder,@PrivacyStatus,@PropertyNames, @PropertyValues)
        set @CategoryID =SCOPE_IDENTITY()'
		exec sp_executesql @createSql,N'@CategoryID int output,@UserID int,@CategoryName nvarchar(128),@Description nvarchar(512),@DisplayOrder int,@PrivacyStatus int,@PropertyNames ntext, @PropertyValues ntext',@CategoryID output,@UserID=@UserID,@CategoryName=@CategoryName,@Description=@Description,@DisplayOrder=@DisplayOrder,
		@PrivacyStatus=@PrivacyStatus,@PropertyNames=@PropertyNames, @PropertyValues=@PropertyValues
		return
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_LayoutPages](
	[PageCode] [char](4) NOT NULL,
	[Theme] [nvarchar](32) NOT NULL,
	[OwnerID] [int] NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[PageName] [nvarchar](128) NOT NULL,
	[LayoutMode] [int] NOT NULL,
	[Description] [nvarchar](1024) NOT NULL,
 CONSTRAINT [PK_spb_LayoutPages] PRIMARY KEY CLUSTERED 
(
	[OwnerID] ASC,
	[Theme] ASC,
	[PageCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、删除大屏幕下的微博 */

CREATE PROCEDURE [dbo].[spb_MicroBlogOfScreen_CreateDelete] 
(
    @Action int,
	@ScreenID int = 0,
	@ThreadID int = 0,
	@AuditingStatus int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if @Action = 0 --添加
	Insert into spb_MicroBlogsOfScreens(ScreenID,ThreadID) values (@ScreenID,@ThreadID)
else if @Action = 2
    delete from spb_MicroBlogsOfScreens where ScreenID = @ScreenID and ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ClubSharedContents](
	[ContentID] [int] IDENTITY(1,1) NOT NULL,
	[ClubID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[Body] [nvarchar](2048) NOT NULL,
	[ThumbnailUrl] [nvarchar](512) NOT NULL,
	[DetailsUrl] [nvarchar](400) NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[AuthorUserID] [int] NOT NULL,
	[Sharer] [nvarchar](64) NOT NULL,
	[SharerUserID] [int] NOT NULL,
	[IsEssential] [bit] NOT NULL,
	[SpecialOrder] [int] NOT NULL,
	[StickyDate] [datetime] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ClubSharedContents] PRIMARY KEY CLUSTERED 
(
	[ContentID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubID_ApplicationID_SpecialOrder] ON [dbo].[spb_ClubSharedContents] 
(
	[ClubID] ASC,
	[ApplicationID] ASC,
	[SpecialOrder] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_DetailsUrl] ON [dbo].[spb_ClubSharedContents] 
(
	[DetailsUrl] ASC
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_DetailsUrl_ClubID] ON [dbo].[spb_ClubSharedContents] 
(
	[ClubID] ASC,
	[DetailsUrl] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户类别 **/

CREATE PROCEDURE [dbo].[spb_UserCategory_Get]
(
  @CategoriesTableName nvarchar(64),
  @CategoryID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @sql nvarchar(1000)
set @sql='SELECT  * FROM '+@CategoriesTableName+' with (nolock) WHERE CategoryID = @CategoryID'
exec sp_executesql @sql,N'@CategoryID int',@CategoryID=@CategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_SiteCategories_Res](
	[CategoryID] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[Name] [nvarchar](128) NOT NULL,
 CONSTRAINT [PK_spb_SiteCategories_Res] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 应用标签的 创建、更新、删除 **/
CREATE PROCEDURE [dbo].[spb_ApplicationTag_CreateUpdateDelete]
(
	@TagsTableName nvarchar(64),
	@ItemInTagsTableName nvarchar(64)='',
	@Action int,
	@TagName nvarchar(64)='',
	@UserID int = 0,
	@Author nvarchar(64)='',
	@LastModified datetime='',
	@OwnerID int = 0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
declare @SameTagUserCount int
declare @ItemCountInUserTag int
declare @OldTagName nvarchar(256)

if @Action = 2 --删除
    begin
		declare @delSql nvarchar(1000)
        set @delSql='delete '+@ItemInTagsTableName+' where TagName=@TagName
					delete '+@TagsTableName+' where TagName=@TagName
					return'
		exec sp_executesql @delSql,N'@TagName nvarchar(64)',@TagName=@TagName
    end
else if @Action =0
    begin
		--存在重复的标签名称
		declare @createSql nvarchar(1000)
        set @createSql='if exists (select top 1 TagName from '+@TagsTableName+' with (nolock) where OwnerID = @OwnerID and TagName = @TagName)
							select -1   
						insert '+@TagsTableName+' (TagName,UserID,Author,OwnerID) values (@TagName,@UserID,@Author,@OwnerID)
						'
		exec sp_executesql @createSql,N'@UserID int,@TagName nvarchar(64),@Author nvarchar(64),@OwnerID int',@UserID=@UserID,@TagName=@TagName,@Author=@Author,@OwnerID=@OwnerID
		
		select 1;
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		zhengw
-- Create date: 2008-11-8
-- Description:	计算Application统计信息
-- =============================================
CREATE PROCEDURE [dbo].[spb_Application_CalculateStatistics] 
(
	@SqlPopulate ntext=''
)
AS
BEGIN

	SET NOCOUNT ON;
  
	exec sp_executesql @SqlPopulate

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ActivityItems_Res](
	[ItemID] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[ItemName] [nvarchar](64) NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_ActivityItems_Res_ItemID_LanguageCode] ON [dbo].[spb_ActivityItems_Res] 
(
	[ItemID] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_SystemData](
	[TradePoints] [int] NOT NULL
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NoticeItems_Res](
	[ItemID] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[ItemName] [nvarchar](64) NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_NoticeItems_Res_ItemID_LanguageCode] ON [dbo].[spb_NoticeItems_Res] 
(
	[ItemID] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Announcements](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[SubjectStyle] [nvarchar](256) NOT NULL,
	[IsHyperLink] [bit] NOT NULL,
	[Body] [ntext] NOT NULL,
	[AnnouncementStatus] [int] NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[ReleaseDate] [datetime] NOT NULL,
	[DateExpired] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserID] [int] NOT NULL,
	[IPAddress] [nvarchar](32) NOT NULL,
	[HitTimes] [int] NOT NULL,
	[IsSticky] [int] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[HyperLinkUrl] [nvarchar](512) NOT NULL,
 CONSTRAINT [PK_spb_Announcements] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Announcements_AnnouncementStatus] ON [dbo].[spb_Announcements] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Announcements_DisplayOrder] ON [dbo].[spb_Announcements] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Announcements_LastModified] ON [dbo].[spb_Announcements] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据@UserID获取获取某个用户的下载记录字典 */

create PROCEDURE [dbo].[spb_FileDownLoadRecords_GetByUserID]
(
    @UserID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
 dbo.spb_FileDownLoadRecords WITH (NOLOCK)
WHERE 
   UserID =@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_TagUsersInPhotos](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[DisplayName] [nvarchar](256) NOT NULL,
	[ThreadID] [int] NOT NULL,
	[OperatorUserID] [int] NOT NULL,
	[AreaX] [int] NOT NULL,
	[AreaY] [int] NOT NULL,
	[AreaWidth] [int] NOT NULL,
	[AreaHeight] [int] NOT NULL,
 CONSTRAINT [PK_spb_TagUsersInPhotos] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_TagUsersInPhotos_ThreadID] ON [dbo].[spb_TagUsersInPhotos] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_TagUsersInPhotos_UserID] ON [dbo].[spb_TagUsersInPhotos] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户可以连接到的朋友 **/

CREATE PROCEDURE [dbo].[spb_FriendConnectPaths_Get] 
(
    @FromUserID int,
    @Degree int = 2,    --默认获取3度关系
    @ToUserID int =0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
-- 创建临时表存储从@FromUserID 可以连接到的人脉路径
CREATE TABLE #TempPath 
(
    ConnectPath nvarchar(2000),
    FromUserID int,
    ToUserID int,
    Degree int,
    Distance int
)

declare @intDegree int

set @intDegree = 1
insert #TempPath select Convert(nvarchar(10),UserID)+'-'+Convert(nvarchar(10),FriendUserID),UserID,FriendUserID,@intDegree,Friendliness 
from spb_Friends with (nolock) where UserID=@FromUserID

while ((@intDegree < @Degree) and 
(exists (select FriendID from spb_Friends F with (nolock),#TempPath T where T.ToUserID=F.UserID and T.Degree=@intDegree 
    and F.FriendUserID not in (select T2.FromUserID from #TempPath T2) 
    and F.FriendUserID not in (select T2.ToUserID from #TempPath T2 where T2.Degree=@intDegree-1)
)))
    begin
        set @intDegree=@intDegree+1
        insert #TempPath select T.ConnectPath+'-'+ Convert(nvarchar(10),F.FriendUserID),F.UserID,F.FriendUserID,@intDegree,
          T.Distance+F.Friendliness from spb_Friends F with (nolock),#TempPath T where T.ToUserID=F.UserID and T.Degree=@intDegree-1 
	        and F.FriendUserID not in (select T2.FromUserID from #TempPath T2) 
          and F.FriendUserID not in (select T2.ToUserID from #TempPath T2)
    end

update #TempPath set FromUserID = @FromUserID

if (@ToUserID = 0)
    select * from #TempPath
else
    select * from #TempPath where ToUserID = @ToUserID

DROP TABLE #TempPath
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsUserDatas](
	[UserID] [int] NOT NULL,
	[TotalThreadCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_NewsUserDatas] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PrivacyItems_Res](
	[ItemID] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[ItemName] [nvarchar](64) NOT NULL,
	[Description] [nvarchar](256) NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_PrivacyItems_Res_ItemID_LanguageCode] ON [dbo].[spb_PrivacyItems_Res] 
(
	[ItemID] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据recordID获取FileDownLoadRecord */

create PROCEDURE [dbo].[spb_FileDownLoadRecord_Get]
(
    @RecordID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
 dbo.spb_FileDownLoadRecords	 WITH (NOLOCK)
WHERE 
    RecordID=@RecordID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsComments](
	[CommentID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[SectionID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](256) NOT NULL,
	[Title] [nvarchar](512) NOT NULL,
	[Body] [ntext] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_NewsComments] PRIMARY KEY CLUSTERED 
(
	[CommentID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsComments_PostDate] ON [dbo].[spb_NewsComments] 
(
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsComments_SectionID_PostDate] ON [dbo].[spb_NewsComments] 
(
	[SectionID] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsComments_ThreadID_PostDate] ON [dbo].[spb_NewsComments] 
(
	[ThreadID] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsComments_UserID] ON [dbo].[spb_NewsComments] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EventUserDatas](
	[UserID] [int] NOT NULL,
	[CreatedThreadCount] [int] NOT NULL,
	[JoinedThreadCount] [int] NOT NULL,
	[FavoriteThreadCount] [int] NOT NULL,
	[PhotoCount] [int] NOT NULL,
	[PostCount] [int] NOT NULL,
	[PhotoCommentCount] [int] NOT NULL,
	[ExperiencePoints] [int] NOT NULL,
 CONSTRAINT [PK_spb_EventUserDatas] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EventPhotos](
	[AttachmentID] [int] IDENTITY(1,1) NOT NULL,
	[EventID] [int] NOT NULL,
	[FriendlyFileName] [nvarchar](64) NOT NULL,
	[Description] [nvarchar](2048) NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[FileName] [nvarchar](64) NOT NULL,
	[ContentType] [nvarchar](64) NOT NULL,
	[ContentSize] [int] NOT NULL,
	[Height] [int] NOT NULL,
	[Width] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[CommentCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_EventPhotos] PRIMARY KEY CLUSTERED 
(
	[AttachmentID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventPhotos_EventID] ON [dbo].[spb_EventPhotos] 
(
	[EventID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_GlobalPrivacyItemSettings](
	[ItemID] [int] NOT NULL,
	[PrivacyDegree] [int] NOT NULL,
 CONSTRAINT [PK_spb_GlobalPrivacyItemSettings] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_GlobalPrivacyItemSettings_ItemID] ON [dbo].[spb_GlobalPrivacyItemSettings] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_Common_GetPagingRecords]
	@PageIndex int,
	@PageSize int,
	@FromClause varchar(512),                  --单个Table或者用Join关联的多个Table
	@SelectFields varchar(4000) = '*',         --查询字段，默认为 *
	@WhereClause nvarchar(4000) = N'',         --条件例如"DirectoryID=4"
	@SortField varchar(256),                   --排序字段 
	@SortFieldIsDesc bit = 1,                  --正序(0)还是倒序(1)
    @ReturnRecordCount bit = 1,                --是否需要返回查询到的记录数
    @MaxRecords int = -1,                      --最多获取多少条记录
	@TotalRecords int = -1 output,             --查询到的记录数
	@ReverseOrder bit = 0 output               --1表示读取数据的时候 排序要反过来

AS
BEGIN
	SET NOCOUNT ON;
	
	if (@PageIndex < 0)
	 set @PageIndex = 0;

	DECLARE @SQLString nvarchar(4000);
	DECLARE @WhereString1 nvarchar(4000);
	DECLARE @WhereString2 nvarchar(4000);

	IF @WhereClause IS NULL OR @WhereClause = N'' BEGIN
		SELECT @WhereString1 = N'';
		SELECT @WhereString2 = N'WHERE ';
	END
	ELSE BEGIN
		SELECT @WhereString1 = N'WHERE ' + @WhereClause;
		SELECT @WhereString2 = N'WHERE ' + @WhereClause + N' AND ';
	END

  --1.处理查询记录数
  IF @ReturnRecordCount=1 
    BEGIN
    DECLARE @SQLCountString nvarchar(4000);
    IF @MaxRecords>0
      set @SQLCountString = N'select @TotalRecords = count(*) from (select top ' + str(@MaxRecords)+ N' '+ @SortField 
        + N' from ' + @FromClause +N' ' + @WhereString1+ N') as TempCountTable';
    ELSE
      set @SQLCountString = N'select @TotalRecords = count(*) from ' + @FromClause + N' ' + @WhereString1;
  
    exec sp_executesql @SQLCountString,N'@TotalRecords int out ',@TotalRecords out  
    
	if(@PageIndex*@PageSize > @TotalRecords)
	  set @PageIndex=0	
    END 
  else 
    set @TotalRecords = -1

    IF (@MaxRecords>0  and @PageIndex*@PageSize>@MaxRecords)
	    set @PageIndex=0	

	IF @PageIndex = 0 BEGIN
		SELECT @SQLString = N'SELECT TOP ' + STR(@PageSize)
			+ N' ' + @SelectFields + N' FROM ' + @FromClause + N' ' + @WhereString1 + '	ORDER BY ' + @SortField;
			
		IF @SortFieldIsDesc = 1
			SELECT @SQLString = @SQLString + ' DESC';
						
		SET @ReverseOrder=0	
	END
	ELSE BEGIN
	-----------------------------------------------
	  DECLARE @SortField_NoPrefix varchar(256);
	  IF (CHARINDEX('.',@SortField)>0)
	    SET @SortField_NoPrefix = SUBSTRING(@SortField, CHARINDEX('.',@SortField)+1, LEN(@SortField));
	  ELSE
	    SET @SortField_NoPrefix = @SortField;
	
		SET @SQLString='';
		DECLARE @GetFromLast BIT
		IF @TotalRecords=-1
			SET @GetFromLast=0
		ELSE BEGIN
			DECLARE @TotalPage INT,@ResidualCount INT
			SET @ResidualCount=@TotalRecords%@PageSize
			IF @ResidualCount=0
				SET @TotalPage=@TotalRecords/@PageSize
			ELSE
				SET @TotalPage=@TotalRecords/@PageSize+1
			IF @PageIndex>@TotalPage/2 --页数过半，则从后往前算
				SET @GetFromLast=1
			ELSE
				SET @GetFromLast=0

			IF @GetFromLast=1 BEGIN
				IF @PageIndex=@TotalPage-1 BEGIN
					IF @ResidualCount=0
						SET @ResidualCount=@PageSize;
					SELECT @SQLString = N'SELECT top ' + STR(@ResidualCount)
						+ N' ' + @SelectFields
						+ N' FROM ' + @FromClause + N' ' + @WhereString1 + N' ORDER BY ' + @SortField;
					IF @SortFieldIsDesc = 0--正序
						SELECT @SQLString = @SQLString + ' DESC';
					SET @ReverseOrder=1
				END 
				ELSE IF  @PageIndex>@TotalPage-1 BEGIN --已经超过最大页数
					SELECT @SQLString = N'SELECT ' + @SelectFields
						+ N' FROM ' + @FromClause + ' WHERE 0=1'
					SET @ReverseOrder=0
				END
				ELSE BEGIN
					SET @PageIndex=@TotalPage-(@PageIndex+1)
					IF @SortFieldIsDesc=1
						SET @SortFieldIsDesc=0
					ELSE
						SET @SortFieldIsDesc=1
					SET @ReverseOrder=1
				END  
			END
			ELSE 
				SET @ReverseOrder=0
		END
		
		IF @SQLString='' BEGIN
			DECLARE @TopCount INT
			IF @GetFromLast=1 BEGIN
				SET @TopCount=@PageSize * (@PageIndex-1)+@ResidualCount
				IF @TopCount = 0
					SET @TopCount = @PageSize;
			END
			ELSE
				SET @TopCount=@PageSize * @PageIndex

			IF @SortFieldIsDesc = 1
				SELECT @SQLString = 'SELECT TOP ' + STR(@PageSize)
				+ N' ' + @SelectFields
				+ N' FROM ' + @FromClause+N' ' + @WhereString2 + @SortField + ' <
					(SELECT Min(' + @SortField_NoPrefix + ') FROM 
						(SELECT TOP ' + STR(@TopCount) + ' ' + @SortField + ' FROM ' + @FromClause + N' ' + @WhereString1 + '
								ORDER BY ' + @SortField + ' DESC) AS TempTable)
				ORDER BY ' + @SortField + ' DESC';
			ELSE
				SELECT @SQLString = 'SELECT TOP ' + STR(@PageSize)
				+ N' ' + @SelectFields
				+ N' FROM ' + @FromClause + N' ' + @WhereString2 + @SortField + ' >
					(SELECT Max(' + @SortField_NoPrefix + ') FROM 
						(SELECT TOP ' + STR(@TopCount) + ' ' + @SortField + ' FROM ' + @FromClause+ N' ' + @WhereString1 + '
								ORDER BY ' + @SortField + ' ASC) AS TempTable)
				ORDER BY ' + @SortField;
		END
	END
		
	EXEC sp_executesql @SQLString;

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除FileAttachments */

create PROCEDURE [dbo].[spb_FileDownLoadRecords_DeleteByUserID] 
(
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

delete dbo.spb_FileDownLoadRecords where UserID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserPointItems_Res](
	[ItemID] [int] NOT NULL,
	[LanguageCode] [varchar](20) NOT NULL,
	[ItemName] [nvarchar](64) NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_UserPointItems_Res_ItemID_LanguageCode] ON [dbo].[spb_UserPointItems_Res] 
(
	[ItemID] ASC,
	[LanguageCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserVisits](
	[VisitID] [int] IDENTITY(1,1) NOT NULL,
	[FromUserID] [int] NOT NULL,
	[FromUserDisplayName] [nvarchar](64) NOT NULL,
	[FromUserType] [int] NOT NULL,
	[ToUserID] [int] NOT NULL,
	[ToUserDisplayName] [nvarchar](64) NOT NULL,
	[ToUserType] [int] NOT NULL,
	[VisitTimes] [int] NOT NULL,
	[LastVisitTime] [datetime] NOT NULL,
	[IsVisible] [bit] NOT NULL,
 CONSTRAINT [PK_spb_UserVisits] PRIMARY KEY CLUSTERED 
(
	[VisitID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserVisits_FromUserID] ON [dbo].[spb_UserVisits] 
(
	[FromUserID] ASC,
	[LastVisitTime] DESC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserVisits_ToUserID] ON [dbo].[spb_UserVisits] 
(
	[ToUserID] ASC,
	[LastVisitTime] DESC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 简历点击计数 **/
Create PROCEDURE [dbo].[spb_ResumeView_Add]
(
	@ItemID int,
	@WebViewCount int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Resumes set HitTimes = HitTimes+@WebViewCount,WeekHitTimes = WeekHitTimes+@WebViewCount where UserID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_MicroBlog_UpdateTimeLine] 
(
	@Action int,
	@UserID int,
	@FollowedUserID int = 0,
	@DateScope int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
IF (@Action = 0) --添加
Begin
	DECLARE @startDate datetime
	SET @startDate = convert(char(10),getdate() - @DateScope,120)
    insert into spb_MicroBlogTimeLine (UserID,ThreadID,FollowedUserID) Select @UserID,ThreadID,@FollowedUserID From spb_MicroBlogThreads Where DateCreated >= @startDate
End
ELSE IF (@Action = 2)
	Delete From spb_MicroBlogTimeLine Where UserID = @UserID and FollowedUserID = @FollowedUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ClubSharedContentTags](
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[OwnerID] [int] NOT NULL,
 CONSTRAINT [PK_spb_ClubSharedContentTags_1] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubSharedContentTags_ownerID] ON [dbo].[spb_ClubSharedContentTags] 
(
	[OwnerID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogFollows](
	[FollowID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[DisplayName] [nvarchar](64) NOT NULL,
	[ItemID] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_MicroBlogFollows] PRIMARY KEY CLUSTERED 
(
	[FollowID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogFollows_ItemID] ON [dbo].[spb_MicroBlogFollows] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogFollows_UserID] ON [dbo].[spb_MicroBlogFollows] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PermissionItemRolesInUserRanks](
	[ItemID] [int] NOT NULL,
	[Rank] [int] NOT NULL,
	[AllowType] [int] NOT NULL,
	[AllowedValue] [float] NOT NULL,
 CONSTRAINT [PK_spb_PermissionItemRolesInUserRanks] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[Rank] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_PermissionItemRolesInUserRanks_ItemID_Rank] ON [dbo].[spb_PermissionItemRolesInUserRanks] 
(
	[ItemID] ASC,
	[Rank] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ClubLinks](
	[LinkID] [int] IDENTITY(1,1) NOT NULL,
	[ClubID] [int] NOT NULL,
	[CategoryID] [int] NOT NULL,
	[Title] [nvarchar](256) NOT NULL,
	[ImageUrl] [nvarchar](256) NOT NULL,
	[LinkTitle] [nvarchar](256) NOT NULL,
	[LinkHref] [nvarchar](256) NOT NULL,
	[LinkType] [int] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IsEnabled] [bit] NOT NULL,
 CONSTRAINT [PK_spb_ClubLinks] PRIMARY KEY CLUSTERED 
(
	[LinkID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubLinks_CategoryID_DisplayOrder] ON [dbo].[spb_ClubLinks] 
(
	[CategoryID] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubLinks_ClubID_CategoryID] ON [dbo].[spb_ClubLinks] 
(
	[ClubID] ASC,
	[CategoryID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubLinks_DisplayOrder] ON [dbo].[spb_ClubLinks] 
(
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取UserNavigations集合 **/
CREATE PROCEDURE [dbo].[spb_UserNavigations_Get]
(
	@UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
	select u.* from spb_UserNavigations u with (nolock) 
	where u.UserID = @UserID order by u.DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、活动每天执行任务
*/

Create PROCEDURE [dbo].[spb_Task_Event_PerStage]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

exec spb_Task_Event_Statistics
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_VoteComments](
	[CommentID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[ThreadOwnerID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[Author] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_VoteComments] PRIMARY KEY CLUSTERED 
(
	[CommentID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserVoteComments_ThreadID] ON [dbo].[spb_VoteComments] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_MicroBlog_CreateDeleteOfScreen] 
(
    @Action int,
    @ItemID int output,
    @ThreadID int = 0,
	@ScreenID int = 0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
begin
	INSERT spb_MicroBlogsOfScreens (ScreenID,ThreadID)Values (@ScreenID,@ThreadID)
	SET @ItemID = SCOPE_IDENTITY()
End
else if (@Action = 2)
    delete from spb_MicroBlogsOfScreens where ItemID = @ItemID and ScreenID = @ScreenID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取收藏 **/

CREATE PROCEDURE [dbo].[spb_Favorite_GetByFavoriteID]
(
  @FavoriteTableName nvarchar(64),
  @FavoriteID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @sql nvarchar(1000)
set @sql='SELECT  * FROM '+@FavoriteTableName+' WHERE  FavoriteID = @FavoriteID'
exec sp_executesql @sql,N'@FavoriteID int', @FavoriteID = @FavoriteID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EmailQueue](
	[EmailID] [uniqueidentifier] NOT NULL,
	[emailPriority] [int] NOT NULL,
	[IsBodyHtml] [bit] NOT NULL,
	[emailTo] [nvarchar](2000) NOT NULL,
	[emailCc] [ntext] NULL,
	[emailBcc] [ntext] NULL,
	[EmailFrom] [nvarchar](256) NOT NULL,
	[EmailSubject] [nvarchar](1024) NOT NULL,
	[EmailBody] [ntext] NOT NULL,
	[NextTryTime] [datetime] NOT NULL,
	[NumberOfTries] [int] NOT NULL,
 CONSTRAINT [PK_spb_EmailQueue] PRIMARY KEY CLUSTERED 
(
	[EmailID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EmailQueue_NextTryTime] ON [dbo].[spb_EmailQueue] 
(
	[NextTryTime] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogTopics](
	[TopicID] [int] IDENTITY(1,1) NOT NULL,
	[Title] [nvarchar](150) NOT NULL,
	[Body] [nvarchar](150) NOT NULL,
	[UserID] [int] NOT NULL,
	[IsFeatured] [bit] NOT NULL,
	[ItemCount] [int] NOT NULL,
	[StageItemCount] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_MiniBlogTopices] PRIMARY KEY CLUSTERED 
(
	[TopicID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogTopices_ItemCount] ON [dbo].[spb_MicroBlogTopics] 
(
	[ItemCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogTopices_StageItemCount] ON [dbo].[spb_MicroBlogTopics] 
(
	[StageItemCount] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogThreadsReferUsers](
	[UserID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_MicroBlogThreadsReferUsers_UserID_ThreadID] ON [dbo].[spb_MicroBlogThreadsReferUsers] 
(
	[UserID] ASC,
	[ThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsTitlePrefixes](
	[PrefixID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_NewsTitlePrefixes] PRIMARY KEY CLUSTERED 
(
	[PrefixID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PrivateMessageThreads](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[SenderUserID] [int] NOT NULL,
	[Sender] [nvarchar](64) NOT NULL,
	[ReceiverUserID] [int] NOT NULL,
	[Receiver] [nvarchar](64) NOT NULL,
	[RelativeItemID] [int] NOT NULL,
	[RelativeItemName] [nvarchar](64) NOT NULL,
	[MessageType] [int] NOT NULL,
	[IsLocked] [bit] NOT NULL,
	[ReplyCount] [int] NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[LastRepliedDate] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ PrivateMessageThreads] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PrivateMessageThreads_LastRepliedDate] ON [dbo].[spb_PrivateMessageThreads] 
(
	[LastRepliedDate] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新item的所属UserTag **/
CREATE PROCEDURE [dbo].[spb_ItemsInUserTag_Update]
(
	@UserTagsTableName nvarchar(64),
	@SiteTagsTableName nvarchar(64),
	@InUserTagsTableName nvarchar(64),
	@ItemID int,
	@TagName nvarchar(64)
)
AS
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED
declare @strSql nvarchar(800)
set @strSql='insert into '+@InUserTagsTableName+'(TagName,ItemID)values(@TagName,@ItemID)
update '+@UserTagsTableName+' set ItemCount=ItemCount+1 where TagName=@TagName
update '+@SiteTagsTableName+' set ItemCount=ItemCount+1 where TagName =@TagName'
exec sp_executesql @strSql,N'@TagName nvarchar(64),@ItemID int',@TagName=@TagName,@ItemID=@ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**
<summary>
根据UserName或者UserID获取User，并可以记录用户活动状态
</summary>
**/

CREATE PROCEDURE [dbo].[spb_User_Get]
(
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

DECLARE @UserType as int

select @UserType = UserType from spb_users where UserID = @UserID
IF (@UserType is not null)
BEGIN

if @UserType =1  
  SELECT U.* FROM spb_vw_PersonUsers_FullUser U WHERE  U.UserID = @UserID                 
else if @UserType = 2
  SELECT U.* FROM spb_vw_CompanyUsers_FullUser U WHERE U.UserID = @UserID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ClubLinkCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[ClubID] [int] NOT NULL,
	[CategoryName] [nvarchar](256) NOT NULL,
	[Description] [nvarchar](1024) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_spb_ClubLinkCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubLinkCategories_ClubID_DisplayOrder] ON [dbo].[spb_ClubLinkCategories] 
(
	[ClubID] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsRatings](
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Rate] [int] NOT NULL,
 CONSTRAINT [PK_spb_NewsRatings] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsRatings_UserID] ON [dbo].[spb_NewsRatings] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EventThreads](
	[EventID] [int] IDENTITY(1,1) NOT NULL,
	[EventName] [nvarchar](64) NOT NULL,
	[UserID] [int] NOT NULL,
	[Sponsor] [nvarchar](64) NOT NULL,
	[ClubID] [int] NOT NULL,
	[SiteCategoryID] [int] NOT NULL,
	[AreaCode] [varchar](8) NOT NULL,
	[StartTime] [datetime] NOT NULL,
	[EndTime] [datetime] NOT NULL,
	[SignEndTime] [datetime] NOT NULL,
	[Location] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[FeaturedPhotoID] [int] NOT NULL,
	[EventStatus] [int] NOT NULL,
	[IsPublic] [bit] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[IsEssential] [bit] NOT NULL,
	[PayType] [int] NOT NULL,
	[IsOnlyAllowClubMemberSignUp] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[Points] [int] NOT NULL,
	[IsPointsEncashed] [bit] NOT NULL,
	[RatingSum] [int] NOT NULL,
	[TotalRatings] [int] NOT NULL,
	[FaviteCount] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[MemberCount] [int] NOT NULL,
	[PhotoCount] [int] NOT NULL,
	[PostCount] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_EventThreads] PRIMARY KEY CLUSTERED 
(
	[EventID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_AreaCode] ON [dbo].[spb_EventThreads] 
(
	[AreaCode] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_ClubID] ON [dbo].[spb_EventThreads] 
(
	[ClubID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_FaviteCount] ON [dbo].[spb_EventThreads] 
(
	[FaviteCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_HitTimes] ON [dbo].[spb_EventThreads] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_LastModified] ON [dbo].[spb_EventThreads] 
(
	[LastModified] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_MemberCount] ON [dbo].[spb_EventThreads] 
(
	[MemberCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_PhotoCount] ON [dbo].[spb_EventThreads] 
(
	[PhotoCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_PostCount] ON [dbo].[spb_EventThreads] 
(
	[PostCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_SiteCategoryID] ON [dbo].[spb_EventThreads] 
(
	[SiteCategoryID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_StartTime] ON [dbo].[spb_EventThreads] 
(
	[StartTime] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventThreads_UserID] ON [dbo].[spb_EventThreads] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsReaders](
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[ReaderDisplayName] [nvarchar](256) NOT NULL,
	[ConsumedPoint] [float] NOT NULL,
	[ReadDate] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_NewsReaders] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsReaders_ThreadID] ON [dbo].[spb_NewsReaders] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ItemsForIndex](
	[ItemID] [int] NOT NULL,
	[SearchTypeCode] [nvarchar](64) NOT NULL,
	[ClubID] [int] NOT NULL,
	[DataAction] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_ItemsForIndex] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[SearchTypeCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ItemsForIndex_SearchTypeCode] ON [dbo].[spb_ItemsForIndex] 
(
	[SearchTypeCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EventAreaStatistics](
	[AreaCode] [varchar](8) NOT NULL,
	[PublishedCount] [int] NOT NULL,
	[FinishedCount] [int] NOT NULL,
	[TotalCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_EventAreaStatistics] PRIMARY KEY CLUSTERED 
(
	[AreaCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubAreaStatistics_AreaCode] ON [dbo].[spb_EventAreaStatistics] 
(
	[AreaCode] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventAreaStatistics_AreaCode] ON [dbo].[spb_EventAreaStatistics] 
(
	[AreaCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_MicroBlog_InsertOfScreen] 
(
	@ItemID int output,
    @ThreadID int = 0,
	@TopThreadID int = 0,
	@ScreenID int = 0 
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @dateCreated datetime
select @dateCreated = DateCreated from spb_MicroBlogsOfScreens where ScreenID = @ScreenID and ThreadID = @ThreadID
if @dateCreated is null
Begin
	INSERT spb_MicroBlogsOfScreens (ScreenID,ThreadID)Values (@ScreenID,@ThreadID)
	set @ItemID = SCOPE_IDENTITY()
end
else
Begin
	set  @dateCreated = dateadd(millisecond,-2,@dateCreated)
	INSERT spb_MicroBlogsOfScreens (ScreenID,ThreadID,DateCreated)Values (@ScreenID,@ThreadID,@dateCreated)
	set @ItemID = SCOPE_IDENTITY()
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_GlobalActivityItemSettings](
	[ItemID] [int] NOT NULL,
	[IsAllowSending] [bit] NOT NULL,
	[IsAllowReceiving] [bit] NOT NULL,
 CONSTRAINT [PK_spb_GlobalActivityItemSettings] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_GlobalActivityItemSettings_ItemID] ON [dbo].[spb_GlobalActivityItemSettings] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PersonSiteTags](
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[UserCount] [int] NOT NULL,
	[LastModified] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_PersonsSiteTags] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FriendsInUserCategories](
	[CategoryID] [int] NOT NULL,
	[ItemID] [int] NOT NULL,
 CONSTRAINT [PK_spb_FriendsInUserCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC,
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FriendsInUserCategories_ItemID] ON [dbo].[spb_FriendsInUserCategories] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PermissionItems](
	[ItemID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[ItemKey] [nvarchar](64) NOT NULL,
	[ItemName] [nvarchar](64) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[EnabledPermissionLine] [bit] NOT NULL,
	[EnabledInUserRole] [bit] NOT NULL,
	[EnabledInUserRank] [bit] NOT NULL,
 CONSTRAINT [PK_spb_PermissionItems] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_PermissionItems_ItemKey] ON [dbo].[spb_PermissionItems] 
(
	[ItemKey] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PhotoMetaData](
	[ThreadID] [int] NOT NULL,
	[MetaKey] [nvarchar](128) NOT NULL,
	[MetaType] [nvarchar](128) NOT NULL,
	[MetaValue] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_PhotoMetaData] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC,
	[MetaKey] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ItemsInClubSharedContentTags](
	[ItemID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_ItemsInClubSharedContentTags_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ClubMembers](
	[ClubID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Rank] [int] NOT NULL,
	[Points] [int] NOT NULL,
	[ClubMemberRole] [int] NOT NULL,
	[Status] [int] NOT NULL,
	[ApplyRemark] [nvarchar](2000) NOT NULL,
	[InviteUserID] [int] NOT NULL,
	[InviteUserDisplayName] [nvarchar](64) NOT NULL,
	[EnableManagerNotification] [bit] NOT NULL,
	[EnableNotificationed] [bit] NOT NULL,
	[JoinDate] [datetime] NOT NULL,
	[DisplayName] [nvarchar](64) NOT NULL,
	[UserDisplayInformation] [nvarchar](2000) NOT NULL,
	[VisitTimes] [int] NOT NULL,
	[LastVisitTime] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ClubMembers] PRIMARY KEY CLUSTERED 
(
	[ClubID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubMembers_ClubID_LastVisitTime] ON [dbo].[spb_ClubMembers] 
(
	[ClubID] ASC,
	[LastVisitTime] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubMembers_JoinDate] ON [dbo].[spb_ClubMembers] 
(
	[JoinDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubMembers_UserID] ON [dbo].[spb_ClubMembers] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogsFavorites](
	[UserID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogsFavorites] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 更新大屏幕播放成员 */

CREATE PROCEDURE [dbo].[spb_MicroBlogScreenPalyItem_Add] 
(
    @ItemID int,
	@PlayCount int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
exec('Update spb_MicroBlogsOfScreens Set Status = 1 Where ScreenID = '+ @ItemID + 'and ItemID in (select Top ' 
+ @PlayCount + ' ItemID from spb_MicroBlogsOfScreens where ScreenID = ' + @ItemID + ' and Status = 0 order by DateCreated)')
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogThreadSiteTags](
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[UserCount] [int] NOT NULL,
	[LastModified] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_BlogThreadSiteTags] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreadSiteTags_ItemCount] ON [dbo].[spb_BlogThreadSiteTags] 
(
	[ItemCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreadSiteTags_LastModified] ON [dbo].[spb_BlogThreadSiteTags] 
(
	[LastModified] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreadSiteTags_UserCount] ON [dbo].[spb_BlogThreadSiteTags] 
(
	[UserCount] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_AuditingItems](
	[ItemID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[ItemKey] [nvarchar](64) NOT NULL,
	[ItemName] [nvarchar](64) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[EnabledInUserRole] [bit] NOT NULL,
	[EnabledInUserRank] [bit] NOT NULL,
 CONSTRAINT [PK_spb_AuditingItems] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_AuditingItems_ItemKey] ON [dbo].[spb_AuditingItems] 
(
	[ItemKey] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_AdvertisingsInPositions](
	[AdvertisingID] [int] NOT NULL,
	[PositionCode] [nvarchar](16) NOT NULL,
 CONSTRAINT [PK_spb_AdvertisingsInPositions] PRIMARY KEY CLUSTERED 
(
	[AdvertisingID] ASC,
	[PositionCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_AdvertisingsInPositions_PositionCode] ON [dbo].[spb_AdvertisingsInPositions] 
(
	[PositionCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ConvertibleGift_ExchangeRecords](
	[RecordID] [int] IDENTITY(1,1) NOT NULL,
	[GiftID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[UserDisplayName] [nvarchar](64) NOT NULL,
	[Price] [int] NOT NULL,
	[TotalCount] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_ConvertibleGift_ExchangeRecords] PRIMARY KEY CLUSTERED 
(
	[RecordID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ConvertibleGift_ExchangeRecords_GiftID] ON [dbo].[spb_ConvertibleGift_ExchangeRecords] 
(
	[GiftID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ConvertibleGift_ExchangeRecords_UserID] ON [dbo].[spb_ConvertibleGift_ExchangeRecords] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FileSiteTags](
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[UserCount] [int] NOT NULL,
	[LastModified] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_FileSiteTags] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSiteTags_ItemCount] ON [dbo].[spb_FileSiteTags] 
(
	[ItemCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSiteTags_LastModified] ON [dbo].[spb_FileSiteTags] 
(
	[LastModified] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSiteTags_UserCount] ON [dbo].[spb_FileSiteTags] 
(
	[UserCount] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Identities](
	[IdentityID] [int] IDENTITY(1,1) NOT NULL,
	[Name] [nvarchar](64) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
 CONSTRAINT [PK_spb_Identities] PRIMARY KEY CLUSTERED 
(
	[IdentityID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserShareThreads](
	[UserThreadID] [int] IDENTITY(1,1) NOT NULL,
	[ThreadID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Body] [nvarchar](512) NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_UserShareThreads] PRIMARY KEY CLUSTERED 
(
	[UserThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogThreadAttachments](
	[AttachmentID] [int] IDENTITY(1,1) NOT NULL,
	[ThreadID] [int] NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[FileName] [nvarchar](512) NOT NULL,
	[FriendlyFileName] [nvarchar](512) NOT NULL,
	[ContentType] [nvarchar](64) NOT NULL,
	[ContentSize] [int] NOT NULL,
	[Height] [int] NOT NULL,
	[Width] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[DownloadCount] [int] NOT NULL,
	[IsCreatedByAdministrator] [bit] NOT NULL,
 CONSTRAINT [PK_spb_BlogThreadAttachments] PRIMARY KEY CLUSTERED 
(
	[AttachmentID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreadAttachments_OwnerUserID] ON [dbo].[spb_BlogThreadAttachments] 
(
	[OwnerUserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreadAttachments_ThreadID] ON [dbo].[spb_BlogThreadAttachments] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_AnnouncementsInPresentAreas](
	[ThreadID] [int] NOT NULL,
	[PresentAreaID] [int] NOT NULL,
 CONSTRAINT [PK_spb_AnnouncementsInPresentAreas] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC,
	[PresentAreaID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_AnnouncementsInPresentAreas_PresentAreaID] ON [dbo].[spb_AnnouncementsInPresentAreas] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_NavigationNameRes_Get]
(
    @NavigationID int
)
as
select * from spb_Navigations_Res where NavigationID = @NavigationID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogThreadUserTags](
	[UserID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_BlogThreadUserTags_1] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreadUserTags_DateCreated] ON [dbo].[spb_BlogThreadUserTags] 
(
	[DateCreated] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogThreadUserTags_ItemCount] ON [dbo].[spb_BlogThreadUserTags] 
(
	[ItemCount] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FriendActivities](
	[ActivityID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[ActivityItemID] [int] NOT NULL,
	[LeadingActorUserID] [int] NOT NULL,
	[LeadingActor] [nvarchar](256) NOT NULL,
	[RelativeItemID] [int] NOT NULL,
	[RelativeItemName] [nvarchar](256) NOT NULL,
	[Subject] [nvarchar](512) NOT NULL,
	[Body] [ntext] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_FriendActivities] PRIMARY KEY CLUSTERED 
(
	[ActivityID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PrivateMessageInbox](
	[UserID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[MessageType] [int] NOT NULL,
	[IsLocked] [bit] NOT NULL,
	[SenderUserID] [int] NOT NULL,
	[Sender] [nvarchar](64) NOT NULL,
	[MostRecentPostDate] [datetime] NOT NULL,
	[MostRecentPostID] [int] NOT NULL,
	[MostRecentPostSubject] [nvarchar](512) NOT NULL,
	[MostRecentPostBody] [nvarchar](3000) NOT NULL,
	[IsRead] [bit] NOT NULL,
 CONSTRAINT [PK_spb_PrivateMessageInbox] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FileComments](
	[PostID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Subject] [nvarchar](512) NOT NULL,
	[Body] [ntext] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[IsApproved] [bit] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[PostDate] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_FileComments] PRIMARY KEY CLUSTERED 
(
	[PostID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileComments_OwnerUserID_PostDate] ON [dbo].[spb_FileComments] 
(
	[OwnerUserID] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileComments_PostDate] ON [dbo].[spb_FileComments] 
(
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileComments_ThreadID_PostDate] ON [dbo].[spb_FileComments] 
(
	[ThreadID] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileComments_UserID] ON [dbo].[spb_FileComments] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EventPhotoComments](
	[CommentID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[AttachmentID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Body] [ntext] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ EventPhotoComments] PRIMARY KEY CLUSTERED 
(
	[CommentID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ EventPhotoComments_AttachmentID] ON [dbo].[spb_EventPhotoComments] 
(
	[AttachmentID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ EventPhotoComments_UserID] ON [dbo].[spb_EventPhotoComments] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_AuditingItemSettingsInUserRoles](
	[ItemID] [int] NOT NULL,
	[RoleID] [int] NOT NULL,
	[StrictDegree] [int] NOT NULL,
	[IsLocked] [bit] NOT NULL,
 CONSTRAINT [PK_spb_AuditingItemSettingsInUserRoles_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[RoleID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserPrivacyItemSettings](
	[UserID] [int] NOT NULL,
	[ItemID] [int] NOT NULL,
	[PrivacyDegree] [int] NOT NULL,
 CONSTRAINT [PK_spb_UserPrivacyItemSettings] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_AuditingItemSettingsInUserRanks](
	[ItemID] [int] NOT NULL,
	[Rank] [int] NOT NULL,
	[StrictDegree] [int] NOT NULL,
 CONSTRAINT [PK_spb_AuditingItemSettingsInUserRanks_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[Rank] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Photos](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[UserCategoryID] [int] NOT NULL,
	[SiteCategoryID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[LastRepliedDate] [datetime] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[IsLocked] [bit] NOT NULL,
	[Password] [nvarchar](64) NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[IsEssential] [bit] NOT NULL,
	[SpecialOrder] [int] NOT NULL,
	[StickyDate] [datetime] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[RssViewTimes] [int] NOT NULL,
	[RatingSum] [int] NOT NULL,
	[TotalRatings] [int] NOT NULL,
	[Subject] [nvarchar](512) NOT NULL,
	[Body] [ntext] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[FileName] [nvarchar](512) NOT NULL,
	[ContentType] [nvarchar](64) NOT NULL,
	[ContentSize] [int] NOT NULL,
	[Height] [int] NOT NULL,
	[Width] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_Photos] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Photos_CommentCount] ON [dbo].[spb_Photos] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Photos_HitTimes] ON [dbo].[spb_Photos] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Photos_LastRepliedDate] ON [dbo].[spb_Photos] 
(
	[LastRepliedDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Photos_OwnerUserID_AuditingStatus_IsPublic] ON [dbo].[spb_Photos] 
(
	[OwnerUserID] ASC,
	[AuditingStatus] ASC,
	[PrivacyStatus] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Photos_PostDate] ON [dbo].[spb_Photos] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Photos_RssViewTimes] ON [dbo].[spb_Photos] 
(
	[RssViewTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Photos_SiteCategoryID_AuditingStatus_IsPublic] ON [dbo].[spb_Photos] 
(
	[SiteCategoryID] ASC,
	[AuditingStatus] ASC,
	[PrivacyStatus] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Photos_SpecialOrder_PostDate] ON [dbo].[spb_Photos] 
(
	[SpecialOrder] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Photos_TotalRatings] ON [dbo].[spb_Photos] 
(
	[TotalRatings] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PhotoUserTags](
	[UserID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_PhotoUserTags_1] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoUserTags_ItemCount] ON [dbo].[spb_PhotoUserTags] 
(
	[ItemCount] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_VoteOptions](
	[OptionID] [int] IDENTITY(1,1) NOT NULL,
	[ThreadID] [int] NOT NULL,
	[VoteCount] [int] NOT NULL,
	[OptionName] [nvarchar](512) NOT NULL,
 CONSTRAINT [PK_spb_VoteOptions] PRIMARY KEY CLUSTERED 
(
	[OptionID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserVoteOptions_ThreadID] ON [dbo].[spb_VoteOptions] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogComments](
	[CommentID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Body] [nvarchar](1024) NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[PostMode] [int] NOT NULL,
	[PostSource] [nvarchar](64) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_MicroBlogComments] PRIMARY KEY CLUSTERED 
(
	[CommentID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogComments_OwnerUserID] ON [dbo].[spb_MicroBlogComments] 
(
	[OwnerUserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogComments_ThreadID] ON [dbo].[spb_MicroBlogComments] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EventMembers](
	[MemberID] [int] IDENTITY(1,1) NOT NULL,
	[EventID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[IsManager] [bit] NOT NULL,
	[IsApproved] [bit] NOT NULL,
	[BringCount] [int] NOT NULL,
	[SignUpDate] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_EventMembers] PRIMARY KEY CLUSTERED 
(
	[MemberID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventMembers_EventID] ON [dbo].[spb_EventMembers] 
(
	[EventID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FriendActivityInbox](
	[UserID] [int] NOT NULL,
	[ActivityID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
 CONSTRAINT [PK_spb_FriendActivityInbox] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ActivityID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FriendActivityInbox_ApplicationID] ON [dbo].[spb_FriendActivityInbox] 
(
	[UserID] ASC,
	[ApplicationID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FriendActivityInbox_UserID_ApplicationID] ON [dbo].[spb_FriendActivityInbox] 
(
	[UserID] ASC,
	[ApplicationID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ClubActivities](
	[ActivityID] [int] IDENTITY(1,1) NOT NULL,
	[ClubID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[LeadingActorUserID] [int] NOT NULL,
	[LeadingActor] [nvarchar](256) NOT NULL,
	[RelativeItemID] [int] NOT NULL,
	[RelativeItemName] [nvarchar](256) NOT NULL,
	[Subject] [nvarchar](512) NOT NULL,
	[Body] [ntext] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ClubActivities] PRIMARY KEY CLUSTERED 
(
	[ActivityID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubActivities_ApplicationID] ON [dbo].[spb_ClubActivities] 
(
	[ClubID] ASC,
	[ApplicationID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubActivities_ClubID] ON [dbo].[spb_ClubActivities] 
(
	[ClubID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ConvertibleGifts](
	[GiftID] [int] IDENTITY(1,1) NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[Price] [int] NOT NULL,
	[TotalCount] [int] NOT NULL,
	[ExchangedCount] [int] NOT NULL,
	[ImageFileName] [nvarchar](256) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[IsEnabled] [bit] NOT NULL,
 CONSTRAINT [PK_spb_ConvertibleGifts] PRIMARY KEY CLUSTERED 
(
	[GiftID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ConvertibleGifts_Price] ON [dbo].[spb_ConvertibleGifts] 
(
	[Price] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_SpecialPrivacyUsers](
	[UserID] [int] NOT NULL,
	[ToUserID] [int] NOT NULL,
	[ToUserDisplayName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_SpecialPrivacyUsers] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ToUserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PhotoUserCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[CategoryName] [nvarchar](128) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[ItemCount] [int] NOT NULL,
	[MostRecentUpdateDate] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_PhotoUserCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoUserCategories_ItemCount] ON [dbo].[spb_PhotoUserCategories] 
(
	[ItemCount] DESC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoUserCategories_MostRecentUpdateDate] ON [dbo].[spb_PhotoUserCategories] 
(
	[MostRecentUpdateDate] DESC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotoUserCategories_UserID] ON [dbo].[spb_PhotoUserCategories] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_WidgetsInZones](
	[InstanceID] [int] IDENTITY(1,1) NOT NULL,
	[WidgetID] [char](16) NOT NULL,
	[OwnerID] [int] NOT NULL,
	[ZoneID] [int] NOT NULL,
	[WidgetXml] [ntext] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_spb_WidgetsInZones] PRIMARY KEY CLUSTERED 
(
	[InstanceID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_WidgetsInZones_OwnerID_ZoneID_DisplayOrder] ON [dbo].[spb_WidgetsInZones] 
(
	[OwnerID] ASC,
	[ZoneID] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FilesInUserTags](
	[ItemID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_FilesInUserTags_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FilesInUserTags_ItemID] ON [dbo].[spb_FilesInUserTags] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_NewsSections](
	[SectionID] [int] IDENTITY(1,1) NOT NULL,
	[SectionName] [nvarchar](256) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ParentIDList] [nvarchar](256) NOT NULL,
	[ChildCount] [int] NOT NULL,
	[Depth] [int] NOT NULL,
	[Description] [nvarchar](2000) NOT NULL,
	[NewsSectionType] [int] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IsActive] [bit] NOT NULL,
	[EnaleSearch] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[MostRecentPostDate] [datetime] NULL,
	[MostRecentThreadID] [int] NULL,
	[MostRecentThreadTitle] [nvarchar](256) NULL,
	[ThreadCount] [int] NOT NULL,
	[PageList] [nvarchar](56) NOT NULL,
	[PageDetail] [nvarchar](56) NOT NULL,
	[PageShowSection] [nvarchar](56) NOT NULL,
	[CommentCount] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_NewsSections] PRIMARY KEY CLUSTERED 
(
	[SectionID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsSections_CommentCount] ON [dbo].[spb_NewsSections] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsSections_DisplayOrder] ON [dbo].[spb_NewsSections] 
(
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsSections_MostRecentPostDate] ON [dbo].[spb_NewsSections] 
(
	[MostRecentPostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_NewsSections_ThreadCount] ON [dbo].[spb_NewsSections] 
(
	[ThreadCount] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、资讯每天执行任务
*/

Create PROCEDURE [dbo].[spb_Task_News_PerDay]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

exec spb_Task_News_Statistics
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_VoteRecords](
	[RecordID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[UserDisplayName] [nvarchar](256) NOT NULL,
	[OptionID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[IsAnonymousVote] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_VoteRecords] PRIMARY KEY CLUSTERED 
(
	[RecordID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserVoteRecords_OptionID] ON [dbo].[spb_VoteRecords] 
(
	[OptionID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserVoteRecords_ThreadID_UserID] ON [dbo].[spb_VoteRecords] 
(
	[ThreadID] ASC,
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_Common_GetPagingRecordsWithNotIn]
	@PageIndex int = 0,
	@PageSize int,
	@FromClause varchar(1024),                 --单个Table或者用Join关联的多个Table
	@SelectFields varchar(512),                --查询字段
	@WhereClause nvarchar(4000) = N'',         --条件例如"DirectoryID=4"
	@OrderByClause varchar(256),               --排序字段,
	@UniqueField varchar(256),                 --唯一列
	@ReturnRecordCount bit = 0,                --是否需要返回查询到的记录数
	@MaxRecords int = -1,                      --最多获取多少条记录
	@TotalRecords int = -1 output              --1表示读取数据的时候
AS
BEGIN
	SET NOCOUNT ON;
	
	DECLARE @SQLString nvarchar(4000);
	DECLARE @WhereString1 nvarchar(4000);
	DECLARE @WhereString2 nvarchar(4000);

	IF @WhereClause IS NULL OR @WhereClause = N'' BEGIN
		SELECT @WhereString1 = N'';
		SELECT @WhereString2 = N'WHERE ';
	END
	ELSE BEGIN
		SELECT @WhereString1 = N'WHERE ' + @WhereClause;
		SELECT @WhereString2 = N'WHERE ' + @WhereClause + N' AND ';
	END

  --1.处理查询记录数
	IF @ReturnRecordCount=1 
	BEGIN
		DECLARE @SQLCountString nvarchar(4000);
		IF @MaxRecords>0
		  set @SQLCountString = N'select @RecordCount = count(*) from (select top ' + str(@MaxRecords) + N' ' + @UniqueField 
			+ N' from ' + @FromClause +N' ' + @WhereString1+ N') as TempCountTable';
		ELSE
		  set @SQLCountString = N'select @RecordCount = count(*) from ' + @FromClause + N' ' + @WhereString1;
		  
		exec sp_executesql @SQLCountString,N'@RecordCount int out ',@TotalRecords out  
		
	    if(@PageIndex*@PageSize > @TotalRecords)
	      set @PageIndex=0	
	END 
	
    IF (@MaxRecords>0  and @PageIndex*@PageSize>@MaxRecords)
	    set @PageIndex=0	
	
	IF @PageIndex = 0 BEGIN
		SELECT @SQLString = N'SELECT TOP ' + STR(@PageSize)
			+ N' ' + @SelectFields + N' FROM ' + @FromClause + N' ' + @WhereString1 + '	ORDER BY ' + @OrderByClause;
	END
	ELSE BEGIN		
		SET @SQLString = N'SELECT TOP ' + STR(@PageSize) + N' ' + @SelectFields + N' FROM ' + @FromClause + N' ' + @WhereString2 + @UniqueField + N' NOT IN (SELECT TOP ' + STR(@pageSize*@pageIndex) + N' ' + @UniqueField + N' FROM ' + @FromClause + N' ' + @WhereString1 + N'ORDER BY ' + @OrderByClause + N') ORDER BY ' + @OrderByClause;
	END
	
	EXEC sp_executesql @SQLString;

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_EventRatings](
	[EventID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Rate] [int] NOT NULL,
 CONSTRAINT [PK_spb_EventRatings] PRIMARY KEY CLUSTERED 
(
	[EventID] ASC,
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_EventRatings_UserID] ON [dbo].[spb_EventRatings] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ItemsInForumTags](
	[ItemID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_ItemsInForumTags_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、更新，删除收藏 */

CREATE PROCEDURE [dbo].[spb_Favorite_CreateUpdateDelete]
( 
	@FavoriteTableName nvarchar(64)='',
    @Action int,
	@FavoriteID	int out,
	@UserID	int=0,
	@DisplayName	nvarchar(64)='',
	@ItemID	int='',
 
	@PrivacyStatus	int	=301,
    @PropertyNames	ntext=null,
    @PropertyValues	ntext=null	
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
		declare @delSql nvarchar(500)
		set @delSql='delete from '+@FavoriteTableName+' where FavoriteID = @FavoriteID'
		exec sp_executesql @delSql,N'@FavoriteID int',@FavoriteID=@FavoriteID
		return
    END
else if( @Action = 1 )
    begin
		declare @updateSql nvarchar(1024)
		set @updateSql='update '+@FavoriteTableName+'
                  set PrivacyStatus=@PrivacyStatus,PropertyNames=@PropertyNames, PropertyValues=@PropertyValues where FavoriteID=@FavoriteID'
        
		exec sp_executesql @updateSql,
			N'@FavoriteID int,
			@PrivacyStatus	int,
			@PropertyNames	ntext ,
			@PropertyValues	ntext ',@FavoriteID=@FavoriteID,@PrivacyStatus=@PrivacyStatus,@PropertyNames=@PropertyNames, @PropertyValues=@PropertyValues
		return
    end
else --添加
    BEGIN 
		--重复收藏
		declare @createSql nvarchar(1024)
		set @createSql='if exists (select top 1 FavoriteID from '+@FavoriteTableName+' where UserID = @UserID and ItemID = @ItemID)
            return
        INSERT INTO '+@FavoriteTableName+'
                   (UserID, DisplayName, ItemID, PrivacyStatus, DateCreated, PropertyNames, PropertyValues)
        VALUES     (@UserID,@DisplayName,@ItemID,@PrivacyStatus, GETDATE(),@PropertyNames,@PropertyValues)
        set @FavoriteID =SCOPE_IDENTITY()'
		exec sp_executesql @createSql,
			N'@FavoriteID int output,
			@UserID int,
			@DisplayName nvarchar(64) ,
			@ItemID	int,
			
			@PrivacyStatus	int ,
			@PropertyNames	ntext ,
			@PropertyValues	ntext ',@FavoriteID output,@UserID=@UserID,@DisplayName=@DisplayName,@ItemID=@ItemID,@PrivacyStatus=@PrivacyStatus,
		@PropertyNames=@PropertyNames, @PropertyValues=@PropertyValues
		return
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ClubActivityInbox](
	[UserID] [int] NOT NULL,
	[ActivityID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
 CONSTRAINT [PK_spb_ClubActivityInbox] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[ActivityID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ClubActivityInbox_UserID_ApplicationID] ON [dbo].[spb_ClubActivityInbox] 
(
	[UserID] ASC,
	[ApplicationID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserIdentities](
	[UserID] [int] NOT NULL,
	[IdentityID] [int] NOT NULL,
	[IdentityDescription] [nvarchar](256) NOT NULL,
 CONSTRAINT [PK_spb_UserIdentities] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_VoteThreads](
	[ThreadID] [int] IDENTITY(1,1) NOT NULL,
	[OwnerID] [int] NOT NULL,
	[Owner] [nvarchar](64) NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Subject] [nvarchar](64) NOT NULL,
	[Body] [nvarchar](512) NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[VoteStaus] [int] NOT NULL,
	[IsMultiple] [bit] NOT NULL,
	[MaxChooseCount] [int] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
	[VoterCount] [int] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
	[EndDate] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[LastModified] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_VoteThreads] PRIMARY KEY CLUSTERED 
(
	[ThreadID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_VoteThreads_CommentCount] ON [dbo].[spb_VoteThreads] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_VoteThreads_HitTimes] ON [dbo].[spb_VoteThreads] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_VoteThreads_OwnerID] ON [dbo].[spb_VoteThreads] 
(
	[OwnerID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_VoteThreads_PresentAreaID] ON [dbo].[spb_VoteThreads] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_VoteThreads_UserID] ON [dbo].[spb_VoteThreads] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_VoteThreads_VoterCount] ON [dbo].[spb_VoteThreads] 
(
	[VoterCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_VoteThreads_WeekHitTimes] ON [dbo].[spb_VoteThreads] 
(
	[StageHitTimes] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、迷你博客每天执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_MicroBlog_PerDay]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

exec spb_Task_MicroBlog_Statistics
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 设置朋友的所属类别 **/

CREATE PROCEDURE [dbo].[spb_UserCategoryOfItem_Create]
(
	@CategoriesTableName nvarchar(64),
	@UserItemTableName nvarchar(64),
    @ItemID	int,
	@CategoryID int
) 
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @sql nvarchar(1000)
set @sql='UPDATE '+@CategoriesTableName+' SET ItemCount = ItemCount + 1 WHERE CategoryID = @CategoryID
		  insert into '+@UserItemTableName+'(CategoryID,ItemID)values(@CategoryID,@ItemID)'
exec sp_executesql @sql,N'@CategoryID int,@ItemID int',@CategoryID=@CategoryID,@ItemID=@ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ForumSectionGroups](
	[GroupID] [int] IDENTITY(1,1) NOT NULL,
	[GroupName] [nvarchar](512) NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[OwnerID] [int] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[ThreadCount] [int] NOT NULL,
	[PostCount] [int] NOT NULL,
 CONSTRAINT [PK_spb_ForumSectionGroups] PRIMARY KEY CLUSTERED 
(
	[GroupID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumSectionGroups_OwnerID] ON [dbo].[spb_ForumSectionGroups] 
(
	[OwnerID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ForumSectionGroups_PresentAreaID] ON [dbo].[spb_ForumSectionGroups] 
(
	[PresentAreaID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FilesOfPendingDeletion](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[StorageProviderName] [nvarchar](256) NOT NULL,
	[FullDirectory] [nvarchar](1024) NOT NULL,
	[FileName] [nvarchar](256) NOT NULL,
	[DateCreated] [datetime] NOT NULL
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FilesOfPendingDeletion_StorageProviderName] ON [dbo].[spb_FilesOfPendingDeletion] 
(
	[StorageProviderName] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Roles](
	[RoleID] [int] IDENTITY(1,1) NOT NULL,
	[RoleName] [nvarchar](64) NOT NULL,
	[LoweredRoleName] [nvarchar](64) NOT NULL,
	[FriendlyRoleName] [nvarchar](64) NOT NULL,
	[IsBuiltIn] [bit] NOT NULL,
	[IsPublic] [bit] NOT NULL,
	[ConnectToUser] [bit] NOT NULL,
	[ApplicationID] [smallint] NOT NULL,
	[Description] [nvarchar](256) NOT NULL,
	[Enabled] [bit] NOT NULL,
 CONSTRAINT [PK_spb_Roles] PRIMARY KEY CLUSTERED 
(
	[RoleID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_Table_LoweredRoleName] ON [dbo].[spb_Roles] 
(
	[RoleID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_Table_RoleName] ON [dbo].[spb_Roles] 
(
	[RoleID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ItemsInNewsTags](
	[ItemID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_ItemsInNewsTags_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ItemsInNewsTags_ItemID] ON [dbo].[spb_ItemsInNewsTags] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FileUserCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[CategoryName] [nvarchar](128) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[ItemCount] [int] NOT NULL,
	[MostRecentUpdateDate] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_FileUserCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileUserCategories_UserID_DisplayOrder] ON [dbo].[spb_FileUserCategories] 
(
	[UserID] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PhotosInUserTags](
	[ItemID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_PhotosInUserTags_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PhotosInUserTags_ItemID] ON [dbo].[spb_PhotosInUserTags] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserShareThreadUserTags](
	[UserID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_UserShareThreadUserTags_1] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserShareThreadsInUserTags](
	[ItemID] [int] NOT NULL,
	[TagName] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_UserShareThreadsInUserTags_1] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC,
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserShareThreadsInUserTags_ItemID] ON [dbo].[spb_UserShareThreadsInUserTags] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UsersFavorites](
	[FavoriteID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[DisplayName] [nvarchar](64) NOT NULL,
	[ItemID] [int] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_UsersFavorites] PRIMARY KEY CLUSTERED 
(
	[FavoriteID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UsersFavorites_ItemID] ON [dbo].[spb_UsersFavorites] 
(
	[ItemID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UsersFavorites_UserID] ON [dbo].[spb_UsersFavorites] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_ImpeachReports](
	[ReportID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[OriginalUrl] [nvarchar](1024) NOT NULL,
	[Reason] [int] NOT NULL,
	[Remark] [nvarchar](2048) NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[IsComplete] [bit] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_ImpeachReports] PRIMARY KEY CLUSTERED 
(
	[ReportID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ImpeachReports_DateCreated] ON [dbo].[spb_ImpeachReports] 
(
	[DateCreated] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_ImpeachReports_IsComplete_DateCreated] ON [dbo].[spb_ImpeachReports] 
(
	[IsComplete] ASC,
	[DateCreated] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Footprints](
	[FootprintID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[ThreadID] [int] NOT NULL,
 CONSTRAINT [PK_spb_Footprints] PRIMARY KEY CLUSTERED 
(
	[FootprintID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Footprints_ThreadID] ON [dbo].[spb_Footprints] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Footprints_UserID] ON [dbo].[spb_Footprints] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
--获取用户参与的投票
CREATE procedure [dbo].[spb_VoteThreads_GetJoined]
(
    @UserID int
)
as
set transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
select ThreadID from spb_UserVoteRecords with(nolock) where userID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsSections_Get]

as
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select * from spb_NewsSections WITH (NOLOCK) order by DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取spb_Navigations **/
CREATE PROCEDURE [dbo].[spb_Navigation_Get]
(
	@NavigationID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select * from spb_Navigations with (nolock) where NavigationID = @NavigationID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FileDownLoadRecords](
	[RecordID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[UserDisplayName] [nvarchar](256) NOT NULL,
	[Price] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[FromUrl] [nvarchar](2000) NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_FileDownLoadRecords] PRIMARY KEY CLUSTERED 
(
	[RecordID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileDownLoadRecords_ThreadID] ON [dbo].[spb_FileDownLoadRecords] 
(
	[ThreadID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileDownLoadRecords_UserID] ON [dbo].[spb_FileDownLoadRecords] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取spb_Navigations **/
CREATE PROCEDURE [dbo].[spb_Navigations_Get]
(
	@OwnerType int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select n.* from spb_Navigations n with (nolock) left join spb_Applications a with (nolock) on (n.ApplicationID = a.ApplicationID ) where (a.IsEnabled = 1 or n.navigationtype = 1) and n.OwnerType = @OwnerType  order by n.DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据FriendID获取朋友 **/

CREATE PROCEDURE [dbo].[spb_Friend_Get] 
(
    @FriendID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select F.* from spb_Friends F with (nolock) where F.FriendID = @FriendID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MicroBlogFollowingsUserCategories](
	[CategoryID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[CategoryName] [nvarchar](128) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[ItemCount] [int] NOT NULL,
	[MostRecentUpdateDate] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_MicroBlogFollowingsUserCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_MicroBlogFollowingsUserCategories_UserID] ON [dbo].[MicroBlogFollowingsUserCategories] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogSections](
	[OwnerUserID] [int] NOT NULL,
	[SectionName] [nvarchar](512) NOT NULL,
	[Description] [nvarchar](2000) NOT NULL,
	[IsActive] [bit] NOT NULL,
	[EnableSearch] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[MostRecentPostDate] [datetime] NULL,
	[MostRecentThreadID] [int] NULL,
	[MostRecentThreadSubject] [nvarchar](216) NULL,
	[MostRecentThreadSummary] [nvarchar](2000) NULL,
	[ThreadCount] [int] NOT NULL,
	[CommentCount] [int] NOT NULL,
	[Points] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_Weblogs] PRIMARY KEY CLUSTERED 
(
	[OwnerUserID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Weblogs_CommentCount] ON [dbo].[spb_BlogSections] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Weblogs_DateCreated] ON [dbo].[spb_BlogSections] 
(
	[DateCreated] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Weblogs_HitTimes] ON [dbo].[spb_BlogSections] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Weblogs_Points] ON [dbo].[spb_BlogSections] 
(
	[Points] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Weblogs_ThreadCount] ON [dbo].[spb_BlogSections] 
(
	[ThreadCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Weblogs_WeekHitTimes] ON [dbo].[spb_BlogSections] 
(
	[StageHitTimes] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_UserShareThreadSiteTags](
	[TagName] [nvarchar](64) NOT NULL,
	[ItemCount] [int] NOT NULL,
	[UserCount] [int] NOT NULL,
	[LastModified] [datetime] NOT NULL,
 CONSTRAINT [PK_spb_UserShareThreadSiteTags] PRIMARY KEY CLUSTERED 
(
	[TagName] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserShareThreadSiteTags_ItemCount] ON [dbo].[spb_UserShareThreadSiteTags] 
(
	[ItemCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_UserShareThreadSiteTags_LastModified] ON [dbo].[spb_UserShareThreadSiteTags] 
(
	[LastModified] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 移动spb_NewsSections */

CREATE PROCEDURE [dbo].[spb_NewsSections_Move] 
(
    @fromSectionID int ,
    @toSectionID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @oldParentID int
select @oldParentID=ParentID from spb_NewsSections WITH (NOLOCK) where SectionID=@fromSectionID

--移动类别
update spb_NewsSections set ParentID=@toSectionID where SectionID=@fromSectionID
--更新旧父类ChildCount
update spb_NewsSections set ChildCount=ChildCount-1 where SectionID=@oldParentID
--更新新父类ChildCount
update spb_NewsSections set ChildCount=ChildCount+1 where SectionID=@toSectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新频道导航的顺序 **/
CREATE PROCEDURE [dbo].[spb_Navigation_UpdateNavigationDisplayOrder]
(
	@OwnerType int,
	@NavigationID int,
	@DisplayOrder int	
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

update spb_Navigations set DisplayOrder = @DisplayOrder where NavigationID = @NavigationID and OwnerType = @OwnerType
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据UserID、FriendUserID获取FriendID */

CREATE PROCEDURE [dbo].[spb_FriendID_Get] 
(
	@UserID int,
	@FriendUserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select FriendID from spb_Friends with (nolock) where UserID=@UserID and FriendUserID=@FriendUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsSection_Get]
(
	@SectionID int 
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select * from spb_NewsSections WITH (NOLOCK) where sectionID=@SectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除spb_Navigations **/
CREATE PROCEDURE [dbo].[spb_Navigation_CreateUpdateDelete]
(
	@Action int,
	@NavigationID int output,
	@NavigationType int=0,
	@OwnerType int = 0,
	@ApplicationID int=0,
	@NavigationText nvarchar(64)='',
	@NavigationUrl nvarchar(512)='',
	@NavigationTarget nvarchar(64)='',
	@DisplayOrder int=0,
	@IsEnabled bit = 1
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

if @Action = 2 --删除
    begin
		delete spb_Navigations where NavigationID = @NavigationID
    end

else if @Action =1 --更新
    begin
		update spb_Navigations set NavigationType = @NavigationType,OwnerType = @OwnerType,ApplicationID = @ApplicationID,
			NavigationText = @NavigationText,NavigationUrl = @NavigationUrl,NavigationTarget=@NavigationTarget,
			DisplayOrder = @DisplayOrder,IsEnabled = @IsEnabled where NavigationID=@NavigationID
    end
else
    begin
        insert into spb_Navigations(NavigationType,OwnerType,ApplicationID,NavigationText,NavigationUrl,NavigationTarget,DisplayOrder,IsEnabled)
			values(@NavigationType,@OwnerType,@ApplicationID,@NavigationText,@NavigationUrl,@NavigationTarget,@DisplayOrder,@IsEnabled)
	    set @NavigationID = SCOPE_IDENTITY()
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据获取用户的所有FriendID **/

Create PROCEDURE [dbo].[spb_Friend_GetFriendIDs] 
(
    @UserID int,
	  @MaxRecords int = -1
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@MaxRecords>0)
  set RowCount @MaxRecords
  
select F.FriendID from spb_Friends F with (nolock) inner join spb_Users U on F.FriendUserID = U.UserID
   where F.UserID=@UserID order by U.LastActivity desc, F.Friendliness

if (@MaxRecords>0)
  set RowCount 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_Widgets](
	[WidgetID] [char](16) NOT NULL,
	[OwnerID] [int] NOT NULL,
	[IsBuiltIn] [bit] NOT NULL,
	[WidgetName] [nvarchar](128) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[WidgetXml] [ntext] NOT NULL,
 CONSTRAINT [PK_spb_Widgets] PRIMARY KEY CLUSTERED 
(
	[WidgetID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_Widgets_ThemeCategory_OwnerID] ON [dbo].[spb_Widgets] 
(
	[PresentAreaID] ASC,
	[OwnerID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_SiteLinks](
	[LinkID] [int] IDENTITY(1,1) NOT NULL,
	[CategoryID] [int] NOT NULL,
	[Title] [nvarchar](256) NOT NULL,
	[ImageUrl] [nvarchar](256) NOT NULL,
	[LinkTitle] [nvarchar](256) NOT NULL,
	[LinkHref] [nvarchar](256) NOT NULL,
	[LinkType] [int] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[IsEnabled] [bit] NOT NULL,
 CONSTRAINT [PK_spb_SiteLinks] PRIMARY KEY CLUSTERED 
(
	[LinkID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_SiteLinks_CategoryID_DisplayOrder] ON [dbo].[spb_SiteLinks] 
(
	[CategoryID] ASC,
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_SiteLinks_DisplayOrder] ON [dbo].[spb_SiteLinks] 
(
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FriendUserCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[CategoryName] [nvarchar](128) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[ItemCount] [int] NOT NULL,
	[MostRecentUpdateDate] [datetime] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_FriendUserCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FriendUserCategories_UserID] ON [dbo].[spb_FriendUserCategories] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_FileSections](
	[OwnerUserID] [int] NOT NULL,
	[SectionName] [nvarchar](512) NOT NULL,
	[Description] [nvarchar](2000) NOT NULL,
	[IsActive] [bit] NOT NULL,
	[EnableSearch] [bit] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[MostRecentPostDate] [datetime] NULL,
	[MostRecentThreadID] [int] NULL,
	[MostRecentThreadSubject] [nvarchar](216) NULL,
	[MostRecentThreadSummary] [nvarchar](2000) NULL,
	[FileCount] [int] NOT NULL,
	[DownloadFileCount] [int] NULL,
	[CommentCount] [int] NOT NULL,
	[Points] [int] NOT NULL,
	[HitTimes] [int] NOT NULL,
	[StageHitTimes] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_FileSections] PRIMARY KEY CLUSTERED 
(
	[OwnerUserID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSections_CommentCount] ON [dbo].[spb_FileSections] 
(
	[CommentCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSections_DateCreated] ON [dbo].[spb_FileSections] 
(
	[OwnerUserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSections_DownloadFileCount] ON [dbo].[spb_FileSections] 
(
	[DownloadFileCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSections_FileCount] ON [dbo].[spb_FileSections] 
(
	[FileCount] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSections_HitTimes] ON [dbo].[spb_FileSections] 
(
	[HitTimes] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSections_MostRecentPostDate] ON [dbo].[spb_FileSections] 
(
	[MostRecentPostDate] ASC
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_FileSections_OwnerUserID] ON [dbo].[spb_FileSections] 
(
	[OwnerUserID] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSections_Points] ON [dbo].[spb_FileSections] 
(
	[Points] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_FileSections_WeekHitTimes] ON [dbo].[spb_FileSections] 
(
	[StageHitTimes] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [dbo].[spb_UserPassword_Update]
    @UserName         nvarchar(64),
    @NewPassword      nvarchar(128),
    @PasswordFormat   int = 0
AS
set nocount on
BEGIN

    update spb_Users set Password=@NewPassword,PasswordFormat=@PasswordFormat
      where LoweredUserName = LOWER(@UserName)

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_MicroBlogFollowUserCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[UserID] [int] NOT NULL,
	[CategoryName] [nvarchar](128) NOT NULL,
	[Description] [nchar](512) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[ItemCount] [int] NOT NULL,
	[MostRecentUpdateDate] [datetime] NOT NULL,
	[PrivacyStatus] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_MicroBlogFollowsUserCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_MicroBlogFollowsUserCategories_UserID] ON [dbo].[spb_MicroBlogFollowUserCategories] 
(
	[CategoryID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_WidgetZones](
	[ZoneID] [int] IDENTITY(1,1) NOT NULL,
	[Theme] [nvarchar](32) NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[PageCode] [char](4) NOT NULL,
	[ColumnNumber] [int] NOT NULL,
	[IsFrozen] [bit] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_spb_WidgetZones] PRIMARY KEY CLUSTERED 
(
	[ZoneID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_WidgetZones_PageCode_Theme_ColumnNumber_] ON [dbo].[spb_WidgetZones] 
(
	[PageCode] ASC,
	[Theme] ASC,
	[ColumnNumber] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除站点标签 **/
CREATE PROCEDURE [dbo].[spb_SiteTag_Delete]
(
	@UserTagsTableName nvarchar(64),
	@SiteTagsTableName nvarchar(64),
	@InUserTagsTableName nvarchar(64),
	@TagName nvarchar(64)
)
AS
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED
declare @strSql nvarchar(1200)
set @strSql='delete from '+@InUserTagsTableName+' where TagName=@TagName;
			 delete from '+@UserTagsTableName+' where TagName=@TagName;
			 delete from '+@SiteTagsTableName+' where TagName=@TagName;'
exec sp_executesql @strSql,N'@TagName nvarchar(64)',@TagName=@TagName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_VoteSections](
	[SectionID] [int] IDENTITY(1,1) NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[OwnerID] [int] NOT NULL,
	[TotalThreadCount] [int] NOT NULL,
	[OverdueThreadCount] [int] NOT NULL,
	[ProgressThreadCount] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_VoteSections] PRIMARY KEY CLUSTERED 
(
	[SectionID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_VoteSections_PresentAreaID_SectionID] ON [dbo].[spb_VoteSections] 
(
	[PresentAreaID] ASC,
	[SectionID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PrivacyItems](
	[ItemID] [int] IDENTITY(1,1) NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[ItemKey] [nvarchar](64) NOT NULL,
	[ItemName] [nvarchar](64) NOT NULL,
	[Description] [nvarchar](128) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
 CONSTRAINT [PK_spb_PrivacyItems] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE UNIQUE NONCLUSTERED INDEX [IX_spb_PrivacyItems_ItemKey] ON [dbo].[spb_PrivacyItems] 
(
	[ItemKey] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据email（账户中的），获取UserID **/

CREATE procedure [dbo].[spb_User_GetUserIDByEmail]
(
	@Email nvarchar(256)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
SELECT UserId as spb_UserID FROM	dbo.spb_users with (nolock) WHERE PrivateEmail = @Email
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_AdvertisingPositions](
	[PositionCode] [nvarchar](16) NOT NULL,
	[PresentAreaID] [int] NOT NULL,
	[Width] [int] NOT NULL,
	[Height] [int] NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[Maximum] [int] NOT NULL,
	[UseredAdvertisings] [int] NOT NULL,
	[AllowSystem] [bit] NOT NULL,
	[ImageUrl] [nvarchar](256) NOT NULL,
 CONSTRAINT [PK_spb_AdvertisingPositions] PRIMARY KEY CLUSTERED 
(
	[PositionCode] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_SiteCategories](
	[CategoryID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ApplicationID] [int] NOT NULL,
	[CategoryName] [nvarchar](128) NOT NULL,
	[Description] [nvarchar](512) NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[Depth] [int] NOT NULL,
	[ChildCount] [int] NOT NULL,
	[ItemCount] [int] NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
 CONSTRAINT [PK_spb_SiteCategories] PRIMARY KEY CLUSTERED 
(
	[CategoryID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_SiteCategories_DisplayOrder] ON [dbo].[spb_SiteCategories] 
(
	[DisplayOrder] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_BlogComments](
	[PostID] [int] IDENTITY(1,1) NOT NULL,
	[ParentID] [int] NOT NULL,
	[ThreadID] [int] NOT NULL,
	[OwnerUserID] [int] NOT NULL,
	[UserID] [int] NOT NULL,
	[Author] [nvarchar](64) NOT NULL,
	[Subject] [nvarchar](256) NOT NULL,
	[Body] [ntext] NOT NULL,
	[IsApproved] [bit] NOT NULL,
	[AuditingStatus] [int] NOT NULL,
	[PostDate] [datetime] NOT NULL,
	[TitleUrl] [nvarchar](256) NOT NULL,
	[PropertyNames] [ntext] NULL,
	[PropertyValues] [ntext] NULL,
	[UserHostAddress] [nvarchar](64) NOT NULL,
 CONSTRAINT [PK_spb_BlogComments] PRIMARY KEY CLUSTERED 
(
	[PostID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogComments_OwnerUserID_PostDate] ON [dbo].[spb_BlogComments] 
(
	[OwnerUserID] ASC,
	[PostDate] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogComments_ThreadID_AuditingStatus] ON [dbo].[spb_BlogComments] 
(
	[ThreadID] ASC,
	[AuditingStatus] ASC
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_BlogComments_UserID] ON [dbo].[spb_BlogComments] 
(
	[UserID] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_CompanyUserProfile](
	[UserID] [int] NOT NULL,
	[Licence] [nvarchar](64) NOT NULL,
	[Trade] [smallint] NOT NULL,
	[CompanyProperty] [smallint] NOT NULL,
	[Fund] [smallint] NOT NULL,
	[EmployeeNum] [smallint] NOT NULL,
	[Intro] [ntext] NOT NULL,
	[Linkman] [nvarchar](64) NOT NULL,
	[LinkmanDuty] [nvarchar](64) NOT NULL,
	[LinkTel] [nvarchar](64) NOT NULL,
	[LinkTelPrivacy] [smallint] NOT NULL,
	[Fax] [nvarchar](64) NOT NULL,
	[FaxPrivacy] [smallint] NOT NULL,
	[Address] [nvarchar](128) NULL,
	[ValidateStatus] [smallint] NOT NULL,
	[ValidateDate] [datetime] NOT NULL,
	[AreaCode] [varchar](8) NOT NULL,
 CONSTRAINT [PK_spb_CompanyUserProfile] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_CompanyUserProfile_AreaCode] ON [dbo].[spb_CompanyUserProfile] 
(
	[AreaCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[spb_PersonUserProfile](
	[UserID] [int] NOT NULL,
	[Gender] [smallint] NOT NULL,
	[Birthday] [datetime] NULL,
	[Stature] [int] NOT NULL,
	[Weight] [int] NOT NULL,
	[Shape] [smallint] NOT NULL,
	[Blood] [smallint] NOT NULL,
	[Degree] [smallint] NOT NULL,
	[School] [nvarchar](256) NOT NULL,
	[SchoolID] [int] NOT NULL,
	[NowSalary] [smallint] NOT NULL,
	[Interest] [nvarchar](512) NOT NULL,
	[Expertise] [nvarchar](512) NOT NULL,
	[Marriage] [smallint] NOT NULL,
	[CardType] [smallint] NOT NULL,
	[CardID] [nvarchar](64) NOT NULL,
	[Title] [nvarchar](64) NOT NULL,
	[TitleLevel] [smallint] NOT NULL,
	[JobSort] [nchar](4) NOT NULL,
	[CompanyName] [nvarchar](256) NOT NULL,
	[CompanyTrade] [smallint] NOT NULL,
	[NowAreaCode] [varchar](8) NOT NULL,
	[HomeAreaCode] [varchar](8) NOT NULL,
	[CompanyAreaCode] [varchar](8) NOT NULL,
 CONSTRAINT [PK_spb_PersonUserProfile] PRIMARY KEY CLUSTERED 
(
	[UserID] ASC
) ON [PRIMARY]
) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_spb_PersonUserProfile_AreaCode] ON [dbo].[spb_PersonUserProfile] 
(
	[NowAreaCode] ASC,
	[HomeAreaCode] ASC,
	[CompanyAreaCode] ASC
) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新在线用户的上次活动时间及IP **/

CREATE procedure [dbo].[spb_User_UpdateOnlineStatus] 
(
  @UserID int,
  @LastAction nvarchar(1024),
  @DisplayName nvarchar(64),
  @IPAddress nvarchar(32) = '000.000.000.000' --记录IP
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
BEGIN

	UPDATE 
		spb_Users 
	SET 
		LastActivity = GetDate(),
		IPLastActivity = @IPAddress,
		LastAction = @LastAction
	WHERE 
		UserID = @UserID

	IF EXISTS (SELECT UserID FROM spb_UsersOnline WHERE UserID = @UserID )
		UPDATE spb_UsersOnline SET DisplayName=@DisplayName, LastActivityDateTime = GetDate(), LastAction = @LastAction,IPAddress=@IPAddress WHERE UserID = @UserID
	ELSE
		INSERT INTO spb_UsersOnline (UserID,DisplayName,LastActivityDateTime,LastAction,IPAddress ) VALUES (@UserID,@DisplayName, GetDate(), @LastAction,@IPAddress)

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_Users_Online_RemoveUser]
	@UserID int 
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

BEGIN
	DELETE spb_UsersOnline	WHERE UserID = @UserID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		mazq
-- Create date: 2008-12-12
-- =============================================
CREATE procedure [dbo].[spb_PersonUser_Delete] 
(
  @UserID int,
  @AdminUserName nvarchar(64) --用户不能删除的内容由AdminUserName接管
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @UserName nvarchar(256)
declare @UserType int
select @UserName=UserName,@UserType=UserType from spb_Users with (nolock) where UserID=@UserID

IF (@UserName IS NULL)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END

DECLARE	@AdminUserID	int
SELECT	@AdminUserID = UserID from spb_Users with (nolock) where UserName=@AdminUserName

-- does the reassign user exist?
IF (@AdminUserID IS NULL)
BEGIN
	SELECT 2 -- InvalidReassignUserName
	RETURN
END

BEGIN TRANSACTION
if(@UserType=1)
begin
--朋友 start
delete from spb_FriendsInUserCategories where CategoryID in (select CategoryID from spb_FriendUserCategories with (nolock) where UserID=@UserID)
IF (@@ERROR <> 0) GOTO Failure

delete from spb_FriendUserCategories where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_FriendsInUserCategories where ItemID in (select FriendID from spb_Friends with (nolock) where UserID=@UserID or FriendUserID=@UserID)
IF (@@ERROR <> 0) GOTO Failure

update spb_Users set FriendCount = FriendCount -1 where userID in (select FriendUserID from spb_friends with (nolock) where userID = @UseriD)
delete from spb_Friends where UserID=@UserID or FriendUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

--朋友 end
end

--联系人 start
delete from spb_Contacts where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--联系人 end


--私信 start
delete from spb_PrivateMessageInbox where UserID=@UserID or SenderUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_PrivateMessageOutbox where UserID=@UserID or ReceiverUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_PrivateMessagePosts where ThreadID in (select ThreadID from spb_PrivateMessageThreads with (nolock) where SenderUserID=@UserID or ReceiverUserID=@UserID)
IF (@@ERROR <> 0) GOTO Failure

delete from spb_PrivateMessageThreads where SenderUserID=@UserID or ReceiverUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--私信 end


--邀请 start
delete from spb_InvitationInbox where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_InvitationOutbox where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_Invitations where SenderUserID=@UserID or ReceiverUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--邀请 end


--隐私 start
delete from spb_UserPrivacyItemSettings where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_SpecialPrivacyUsers where UserID=@UserID or ToUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_UserSpecialPrivacyItemSettings where UserID=@UserID or ToUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_StopedUsers where UserID=@UserID or ToUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--隐私 end


--动态 start
delete from spb_UserActivityItemSettings where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_UserActivitySettings where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_UserActivities where LeadingActorUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_FriendActivityInbox where UserID=@UserID or ActivityID in (select ActivityID from spb_FriendActivities with (nolock) where LeadingActorUserID=@UserID)
IF (@@ERROR <> 0) GOTO Failure

delete from spb_FriendActivities where LeadingActorUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--动态 end


--积分 start
delete from spb_UserPointRecords where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--积分 end


--通知 start
delete from spb_UserNoticeItemSettings where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--通知 end


--推荐 start
delete from spb_RecommendedItems where ItemID=@UserID and CommendTypeID in (select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=11)
IF (@@ERROR <> 0) GOTO Failure
--推荐 end


--留言 start
delete from spb_UserGuestbookPosts where UserID=@UserID or GuestbookID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_UserGuestbooks where GuestbookID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--留言 end


--友情链接 start
delete from spb_UserLinkCategories where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_UserLinks where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--友情链接 end


--广告 start
delete from spb_AdvertisingsInPositions where AdvertisingID in (select AdvertisingID from spb_Advertisings with (nolock) where PresentAreaID=11 and OwnerID=@UserID)
IF (@@ERROR <> 0) GOTO Failure

delete from spb_Advertisings where PresentAreaID=11 and OwnerID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--广告 end

--账号绑定 start
delete from spb_AccountBindings where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--账号绑定 end


--用户索引 start
if exists (select ItemID from spb_ItemsForIndex with (nolock) where ItemID = @UserID and SearchTypeCode = 001101)
    delete from spb_ItemsForIndex where ItemID = @UserID and SearchTypeCode = 001101

insert into spb_ItemsForIndex (ItemID,SearchTypeCode,DataAction) values (@UserID,001101,2)
IF (@@ERROR <> 0) GOTO Failure
--用户索引 end

--用户相关 start
delete from spb_UserVisits where FromUserID=@UserID or ToUserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_UsersOnline where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_UsersInRoles where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_PersonUserProfile where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_CompanyUserProfile where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_Users where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
--用户相关 end


COMMIT TRANSACTION
SELECT 1 -- Success
RETURN

Failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE  PROCEDURE [dbo].[spb_Users_Online]
	@PastMinutes int --距上次活动的时间间隔
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN
	DELETE spb_UsersOnline	WHERE	LastActivityDateTime < DateAdd(minute, -@PastMinutes, GetDate())
	
	SELECT * FROM spb_UsersOnline ORDER BY LastActivityDateTime desc
	
	SELECT * FROM spb_AnonymousUsers
END
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE Procedure [dbo].[spb_VoteThread_CreateUpdateDelete]
(
    @ThreadID int output,
    @PresentAreaID int = 11,
    @Owner nvarchar(64)= '',
    @OwnerID int=0,
    @UserID int=null,
    @Author nvarchar(64)='',
    @Subject nvarchar(64)='',
    @Body nvarchar(512)='',
    @AuditingStatus int=40,
    @VoteStaus int=0,
    @IsMultiple bit=0,
    @MaxChooseCount int=0,
    @PrivacyStatus int=30,
    @UserHostAddress nvarchar(64)=N'000.000.000.000',
    @EndDate datetime='',
    @PropertyNames ntext=null,
    @PropertyValues ntext=null,
    @Action int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if ( @Action = 0 ) --添加
begin
  begin transaction     
      insert into spb_VoteThreads
       (OwnerID,PresentAreaID,Owner,UserID,Author,Subject,AuditingStatus,VoteStaus,IsMultiple,MaxChooseCount,Body,PrivacyStatus
       ,UserHostAddress,EndDate,LastModified,PropertyNames,PropertyValues) 
       values 
       (@OwnerID,@PresentAreaID,@Owner,@UserID,@Author,@Subject,@AuditingStatus,@VoteStaus,@IsMultiple,@MaxChooseCount,@Body,
       @PrivacyStatus,@UserHostAddress,@EndDate,getdate(),@PropertyNames,@PropertyValues)
       set @ThreadID=SCOPE_IDENTITY()
      if(@@error<>0) goto FAILURES
      if(@PresentAreaID=11)
      begin
        if exists(select * from spb_VoteUserDatas with (nolock) where UserID = @UserID)
            begin
               update spb_VoteUserDatas 
               set TotalThreadCount = TotalThreadCount + 1,ProgressThreadCount = ProgressThreadCount + 1
               where UserID=@UserID
               if(@@error<>0) goto FAILURES 
            end
        else
            begin
              insert into spb_VoteUserDatas(UserID,TotalThreadCount,ProgressThreadCount) values (@UserID,1,1)
              if(@@error<>0) goto FAILURES 
            end
      end
  commit transaction
  return
  FAILURES:
  rollback transaction
  return
end
else if( @Action = 1 ) --更新
begin
	update spb_VoteThreads
	set Subject=@Subject,
	Body=@Body,VoteStaus=@VoteStaus,IsMultiple=@IsMultiple,
	MaxChooseCount=@MaxChooseCount,PrivacyStatus=@PrivacyStatus,UserHostAddress=@UserHostAddress,
	EndDate=@EndDate,LastModified=getdate(),PropertyNames=@PropertyNames,PropertyValues=@PropertyValues,
	AuditingStatus = @AuditingStatus
	where ThreadID=@ThreadID     
end
else if(@Action = 2)  --删除
begin
	begin transaction
	  delete from spb_VoteThreads where ThreadID=@ThreadID
	  if(@@error<>0) goto FAILURE
	  delete from spb_VoteOptions where ThreadID=@ThreadID
	  if(@@error<>0) goto FAILURE
	  delete from spb_VoteRecords where ThreadID=@ThreadID
	  if(@@error<>0) goto FAILURE
	  delete from spb_VoteComments where ThreadID=@ThreadID
	  if(@@error<>0) goto FAILURE
	  
	  if(@PresentAreaID=11)
	  begin
		  if exists( select UserID from spb_VoteUserDatas with (nolock) where UserID=@UserID) 
		  begin
			update spb_VoteUserDatas 
			set TotalThreadCount = TotalThreadCount - 1,ProgressThreadCount = ProgressThreadCount - 1
			where UserID=@UserID and TotalThreadCount > 0 and ProgressThreadCount > 0
			if(@@error<>0) goto FAILURE
		  end
	  end
	commit transaction
	return
	FAILURE:
	ROLLBACK transaction
	return
end
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_Vote_DeleteUserAndReassignContent]
(
    @UserID int,
	@ReassignUserName nvarchar(64)
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
    DECLARE	@ReassignUserID	int
    Set @ReassignUserID = 0
    SELECT	@ReassignUserID = UserID from spb_Users with (nolock) where UserType=1 and UserName=@ReassignUserName

    -- does the reassign user exist?
    IF (@ReassignUserID IS NULL)
    BEGIN
	    SELECT 2 -- InvalidReassignUserName
	    RETURN
    END

    IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
    BEGIN
	    SELECT 3 -- 待删除的用户不存在
	    RETURN
    END
    BEGIN TRANSACTION
	
    if(@ReassignUserID > 0)
    Begin
    --更新投票
    update spb_VoteThreads set UserID=@ReassignUserID where UserID=@UserID
    if(@@error<>0) goto failure
    End
    --管理员推荐
    delete spb_RecommendedItems  where CommendTypeID in(select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=241) and AuthorUserID=@UserID
    if(@@error<>0) goto failure
    --删除投票选项
    delete spb_VoteOptions where ThreadID in (select ThreadID from spb_VoteThreads where UserID=@UserID)
    if(@@error<>0) goto failure
    --删除投票主题
    delete spb_VoteThreads where UserID=@UserID
    if(@@error<>0) goto failure
    --删除评论
    delete spb_VoteComments where UserID=@UserID
    if(@@error<>0) goto failure

    --删除评论
    delete spb_VoteComments where UserID=@UserID
    if(@@error<>0) goto failure
    --删除UsreDatas中用户相关数据
	delete spb_VoteUserDatas where UserID = @UserID
    if(@@error<>0) goto failure
	--删除UserSections中用户相关数据
    delete spb_VoteSections where OwnerID = @UserID and PresentAreaID = 11
    if(@@error<>0) goto failure
    
    COMMIT TRANSACTION
    SELECT 1 -- Success
    RETURN
    Failure:
	    ROLLBACK TRANSACTION
	    SELECT 10 -- UnknownFailure
	    RETURN
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create Procedure [dbo].[spb_VoteUserData_Delete]
(
	@UserID int = 0
)
as 
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if not exists(select * from spb_VoteUserDatas with (nolock) where UserID = @UserID)
	return
delete from spb_VoteUserDatas where UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_VoteUserData_Get]
(
	@UserID int
)
as
select * from spb_VoteUserDatas with(nolock) where UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create Procedure [dbo].[spb_VoteUserData_Create]
(
	@UserID int
)
as
insert into spb_VoteUserDatas (UserID) Values (@UserID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		zhengw
-- Create date: 2008-12-24
-- Description:	学校的添加、修改、删除
-- =============================================
CREATE PROCEDURE [dbo].[spb_School_CreateUpdateDelete]

  @Action int,
  @SchoolID	int out,
  @SchoolName nvarchar(128) = null,
  @SchoolType int = null,
  @AreaCode varchar(8) = null,
  @AreaName nvarchar(128) = null,
  @DisplayOrder int = 0

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if @Action = 2 --删除

    begin
	   DELETE FROM spb_Schools WHERE   (SchoolID = @SchoolID)   
      
    end

else if  @Action = 1 --修改
    begin
		UPDATE    spb_Schools
        SET   SchoolName = @SchoolName,SchoolType = @SchoolType, AreaCode = @AreaCode, AreaName = @AreaName, DisplayOrder = @DisplayOrder
        WHERE (SchoolID = @SchoolID)  
    end

else if @Action = 0 --添加

begin
    INSERT INTO spb_Schools
     (SchoolName,SchoolType, AreaCode, AreaName, DisplayOrder)
    VALUES (@SchoolName,@SchoolType,@AreaCode,@AreaName,@DisplayOrder)
    select @SchoolID = SCOPE_IDENTITY() 
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_Schools_GetIDs] 
(
    @AreaCodes nvarchar(4000) = null,
    @SchoolType int = -1
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON;

if (@AreaCodes is null)
  begin
    if @SchoolType >= 0
      select SchoolID from spb_Schools where SchoolType=@SchoolType order by DisplayOrder, SchoolID
    else
      select SchoolID from spb_Schools order by DisplayOrder, SchoolID
  end
else
  begin
    declare @strSql nvarchar(1024)
    set @strSql='
    if @SchoolType >= 0
      select SchoolID from spb_Schools where AreaCode in('+@AreaCodes+') and SchoolType=@SchoolType order by DisplayOrder, SchoolID
    else
      select SchoolID from spb_Schools where AreaCode in('+@AreaCodes+') order by DisplayOrder, SchoolID'
    exec sp_executesql  @strSql,N'@SchoolType int',@SchoolType=@SchoolType
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		zhengw
-- Create date: 2008-12-3
-- Description:	根据学校ID获取单个学校
-- =============================================

CREATE PROCEDURE [dbo].[spb_School_Get]
(
    @SchoolID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     spb_Schools.*
FROM         spb_Schools with (nolock)
WHERE     (SchoolID = @SchoolID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户并重设内容时调用 */

CREATE PROCEDURE [dbo].[spb_Photo_DeleteUserAndReassignContent]
( 
    @UserID int,
	@ReassignUserName		nvarchar(64)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE	@ReassignUserID	int
SELECT	@ReassignUserID = UserID from spb_Users with (nolock) where UserType=1 and UserName=@ReassignUserName

-- does the reassign user exist?
IF (@ReassignUserID IS NULL)
BEGIN
	SELECT 2 -- InvalidReassignUserName
	RETURN
END

IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END


BEGIN TRANSACTION
  --更新用户标签 
  update spb_PhotoUserTags set UserID=@ReassignUserID where UserID=@UserID
  if(@@error<>0) goto failure
  --更新用户类别
  update spb_PhotoUserCategories set UserID=@ReassignUserID where UserID=@UserID
  if(@@error<>0) goto failure
  --更新文章
  update spb_Photos set OwnerUserID=@ReassignUserID where OwnerUserID=@UserID
  if(@@error<>0) goto failure
  --管理员推荐
  delete spb_RecommendedItems  where CommendTypeID in(select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=112) and AuthorUserID=@UserID
  if(@@error<>0) goto failure
  --更新被转移到用户的WePhoto 
  declare @OldPhotoCount int
  select @OldPhotoCount=PhotoCount from spb_PhotoSections with (nolock) where OwnerUserID=@UserID
  if(@@error<>0) goto failure
  update spb_PhotoSections set PhotoCount =PhotoCount + @OldPhotoCount where OwnerUserID= @ReassignUserID
  if(@@error<>0) goto failure
  --删除评论
  delete spb_PhotoComments where OwnerUserID=@UserID
  if(@@error<>0) goto failure
  delete spb_PhotoComments where UserID=@UserID
  if(@@error<>0) goto failure
  --删除星级评价（只删除删除用户做出的评价）
  delete spb_PhotoRatings where UserID=@UserID
  if(@@error<>0) goto failure
  --删除模块
  delete spb_PhotoSections where OwnerUserID=@UserID
  if(@@error<>0) goto failure
COMMIT TRANSACTION
SELECT 1 -- Success
RETURN
failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 对文章进行评价 */

CREATE PROCEDURE [dbo].[spb_PhotoRating_Rate]
( 
	@ThreadID	int,
	@UserID	int,
	@Author	nvarchar(64) = '',
	@Rate	int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if exists (select ThreadID from spb_PhotoRatings with (nolock) where ThreadID=@ThreadID and UserID=@UserID)

	begin
        
        UPDATE    spb_Photos 
        SET       RatingSum=RatingSum+@Rate-(select Rate from spb_PhotoRatings with (nolock) where ThreadID=@ThreadID and UserID=@UserID)
        WHERE     ThreadID = @ThreadID
        
		UPDATE    spb_PhotoRatings
        SET       Author = @Author, Rate = @Rate
        WHERE    (ThreadID = @ThreadID) AND (UserID = @UserID)

	end
	
else
	begin
        INSERT INTO spb_PhotoRatings
                   (ThreadID, UserID, Author, Rate)
        VALUES     (@ThreadID,@UserID,@Author,@Rate)
        
        UPDATE    spb_Photos 
        SET       RatingSum=RatingSum+@Rate,TotalRatings=TotalRatings+1
        WHERE     ThreadID = @ThreadID
	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除Photo */

CREATE PROCEDURE [dbo].[spb_Photo_Delete] 
(
    @ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
if not exists(select * from spb_Photos with (nolock) where ThreadID=@ThreadID)
return
DECLARE @OwnerUserID INT

SELECT @OwnerUserID = OwnerUserID FROM spb_Photos WHERE	ThreadID = @ThreadID
    
declare @CommentCount int
declare @UserCategoryID int

begin transaction
    select @CommentCount = Count(*) from spb_PhotoComments with (nolock) where ThreadID = @ThreadID 
    select @UserCategoryID=UserCategoryID from spb_Photos with (nolock) where ThreadID=@ThreadID
    --更新站点标签
    update spb_PhotoSiteTags set ItemCount =ItemCount-1 where TagName in(select TagName from spb_PhotoUserTags with (nolock) where TagName in(select TagName from spb_PhotosInUserTags with (nolock) where ItemID=@ThreadID))
    if(@@error<>0) goto failure
    
    --更新用户标签计数
    update spb_PhotoUserTags set ItemCount=ItemCount-1 where TagName in(select TagName from spb_PhotosInUserTags with (nolock) where ItemID=@ThreadID) 
    if(@@error<>0) goto failure
    
    --更新用户分类
    if exists (select UserID from spb_PhotoUserCategories with (nolock) where CategoryID=@UserCategoryID)
    begin
       update spb_PhotoUserCategories set ItemCount=ItemCount-1 where CategoryID=@UserCategoryID
  	   if(@@error<>0) goto failure
  	end
  	
     --更新图片模块
    update spb_PhotoSections set PhotoCount = PhotoCount - 1,CommentCount = CommentCount - @CommentCount where OwnerUserID = @OwnerUserID 
    if(@@error<>0) goto failure
    if  @ThreadID = (select MostRecentThreadID from spb_PhotoSections with (nolock) where OwnerUserID=@OwnerUserID)
         begin
           declare @newThreadID int
           declare @newSubject nvarchar(512)
           declare @newExcerpt nvarchar(512)
           declare @newMostRecentPostDate datetime
           select top 1 @newThreadID=ThreadID,@newSubject=Subject,@newExcerpt=Body,@newMostRecentPostDate=PostDate from spb_Photos with (nolock) where OwnerUserID=@OwnerUserID and PrivacyStatus>10 order by ThreadID desc
           
           update spb_PhotoSections set PhotoCount = PhotoCount - 1,CommentCount = CommentCount - @CommentCount, MostRecentPostDate=@newMostRecentPostDate, MostRecentThreadID=@newThreadID,MostRecentThreadSubject=@newSubject,MostRecentThreadSummary=Substring(@newExcerpt,0,164) where OwnerUserID=@OwnerUserID
	         if(@@error<>0) goto failure
         end  
    else
      begin
         update spb_PhotoSections set PhotoCount = PhotoCount - 1,CommentCount = CommentCount - @CommentCount where OwnerUserID = @OwnerUserID    
       	 if(@@error<>0) goto failure
      end
    
    --删除管理员推荐
    delete spb_RecommendedItems where CommendTypeID in (select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=112) and ItemID=@ThreadID
    if(@@error<>0) goto failure
    
    --删除星级评价
    delete spb_PhotoRatings where ThreadID=@ThreadID
	  if(@@error<>0) goto failure
	  
    --删除标签
    delete spb_PhotosInUserTags where ItemID=@ThreadID
    if(@@error<>0) goto failure

    --相关附件的删除【附件独立逻辑处理】
    
    --删除文章回复
    delete spb_PhotoComments where ThreadID = @ThreadID
	  if(@@error<>0) goto failure

    --删除文章
    delete spb_Photos where ThreadID = @ThreadID
    if(@@error<>0) goto failure
    commit transaction
    return
    
    
    failure:
    rollback transaction
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取动态项目默认设置 **/

CREATE PROCEDURE [dbo].[spb_ActivityItemSettingssInGlobal_GetAll] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     S.*, G.IsAllowSending, G.IsAllowReceiving
FROM         spb_GlobalActivityItemSettings G with (nolock) INNER JOIN
                      spb_ActivityItems S with (nolock) ON G.ItemID = S.ItemID,
				   spb_Applications A with (nolock)
WHERE      S.ApplicationID=A.ApplicationID and A.IsEnabled=1
SET NOCOUNT off
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加 朋友动态 */

CREATE PROCEDURE [dbo].[spb_FriendActivity_Create]
( 
    @ActivityID int out,
    @IsCreated bit out,
    @ApplicationID	int,
    @ActivityItemID	int,
    @LeadingActorUserID	int,
    @LeadingActor	nvarchar(256) ,
    @RelativeItemID int,
    @RelativeItemName nvarchar(256),
    @Subject nvarchar(512),
    @Body ntext ='',
    @PropertyNames ntext =null,
    @PropertyValues ntext =null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @OnlyOneTimePerDay bit
select @OnlyOneTimePerDay=OnlyOneTimePerDay from spb_ActivityItems with (nolock) where ItemID=@ActivityItemID
if (@OnlyOneTimePerDay=1)
begin
 select @ActivityID=ActivityID from spb_FriendActivities with (nolock) where datediff(day,DateCreated,getdate())=0 and LeadingActorUserID=@LeadingActorUserID and ActivityItemID=@ActivityItemID

  if(@ActivityID > 0)
    begin
      --select top 1 @ActivityID=ActivityID from spb_FriendActivities where LeadingActorUserID=@LeadingActorUserID order by DateCreated desc
      update spb_FriendActivities set RelativeItemID=@RelativeItemID,RelativeItemName=@RelativeItemName,Subject=@Subject,
          Body=@Body,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues,DateCreated=getdate() where ActivityID = @ActivityID
      
      set @IsCreated = 0
      return
    end
end
insert into spb_FriendActivities (ApplicationID,ActivityItemID,LeadingActorUserID,LeadingActor,RelativeItemID,RelativeItemName,Subject,Body,DateCreated,PropertyNames,PropertyValues)
        values (@ApplicationID,@ActivityItemID,@LeadingActorUserID,@LeadingActor,@RelativeItemID,@RelativeItemName,@Subject,@Body,GetDate(),@PropertyNames,@PropertyValues)

set @ActivityID = SCOPE_IDENTITY()
set @IsCreated = 1
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户动态设置 **/

CREATE PROCEDURE [dbo].[spb_ActivityItemSettingssInUser_Get]
(
  @UserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     S.*, U.UserID, U.IsAllowSending, U.IsAllowReceiving
FROM         spb_ActivityItems S with (nolock) INNER JOIN
                      spb_UserActivityItemSettings U with (nolock) ON S.ItemID = U.ItemID,
				   spb_Applications A with (nolock)
WHERE     (U.UserID = @UserID) and S.ApplicationID=A.ApplicationID and A.IsEnabled=1
SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、删除 个人动态 */

CREATE PROCEDURE [dbo].[spb_UserActivity_CreateDelete]
( 
    @Action int,
    @ActivityID int out,
    @ApplicationID	int =0,
    @ActivityItemID	int =0,
    @LeadingActorUserID	int =0,
    @LeadingActor	nvarchar(256) ='',
    @RelativeItemID int =0,
    @RelativeItemName nvarchar(256) ='',
    @Subject nvarchar(2000) ='',
    @Body ntext ='',
    @IsPublic bit =0,
    @PropertyNames ntext =null,
    @PropertyValues ntext =null,
    @UserID int =null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
begin
	if(@UserID<>null)
	begin
		delete from	spb_UserActivities where ActivityID = @ActivityID and LeadingActorUserID=@UserID
	end
	else
	begin
		delete from	spb_UserActivities where ActivityID = @ActivityID
	end
end
else 
    begin
        if (@Action = 0) --添加
          begin
            declare @OnlyOneTimePerDay bit
            select @OnlyOneTimePerDay=OnlyOneTimePerDay from spb_ActivityItems with (nolock) where ItemID=@ActivityItemID
            if (@OnlyOneTimePerDay=1)
              begin
                if exists (select ActivityID from spb_UserActivities with (nolock) where datediff(day,DateCreated,getdate())=0 and LeadingActorUserID=@LeadingActorUserID and ActivityItemID=@ActivityItemID)
                  begin
                    select top 1 @ActivityID=ActivityID from spb_UserActivities with (nolock) where LeadingActorUserID=@LeadingActorUserID and ActivityItemID=@ActivityItemID order by DateCreated desc
                    update spb_UserActivities set RelativeItemID=@RelativeItemID,RelativeItemName=@RelativeItemName,Subject=@Subject,
                        Body=@Body,IsPublic=@IsPublic,DateCreated=GetDate(),PropertyNames=@PropertyNames,PropertyValues=@PropertyValues where ActivityID = @ActivityID
                    return
                  end
              end
			        insert into spb_UserActivities (ApplicationID,ActivityItemID,LeadingActorUserID,LeadingActor,RelativeItemID,RelativeItemName,Subject,Body,IsPublic,DateCreated,PropertyNames,PropertyValues)
                                        values (@ApplicationID,@ActivityItemID,@LeadingActorUserID,@LeadingActor,@RelativeItemID,@RelativeItemName,@Subject,@Body,@IsPublic,GetDate(),@PropertyNames,@PropertyValues)
                      
                      set  @ActivityID = SCOPE_IDENTITY()
          end       
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有动态项集合 **/

CREATE PROCEDURE [dbo].[spb_ActivityItems_GetAll] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT * FROM spb_ActivityItems I with (nolock) inner join spb_Applications A with (nolock) on I.ApplicationID=A.ApplicationID
WHERE A.IsEnabled=1 ORDER BY  I.DisplayOrder

SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 对 文件 进行评价 */

CREATE PROCEDURE [dbo].[spb_FileRating_Rate]
( 
	@ItemID	int,
	@UserID	int,
	@Author	nvarchar(64) = '',
	@Rate	int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if exists (select ThreadID from spb_FileRatings where ThreadID=@ItemID and UserID=@UserID)

	begin
		
        UPDATE spb_FileThreads 
        SET    RatingSum=RatingSum+@Rate-(select Rate from spb_FileRatings where ThreadID=@ItemID and UserID=@UserID)
        WHERE  ThreadID=@ItemID
        
        UPDATE    spb_FileRatings
        SET       Author = @Author, Rate = @Rate
        WHERE    (ThreadID = @ItemID) AND (UserID = @UserID)
	end
	
else
	begin
        INSERT INTO spb_FileRatings
                   (ThreadID, UserID, Author, Rate)
        VALUES     (@ItemID,@UserID,@Author,@Rate)
        
        UPDATE     spb_FileThreads 
        SET        RatingSum=RatingSum+@Rate,TotalRatings=TotalRatings+1
        WHERE      ThreadID=@ItemID
	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置文件评论审核状态 */

create PROCEDURE [dbo].[spb_FileThread_UpdateAuditingStatus]
( 
    @ThreadID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_FileThreads set AuditingStatus=@AuditingStatus where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置文件评论审核状态 */

create PROCEDURE [dbo].[spb_FileThread_UpdatePrivacyStatus]
( 
    @ThreadID int,
    @PrivacyStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_FileThreads set PrivacyStatus=@PrivacyStatus where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新FilePost 用于回复 **/

CREATE PROCEDURE [dbo].[spb_FileComment_CreateUpdate] 
(
  @Action int,
	@PostID int out,
	@ParentID int = 0,
  @ThreadID int,
  @OwnerUserID int,
 	@UserID int,
  @Author nvarchar(256) = '',
	@Body ntext,
	@PropertyNames ntext = null,
	@PropertyValues ntext = null,
  @IsApproved bit = 1,
  @AuditingStatus int=40,
	@UserHostAddress	nvarchar(64) = null
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加

	begin
	
		INSERT spb_FileComments (ParentID,ThreadID,OwnerUserID,UserID,Author,Body,IsApproved,UserHostAddress,AuditingStatus,PropertyNames,PropertyValues)
				values (@ParentID,@ThreadID,@OwnerUserID,@UserID,@Author,@Body,@IsApproved,@UserHostAddress,@AuditingStatus,@PropertyNames,@PropertyValues)

		-- Grab the new PostID and update the ThreadID's info
		SELECT @PostID = SCOPE_IDENTITY()

    update spb_FileThreads set CommentCount = CommentCount+1, LastRepliedDate=GetDate()	where ThreadID = @ThreadID
       
		-- Update the GallerySection statitics

    update spb_FileSections set CommentCount=CommentCount + 1	where OwnerUserID = @OwnerUserID

	end

  else if @Action=1 --更新

	 update spb_FileComments set Body=@Body,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues where PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除文件和其回复 **/

CREATE procedure [dbo].[spb_FileThread_Delete]
(
    @ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
declare @OwnerUserID int
declare @CommentCount int
declare @UserCategoryID int
select @OwnerUserID=OwnerUserID,@CommentCount = CommentCount from spb_FileThreads with (nolock) where ThreadID = @ThreadID
select @UserCategoryID=UserCategoryID from spb_FileThreads with (nolock) where ThreadID=@ThreadID
if not exists (select * from spb_FileThreads with (nolock) where ThreadID=@ThreadID)
return
begin TRANSACTION

--更新站点标签
update spb_FileSiteTags set ItemCount =ItemCount-1 where TagName in(select TagName from spb_FileUserTags with (nolock) where TagName in(select TagName from spb_FilesInUserTags with (nolock) where ItemID=@ThreadID))
IF (@@ERROR <> 0) GOTO Failure


--更新用户标签计数
update spb_FileUserTags set ItemCount=ItemCount-1 where TagName in(select TagName from spb_FilesInUserTags with (nolock) where ItemID=@ThreadID) 
IF (@@ERROR <> 0) GOTO Failure

--更新用户分类
if exists (select UserID from spb_FileUserCategories with (nolock) where CategoryID=@UserCategoryID)
  begin
    update spb_FileUserCategories set ItemCount=ItemCount-1 where CategoryID=@UserCategoryID
    IF (@@ERROR <> 0) GOTO Failure
  end


--删除管理员推荐
delete spb_RecommendedItems where CommendTypeID in (select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=113) and ItemID=@ThreadID
IF (@@ERROR <> 0) GOTO Failure

--删除星级评价
delete spb_FileRatings where ThreadID=@ThreadID
IF (@@ERROR <> 0) GOTO Failure

--删除标签
delete spb_FilesInUserTags where ItemID=@ThreadID
IF (@@ERROR <> 0) GOTO Failure

--相关附件的删除【附件独立逻辑处理】

--删除下载记录
delete spb_FileDownLoadRecords where ThreadID = @ThreadID
IF (@@ERROR <> 0) GOTO Failure

--删除文件评论
delete spb_FileComments where ThreadID = @ThreadID    
IF (@@ERROR <> 0) GOTO Failure

--删除文件
delete spb_FileThreads where ThreadID = @ThreadID
IF (@@ERROR <> 0) GOTO Failure

COMMIT TRANSACTION
RETURN

Failure:
	ROLLBACK TRANSACTION
	RETURN

SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置文件站点类别 */

create PROCEDURE [dbo].[spb_FileThread_UpdateSiteCategoryByCategoryID]
( 
    @fromSiteCategoryID int,
    @toSiteCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_FileThreads set SiteCategoryID=@toSiteCategoryID where SiteCategoryID=@fromSiteCategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置用户文件类别 */

CREATE PROCEDURE [dbo].[spb_FileThread_UpdateUserCategory]
( 
    @ThreadID int,
    @UserCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE @OldUserCategoryID nvarchar(8)
select  @OldUserCategoryID=UserCategoryID from spb_FileThreads with (nolock) where (ThreadID=@ThreadID)
UPDATE    spb_FileThreads
SET       UserCategoryID=@UserCategoryID
WHERE     ThreadID=@ThreadID

if(@OldUserCategoryID<>@UserCategoryID)
begin
    --原类别的内容数减1
    UPDATE   spb_FileUserCategories SET ItemCount = ItemCount - 1 WHERE (CategoryID = @OldUserCategoryID) AND (ItemCount>0)
    --新类别的内容数加1
    UPDATE   spb_FileUserCategories SET ItemCount = ItemCount + 1 WHERE (CategoryID = @UserCategoryID) 
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置取消精华 */

CREATE PROCEDURE [dbo].[spb_FileThread_SetEssential] 
(
    @ThreadID int,
    @IsEssential bit
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
if exists (select ThreadID from spb_FileThreads with (nolock) where ThreadID=@ThreadID)
  update spb_FileThreads set IsEssential = @IsEssential where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、文件统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_File_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--1.更新spb_Applications表
DECLARE @TotalCount INT
DECLARE @CountInPast24Hours INT
DECLARE @NewestID INT

DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate() - 1,120)  

SELECT @TotalCount=COUNT(*) FROM spb_FileThreads with (nolock)
SELECT @CountInPast24Hours=COUNT(*) FROM spb_FileThreads with (nolock) WHERE PostDate > @currentDate
SELECT @NewestID=isnull(MAX(ThreadID),0) FROM spb_FileThreads with (nolock)

UPDATE    spb_Applications
SET       TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
WHERE     (ApplicationID = 113)

--2.更新spb_SiteCategories表（取值 ItemCount 从FileSections中）
declare @CategoryID int
DECLARE Categories_Cursor CURSOR FOR
SELECT CategoryID FROM spb_SiteCategories WHERE (ApplicationID = 113)
	
OPEN Categories_Cursor
FETCH NEXT FROM Categories_Cursor INTO @CategoryID
	
WHILE @@FETCH_STATUS = 0
    BEGIN	
      update spb_SiteCategories  
      set    ItemCount = (select count(*) from spb_FileThreads where SiteCategoryID = @CategoryID and AuditingStatus=40 )
      where  CategoryID = @CategoryID

	  FETCH NEXT FROM Categories_Cursor INTO @CategoryID
	END
	
CLOSE Categories_Cursor
DEALLOCATE Categories_Cursor

--4.更新文件积分
declare @ThreadCountForFilePointRate float
declare @CommentCountForFilePointRate float
declare @HitTimesForFilePointRate float

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=5001)  
  select @ThreadCountForFilePointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=5001
else
  set @ThreadCountForFilePointRate=4

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=5002)  
  select @CommentCountForFilePointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=5002
else
  set @CommentCountForFilePointRate=1

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=5003)  
  select @HitTimesForFilePointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=4004
else
  set @HitTimesForFilePointRate=0.1


update spb_FileSections set Points = FileCount*@ThreadCountForFilePointRate + CommentCount*@CommentCountForFilePointRate + HitTimes*@HitTimesForFilePointRate 
where IsActive = 1
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置站点文件类别 */

CREATE PROCEDURE [dbo].[spb_FileThread_UpdateSiteCategory]
( 
    @ThreadID int,
    @SiteCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_FileThreads set SiteCategoryID=@SiteCategoryID where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户并重设内容时调用 */

CREATE PROCEDURE [dbo].[spb_File_DeleteUserAndReassignContent]
( 
    @UserID int,
	@ReassignUserName		nvarchar(64)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE	@ReassignUserID	int
SELECT	@ReassignUserID = UserID from spb_Users with (nolock) where UserType=1 and UserName=@ReassignUserName

-- does the reassign user exist?
IF (@ReassignUserID IS NULL)
BEGIN
	SELECT 2 -- InvalidReassignUserName
	RETURN
END

IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END


BEGIN TRANSACTION
  
  --更新用户标签 
  update spb_FileUserTags set UserID=@ReassignUserID where UserID=@UserID
  if(@@error<>0) goto failure
  --更新用户类别
  update spb_FileUserCategories set UserID=@ReassignUserID where UserID=@UserID
  if(@@error<>0) goto failure

  --更新文章
  update spb_FileThreads set OwnerUserID=@ReassignUserID where OwnerUserID=@UserID
  if(@@error<>0) goto failure
  --管理员推荐
  delete spb_RecommendedItems  where CommendTypeID in(select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=113) and AuthorUserID=@UserID
  if(@@error<>0) goto failure
  --更新被转移到用户的WeFile 
  declare @OldFileCount int
  if(@@error<>0) goto failure
  select @OldFileCount=FileCount from spb_FileSections with (nolock) where OwnerUserID=@UserID
  if(@@error<>0) goto failure
  update spb_FileSections set FileCount =FileCount + @OldFileCount where OwnerUserID= @ReassignUserID
  if(@@error<>0) goto failure

  
  --删除评论
  delete spb_FileComments where OwnerUserID=@UserID
  if(@@error<>0) goto failure
  delete spb_FileComments where UserID=@UserID
  if(@@error<>0) goto failure
  
  --删除星级评价（只删除删除用户做出的评价）
  delete spb_FileRatings where UserID=@UserID
  if(@@error<>0) goto failure
  
  --删除下载记录表
  delete spb_FileDownLoads where UserID=@UserID
  if(@@error<>0) goto failure
  --删除模块
  delete spb_FileSections where OwnerUserID=@UserID
  if(@@error<>0) goto failure
COMMIT TRANSACTION
SELECT 1 -- Success
RETURN
failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台文件统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_FileManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingCommentCount int out
)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
	
select @PendingThreadCount= count(ThreadID) from spb_FileThreads with (nolock) where AuditingStatus=20
select @AgainThreadCount=count(ThreadID) from spb_FileThreads with (nolock) where AuditingStatus=30
select @PendingCommentCount=count(PostID) from spb_FileComments (nolock) where AuditingStatus=20
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、文件应用每阶段执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_File_PerStage]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
    --重置周浏览量
    update spb_FileSections set StageHitTimes=0
    update spb_FileThreads set StageHitTimes=0,StageDownloadCount=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除回复 **/

CREATE procedure [dbo].[spb_FileComment_Delete]
(
    @PostID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
    if not exists(select * from spb_FileComments with (nolock) where PostID = @PostID)
    return
    declare @OwnerUserID int
    DECLARE @ThreadID int
    select @OwnerUserID=OwnerUserID,
           @ThreadID = ThreadID 
    from spb_FileComments with (nolock) where PostID = @PostID
    
    delete spb_FileComments where PostID = @PostID

    update spb_FileThreads set CommentCount = CommentCount - 1 where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 置顶 */

CREATE PROCEDURE [dbo].[spb_FileThread_SetSticky] 
(
    @ThreadID int,
    @SpecialOrder int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
if exists (select ThreadID from spb_FileThreads with (nolock) where ThreadID=@ThreadID)
  update spb_FileThreads set SpecialOrder = @SpecialOrder where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取某文件的前一个及后一个张ThreadID */
CREATE PROCEDURE [dbo].[spb_FileThread_GetPrevNextThread] 
(
	@ThreadID int,
    @UserCategoryID int, 
    @NextThreadID int OUTPUT,
    @NextThreadSubject  nvarchar(512) OUTPUT,
	@PrevThreadID int OUTPUT,
    @PrevThreadSubject  nvarchar(512) OUTPUT
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @OwnerUserID int

SELECT @OwnerUserID=T.OwnerUserID FROM	spb_FileThreads T with (nolock) WHERE T.ThreadID = @ThreadID AND  T.UserCategoryID=@UserCategoryID 

SELECT TOP 1 
	@PrevThreadID = ThreadID,@PrevThreadSubject=Subject
FROM 
	spb_FileThreads with (nolock)  
WHERE 
	OwnerUserID = @OwnerUserID AND ThreadID < @ThreadID  AND UserCategoryID=@UserCategoryID 
ORDER BY ThreadID DESC

IF @@ROWCOUNT < 1
  begin
	SELECT @PrevThreadID = 0
    SELECT @PrevThreadSubject=''
  end
	
SELECT TOP 1 
	@NextThreadID = ThreadID,@NextThreadSubject=Subject
FROM 
	spb_FileThreads with (nolock)
WHERE 
	OwnerUserID = @OwnerUserID AND ThreadID > @ThreadID AND UserCategoryID=@UserCategoryID 
ORDER BY ThreadID ASC

IF @@ROWCOUNT < 1
  begin
	SELECT @NextThreadID = 0
    SELECT @NextThreadSubject=''
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新FileThread **/

CREATE PROCEDURE [dbo].[spb_FileThread_CreateUpdate] 
(
  @Action int,
  @ThreadID int out,
  @OwnerUserID int,
  @Author nvarchar(64) = '',
  @PrivacyStatus int = 30,
  @Password nvarchar(64)='',
  @Price int = 0,
  @IsLocked bit = 0,
  @IsEssential bit=0,
  @SpecialOrder int=0,
  @StickyDate datetime,
  @Subject nvarchar(256)='',
  @Body	ntext=null,
  @SiteCategoryID int=0,
  @UserCategoryID int=0,
  @AuditingStatus int,
  @UserHostAddress nvarchar(64)=null,
  @PropertyNames ntext=null,
  @PropertyValues ntext=null,
  @FileName nvarchar(512)='',
  @ContentType nvarchar(64)='',
  @ContentSize int=0,
  @Height int=0,
  @Width int=0,
  @IsRemote int=0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
			INSERT spb_FileThreads (OwnerUserID,Author,PrivacyStatus,Password,Price,IsLocked,IsEssential,SpecialOrder,StickyDate,Subject,Body,SiteCategoryID,
          UserCategoryID,AuditingStatus,UserHostAddress,PropertyNames,PropertyValues,FileName,ContentType,ContentSize,Height,Width,IsRemote)
			  Values (@OwnerUserID,@Author,@PrivacyStatus,@Password,@Price,@IsLocked,@IsEssential,@SpecialOrder,@StickyDate,@Subject,@Body,@SiteCategoryID,
          @UserCategoryID,@AuditingStatus,@UserHostAddress,@PropertyNames,@PropertyValues,@FileName,@ContentType,@ContentSize,@Height,@Width,@IsRemote)

			SELECT @ThreadID = SCOPE_IDENTITY()
             
        -- 用户分类计数
        if exists (select UserID from spb_FileUserCategories with (nolock) where CategoryID=@UserCategoryID)
           update spb_FileUserCategories set ItemCount=ItemCount+1 where CategoryID=@UserCategoryID
	end

  else if @Action=1 --更新

	begin
     declare @oldUserCategoryID int
     declare @oldPrivacyStatus int
	 select @oldUserCategoryID = UserCategoryID from spb_FileThreads with (nolock) where ThreadID=@ThreadID

     update spb_FileThreads set 
          Author=@Author,PrivacyStatus=@PrivacyStatus,Password=@Password,Price=@Price,IsLocked=@IsLocked,IsEssential=@IsEssential,SpecialOrder=@SpecialOrder,StickyDate=@StickyDate,Subject=@Subject,
          SiteCategoryID=@SiteCategoryID,UserCategoryID=@UserCategoryID,AuditingStatus=@AuditingStatus,
          UserHostAddress=@UserHostAddress,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues,FileName=@FileName,
          ContentType=@ContentType,ContentSize=@ContentSize,Height=@Height,Width=@Width,IsRemote=@IsRemote,LastRepliedDate=getdate()
     where ThreadID=@ThreadID

	if @Body is not null UPDATE spb_FileThreads SET	Body = @Body  where ThreadID=@ThreadID  

     if @UserCategoryID <> @oldUserCategoryID 
         begin
          update spb_FileUserCategories set ItemCount=ItemCount+1,MostRecentUpdateDate=getdate() where CategoryID=@UserCategoryID
          update spb_FileUserCategories set ItemCount=ItemCount-1 ,MostRecentUpdateDate=getdate()  where CategoryID=@oldUserCategoryID
          
         end
     
           declare @newThreadID int
           declare @newSubject nvarchar(512)
           declare @newExcerpt nvarchar(512)
           declare @newRecentPostDate datetime
	end


/****** 对象:  StoredProcedure [dbo].[spb_FileThread_Delete]    脚本日期: 08/24/2009 16:02:31 ******/
SET ANSI_NULLS ON
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 文件计数 **/
CREATE PROCEDURE [dbo].[spb_FileThreadView_Add]
(
	@ItemID int,
	@RssViewCount int =0,
	@WebViewCount int=0,
    @DownloadCount int=0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_FileThreads set 
	HitTimes = HitTimes+@WebViewCount,
	StageHitTimes = StageHitTimes+@WebViewCount,
	RssViewTimes = RssViewTimes+@RssViewCount,
	DownloadCount = DownloadCount+@DownloadCount,
	StageDownloadCount = StageDownloadCount+@DownloadCount
 where ThreadID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 重置FileSection统计信息 **/

CREATE procedure [dbo].[spb_FileSection_ResetStatistics]
(
	@OwnerUserID int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
DECLARE @MostRecentThreadID int
DECLARE @MostRecentPostDate datetime
DECLARE @MostRecentThreadSubject nvarchar(256)
DECLARE @MostRecentThreadSummary nvarchar(2000)

IF @OwnerUserID > 0
    BEGIN
	    -- Select the most recent Thread from the Section.
	    SELECT TOP 1
		    @MostRecentThreadID=ThreadID,
		    @MostRecentPostDate=PostDate,
            @MostRecentThreadSubject=Subject,
            @MostRecentThreadSummary=Substring(Body,0,500)
	    FROM 
		    spb_FileThreads with (nolock)
	    WHERE 
		    OwnerUserID = @OwnerUserID
	    ORDER BY
		    ThreadID DESC
		
	    -- If the thread is null, reset the forum statistics.
	    IF @MostRecentThreadID IS NULL
		    UPDATE
			    spb_FileSections
		    SET
			    FileCount = 0,
			    CommentCount = 0,
			    MostRecentThreadID = null,
			    MostRecentThreadSubject = null,
			    MostRecentPostDate = null,
			    MostRecentThreadSummary = null
		    WHERE
			    OwnerUserID = @OwnerUserID
	    ELSE
          begin
              DECLARE @FileCount int              
              DECLARE @CommentCount int
              DECLARE @DownloadFileCount int
              select @FileCount=COUNT(ThreadID) FROM spb_FileThreads with (nolock) WHERE OwnerUserID = @OwnerUserID
              select @CommentCount=COUNT(PostID) FROM spb_FileComments with (nolock) WHERE UserID = @OwnerUserID
              select @DownloadFileCount=COUNT(RecordID) FROM spb_FileDownLoadRecords with (nolock) WHERE UserID = @OwnerUserID

              UPDATE 
	              spb_FileSections
              SET
				FileCount = isnull(@FileCount,0),
			    CommentCount = isnull(@CommentCount,0),
			    DownloadFileCount = isnull(@DownloadFileCount,0),
			    MostRecentThreadID = isnull(@MostRecentThreadID,0),
			    MostRecentThreadSubject = @MostRecentThreadSubject,
			    MostRecentPostDate = @MostRecentPostDate,
			    MostRecentThreadSummary = @MostRecentThreadSummary
              WHERE
	              OwnerUserID = @OwnerUserID
          end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台问答统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_RewardManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingAnswerCount int out,
@PendingCommentCount int out
)
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN
	
	SET NOCOUNT ON;
select @PendingThreadCount=count(ThreadID) from Tunynet_Reward_Threads with (nolock) where AuditingStatus=20

select @AgainThreadCount=count(ThreadID) from Tunynet_Reward_Threads with (nolock) where AuditingStatus=30

select @PendingAnswerCount=count(PostID) from Tunynet_Reward_Answer with (nolock) where AuditingStatus=20

select @PendingCommentCount=count(CommentID) from Tunynet_Reward_Comments with (nolock) where AuditingStatus=20

   
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取通知项目默认设置 **/

CREATE PROCEDURE [dbo].[spb_NoticeItemSettingssInGlobal_GetAll]
(
	@userType int,
	@NoticeWayCode nvarchar(16)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if(@userType=1)
	begin
		SELECT     N.*, G.NoticeWayCode
		FROM       spb_NoticeItems AS N with (nolock) INNER JOIN
				   spb_GlobalNoticeItemSettings AS G with (nolock) ON N.ItemID = G.ItemID,
				   spb_Applications AS A with (nolock)
		WHERE G.NoticeWayCode=@NoticeWayCode and N.ApplicationID=A.ApplicationID and A.IsEnabled=1 and N.AllowPersonUser=1	 
	end
else if(@userType=2)
	begin
		SELECT     N.*, G.NoticeWayCode
		FROM       spb_NoticeItems AS N with (nolock) INNER JOIN
				   spb_GlobalNoticeItemSettings AS G with (nolock) ON N.ItemID = G.ItemID,
				   spb_Applications AS A
		WHERE G.NoticeWayCode=@NoticeWayCode and N.ApplicationID=A.ApplicationID and A.IsEnabled=1 and N.AllowCompanyUser=1
	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新默认通知项目设置 **/

CREATE PROCEDURE [dbo].[spb_NoticeItemSettingsInGlobal_Update] 
(
  @ItemID	int,
  @NoticeWayCode Nvarchar(16),
  @strItemID Nvarchar(1024)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @strSql nvarchar(1024)
set @strSql='DELETE FROM spb_GlobalNoticeItemSettings WHERE NoticeWayCode=@NoticeWayCode and ItemID not in('+@strItemID+')'
exec sp_executesql  @strSql,N'@NoticeWayCode nvarchar(16)',@NoticeWayCode=@NoticeWayCode

if not exists (select ItemID from spb_GlobalNoticeItemSettings with (nolock) where ItemID=@ItemID and NoticeWayCode=@NoticeWayCode)
--如果要更新的项目不存在则创建
  INSERT INTO spb_GlobalNoticeItemSettings
      (ItemID, NoticeWayCode)
  VALUES  (@ItemID, @NoticeWayCode)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户某个类别的链接 */

create PROCEDURE [dbo].[spb_UserLinks_DeleteByCategoryID] 
(
	@CategoryID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

delete from spb_UserLinks where CategoryID=@CategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 用户链接类别 */

CREATE PROCEDURE [dbo].[spb_UserLink_CreateUpdateDelete]
( 
    @Action int,
	@LinkID	int output,
	@UserID	int = 0,
	@CategoryID	int = 0,
	@Title nvarchar(256) = '',
	@ImageUrl nvarchar(256) = '',
	@LinkTitle nvarchar(256) = '',
	@LinkHref nvarchar(256) = '',
	@LinkType int = 0,
	@IsEnabled bit = 1,
	@DisplayOrder int = 0 output
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
        delete from spb_UserLinks where LinkID = @LinkID    --删除
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin
--				--取用户的最大值
--				DECLARE @NewDisplayOrder int
--				select @NewDisplayOrder=max(DisplayOrder) from spb_UserLinks where UserID=@UserID
--				if (@NewDisplayOrder is null) --新记录
--					begin
--						set @NewDisplayOrder = 0
--					end
--				else 
--					begin
--						set @NewDisplayOrder = @NewDisplayOrder + 1
--					end
				INSERT INTO [spb_UserLinks] ([UserID],[CategoryID],[Title],[ImageUrl],[LinkTitle],[LinkHref],[LinkType],[IsEnabled],[DisplayOrder])
                      VALUES (@UserID,@CategoryID,@Title,@ImageUrl,@LinkTitle,@LinkHref,@LinkType,@IsEnabled,@DisplayOrder)
            
				select @DisplayOrder = @DisplayOrder
                select @LinkID = SCOPE_IDENTITY() 
            end       
         else --更新
            begin
				UPDATE [spb_UserLinks]
				   SET [CategoryID] = @CategoryID
					  ,[Title] = @Title
					  ,[ImageUrl] = @ImageUrl
					  ,[LinkTitle] = @LinkTitle
					  ,[LinkHref] = @LinkHref
					  ,[LinkType] = @LinkType
					  ,[IsEnabled] = @IsEnabled
					  ,[DisplayOrder] = @DisplayOrder
					where LinkID=@LinkID
            end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取用户链接类别 */

CREATE PROCEDURE [dbo].[spb_UserLink_Get] 
(
    @LinkID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select l.*,c.CategoryName
from spb_UserLinks as l with (nolock) inner join spb_UserLinkCategories as c with (nolock) on l.categoryid=c.categoryid where l.LinkID=@LinkID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、博客每天执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Blog_PerDay]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

exec spb_Task_Blog_Statistics

update spb_BlogThreads set UserCategoryID=0
Where not exists
	(select CategoryID 
	from spb_BlogThreadUserCategories AS BUC with (nolock)
	where spb_BlogThreads.UserCategoryID= BUC.CategoryID and BUC.CategoryID>0
	 )
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除BlogPost */

CREATE PROCEDURE [dbo].[spb_BlogComment_Delete] 
(
    @PostID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
DECLARE @OwnerUserID INT
DECLARE @ThreadID INT


SELECT
    @OwnerUserID = P.OwnerUserID,
	@ThreadID = P.ThreadID
FROM
	spb_BlogComments P with (nolock) 
WHERE
	PostID = @PostID


  begin
    if not exists(select * from spb_BlogComments with (nolock) where PostID = @PostID)
    return
    delete spb_BlogComments where PostID = @PostID

    update spb_BlogThreads set CommentCount = CommentCount - 1 where ThreadID = @ThreadID
    
    update spb_BlogSections set CommentCount = CommentCount - 1 where OwnerUserID = @OwnerUserID    
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 对文章进行评价 */

CREATE PROCEDURE [dbo].[spb_BlogRating_Rate]
( 
	@ThreadID	int,
	@UserID	int,
	@Author	nvarchar(64) = '',
	@Rate	int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if exists (select ThreadID from spb_BlogRatings with (nolock) where ThreadID=@ThreadID and UserID=@UserID)

	begin
		
        UPDATE    spb_BlogThreads
        SET       RatingSum=RatingSum+@Rate-(select Rate from spb_BlogRatings with (nolock) where ThreadID=@ThreadID and UserID=@UserID)
        Where     ThreadID = @ThreadID
        
        UPDATE    spb_BlogRatings
        SET       Author = @Author, Rate = @Rate
        WHERE    (ThreadID = @ThreadID) AND (UserID = @UserID)

	end
    
	
else
	begin
        INSERT INTO spb_BlogRatings
                   (ThreadID, UserID, Author, Rate)
        VALUES     (@ThreadID,@UserID,@Author,@Rate)
    
        UPDATE    spb_BlogThreads
        SET       RatingSum=RatingSum+@Rate,TotalRatings=TotalRatings+1
        Where     ThreadID = @ThreadID
	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户并重设内容时调用 */

CREATE PROCEDURE [dbo].[spb_Blog_DeleteUserAndReassignContent]
( 
    @UserID int,
	@ReassignUserName		nvarchar(64)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE	@ReassignUserID	int
SELECT	@ReassignUserID = UserID from spb_Users with (nolock) where UserType=1 and UserName=@ReassignUserName

-- does the reassign user exist?
IF (@ReassignUserID IS NULL)
BEGIN
	SELECT 2 -- InvalidReassignUserName
	RETURN
END

IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END


BEGIN TRANSACTION
  
  --更新用户标签 
  update spb_BlogThreadUserTags set UserID=@ReassignUserID where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure

  --更新用户类别
  update spb_BlogThreadUserCategories set UserID=@ReassignUserID where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  --更新文章
  update spb_BlogThreads set OwnerUserID=@ReassignUserID where OwnerUserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  --管理员推荐
  delete spb_RecommendedItems  where CommendTypeID in(select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=113) and AuthorUserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  --更新附件表
  update spb_BlogThreadAttachments set OwnerUserID=@ReassignUserID where OwnerUserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  
  --更新被转移到用户的Weblog 
  declare @OldThreadCount int
  select @OldThreadCount=ThreadCount from spb_BlogSections with (nolock) where OwnerUserID=@UserID

  update spb_BlogSections set ThreadCount =ThreadCount + @OldThreadCount where OwnerUserID= @ReassignUserID
  IF (@@ERROR <> 0) GOTO Failure
  
  
  --删除评论
  delete spb_BlogComments where OwnerUserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  
  delete spb_BlogComments where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  
  --删除脚印（只删除删除用户踩脚印记录）
  delete spb_Footprints where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  
  --删除星级评价（只删除删除用户做出的评价）
  delete spb_BlogRatings where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  
  --删除模块
  delete spb_BlogSections where OwnerUserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
COMMIT TRANSACTION
SELECT 1 -- Success
RETURN

Failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取某文章的前一篇及后一篇文章ThreadID */
CREATE PROCEDURE [dbo].[spb_BlogThread_GetPrevNextThread] 
(
	@ThreadID int,
	@NextThreadID int OUTPUT,
    @NextThreadSubject  nvarchar(512) OUTPUT,
	@PrevThreadID int OUTPUT,
    @PrevThreadSubject  nvarchar(512) OUTPUT
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @OwnerUserID int

SELECT @OwnerUserID=T.OwnerUserID FROM	spb_BlogThreads T  with (nolock) WHERE T.ThreadID = @ThreadID

SELECT TOP 1 
	@PrevThreadID = ThreadID,@PrevThreadSubject=Subject
FROM 
	spb_BlogThreads with (nolock) 
WHERE 
	OwnerUserID = @OwnerUserID AND ThreadID < @ThreadID 
ORDER BY ThreadID DESC

IF @@ROWCOUNT < 1
  begin
	SELECT @PrevThreadID = 0
    SELECT @PrevThreadSubject=''
  end
	
SELECT TOP 1 
	@NextThreadID = ThreadID,@NextThreadSubject=Subject
FROM 
	spb_BlogThreads with (nolock)
WHERE 
	OwnerUserID = @OwnerUserID AND ThreadID > @ThreadID 
ORDER BY ThreadID ASC

IF @@ROWCOUNT < 1
  begin
	SELECT @NextThreadID = 0
    SELECT @NextThreadSubject=''
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置博客文章审核状态 */

create PROCEDURE [dbo].[spb_BlogThread_UpdatePrivacyStatus]
( 
    @ThreadID int,
    @PrivacyStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_BlogThreads set PrivacyStatus=@PrivacyStatus where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置博客站点类别 */

create PROCEDURE [dbo].[spb_BlogThread_UpdateSiteCategoryByCategoryID]
( 
    @fromSiteCategoryID int,
    @toSiteCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_BlogThreads set SiteCategoryID=@toSiteCategoryID where SiteCategoryID=@fromSiteCategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台博客统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_BlogManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingCommentCount int out
)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
	
select @PendingThreadCount= count(ThreadID) from spb_BlogThreads with (nolock) where AuditingStatus=20
select @AgainThreadCount=count(ThreadID) from spb_BlogThreads with (nolock) where AuditingStatus=30
select @PendingCommentCount=count(ThreadID) from spb_BlogComments with (nolock) where AuditingStatus=20
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、博客统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Blog_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--1.更新spb_Applications表
DECLARE @TotalCount INT
DECLARE @CountInPast24Hours INT
DECLARE @NewestID INT

DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate() - 1,120)  
SELECT @TotalCount=COUNT(*) FROM spb_BlogThreads with (nolock)
SELECT @CountInPast24Hours=COUNT(*) FROM spb_BlogThreads with (nolock) WHERE PostDate >= @currentDate
SELECT @NewestID=isnull(MAX(ThreadID),0) FROM spb_BlogThreads with (nolock)

UPDATE    spb_Applications
SET       TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
WHERE     (ApplicationID = 111)

--2.更新spb_SiteCategories表
declare @CategoryID int
DECLARE Categories_Cursor CURSOR FOR
SELECT CategoryID FROM spb_SiteCategories with (nolock) WHERE (ApplicationID = 111)
	
OPEN Categories_Cursor
FETCH NEXT FROM Categories_Cursor INTO @CategoryID
	
WHILE @@FETCH_STATUS = 0
    BEGIN	
    update spb_SiteCategories  
    set    ItemCount = (select count(*) from spb_BlogThreads with (nolock) where SiteCategoryID = @CategoryID and AuditingStatus=40 )
    where  CategoryID = @CategoryID

	FETCH NEXT FROM Categories_Cursor INTO @CategoryID
		
	END
	
CLOSE Categories_Cursor
DEALLOCATE Categories_Cursor

--4.更新博客积分
declare @ThreadCountForBlogPointRate float
declare @CommentCountForBlogPointRate float
declare @HitTimesForBlogPointRate float

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=3201)  
  select @ThreadCountForBlogPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=3201
else
  set @ThreadCountForBlogPointRate=4

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=3202)  
  select @CommentCountForBlogPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=3202
else
  set @CommentCountForBlogPointRate=1

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=3204)  
  select @HitTimesForBlogPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=3204
else
  set @HitTimesForBlogPointRate=0.1


update spb_BlogSections set Points = ThreadCount*@ThreadCountForBlogPointRate + CommentCount*@CommentCountForBlogPointRate + HitTimes*@HitTimesForBlogPointRate 
where IsActive = 1
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 按天统计Blog发帖量 */

CREATE PROCEDURE [dbo].[spb_BlogThreads_StatByMonth] 
(
	@OwnerUserID int,
	@Year int = null,
	@Month int = null
)
as
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED

if (@Year is not null) and (@Month is not null)

Select @Month as [Month], @Year as [Year], Day(T.PostDate) as [Day], Count(*) as [Count] 
From spb_BlogThreads T with (nolock)
where T.OwnerUserID=@OwnerUserID and T.PrivacyStatus>20 and Month(T.PostDate)=@Month and Year(T.PostDate)=@Year and T.PostDate<=getdate()
Group by Day(T.PostDate) order by  [Day]

else

Select Year(T.PostDate) as [Year], Month(T.PostDate) as [Month], 1 as [Day], Count(*) as [Count] 
From spb_BlogThreads T with (nolock)
where T.OwnerUserID=@OwnerUserID and T.PrivacyStatus>20 and T.PostDate<=getdate()
Group by Year(T.PostDate),Month(T.PostDate) order by [Year] desc, [Month] desc
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 置顶 */

CREATE PROCEDURE [dbo].[spb_BlogThread_SetSticky] 
(
    @ThreadID int,
    @SpecialOrder int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
if exists (select ThreadID from spb_BlogThreads with (nolock) where ThreadID=@ThreadID)
  update spb_BlogThreads set SpecialOrder = @SpecialOrder where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置博客文章审核状态 */

create PROCEDURE [dbo].[spb_BlogThread_UpdateAuditingStatus]
( 
    @ThreadID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_BlogThreads set AuditingStatus=@AuditingStatus where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置站点文件类别 */

CREATE PROCEDURE [dbo].[spb_BlogThread_UpdateSiteCategory]
( 
    @ThreadID int,
    @SiteCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_BlogThreads set SiteCategoryID=@SiteCategoryID where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置取消精华 */

CREATE PROCEDURE [dbo].[spb_BlogThread_SetEssential] 
(
    @ThreadID int,
    @IsEssential bit
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
if exists (select ThreadID from spb_BlogThreads with (nolock) where ThreadID=@ThreadID)
  update spb_BlogThreads set IsEssential = @IsEssential where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除BlogThread */

CREATE PROCEDURE [dbo].[spb_BlogThread_Delete] 
(
    @ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if not exists (select * from spb_BlogThreads with (nolock) where ThreadID=@ThreadID)
return
DECLARE @OwnerUserID INT
SELECT	@OwnerUserID = OwnerUserID FROM spb_BlogThreads with (nolock) WHERE	ThreadID = @ThreadID
    
declare @CommentCount int
declare @UserCategoryID int

select @CommentCount = Count(*) from spb_BlogComments with (nolock) where ThreadID = @ThreadID
select @UserCategoryID=UserCategoryID from spb_BlogThreads with (nolock) where ThreadID=@ThreadID

begin TRANSACTION

--更新站点标签
update spb_BlogThreadSiteTags set ItemCount =ItemCount-1 where TagName in(select TagName from spb_BlogThreadUserTags with (nolock) where TagName in(select TagName from spb_BlogThreadsInUserTags with (nolock) where ItemID=@ThreadID))
IF (@@ERROR <> 0) GOTO Failure

--更新用户标签计数
update spb_BlogThreadUserTags set ItemCount=ItemCount-1 where TagName in(select TagName from spb_BlogThreadsInUserTags with(nolock) where ItemID=@ThreadID) 
IF (@@ERROR <> 0) GOTO Failure

--更新用户分类
if exists (select UserID from spb_BlogThreadUserCategories with (nolock) where CategoryID=@UserCategoryID)
begin
   update spb_BlogThreadUserCategories set ItemCount=ItemCount-1 where CategoryID=@UserCategoryID
   IF (@@ERROR <> 0) GOTO Failure
end

--删除脚印
delete spb_Footprints where ThreadID=@ThreadID
IF (@@ERROR <> 0) GOTO Failure

--删除管理员推荐
delete spb_RecommendedItems where CommendTypeID in (select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=111) and ItemID=@ThreadID
IF (@@ERROR <> 0) GOTO Failure

--删除星级评价
delete spb_BlogRatings where ThreadID=@ThreadID
IF (@@ERROR <> 0) GOTO Failure

--删除标签
delete spb_BlogThreadsInUserTags where ItemID=@ThreadID
IF (@@ERROR <> 0) GOTO Failure

--相关附件的删除【附件独立逻辑处理】

--删除文章回复
delete spb_BlogComments where ThreadID = @ThreadID
IF (@@ERROR <> 0) GOTO Failure

--删除文章
delete spb_BlogThreads where ThreadID = @ThreadID
IF (@@ERROR <> 0) GOTO Failure

COMMIT TRANSACTION
RETURN
Failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 重置BlogSection统计信息 **/

CREATE procedure [dbo].[spb_BlogSection_ResetStatistics]
(
	@OwnerUserID int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
DECLARE @MostRecentThreadID int
DECLARE @MostRecentPostDate datetime
DECLARE @MostRecentThreadSubject nvarchar(256)
DECLARE @MostRecentThreadSummary nvarchar(2000)

IF @OwnerUserID > 0
    BEGIN
	    -- Select the most recent Thread from the Section.
		DECLARE @MostRecentThreadSummaryForBody nvarchar(2000)
	    SELECT TOP 1
		    @MostRecentThreadID=ThreadID,
		    @MostRecentPostDate=PostDate,
            @MostRecentThreadSubject=Subject,
            @MostRecentThreadSummary=Excerpt,
            @MostRecentThreadSummaryForBody=Substring(Body,0,500)
	    FROM 
		    spb_BlogThreads with (nolock)
	    WHERE 
		    OwnerUserID = @OwnerUserID
	    ORDER BY
		    ThreadID DESC
		
		if @MostRecentThreadSummary=''
		set @MostRecentThreadSummary = @MostRecentThreadSummaryForBody
       
	    -- If the thread is null, reset the forum statistics.
	    IF @MostRecentThreadID IS NULL
		    UPDATE
			    spb_BlogSections
		    SET
			    ThreadCount = 0,
			    CommentCount = 0,
			    MostRecentThreadID = null,
			    MostRecentThreadSubject = null,
			    MostRecentPostDate = null,
			    MostRecentThreadSummary = null
		    WHERE
			    OwnerUserID = @OwnerUserID
	    ELSE
          begin
              DECLARE @ThreadCount int
              DECLARE @CommentCount int
              select @ThreadCount=COUNT(ThreadID) FROM spb_BlogThreads with (nolock) WHERE OwnerUserID = @OwnerUserID
              select @CommentCount=COUNT(PostID) FROM spb_BlogComments with (nolock) WHERE OwnerUserID = @OwnerUserID

              UPDATE 
	              spb_BlogSections
              SET
				ThreadCount = isnull(@ThreadCount,0),
			    CommentCount = isnull(@CommentCount,0),
			    MostRecentThreadID = isnull(@MostRecentThreadID,0),
			    MostRecentThreadSubject = @MostRecentThreadSubject,
			    MostRecentPostDate = @MostRecentPostDate,
			    MostRecentThreadSummary = @MostRecentThreadSummary
              WHERE
	              OwnerUserID = @OwnerUserID
          end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新BlogThread **/

CREATE PROCEDURE [dbo].[spb_BlogThread_CreateUpdate] 
(
    @Action int,
	--@AllowDuplicatePosts bit,
	--@DuplicateIntervalInMinutes int = 0,
	@UpdateBlogSectionStatistics bit = 1,
	@ThreadID int out,
 	@OwnerUserID int = 0,
    @Author nvarchar(256) = '',
	@Subject nvarchar(512),
	@Body ntext,
    @IsEssential bit=0,
    @SpecialOrder int=0,
    @StickyDate datetime,
    @BlogThreadTypeID int,
    @AuditingStatus int,
    @SiteCategoryID int,
    @UserCategoryID int,
	@PropertyNames ntext = null,
	@PropertyValues ntext = null,
	@Excerpt nvarchar(500) = null,	
	@PrivacyStatus int = 30,
	@UserHostAddress nvarchar(64)='000.000.000.000'
	 --BlogThread
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin

		BEGIN TRANSACTION

			INSERT spb_BlogThreads (OwnerUserID,Author,Subject,Body,IsEssential,SpecialOrder,StickyDate,BlogThreadTypeID,AuditingStatus,PrivacyStatus,SiteCategoryID,UserCategoryID,Excerpt,PropertyNames,PropertyValues,UserHostAddress)
			Values (@OwnerUserID,@Author,@Subject,@Body,@IsEssential,@SpecialOrder,@StickyDate,@BlogThreadTypeID,@AuditingStatus,@PrivacyStatus,@SiteCategoryID,@UserCategoryID,@Excerpt,@PropertyNames,@PropertyValues,@UserHostAddress)
		    IF(@@ERROR<>0) GOTO FAILURE
			-- Get the new ThreadID
			SELECT 
				@ThreadID = SCOPE_IDENTITY()

		
        -- 用户标签计数  -- 站点标签计数 【创建标签关联项时处理】
      
        -- 用户分类计数
        if exists (select UserID from spb_BlogThreadUserCategories with (nolock) where CategoryID=@UserCategoryID)
            begin  
			  update spb_BlogThreadUserCategories set ItemCount=ItemCount+1 where CategoryID=@UserCategoryID
			  IF(@@ERROR<>0) GOTO FAILURE
			end
          
	   COMMIT TRANSACTION
	   return
       FAILURE:
       ROLLBACK TRANSACTION
       RETURN
	end
  else if @Action=1 --更新

	begin
	   declare @oldUserCategoryID int
       declare @oldPrivacyStatus int
	   select  @oldUserCategoryID = UserCategoryID,@oldPrivacyStatus=PrivacyStatus from spb_BlogThreads with (nolock) where ThreadID=@ThreadID

	   update spb_BlogThreads set 
	        OwnerUserID=@OwnerUserID,Author=@Author,Subject=@Subject,IsEssential=@IsEssential,SpecialOrder=@SpecialOrder,StickyDate=@StickyDate,BlogThreadTypeID=@BlogThreadTypeID,AuditingStatus=@AuditingStatus,PrivacyStatus=@PrivacyStatus,SiteCategoryID=@SiteCategoryID,UserCategoryID=@UserCategoryID,Excerpt=@Excerpt,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues,UserHostAddress=@UserHostAddress
	   where ThreadID=@ThreadID
       
       if @Body is not null UPDATE spb_BlogThreads SET	Body = @Body  where ThreadID=@ThreadID  
       
       if @UserCategoryID <> @oldUserCategoryID 
         begin
          update spb_BlogThreadUserCategories set ItemCount=ItemCount+1,MostRecentUpdateDate=getdate() where CategoryID=@UserCategoryID
          update spb_BlogThreadUserCategories set ItemCount=ItemCount-1 ,MostRecentUpdateDate=getdate()  where CategoryID=@oldUserCategoryID
         end 
	end

/****** 对象:  StoredProcedure [dbo].[spb_BlogThread_Delete]    脚本日期: 08/24/2009 16:01:11 ******/
SET ANSI_NULLS ON
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新BlogPost 用于回复及Trackback **/

CREATE PROCEDURE [dbo].[spb_BlogComment_CreateUpdate] 
(
    @Action int,
	@UpdateBlogSectionStatistics bit = 1,
    @ThreadID int ,
    @ParentID int =0,
	@PostID int out,
 	@OwnerUserID int = 0,
    @UserID int=0,
    @Author nvarchar(256) = '',
    @Subject nvarchar(256) = '',
	@Body ntext,
	@IsApproved bit = 1,
    @AuditingStatus int,
	@PropertyNames ntext = null,
	@PropertyValues ntext = null,
	@TitleUrl nvarchar(256) = null,
	@UserHostAddress nvarchar(64)='000.000.000.000'
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加

	begin
	
		INSERT spb_BlogComments (ThreadID,ParentID,OwnerUserID,UserID,Author,Subject,Body,IsApproved,AuditingStatus,TitleUrl,PropertyNames,PropertyValues,UserHostAddress)
				values (@ThreadID,@ParentID,@OwnerUserID,@UserID,@Author,@Subject,@Body,@IsApproved,@AuditingStatus,@TitleUrl,@PropertyNames,@PropertyValues,@UserHostAddress)

		-- Grab the new PostID and update the ThreadID's info
		SELECT @PostID = SCOPE_IDENTITY() 
		
        update spb_BlogThreads set CommentCount = CommentCount+1,LastRepliedDate=GetDate() where ThreadID = @ThreadID
	end

  else if @Action=1 --更新

	 update spb_BlogComments set 
	        ThreadID=@ThreadID,ParentID=@ParentID,OwnerUserID=@OwnerUserID,UserID=@UserID,Author=@Author,Body=@Body,IsApproved=@IsApproved,AuditingStatus=@AuditingStatus,TitleUrl=@TitleUrl,Subject=@Subject,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues,UserHostAddress=@UserHostAddress
	 where PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 博客文章计数 **/
CREATE PROCEDURE [dbo].[spb_BlogThreadView_Add]
(
	@ItemID int,
	@RssViewCount int=0,
	@WebViewCount int=0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_BlogThreads set HitTimes = HitTimes+@WebViewCount,RssViewTimes = RssViewTimes+@RssViewCount where ThreadID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置用户文件类别 */

CREATE PROCEDURE [dbo].[spb_BlogThread_UpdateUserCategory]
( 
    @ThreadID int,
    @UserCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON


      DECLARE @OldUserCategoryID nvarchar(8)
      select  @OldUserCategoryID=UserCategoryID from spb_BlogThreads with (nolock) where (ThreadID=@ThreadID)
      UPDATE    spb_BlogThreads
      SET       UserCategoryID=@UserCategoryID
      WHERE     ThreadID=@ThreadID

      if(@OldUserCategoryID<>@UserCategoryID)
        begin
            --原类别的内容数减1
            UPDATE   spb_BlogThreadUserCategories SET ItemCount = ItemCount - 1 WHERE (CategoryID = @OldUserCategoryID) AND (ItemCount>0)
            --新类别的内容数加1
            UPDATE   spb_BlogThreadUserCategories SET ItemCount = ItemCount + 1 WHERE (CategoryID = @UserCategoryID) 
        end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 添加、修改、删除朋友 **/
CREATE PROCEDURE [dbo].[spb_Friend_CreateUpdateDelete]
(
    @FriendID int = 0 out,
    @FriendID2 int = 0 out, 
    @UserID int = 0,
    @FriendUserID int = 0,
    @Friendliness	int = 2,
    @IsHidden bit=0,
    @NoteName nvarchar(64)='',
    @PropertyNames	ntext = null,
    @PropertyValues	ntext = null,
    @Action int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
	  if not exists (select * from spb_Friends with (nolock) where UserID=@UserID and FriendUserID=@FriendUserID)
	  return
	  
      declare @FriendID1 int
      
      select @FriendID1=FriendID from spb_Friends with (nolock) where UserID=@UserID and FriendUserID=@FriendUserID
      select @FriendID2=FriendID from spb_Friends with (nolock) where UserID=@FriendUserID and FriendUserID=@UserID

      delete from spb_FriendsInUserCategories where ItemID = @FriendID1
      delete from spb_FriendsInUserCategories where ItemID = @FriendID2

	    delete from spb_Friends where UserID=@UserID and FriendUserID=@FriendUserID
	    delete from spb_Friends where UserID=@FriendUserID and FriendUserID=@UserID
	    
	    update spb_Users set FriendCount=FriendCount-1 where UserID = @UserID
	    update spb_Users set FriendCount=FriendCount-1 where UserID = @FriendUserID
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin
                if not exists (select FriendID from spb_Friends with (nolock) where UserID=@UserID and FriendUserID=@FriendUserID)
                    begin
                      insert into spb_Friends (UserID,FriendUserID) values (@UserID,@FriendUserID)
                      set @FriendID = SCOPE_IDENTITY()

                      insert into spb_Friends (UserID,FriendUserID) values (@FriendUserID,@UserID)
                      set @FriendID2 = SCOPE_IDENTITY()
                      
	                    update spb_Users set FriendCount=FriendCount+1 where UserID = @UserID
	                    update spb_Users set FriendCount=FriendCount+1 where UserID = @FriendUserID
                    end
            end
	    ELSE --更新
            update spb_Friends set 
                Friendliness=@Friendliness,
                IsHidden=@IsHidden,
                NoteName=@NoteName,
                PropertyNames=@PropertyNames,
                PropertyValues=@PropertyValues
            where FriendID=@FriendID
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [dbo].[spb_vw_PersonUsers_FullUser]
AS
SELECT     dbo.spb_PersonUserProfile.Gender, dbo.spb_PersonUserProfile.Birthday, dbo.spb_PersonUserProfile.Stature, dbo.spb_PersonUserProfile.Weight, 
                      dbo.spb_PersonUserProfile.Shape, dbo.spb_PersonUserProfile.Blood, dbo.spb_PersonUserProfile.Degree, dbo.spb_PersonUserProfile.School, 
                      dbo.spb_PersonUserProfile.SchoolID, dbo.spb_PersonUserProfile.NowSalary, dbo.spb_PersonUserProfile.Interest, 
                      dbo.spb_PersonUserProfile.Expertise, dbo.spb_PersonUserProfile.Marriage, dbo.spb_PersonUserProfile.CardType, 
                      dbo.spb_PersonUserProfile.CardID, dbo.spb_PersonUserProfile.Title, dbo.spb_PersonUserProfile.TitleLevel, dbo.spb_PersonUserProfile.JobSort, 
                      dbo.spb_PersonUserProfile.CompanyName, dbo.spb_PersonUserProfile.CompanyTrade, dbo.spb_PersonUserProfile.NowAreaCode, 
                      dbo.spb_PersonUserProfile.HomeAreaCode, dbo.spb_PersonUserProfile.CompanyAreaCode, dbo.spb_Users.UserID, dbo.spb_Users.UserName, 
                      dbo.spb_Users.Password, dbo.spb_Users.PasswordSalt, dbo.spb_Users.PasswordQuestion, dbo.spb_Users.PasswordFormat, 
                      dbo.spb_Users.PasswordAnswer, dbo.spb_Users.PrivateEmail, dbo.spb_Users.MembershipID, dbo.spb_Users.CommonName, 
                      dbo.spb_Users.Nickname, dbo.spb_Users.ForceLogin, dbo.spb_Users.UserAccountStatus, dbo.spb_Users.LastActivity, dbo.spb_Users.LastAction, 
                      dbo.spb_Users.IPCreated, dbo.spb_Users.IPLastActivity, dbo.spb_Users.DatabaseQuota, dbo.spb_Users.DatabaseQuotaUsed, 
                      dbo.spb_Users.EnableAvatar, dbo.spb_Users.EnableDisplayInMemberList, dbo.spb_Users.EnableOnlineStatus, dbo.spb_Users.EnableEmail, 
                      dbo.spb_Users.EnableHtmlEmail, dbo.spb_Users.IsAvatarApproved, dbo.spb_Users.UserRankType, dbo.spb_Users.UserType, dbo.spb_Users.Mobile, 
                      dbo.spb_Users.PublicEmail, dbo.spb_Users.MsnIM, dbo.spb_Users.QQIM, dbo.spb_Users.YahooIM, dbo.spb_Users.SkypeIM, 
                      dbo.spb_Users.PersonalHomepage, dbo.spb_Users.InviteUserID, dbo.spb_Users.InviteClubID, dbo.spb_Users.PropertyNames, 
                      dbo.spb_Users.PropertyValues, dbo.spb_Users.MemberLevel, dbo.spb_Users.DateCreated, dbo.spb_Users.BasicPoints, dbo.spb_Users.TradePoints, 
                      dbo.spb_Users.PrepayTradePoints, dbo.spb_Users.ReportPoints, dbo.spb_Users.CreditPoints, dbo.spb_Users.ExpertPoints, dbo.spb_Users.Rank, 
                      dbo.spb_Users.RMBMoney, dbo.spb_Users.PrepayRMBMoney, dbo.spb_Users.ProfileIntegrity, dbo.spb_Users.FriendCount, 
                      dbo.spb_Users.InviteFriendCount, dbo.spb_Users.loginTimes, dbo.spb_Users.HitTimes, dbo.spb_Users.Theme, dbo.spb_Users.ThemeAppearance, 
                      dbo.spb_Users.IsEmailVerified, dbo.spb_PersonUserProfile.NowAreaCode AS Expr1, dbo.spb_PersonUserProfile.HomeAreaCode AS Expr2, 
                      dbo.spb_PersonUserProfile.CompanyAreaCode AS Expr3, dbo.spb_Users.StageHitTimes, dbo.spb_Users.IsModerated, 
                      dbo.spb_Users.IsForceModerated
FROM         dbo.spb_PersonUserProfile INNER JOIN
                      dbo.spb_Users ON dbo.spb_PersonUserProfile.UserID = dbo.spb_Users.UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
功能：从外部系统同步用户
必填参数：@UserName-用户名，@Password-密码，@PasswordFormat-用户密码存储格式（默认是MD5加密），@PrivateEmail-用户账号邮箱
		  
@PasswordFormat可选值：0-密码未加密，1-密码使用 SHA1 哈希算法进行单向加密(from Membership)，
					   2-密码使用由 machineKey 元素配置确定的加密设置进行加密(from Membership)，
					   3-SpaceBuilder自有的对称加密算法，
					   6-标准MD5加密
返回值：
      首个单行单列值是创建结果，对应数字含义是：0-创建失败，1-创建成功，2-用户名重复，3-邮箱重复；
      输出参数： @UserID
*/
create Proc [dbo].[spb_api_CreateUser]
(
      -- spb_users内容
  @UserID int out,  
  
  @UserName nvarchar (64) = null,  --用户名,必填
  @Password nvarchar (128) = null,  --密码
  @PasswordSalt nvarchar (128) = '', --加密存储密码时的散列值
  @PasswordFormat int = 6, --用户密码存储格式
  @PasswordQuestion nvarchar(64) = '',--密码问题
  @PasswordAnswer nvarchar(128) = '',--密码答案
  @PrivateEmail nvarchar(64) = null,  --用户账号邮箱
  @RequiresUniqueEmail bit = 2, --是否要求邮箱是唯一的
    
  @CommonName nvarchar(64) = '', --真实姓名
  @NickName nvarchar(64) = '', --昵称
  @ForceLogin   bit= 0,	 
  @UserAccountStatus  smallint = 1,	
  @IPCreated nvarchar(32) = '000.000.000.000',
  @DatabaseQuota int = 102400,
  @DatabaseQuotaUsed int =0,
  @IsModerated  bit  = 1,
  @IsForceModerated bit = 0,	
  @MemberLevel int  = 0,	
  @EnableAvatar bit  = 1, -- 启用头像	
  @EnableDisplayInMemberList  bit  = 1,	
  @EnableOnlineStatus   bit  = 1,
  @EnableEmail bit = 1, --默认接收网站email
  @EnableHtmlEmail   bit  = 1,	
  @IsAvatarApproved   bit  = 1, --头像审核通过
  @UserRankType smallint = 0,
  @InviteUserID	int = 0,
  @InviteClubID	int	= 0,	
  @IsEmailVerified bit = 0,
  
  @mobile nvarchar(64) = '',
  @PublicEmail nvarchar(64) = '',
  @MsnIM nvarchar(64) = '',
  @QQIM nvarchar(64) = '',
  @YahooIM nvarchar(64) = '',
  @SkypeIM nvarchar(64) = '',
  @PersonalHomepage		nvarchar(256) = '',
  @Theme nvarchar(128) = '',
  @ThemeAppearance	nvarchar(128) = '',
  @PropertyNames ntext = null,
  @PropertyValues ntext = null,    
  
  -- spb_PersonUsersProfile 内容
  @Gender	smallint =1,
  @Birthday datetime = null,
  @NowAreaCode varchar(8) = '',
  @HomeAreaCode varchar(8) = '',
  @Stature int = 0,
  @Weight	int = 0,
  @Shape smallint = 0,
  @Blood smallint = 0,
  @Degree	smallint = 0,
  @School	nvarchar(256) = '',
  @SchoolID int=0,
  @NowSalary	smallint = 0,
  @Interest nvarchar(512) = '',
  @Expertise nvarchar(512) = '',
  @Marriage smallint = 0,
  @CardType smallint = 1,
  @CardID	nvarchar(64) = '',
  @Title nvarchar(64)='',
  @TitleLevel	smallint = 0,
  @JobSort	nchar(4) = '',
  @CompanyName nvarchar(256)='',
  @CompanyAreaCode varchar(8) = '',
  @CompanyTrade smallint=0

  -- spb_PersonUsersProfile end  
)
as
    begin transaction
    
          if exists (select UserID from spb_Users with (nolock) where LoweredUserName = lower(@UserName))
      begin
        select 2 --用户名重复
        return 
      end      
      
      if (@RequiresUniqueEmail = 1)
      begin
        if exists (select UserID from spb_Users with (nolock) where LoweredPrivateEmail = lower(@PrivateEmail))
        begin
          select 3 -- 邮箱重复
          return
        end
      end
      insert into [spb_Users] (UserName,LoweredUserName,Password,PasswordSalt,PasswordFormat,PasswordQuestion,PasswordAnswer,PrivateEmail,LoweredPrivateEmail,
          CommonName,Nickname,ForceLogin,UserAccountStatus,IPCreated,IPLastActivity,IsModerated,MemberLevel,EnableAvatar,EnableDisplayInMemberList,
          EnableOnlineStatus,EnableEmail,EnableHtmlEmail,UserRankType,mobile,PublicEmail,MsnIM,QQIM,YahooIM,SkypeIM,PersonalHomepage,UserType,InviteUserID,InviteClubID,IsEmailVerified,Theme,ThemeAppearance,PropertyNames,PropertyValues)
      values (@UserName,lower(@UserName),@Password,@PasswordSalt,@PasswordFormat,@PasswordQuestion,@PasswordAnswer,@PrivateEmail,lower(@PrivateEmail),
          @CommonName,@NickName,@ForceLogin,@UserAccountStatus,@IPCreated,@IPCreated,@IsModerated,@MemberLevel,@EnableAvatar,@EnableDisplayInMemberList,
          @EnableOnlineStatus,@EnableEmail,@EnableHtmlEmail,@UserRankType,@mobile,@PublicEmail,@MsnIM,@QQIM,@YahooIM,@SkypeIM,@PersonalHomepage,1,@InviteUserID,@InviteClubID,@IsEmailVerified,@Theme,@ThemeAppearance,@PropertyNames,@PropertyValues)
	  if(@@error<>0) goto failure

      set @UserID = SCOPE_IDENTITY()
        
      insert into spb_PersonUserProfile ([UserID],[Gender],[Birthday],[NowAreaCode],[HomeAreaCode],[Stature],[Weight],[Shape],
          [Blood],[Degree],[School],[SchoolID],[NowSalary],[Interest],[Expertise],[Marriage],[CardType],[CardID],[Title],[TitleLevel],[JobSort],[CompanyName],[CompanyAreaCode],[CompanyTrade])
      values (@UserID,@Gender,@Birthday,@NowAreaCode,@HomeAreaCode,@Stature,@Weight,@Shape,@Blood,@Degree,@School,@SchoolID,@NowSalary,
          @Interest,@Expertise,@Marriage,@CardType,@CardID,@Title,@TitleLevel,@JobSort,@CompanyName,@CompanyAreaCode,@CompanyTrade)
	  if(@@error<>0) goto failure
	   
	  
    insert into spb_BlogSections (OwnerUserID,SectionName) values (@UserID, @Nickname+'的博客')
	  if(@@error<>0) goto failure
	  
    insert into spb_PhotoSections (OwnerUserID,SectionName) values (@UserID, @Nickname+'的相册')
	  if(@@error<>0) goto failure
	  
    insert into spb_FileSections (OwnerUserID,SectionName) values (@UserID, @Nickname+'的文件')
	  if(@@error<>0) goto failure
	      
	Insert spb_VoteSections (PresentAreaID, OwnerID) values (11,@UserID)
    if(@@error<>0) goto failure
	
	Insert spb_OwnerApplicationInPresentAreas(OwnerID,ApplicationID,PresentAreaID) Select @UserID,ApplicationID,11 From spb_ApplicationInAvailablePresentAreas Where PresentAreaID = 11 and IsBuiltIn = 0
    if(@@error<>0) goto failure
    
    Insert spb_PhotoUserCategories(UserID,CategoryName) values (@UserID,'默认相册')
    if(@@error<>0) goto failure
	select 1     -- 成功

    commit transaction
    return
    
    failure:
    rollback transaction
    select 0   --失败
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE procedure [dbo].[spb_PersonUser_CreateUpdate] 
(
  -- spb_users内容
  @UserID int out,  
  
  @UserName nvarchar (64) = null,
  @Password nvarchar (128) = null,
  @PasswordSalt nvarchar (128) = null,
  @PasswordFormat int = 1,
  @PasswordQuestion nvarchar(64) = null,
  @PasswordAnswer nvarchar(128) = null,
  @PrivateEmail nvarchar(64) = '',    
  @RequiresUniqueEmail bit = 2,
  @MembershipID uniqueidentifier = null,
    
  @CommonName nvarchar(64) = '',
  @NickName nvarchar(64) = '',
  @ForceLogin   bit= 0,	
  @UserAccountStatus  smallint = 1,	
  @IPCreated nvarchar(32) = '000.000.000.000',
  @DatabaseQuota int = 102400,
  @DatabaseQuotaUsed int =0,
  @IsModerated  bit  = 1,
  @IsForceModerated bit = 0,	
  @MemberLevel int  = 0,	
  @EnableAvatar bit  = 1, -- 启用头像	
  @EnableDisplayInMemberList  bit  = 1,	
  @EnableOnlineStatus   bit  = 1,
  @EnableEmail bit = 1, --默认接收网站email
  @EnableHtmlEmail   bit  = 1,	
  @IsAvatarApproved   bit  = 1, --头像审核通过
  @UserRankType smallint = 0,
  @InviteUserID	int = 0,
  @InviteClubID	int	= 0,	
  @IsEmailVerified bit = 0,
  
  @mobile nvarchar(64) = '',
  @PublicEmail nvarchar(64) = '',
  @MsnIM nvarchar(64) = '',
  @QQIM nvarchar(64) = '',
  @YahooIM nvarchar(64) = '',
  @SkypeIM nvarchar(64) = '',
  @PersonalHomepage		nvarchar(256) = '',
  @Theme nvarchar(128) = '',
  @ThemeAppearance	nvarchar(128) = '',
  @PropertyNames ntext = null,
  @PropertyValues ntext = null,    
  
  -- spb_PersonUsersProfile 内容
  @Gender	smallint =1,
  @Birthday datetime = null,
  @NowAreaCode varchar(8) = '',
  @HomeAreaCode varchar(8) = '',
  @Stature int = 0,
  @Weight	int = 0,
  @Shape smallint = 0,
  @Blood smallint = 0,
  @Degree	smallint = 0,
  @School	nvarchar(256) = '',
  @SchoolID int=0,
  @NowSalary	smallint = 0,
  @Interest nvarchar(512) = '',
  @Expertise nvarchar(512) = '',
  @Marriage smallint = 0,
  @CardType smallint = 1,
  @CardID	nvarchar(64) = '',
  @Title nvarchar(64),
  @TitleLevel	smallint = 0,
  @JobSort	nchar(4) = '',
  @CompanyName nvarchar(256),
  @CompanyAreaCode varchar(8) = '',
  @CompanyTrade smallint,

  -- spb_PersonUsersProfile end  

  @Action    int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
/*
This sproc returns an int that indicates the CreateUserStatus enum value:
  UnknownFailure = 0
  Created = 1
  DuplicateUsername = 2
  DuplicateEmailAddress = 3
  DisallowedUsername = 4
  Updated = 5
  InvalidQuestionAnswer = 6
  InvalidPassword = 7
*/

declare @UserType smallint
set @UserType = 1

--删除用户未处理

IF @Action = 0  
    BEGIN
      if exists (select UserID from spb_Users with (nolock) where LoweredUserName = lower(@UserName))
      begin
        select 2
        return 
      end      
      
      if (@RequiresUniqueEmail = 1)
      begin
        if exists (select UserID from spb_Users with (nolock) where LoweredPrivateEmail = lower(@PrivateEmail))
        begin
          select 3
          return
        end
      end
    
      insert into [spb_Users] (UserName,LoweredUserName,Password,PasswordSalt,PasswordFormat,PasswordQuestion,PasswordAnswer,PrivateEmail,LoweredPrivateEmail,MembershipID,
          CommonName,Nickname,ForceLogin,UserAccountStatus,IPCreated,IPLastActivity,IsModerated,MemberLevel,EnableAvatar,EnableDisplayInMemberList,
          EnableOnlineStatus,EnableEmail,EnableHtmlEmail,UserRankType,mobile,PublicEmail,MsnIM,QQIM,YahooIM,SkypeIM,PersonalHomepage,UserType,InviteUserID,InviteClubID,IsEmailVerified,Theme,ThemeAppearance,PropertyNames,PropertyValues)
      values (@UserName,lower(@UserName),@Password,@PasswordSalt,@PasswordFormat,@PasswordQuestion,@PasswordAnswer,@PrivateEmail,lower(@PrivateEmail),@MembershipID,
          @CommonName,@NickName,@ForceLogin,@UserAccountStatus,@IPCreated,@IPCreated,@IsModerated,@MemberLevel,@EnableAvatar,@EnableDisplayInMemberList,
          @EnableOnlineStatus,@EnableEmail,@EnableHtmlEmail,@UserRankType,@mobile,@PublicEmail,@MsnIM,@QQIM,@YahooIM,@SkypeIM,@PersonalHomepage,@UserType,@InviteUserID,@InviteClubID,@IsEmailVerified,@Theme,@ThemeAppearance,@PropertyNames,@PropertyValues)

      Select @UserID = SCOPE_IDENTITY()
        
      insert into spb_PersonUserProfile ([UserID],[Gender],[Birthday],[NowAreaCode],[HomeAreaCode],[Stature],[Weight],[Shape],
          [Blood],[Degree],[School],[SchoolID],[NowSalary],[Interest],[Expertise],[Marriage],[CardType],[CardID],[Title],[TitleLevel],[JobSort],[CompanyName],[CompanyAreaCode],[CompanyTrade])
      values (@UserID,@Gender,@Birthday,@NowAreaCode,@HomeAreaCode,@Stature,@Weight,@Shape,@Blood,@Degree,@School,@SchoolID,@NowSalary,
          @Interest,@Expertise,@Marriage,@CardType,@CardID,@Title,@TitleLevel,@JobSort,@CompanyName,@CompanyAreaCode,@CompanyTrade)

      select 1
      RETURN
      
    End
Else IF @Action = 1
    Begin

      if (@RequiresUniqueEmail = 1)
      begin
        if exists (select UserID from spb_Users with (nolock) where UserID<>@UserID and LoweredPrivateEmail = lower(@PrivateEmail))
        begin
          select 3
          return
        end
      end

      UPDATE spb_PersonUserProfile SET
            Gender = @Gender,
            Birthday = @Birthday,
            NowAreaCode = @NowAreaCode,
            HomeAreaCode = @HomeAreaCode,
            Stature = @Stature,
            Weight = @Weight,
            Shape = @Shape,
            Blood = @Blood,
            Degree = @Degree,
            School = @School,
            SchoolID=@SchoolID,
            NowSalary = @NowSalary,
            Interest = @Interest,
            Expertise = @Expertise,
            Marriage = @Marriage,
            CardType = @CardType,
            CardID = @CardID,
            Title = @Title,
            TitleLevel = @TitleLevel,
            JobSort = @JobSort,
            CompanyName = @CompanyName,
            CompanyAreaCode = @CompanyAreaCode,
            CompanyTrade = @CompanyTrade
        WHERE UserID = @UserID

      UPDATE spb_Users SET
            PrivateEmail = @PrivateEmail,
            LoweredPrivateEmail = lower(@PrivateEmail),
            CommonName = @CommonName,
            Nickname = @NickName,
            ForceLogin = @ForceLogin,
            UserAccountStatus = @UserAccountStatus,
            DatabaseQuota = @DatabaseQuota,
            DatabaseQuotaUsed=@DatabaseQuotaUsed,
            IsModerated = @IsModerated,
            IsForceModerated = @IsForceModerated,
            MemberLevel = @MemberLevel,
            EnableAvatar = @EnableAvatar,
            EnableDisplayInMemberList = @EnableDisplayInMemberList,
            EnableOnlineStatus = @EnableOnlineStatus,
            EnableEmail = @EnableEmail,
            EnableHtmlEmail = @EnableHtmlEmail,
            IsAvatarApproved = @IsAvatarApproved,
            UserRankType = @UserRankType,
            mobile = @mobile,
            publicEmail = @PublicEmail,
			IsEmailVerified = @IsEmailVerified,
            MsnIM = @MsnIM,
            QQIM = @QQIM,
            YahooIM = @YahooIM,
            SkypeIM = @SkypeIM,
            PersonalHomepage = @PersonalHomepage,
            Theme = @Theme,
            ThemeAppearance = @ThemeAppearance,
            PropertyNames = @PropertyNames,
            PropertyValues = @PropertyValues
        WHERE UserID = @UserID
      
      Select 5

    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--如果不输入管理员 username=admin password=admin888
CREATE Proc [dbo].[spb_system_CreateAdminUser]
(
    @AdminUserName nvarchar(256) = 'admin'
)
as
    begin transaction
    
    DECLARE @AdminPassword nvarchar(256)
    DECLARE @PasswordFOrmat int
    DECLARE @AdminEmail nvarchar(256)
    DECLARE @UserID int

    set @AdminPassword = '7fef6171469e80d32c0559f88b377245' --admin888
    set @PasswordFormat = 6  --0=clear text, 6=md5
    set @AdminEmail = 'admin@localhost.com'

    if not exists (select * from spb_SiteSettings with (nolock))
    begin
      INSERT spb_SiteSettings (SettingsXML,SettingsKey,version) VALUES (null,newID(),'2.0.0.1')
	    if(@@error<>0) goto failure
	  end
	  
    INSERT INTO [spb_Users] ([UserName], [LoweredUserName],[Password],[PasswordFormat], [PasswordSalt], [ForceLogin], [UserAccountStatus], [LastActivity], [LastAction],[PrivateEmail], [LoweredPrivateEmail],[IsModerated]) 
      VALUES(@AdminUserName, Lower(@AdminUserName),@AdminPassword,@PasswordFormat, N'D0+NqpHhqCPMR2WHXj2zNQ==', 0, 1, getdate(),'',@AdminEmail,lower(@AdminEmail),0)
	  if(@@error<>0) goto failure
	  
    set @UserID=SCOPE_IDENTITY()
    INSERT INTO [spb_PersonUserProfile]([UserID])	VALUES (@UserID)
	  if(@@error<>0) goto failure
	  
    insert into spb_BlogSections (OwnerUserID,SectionName) values (@UserID, 'Weblog')
	  if(@@error<>0) goto failure
	  
    insert into spb_PhotoSections (OwnerUserID,SectionName) values (@UserID, 'Gallery')
	  if(@@error<>0) goto failure
	  
    insert into spb_FileSections (OwnerUserID,SectionName) values (@UserID, 'FileGallery')
	  if(@@error<>0) goto failure
	  
    DECLARE @AdminRoleID int
    select @AdminRoleID=RoleID from [spb_Roles] with (nolock) where LoweredRoleName=lower('SystemAdministrator')
    if(@@error<>0) goto failure
    
    Insert spb_UsersInRoles (UserId, RoleId) values (@UserID,@AdminRoleID)
    if(@@error<>0) goto failure
    
	Insert spb_VoteSections (PresentAreaID, OwnerID) values (11,@UserID)
    if(@@error<>0) goto failure
	
	Insert spb_OwnerApplicationInPresentAreas(OwnerID,ApplicationID,PresentAreaID) Select @UserID,ApplicationID,11 From spb_ApplicationInAvailablePresentAreas Where PresentAreaID = 11 and IsBuiltIn = 0
    if(@@error<>0) goto failure
    
    Insert spb_PhotoUserCategories(UserID,CategoryName) values (@UserID,'默认相册')
    if(@@error<>0) goto failure
    
    commit transaction
    return
    
    failure:
    rollback transaction
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新用户通知项目设置 **/

CREATE PROCEDURE [dbo].[spb_NoticeItemSettingsInUser_Update] 
(
  @UserID int,
  @ItemID	int,
  @NoticeWayCode Nvarchar(16),
  @strItemID Nvarchar(1024)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
declare @strSql nvarchar(1024)
set @strSql='DELETE FROM spb_UserNoticeItemSettings WHERE NoticeWayCode=@NoticeWayCode and UserID=@UserID and ItemID not in('+@strItemID+')'
exec sp_executesql  @strSql,N'@NoticeWayCode nvarchar(16),@UserID int',@NoticeWayCode=@NoticeWayCode,@UserID=@UserID

if not exists (select ItemID,UserID from spb_UserNoticeItemSettings with (nolock) where ItemID=@ItemID and UserID=@UserID and NoticeWayCode=@NoticeWayCode)
--如果要更新的项目不存在则创建
  INSERT INTO spb_UserNoticeItemSettings
             (ItemID, NoticeWayCode, UserID)
  VALUES     (@ItemID,@NoticeWayCode,@UserID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取通知项目默认设置 **/

CREATE PROCEDURE [dbo].[spb_NoticeItemSettingssInUser_Get]
(
  @UserID int,
  @NoticeWayCode nvarchar(16)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
DECLARE @UserType INT
SELECT @UserType=UserType FROM spb_Users with (nolock) WHERE (UserID=@UserID)
if(@UserType=1)
begin
	SELECT     N.*, U.UserID, U.NoticeWayCode
	FROM         spb_UserNoticeItemSettings AS U with (nolock) INNER JOIN
						  spb_NoticeItems AS N with (nolock) ON U.ItemID = N.ItemID,
						  spb_Applications AS A with (nolock)
	WHERE     (U.UserID = @UserID) 
	and (U.NoticeWayCode = @NoticeWayCode) 
	and	(N.ApplicationID=A.ApplicationID) 
	and (A.IsEnabled=1) 
	and (N.AllowPersonUser=1) 
end
else if(@UserType=2)
begin 
	SELECT     N.*, U.UserID, U.NoticeWayCode
	FROM         spb_UserNoticeItemSettings AS U with (nolock) INNER JOIN
						  spb_NoticeItems AS N with (nolock) ON U.ItemID = N.ItemID,
						  spb_Applications AS A with (nolock)
	WHERE     (U.UserID = @UserID)
	and (U.NoticeWayCode = @NoticeWayCode)  
	and       (N.AllowCompanyUser=1)
	and		(N.ApplicationID=A.ApplicationID) 
	and		(A.IsEnabled=1)
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户并重设内容时调用 */

CREATE PROCEDURE [dbo].[spb_Forum_DeleteUserAndReassignContent]
( 
    @UserID int,
	@ReassignUserName		nvarchar(64)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE	@ReassignUserID	int
SELECT	@ReassignUserID = UserID from spb_Users with (nolock) where UserType=1 and UserName=@ReassignUserName

-- does the reassign user exist?
IF (@ReassignUserID IS NULL)
BEGIN
	SELECT 2 -- InvalidReassignUserName
	RETURN
END

IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END


BEGIN TRANSACTION
  
  update spb_ForumTags set UserID=@ReassignUserID where UserID=@UserID
  if(@@error<>0) goto Failure
  delete spb_ForumRatings where UserID=@UserID
  if(@@error<>0) goto Failure
  delete spb_ForumModerators where UserID=@UserID
  if(@@error<>0) goto Failure
  update spb_ForumPostAttachments set UserID=@ReassignUserID where UserID=@UserID
  if(@@error<>0) goto Failure
  update spb_ForumPosts set UserID=@ReassignUserID where UserID=@UserID
  if(@@error<>0) goto Failure
  update spb_ForumThreads set UserID=@ReassignUserID where UserID=@UserID
  if(@@error<>0) goto Failure
COMMIT TRANSACTION
SELECT 1 -- Success
RETURN


Failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除主题及其回复 **/

CREATE procedure [dbo].[spb_ForumPost_Delete]
(
    @PostID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
if not exists (select * from spb_ForumPosts with (nolock) where PostID = @PostID)
return
DECLARE @SectionID INT
DECLARE @ThreadID INT
DECLARE @UserID INT
DECLARE @ParentID INT
DECLARE @GroupID int

SELECT
	@SectionID = T.SectionID,
	@ThreadID = T.ThreadID,
	@UserID = P.UserID,	
	@ParentID = P.ParentID,
	@GroupID = T.GroupID
FROM
	spb_ForumPosts P (nolock) inner join spb_ForumThreads as T with (nolock) on P.ThreadID = T.ThreadID 
WHERE
	P.PostID = @PostID
if (@ParentID > 0)
Begin
	Update spb_ForumThreads
	Set ReplyCount = ReplyCount - 1
	Where ReplyCount > 0 and ThreadID = @ThreadID
	Declare @MostRecentPostAuthorID int
	Declare @MostRecentPostAuthor nvarchar(64)
	Declare @MostRecentPostID int
	set @MostRecentPostAuthorID = 0
	Set @MostRecentPostID = 0
	select top 1 @MostRecentPostAuthorID = UserID,@MostRecentPostAuthor = Author,@MostRecentPostID = PostID From spb_ForumPosts Where ThreadID = @ThreadID order by PostID 
	Update spb_ForumThreads
	Set MostRecentPostAuthorID = @MostRecentPostAuthorID,MostRecentPostAuthor = @MostRecentPostAuthor,MostRecentPostID = @MostRecentPostID
	Where ThreadID = @ThreadID
End

if (@ParentID=0)
    begin
    begin transaction

	  --附件在附件自己的业务逻辑处理
      --delete wl_ForumPostAttachments where PostID in (select PostID from wl_ForumPosts where ThreadID = @ThreadID)
      
      --论坛标签关联
      update spb_ForumTags set ItemCount=ItemCount-1 where TagName in(select TagName from spb_ItemsInForumTags with (nolock) where ItemID=@ThreadID) 
	  if(@@error<>0) goto failure
      delete spb_ItemsInForumTags where ItemID = @ThreadID
      if(@@error<>0) goto failure
      --主题评价
      delete spb_ForumRatings where ThreadID = @ThreadID
      if(@@error<>0) goto failure
      delete spb_ForumPosts where ThreadID = @ThreadID    
      if(@@error<>0) goto failure
      delete spb_ForumThreads where ThreadID = @ThreadID
      if(@@error<>0) goto failure
      
	update 	spb_ForumUserDatas
	Set ThreadCount = ThreadCount - 1
	Where UserID = @UserID and ThreadCount > 0
	
    commit transaction
    return
    failure:
    rollback transaction
    return
    end

else
    begin    
    begin tran

	  --附件在附件自己的业务逻辑处理
      --delete wl_ForumPostAttachments where PostID = @PostID

    delete spb_ForumPosts where PostID = @PostID
	
	IF (select PresentAreaID From spb_ForumSectionGroups where GroupID = @GroupID) = 11
		update 	spb_ForumUserDatas
		Set ThreadCount = ThreadCount - 1
		Where UserID = @UserID and PostCount > 0
	
    commit tran
	return
    failurea:
    rollback transaction
    return
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 重置PhotoSection统计信息 **/

create procedure [dbo].[spb_PhotoSection_ResetStatistics]
(
	@OwnerUserID int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
DECLARE @MostRecentThreadID int
DECLARE @MostRecentPostDate datetime
DECLARE @MostRecentThreadSubject nvarchar(256)
DECLARE @MostRecentThreadSummary nvarchar(2000)

IF @OwnerUserID > 0
    BEGIN
		DECLARE @MostRecentThreadSummaryForBody nvarchar(2000)
	    SELECT TOP 1
		    @MostRecentThreadID=ThreadID,
		    @MostRecentPostDate=PostDate,
            @MostRecentThreadSubject=Subject,
            @MostRecentThreadSummary=Body,
            @MostRecentThreadSummaryForBody=Substring(Body,0,500)
	    FROM 
		    dbo.spb_Photos with (nolock)
	    WHERE 
		    OwnerUserID = @OwnerUserID
	    ORDER BY
		    ThreadID DESC
		
		if @MostRecentThreadSummary=''
		set @MostRecentThreadSummary = @MostRecentThreadSummaryForBody
       
	    -- If the thread is null, reset the forum statistics.
	    IF @MostRecentThreadID IS NULL
		    UPDATE
			    dbo.spb_PhotoSections
		    SET
			    PhotoCount = 0,
			    CommentCount = 0,
			    MostRecentThreadID = null,
			    MostRecentThreadSubject = null,
			    MostRecentPostDate = null,
			    MostRecentThreadSummary = null
		    WHERE
			    OwnerUserID = @OwnerUserID
	    ELSE
          begin
              DECLARE @ThreadCount int
              DECLARE @CommentCount int
              select @ThreadCount=COUNT(ThreadID) FROM dbo.spb_Photos with (nolock) WHERE OwnerUserID = @OwnerUserID
              select @CommentCount=COUNT(PostID) FROM dbo.spb_PhotoComments with (nolock) WHERE OwnerUserID = @OwnerUserID

              UPDATE 
	              dbo.spb_PhotoSections
              SET
				PhotoCount = isnull(@ThreadCount,0),
			    CommentCount = isnull(@CommentCount,0),
			    MostRecentThreadID = isnull(@MostRecentThreadID,0),
			    MostRecentThreadSubject = @MostRecentThreadSubject,
			    MostRecentPostDate = @MostRecentPostDate,
			    MostRecentThreadSummary = @MostRecentThreadSummary
              WHERE
	              OwnerUserID = @OwnerUserID
          end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、图片统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Photo_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--1.更新spb_Applications表
DECLARE @TotalCount INT
DECLARE @CountInPast24Hours INT
DECLARE @NewestID INT

DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate() - 1,120)

SELECT @TotalCount=COUNT(*) FROM spb_Photos with (nolock)
SELECT @CountInPast24Hours=COUNT(*) FROM spb_Photos with (nolock) WHERE PostDate > @currentDate
SELECT @NewestID=isnull(MAX(ThreadID),0) FROM spb_Photos with (nolock)

UPDATE    spb_Applications
SET       TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
WHERE     (ApplicationID = 112)

--2.更新spb_SiteCategories表
declare @CategoryID int
DECLARE Categories_Cursor CURSOR FOR
SELECT CategoryID FROM spb_SiteCategories with (nolock) WHERE (ApplicationID = 112)
	
OPEN Categories_Cursor
FETCH NEXT FROM Categories_Cursor INTO @CategoryID
	
WHILE @@FETCH_STATUS = 0
    BEGIN	
    update spb_SiteCategories  
    set    ItemCount = (select count(*) from spb_Photos with (nolock) where SiteCategoryID = @CategoryID and AuditingStatus=40 )
    where  CategoryID = @CategoryID

	FETCH NEXT FROM Categories_Cursor INTO @CategoryID
		
	END
	
CLOSE Categories_Cursor
DEALLOCATE Categories_Cursor


--3.更新图片积分
declare @ThreadCountForPhotoPointRate float
declare @CommentCountForPhotoPointRate float
declare @HitTimesForPhotoPointRate float

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=4001)  
  select @ThreadCountForPhotoPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=4001
else
  set @ThreadCountForPhotoPointRate=4

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=4002)  
  select @CommentCountForPhotoPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=4002
else
  set @CommentCountForPhotoPointRate=1

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=4004)  
  select @HitTimesForPhotoPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=4004
else
  set @HitTimesForPhotoPointRate=0.1


update spb_PhotoSections set Points = PhotoCount*@ThreadCountForPhotoPointRate + CommentCount*@CommentCountForPhotoPointRate + HitTimes*@HitTimesForPhotoPointRate 
where IsActive = 1
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取好友的PhotoSection */

CREATE PROCEDURE [dbo].[spb_PhotoSections_GetSectionIDOfFriends]
(	
  @UserID int = 0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select OwnerUserID from spb_PhotoSections with (nolock) where OwnerUserID 
  in (select FriendUserID from spb_Friends with (nolock) where userID= @UserID) and MostRecentThreadID >0 order by MostRecentThreadID desc
  

SET NOCOUNT OFF


/****** 对象:  StoredProcedure [dbo].[spb_Photo_Get]    脚本日期: 09/27/2009 18:35:55 ******/
SET ANSI_NULLS ON
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 相册计数 **/
CREATE PROCEDURE [dbo].[spb_PhotoSectionView_Add]
(
	@ItemID int,
	@WebViewCount int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_PhotoSections set HitTimes = HitTimes+@WebViewCount,StageHitTimes = StageHitTimes+@WebViewCount where OwnerUserID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取PhotoSection */

CREATE PROCEDURE [dbo].[spb_PhotoSection_Get]
(	
    @OwnerUserID int = 0,
	@ApplicationKey	nvarchar(256) = null
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
    
 select * from spb_PhotoSections with (nolock) where OwnerUserID = @OwnerUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、相册应用每月执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Photo_PerStage]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
    --重置周浏览量
    update spb_PhotoSections set StageHitTimes=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新PhotoComment 用于回复 **/

CREATE PROCEDURE [dbo].[spb_PhotoComment_CreateUpdate] 
(
    @Action int,
	@UpdateSectionStatistics bit = 1,

	@PostID int out,
	@ParentID int = null,
    @ThreadID int,
    @OwnerUserID int =0,
    @AuditingStatus int,
 	@UserID int = 0,
    @Author nvarchar(256) = '',
	@Body ntext,
	@IsApproved bit = 1,
	@PropertyNames ntext = null,
	@PropertyValues ntext = null,
	@UserHostAddress	nvarchar(64) = null
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加

	begin
	
--	    declare @ThreadID int
	    
--	    select @ThreadID = ThreadID,@OwnerUserID = OwnerUserID from spb_PhotoComments where PostID = @ParentID

		INSERT spb_PhotoComments (ParentID,ThreadID,OwnerUserID,UserID,Author,Body,IsApproved,AuditingStatus,UserHostAddress,PropertyNames,PropertyValues)
				values (@ParentID,@ThreadID,@OwnerUserID,@UserID,@Author,@Body,@IsApproved,@AuditingStatus,@UserHostAddress,@PropertyNames,@PropertyValues)

		-- Grab the new PostID and update the ThreadID's info
		SELECT @PostID = SCOPE_IDENTITY() 


        update spb_Photos set CommentCount = CommentCount+1,LastRepliedDate=GetDate() where ThreadID = @ThreadID
       
		-- Update the GallerySection statitics
		IF @UpdateSectionStatistics = 1 AND @OwnerUserID > 0
            update spb_PhotoSections set CommentCount=CommentCount + 1,MostRecentPostDate= GetDate() where OwnerUserID = @OwnerUserID

	end

  else if @Action=1 --更新

	 update spb_PhotoComments set 
	        Body=@Body,AuditingStatus=@AuditingStatus,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
	 where PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* PhotoSection的添加、修改、删除 */

CREATE PROCEDURE [dbo].[spb_PhotoSection_CreateUpdateDelete] 
(
    @Action int,
	@OwnerUserID	int,
	@SectionName nvarchar(512) = '',	
	@Description	nvarchar(2000) = '',	
	@IsActive 	bit = 0,
	@EnableSearch   bit = 1,	
	@PropertyNames ntext = null,
	@PropertyValues ntext = null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON


if @Action = 2 --删除

delete spb_PhotoSections where  OwnerUserID=@OwnerUserID

else if  @Action = 1 --修改

    update spb_PhotoSections set 
        SectionName=@SectionName,Description=@Description,IsActive=@IsActive,EnableSearch=@EnableSearch,
        PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
    where OwnerUserID=@OwnerUserID

else if @Action = 0 --添加
begin
if(not exists(select OwnerUserID from spb_PhotoSections where OwnerUserID = @OwnerUserID))
    insert into spb_PhotoSections (OwnerUserID,SectionName,Description,IsActive,EnableSearch,PropertyNames,PropertyValues)
        values (@OwnerUserID,@SectionName,@Description,@IsActive,@EnableSearch,@PropertyNames,@PropertyValues)
        
        
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除PhotoComment */

CREATE PROCEDURE [dbo].[spb_PhotoComment_Delete] 
(
    @PostID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
DECLARE @OwnerUserID INT
DECLARE @ThreadID INT


SELECT
    @OwnerUserID = P.OwnerUserID,
	@ThreadID = P.ThreadID
FROM
	spb_PhotoComments P with (nolock)
WHERE
	PostID = @PostID


  begin
   if not exists(select * from spb_PhotoComments with (nolock) where PostID = @PostID)
   return
    delete spb_PhotoComments where PostID = @PostID

    update spb_Photos set CommentCount = CommentCount - 1 where ThreadID = @ThreadID
    
    update spb_PhotoSections set CommentCount = CommentCount - 1 where OwnerUserID = @OwnerUserID    
    
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取某人的未读通知数 **/
CREATE PROCEDURE [dbo].[spb_NoticeRecord_GetNoReadCount]
(
	@UserID int,
	@NoReadCount int output
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select @NoReadCount=count(*) from spb_NoticeRecords with (nolock) where UserID = @UserID and IsReaded = 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建spb_Notices **/
create PROCEDURE [dbo].[spb_NoticeRecord_Create]
(
	@RecordID int output,
	@ApplicationID int=0,
	@NoticeItemID int=0,
	@UserID int = 0,
	@LeadingActorUserID int = 0,
	@LeadingActor nvarchar(256)='',
	@RelativeItemID int=0,
	@RelativeItemName nvarchar(256)='',
	@Subject nvarchar(512)='',
	@Body ntext = '',
	@IsReaded bit = 0,
	@PropertyNames ntext=null,
	@PropertyValues ntext=null
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

insert into spb_NoticeRecords(ApplicationID,NoticeItemID,UserID,LeadingActorUserID,LeadingActor,RelativeItemID,RelativeItemName,Subject,Body,IsReaded,PropertyNames,PropertyValues)
	values(@ApplicationID,@NoticeItemID,@UserID,@LeadingActorUserID,@LeadingActor,@RelativeItemID,@RelativeItemName,@Subject,@Body,@IsReaded,@PropertyNames,@PropertyValues)
set @RecordID = SCOPE_IDENTITY()
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 定期删除已读的NoticeRecords */

CREATE PROCEDURE [dbo].[spb_NoticeRecords_Delete] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
DELETE FROM spb_NoticeRecords
WHERE     (IsReaded = 1)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 通知设为已读 **/
create PROCEDURE [dbo].[spb_NoticeRecord_BatchSetIsRead]
(
	@UserID int,
	@RecordID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

update spb_NoticeRecords set IsReaded = 1 where RecordID = @RecordID and @UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_PresentArea_Update]
(
	@PresentAreaID int,
	@Name nvarchar(64) = '',
	@Description nvarchar(512) = '',	
	@CanAssignOwner	bit = 0,
	@EnableThemes	bit = 0,
	@DefaultTheme nvarchar(64) = '',	
	@DefaultAppearance nvarchar(64) = '',
	@ThemeLocation nvarchar(512) = '',
	@WidgetLocation nvarchar(512) = '',
	@PropertyNames	ntext = null,	
	@PropertyValues	ntext = null
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Update spb_PresentAreas
Set Name = @Name,Description = @Description,EnableThemes = @EnableThemes,DefaultTheme = @DefaultTheme,
DefaultAppearance = @DefaultAppearance,ThemeLocation = @ThemeLocation,WidgetLocation = @WidgetLocation
where PresentAreaID = @PresentAreaID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
CREATE Procedure [dbo].[spb_PresentAreas_GetID]

as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Select PresentAreaID From spb_PresentAreas
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
Create Procedure [dbo].[spb_PresentArea_Get]
(
	@PresentAreaID int = 0
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Select * From spb_PresentAreas with (nolock) Where PresentAreaID = @PresentAreaID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE Procedure [dbo].[spb_AreaNameRes_Get]
(
    @AreaCode varchar(8)=''
)
as
select * from spb_Areas_Res where AreaCode = @AreaCode
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE Procedure [dbo].[spb_AreaNameRes_Update]
(
    @AreaCode varchar(8)='',
    @LanguageCode varchar(20)='',
    @Name nvarchar(128)=''
)
as
if exists(select * from spb_Areas_Res where AreaCode=@AreaCode and LanguageCode=@LanguageCode)
Update spb_Areas_Res Set Name=@Name Where AreaCode=@AreaCode and LanguageCode=@LanguageCode
else
Insert into spb_Areas_Res(AreaCode,LanguageCode,Name) values(@AreaCode,@LanguageCode,@Name)
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE Procedure [dbo].[Spb_RecommendationTypeRes_Update]
(
    @TypeID int=0,
    @LanguageCode varchar(20)='',
    @Name nvarchar(128)=''
)
as
if exists (select * from spb_RecommendedItemTypes_Res where TypeID=@TypeID and LanguageCode=@LanguageCode)
    update spb_RecommendedItemTypes_Res
    set Name=@Name
    where TypeID=@TypeID and LanguageCode=@LanguageCode
else
    Insert into spb_RecommendedItemTypes_Res(TypeID,LanguageCode,Name) Values (@TypeID,@LanguageCode,@Name)
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE Procedure [dbo].[spb_RecommendationTypeRes_Get]
(
    @TypeID int=0
)
as
select * from spb_RecommendedItemTypes_Res where TypeID=@TypeID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取信息推荐 */

CREATE PROCEDURE [dbo].[spb_RecommendedItem_Get]
( 
    @CommendID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select i.*,t.ApplicationID from spb_RecommendedItems as i  with (nolock) inner join spb_RecommendedItemTypes as t with (nolock) 
on i.CommendTypeID=t.TypeID where CommendID=@CommendID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*创建、更新、删除 信息的推荐类别*/

CREATE PROCEDURE [dbo].[spb_RecommendedItemType_CreateUpdateDelete]
(
    @Action int,
    @TypeID	int,
    @ApplicationID int,
    @Name nvarchar(256)='',
    @Description nvarchar(2048)=''
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

    if @Action = 0 --添加    
      begin
        if not exists (select TypeID from spb_RecommendedItemTypes with (nolock) where TypeID=@TypeID)
          insert into spb_RecommendedItemTypes(TypeID,ApplicationID,Name,Description)
            values (@TypeID,@ApplicationID,@Name,@Description)
      end      
    else if @Action = 1 --更新 
        update spb_RecommendedItemTypes set
            Name = @Name,
			ApplicationID=@ApplicationID,
            Description = @Description
         where TypeID=@TypeID
    else
      begin
        delete spb_RecommendedItems where CommendTypeID = @TypeID
        delete spb_RecommendedItemTypes where TypeID = @TypeID        
      end
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_Share_DeleteUserAndReassignContent]
(
    @UserID int,
	@ReassignUserName nvarchar(64)
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
    DECLARE	@ReassignUserID	int
    DECLARE @Author nvarchar(64)
    SELECT	@ReassignUserID = UserID,@Author=CommonName from spb_Users with (nolock) where UserType=1 and UserName=@ReassignUserName

    -- does the reassign user exist?
    IF (@ReassignUserID IS NULL)
    BEGIN
	    SELECT 2 -- InvalidReassignUserName
	    RETURN
    END

    IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
    BEGIN
	    SELECT 3 -- 待删除的用户不存在
	    RETURN
    END
    BEGIN TRANSACTION
	
	--转移站点分享
	update spb_ShareThreads set UserID=@ReassignUserID,Author=@Author where UserID=@UserID
    if(@@error<>0) goto failure
    --转移用户分享
    update spb_UserShareThreads set UserID=@ReassignUserID,Author=@Author where UserID=@UserID
    if(@@error<>0) goto failure
    --管理员推荐
    delete spb_RecommendedItems  where CommendTypeID in(select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=261) and AuthorUserID=@UserID
    if(@@error<>0) goto failure
     --删除分享评论
    delete spb_ShareComments where UserID=@UserID
    if(@@error<>0) goto failure

    COMMIT TRANSACTION
    SELECT 1 -- Success
    RETURN
    Failure:
	    ROLLBACK TRANSACTION
	    SELECT 10 -- UnknownFailure
	    RETURN
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户并重设内容时调用 */

CREATE PROCEDURE [dbo].[spb_Club_DeleteUserAndReassignContent]
( 
    @UserID int,
	@ReassignUserName		nvarchar(64)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE	@ReassignUserID	int
SELECT	@ReassignUserID = UserID from spb_Users with (nolock) where UserType=1 and UserName=@ReassignUserName

-- does the reassign user exist?
IF (@ReassignUserID IS NULL)
BEGIN
	SELECT 2 -- InvalidReassignUserName
	RETURN
END

IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END


BEGIN TRANSACTION
  
  delete FROM spb_ClubActivities where [LeadingActorUserID]=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  delete from spb_ClubMembers where UserID=@UserID and ClubID not in (select ClubID from spb_Clubs with (nolock) where ClubOwnerUserID=@UserID)
  IF (@@ERROR <> 0) GOTO Failure
  update spb_ClubMembers set ClubMemberRole=3 where UserID = @ReassignUserID and ClubID in (select ClubID from spb_Clubs with (nolock) where ClubOwnerUserID=@UserID)
  IF (@@ERROR <> 0) GOTO Failure
  delete from spb_ClubMembers where UserID=@UserID and ClubID in 
    (select ClubID from spb_ClubMembers with (nolock) where UserID=@ReassignUserID and ClubID in (select ClubID from spb_Clubs with (nolock) where ClubOwnerUserID=@UserID))
  IF (@@ERROR <> 0) GOTO Failure
  update spb_ClubMembers set UserID=@ReassignUserID where UserID=@UserID and ClubID in (select ClubID from spb_Clubs with (nolock) where ClubOwnerUserID=@UserID)
  IF (@@ERROR <> 0) GOTO Failure
  delete spb_ClubGuestbookPosts where UserID = @UserID
  IF (@@ERROR <> 0) GOTO Failure
  delete from spb_RecommendedItems where ItemID in (select ClubID from spb_Clubs with (nolock) where ClubOwnerUserID=@UserID)
    and CommendTypeID in (select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=231)
  IF (@@ERROR <> 0) GOTO Failure
  update spb_Clubs set ClubOwnerUserID = @ReassignUserID where ClubOwnerUserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
    delete from spb_ClubUserDatas where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure

COMMIT TRANSACTION
SELECT 1 -- Success
RETURN

Failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*获取所有信息推荐类别*/

CREATE PROCEDURE [dbo].[spb_RecommendedItemTypes_Get]

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_RecommendedItemTypes with (nolock)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 检测信息推荐类别ID是否存在 */

CREATE PROCEDURE [dbo].[spb_RecommendedItemType_IsTypeExist]
( 
    @TypeID int,
    @IsTypeExist bit output
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if exists (select TypeID from spb_RecommendedItemTypes with (nolock) where TypeID=@TypeID)
	set @IsTypeExist = 1
else
	set @IsTypeExist = 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户并重设内容时调用 */

CREATE PROCEDURE [dbo].[spb_News_DeleteUserAndReassignContent]
( 
    @UserID int,
	@ReassignUserName		nvarchar(64)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE	@ReassignUserID	int
SELECT	@ReassignUserID = UserID from spb_Users with (nolock) where UserType=1 and UserName=@ReassignUserName

-- does the reassign user exist?
IF (@ReassignUserID IS NULL)
BEGIN
	SELECT 2 -- InvalidReassignUserName
	RETURN
END

IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END


BEGIN TRANSACTION
  
  update spb_NewsTags set UserID=@ReassignUserID where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  delete spb_NewsReaders where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  delete spb_NewsRatings where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure

  update spb_NewsAttachments set UserID=@ReassignUserID where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  delete spb_NewsComments where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  delete from spb_RecommendedItems where ItemID in (select ThreadID from spb_NewsThreads with (nolock) where UserID=@UserID)
    and CommendTypeID in (select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=201)
  IF (@@ERROR <> 0) GOTO Failure

  update spb_NewsThreads set UserID=@ReassignUserID where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
COMMIT TRANSACTION
SELECT 1 -- Success
RETURN
Failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除NewsThread **/
CREATE PROCEDURE [dbo].[spb_NewsThread_CreateUpdateDelete]
(
	@Action int,
	@ThreadID int output,
	@SectionID int=0,
	@UserID int=0,
	@Contributor nvarchar(64)='',
	@Title nvarchar(256)='',
	@Subtitle nvarchar(256)='',
	@PrefixID int=0,
	@Body ntext=null,
	@AuditingStatus int=40,
	@IsLocked bit=0,
	@IsEssential bit=0,
	@IsContributed bit=0,
	@StickyDate datetime='',
	@SpecialOrder int=0,
	@RatingSum int=0,
	@TotalRatings int=0,
	@UserHostAddress nvarchar(64)='',
	@PointConsumption int=0,
	@PropertyNames ntext=null,
	@PropertyValues ntext=null
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

if @Action = 2 --删除
    begin
		--更新站点标签
	    if not exists (select * from spb_NewsThreads WITH (NOLOCK) where ThreadID=@ThreadID)
	    return
        update spb_NewsTags set ItemCount=ItemCount-1 where TagName in(select TagName from spb_ItemsInNewsTags with (nolock) where ItemID=@ThreadID) 

		select @PrefixID=PrefixID,@SectionID=SectionID from spb_NewsThreads WITH (NOLOCK) where ThreadID=@ThreadID

		delete spb_ItemsInNewsTags where ItemID=@ThreadID
		delete spb_NewsReaders where ThreadID=@ThreadID
		delete spb_NewsRatings where ThreadID=@ThreadID
		delete spb_NewsComments where ThreadID=@ThreadID
		delete spb_NewsAttachments where ThreadID=@ThreadID

		declare @CommentCount int
		select @CommentCount=CommentCount,@UserID=UserID from spb_NewsThreads WITH (NOLOCK) where ThreadID=@ThreadID
		delete spb_RecommendedItems where CommendTypeID in (select TypeID from spb_RecommendedItemTypes with (nolock) where ApplicationID=201) and ItemID=@ThreadID
		delete spb_NewsThreads where ThreadID=@ThreadID

		declare @MostRecentPostDate datetime
		declare @MostRecentThreadID int
		declare @MostRecentThreadTitle nvarchar(256)
		select top 1 @MostRecentPostDate=PostDate,@MostRecentThreadID=ThreadID,@MostRecentThreadTitle=Title 
			from spb_NewsThreads WITH (NOLOCK) order by PostDate desc
		
        update spb_NewsSections set ThreadCount=ThreadCount-1,CommentCount=CommentCount-@CommentCount,MostRecentPostDate=@MostRecentPostDate,
			MostRecentThreadID=@MostRecentThreadID,MostRecentThreadTitle=@MostRecentThreadTitle where SectionID=@SectionID
		
		if exists( select UserID from spb_NewsUserDatas with (nolock) where UserID=@UserID) 
		  begin
			update spb_NewsUserDatas 
			set TotalThreadCount = TotalThreadCount - 1
			where UserID=@UserID and TotalThreadCount > 0
		  end
		  else
            begin
              insert into spb_NewsUserDatas(UserID) values (@UserID)
            end
	    return
    end

else if @Action =1 --更新
    begin
		update spb_NewsThreads set SectionID=@SectionID,Title=@Title,Subtitle=@Subtitle,PrefixID=@PrefixID,AuditingStatus=@AuditingStatus,IsLocked=@IsLocked,
			IsEssential=@IsEssential,IsContributed=@IsContributed,StickyDate=@StickyDate,SpecialOrder=@SpecialOrder,RatingSum=@RatingSum,TotalRatings=@TotalRatings,
			PointConsumption=@PointConsumption,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues where ThreadID=@ThreadID
		
		if(@Body is not null)
		begin
		    update spb_NewsThreads set Body = @Body where ThreadID=@ThreadID
		end
		
		select @SectionID=SectionID from spb_NewsThreads WITH (NOLOCK) where ThreadID=@ThreadID
		update spb_NewsSections set MostRecentThreadTitle=@Title where SectionID=@SectionID
    end
else
    begin
        insert into spb_NewsThreads(SectionID,UserID,Contributor,Title,Subtitle,PrefixID,Body,AuditingStatus,IsLocked,IsEssential,IsContributed,StickyDate,SpecialOrder,RatingSum,TotalRatings,UserHostAddress,PointConsumption,PropertyNames,PropertyValues)
			values(@SectionID,@UserID,@Contributor,@Title,@Subtitle,@PrefixID,@Body,@AuditingStatus,@IsLocked,@IsEssential,@IsContributed,@StickyDate,@SpecialOrder,@RatingSum,@TotalRatings,@UserHostAddress,@PointConsumption,@PropertyNames,@PropertyValues)
	    set @ThreadID = SCOPE_IDENTITY()
	
		select @MostRecentPostDate=PostDate,@MostRecentThreadID=ThreadID,@MostRecentThreadTitle=Title 
			from spb_NewsThreads WITH (NOLOCK) where ThreadID=@ThreadID

		update spb_NewsSections set ThreadCount=ThreadCount+1,MostRecentPostDate=@MostRecentPostDate,
			MostRecentThreadID=@MostRecentThreadID,MostRecentThreadTitle=@MostRecentThreadTitle where SectionID=@SectionID
		
        if exists(select * from spb_NewsUserDatas with (nolock) where UserID = @UserID)
            begin
               update spb_NewsUserDatas 
               set TotalThreadCount = TotalThreadCount + 1
               where UserID=@UserID
            end
        else
            begin
              insert into spb_NewsUserDatas(UserID,TotalThreadCount) values (@UserID,1)
            end
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 群组 */

CREATE PROCEDURE [dbo].[spb_Club_CreateUpdateDelete] 
(
    @ClubID    int output,
    @ClubName    nvarchar(256) = '',
    @DomainName nvarchar(256)='',
    @Brief    nvarchar(2000) = '',
    @CategoryID    int = 0,
    @AreaCode    nvarchar(8) = '',
    @IsPublic bit =1,
    @IsMemberNeedAuthorize bit = 0,
    @News ntext = null,
    @AuditingStatus int =0,
    @Points int = 0,
    @MemberCount int = 0,
    @RegisterCountByClub int = 0,
    @DisplayOrder int = 0,
    @ClubOwnerUserID int = 0,
    @HasLogo bit =0,
    @Theme nvarchar(128) ='',
    @ThemeAppearance nvarchar(128)='',
    @PropertyNames  ntext = null,
    @PropertyValues ntext = null,
    @Action int,
    @UserHostAddress nvarchar(64)='000.000.000.000',
    @IsEnabled bit = 1
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    begin
    if not exists ( select * from spb_Clubs with (nolock) where ClubID=@ClubID)
    return
    --删除群组成员
    delete spb_ClubMembers where ClubID=@ClubID
    
    --删除群组留言

    
    select @ClubOwnerUserID = ClubOwnerUserID from spb_Clubs with (nolock) where ClubID=@ClubID
    
    --删除群组友情链接
    delete spb_ClubLinkCategories where ClubID=@ClubID
    delete spb_ClubLinks where ClubID=@ClubID


    --删除群组
    delete spb_Clubs where ClubID=@ClubID
    
    --删除管理员推荐
    delete spb_RecommendedItems where CommendTypeID in (select TypeID from spb_ReCommendedItemTypes with (nolock) where ApplicationID=231) and ItemID=@ClubID 
    
    --更新ClubUserDatas
    update spb_ClubUserDatas set CreatedClubCount=CreatedClubCount-1 where UserID = @ClubOwnerUserID and CreatedClubCount > 0
    end
ELSE 
    BEGIN
        if (@Action = 0) --添加
            BEGIN
                
              if not exists (select ClubID from spb_Clubs with (nolock) where DomainName = @DomainName and len(DomainName)>0)
                begin            
                  INSERT INTO spb_Clubs (ClubName,DomainName,Brief,CategoryID,AreaCode,IsPublic,IsMemberNeedAuthorize,News,AuditingStatus,IsEnabled,Points,MemberCount,RegisterCountByClub,DisplayOrder,ClubOwnerUserID,HasLogo,Theme,ThemeAppearance,PropertyNames,PropertyValues,UserHostAddress) 
                    VALUES (@ClubName,@DomainName,@Brief,@CategoryID,@AreaCode,@IsPublic,@IsMemberNeedAuthorize,@News,@AuditingStatus,@IsEnabled,@Points,@MemberCount,@RegisterCountByClub,@DisplayOrder,@ClubOwnerUserID,@HasLogo,@Theme,@ThemeAppearance,@PropertyNames,@PropertyValues,@UserHostAddress)
                  select @ClubID = SCOPE_IDENTITY()

                if exists (select * from spb_ClubUserDatas with (nolock) where UserID=@ClubOwnerUserID)
				    update spb_ClubUserDatas set CreatedClubCount=CreatedClubCount+1 where UserID=@ClubOwnerUserID
			    else
				    insert into spb_ClubUserDatas (UserID,CreatedClubCount) values (@ClubOwnerUserID,1)
                end
              else
                    begin
                        select @ClubID = -1
                    end
            END
      ELSE --更新
        BEGIN
        declare @oldCategoryID int
        select @oldCategoryID=CategoryID from spb_Clubs with (nolock) where ClubID = @ClubID 
        if @oldCategoryID <> @CategoryID
        begin
          update spb_SiteCategories set ItemCount =ItemCount-1 where CategoryID=@oldCategoryID
          update spb_SiteCategories set ItemCount =ItemCount+1 where CategoryID=@CategoryID
        end
        UPDATE spb_Clubs SET      
                ClubName      = @ClubName,
                DomainName    = @DomainName,
                Brief         = @Brief,
                CategoryID    = @CategoryID,
                AreaCode        = @AreaCode,
                IsPublic      = @IsPublic,
                IsMemberNeedAuthorize       = @IsMemberNeedAuthorize,
                --News       = @News,
                AuditingStatus= @AuditingStatus,
                IsEnabled = @IsEnabled,
                Points  = @Points,
                MemberCount=@MemberCount,
                RegisterCountByClub=@RegisterCountByClub,
                DisplayOrder=@DisplayOrder,
                ClubOwnerUserID=@ClubOwnerUserID,
                HasLogo=@HasLogo,
                Theme=@Theme,
                ThemeAppearance=@ThemeAppearance,
                UserHostAddress=@UserHostAddress,
                PropertyNames  = @PropertyNames,
                PropertyValues = @PropertyValues
        WHERE
          ClubID = @ClubID 
          
        if @News is not null
        begin
		   UPDATE spb_Clubs SET News = @News WHERE ClubID = @ClubID 
        end
        
        END
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_Language_CreateUpdate]
(
@Action int,
@LanguageCode varchar(20),
@NativeName nvarchar(100),
@IsEnabled bit
)
AS
BEGIN
	SET NOCOUNT ON;
	if(@action=0)
		begin
			INSERT INTO [spb_Languages]([LanguageCode],[NativeName],[IsEnabled]) VALUES(@LanguageCode,@NativeName,@IsEnabled)
		end
	else if(@action=1)
		begin
			UPDATE [spb_Languages] SET [NativeName]=@NativeName,[IsEnabled]=@IsEnabled
			WHERE [LanguageCode]=@LanguageCode 
		end
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_Language_Delete]
(
@LanguageCode varchar(20)
)
AS
BEGIN
	SET NOCOUNT ON;
	if not exists(select * from spb_Languages with (nolock) where LanguageCode = @LanguageCode)
	return
	
	delete spb_Languages where LanguageCode=@LanguageCode
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_Language_Get]
(
@LanguageCode varchar(20),
@Action int
)
AS
BEGIN
	SET NOCOUNT ON;
	if(@Action=0)
		select * from  spb_Languages with (nolock) where LanguageCode=@LanguageCode
    else
        select * from  spb_Languages with (nolock) 

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、删除大屏幕收藏夹中的微博 **/

CREATE PROCEDURE [dbo].[spb_MicroBlogFavoriteScreenItem_CreateDelete] 
(
    @Action int,
	@ScreenID int = 0,
	@SerialNumber int = 0,
	@ThreadID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
begin
	if not EXISTS (select 1 from spb_MicroBlogScreenFavorites where ThreadID = @ThreadID and ScreenID = @ScreenID)
		INSERT spb_MicroBlogScreenFavorites (ScreenID,SerialNumber,ThreadID)Values (@ScreenID,@SerialNumber,@ThreadID)
	else
		Update spb_MicroBlogScreenFavorites 
		Set SerialNumber = @SerialNumber
		where ScreenID = @ScreenID and ThreadID = @ThreadID
End
else if (@Action = 2)
    delete from spb_MicroBlogScreenFavorites where ScreenID = @ScreenID and ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取未处理的邀请数 */
CREATE PROCEDURE [dbo].[spb_Invitations_GetCountOfUnsettled] 
(
	@ReceiverUserID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
select R.ApplicationID, count(R.InvitationID) as unsettledCount from spb_Invitations R with (nolock) inner join spb_InvitationInbox I with (nolock) on R.InvitationID=I.InvitationID
  where R.ReceiverUserID=@ReceiverUserID and R.Status=0 group by R.ApplicationID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 添加邀请 **/

CREATE PROCEDURE [dbo].[spb_Invitation_Create] 
(
    @InvitationID int out,
	  @ApplicationID int,
    @SenderUserID	int,
    @Sender	nvarchar(64),
    @ReceiverUserID	int,
    @Receiver	nvarchar(64),
    @RelativeItemID	int,
    @RelativeItemName nvarchar(256),
	  @Subject nvarchar(256),
	  @Body ntext,
    @Status	int,
    @TransportMode	int,
    @PropertyNames	ntext = null,
    @PropertyValues	ntext = null
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

BEGIN

  if exists(select InvitationID from spb_Invitations with (nolock) where SenderUserID=@SenderUserID and ReceiverUserID=@ReceiverUserID and RelativeItemID=@RelativeItemID and TransportMode=0 and Status=0)
  begin
    select 6  --已经发送过邀请
    return
  end

  insert into spb_Invitations (ApplicationID,SenderUserID,Sender,ReceiverUserID,Receiver,RelativeItemID,RelativeItemName,Subject,Body,Status,TransportMode,PropertyNames,PropertyValues)
      values (@ApplicationID,@SenderUserID,@Sender,@ReceiverUserID,@Receiver,@RelativeItemID,@RelativeItemName,@Subject,@Body,@Status,@TransportMode,@PropertyNames,@PropertyValues)
      
	-- Get the new RequestID
	SELECT @InvitationID = SCOPE_IDENTITY()

  --处理发件箱 
  if(@SenderUserID>0)
	begin
	  insert into spb_InvitationOutbox (UserID,InvitationID,ApplicationID) values (@SenderUserID,@InvitationID,@ApplicationID)
	end
  --处理收件箱
  if(@ReceiverUserID>0)
	begin
	  insert into spb_InvitationInbox (UserID,InvitationID,ApplicationID) values (@ReceiverUserID,@InvitationID,@ApplicationID)
	end
  select 1  --成功发送邀请

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 从收件箱/发件箱删除邀请（发件箱、收件箱都已经删除的情况下彻底删除Invitation）  */
CREATE PROCEDURE [dbo].[spb_Invitation_DeleteFromInvitationBox] 
(
  @UserID	int,
  @InvitationID	int,
  @RequestBoxType int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@RequestBoxType=1)
  delete from spb_InvitationInbox where UserID=@UserID and InvitationID=@InvitationID
else
  delete from spb_InvitationOutbox where UserID=@UserID and InvitationID=@InvitationID

if (not exists (select InvitationID from spb_InvitationInbox with (nolock) where InvitationID=@InvitationID)) and
  (not exists (select InvitationID from spb_InvitationOutbox with (nolock) where InvitationID=@InvitationID))
begin
  delete from spb_Invitations where InvitationID=@InvitationID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取邀请  */
CREATE PROCEDURE [dbo].[spb_Invitation_Get] 
(
  @InvitationID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_Invitations with (nolock) where InvitationID=@InvitationID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新邀请的状态 **/

create PROCEDURE [dbo].[spb_Invitation_UpdateStatus] 
(
    @InvitationID int,
    @Status	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

  update spb_Invitations set Status=@Status where InvitationID=@InvitationID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 从发件箱删除邀请  */
create PROCEDURE [dbo].[spb_Invitation_DeleteFromOutBoxByRelativeItem] 
(
  @InvitationID	int,
  @RelativeItemID int,
  @ApplicationID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

  delete from spb_InvitationOutbox  where InvitationID=@InvitationID and ApplicationID=@ApplicationID and @RelativeItemID in (select RelativeItemID from spb_Invitations where InvitationID=@InvitationID)

if (not exists (select InvitationID from spb_InvitationInbox with (nolock) where InvitationID=@InvitationID)) and
  (not exists (select InvitationID from spb_InvitationOutbox with (nolock) where InvitationID=@InvitationID))
begin
  delete from spb_Invitations where InvitationID=@InvitationID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取积分项目规则集合 **/

CREATE PROCEDURE [dbo].[spb_UserPointItemRoles_Get]
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT    P.*,R.BasicPoints, R.ReportPoints, R.CreditPoints, R.TradePoints, R.BasicPointQuota,R.ReportPointQuota,R.CreditPointQuota,R.TradePointQuota
FROM      spb_UserPointItemRules AS R with (nolock) INNER JOIN
          spb_UserPointItems AS P with (nolock) ON R.ItemID = P.ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有用户积分项目 **/

CREATE PROCEDURE [dbo].[spb_UserPointItems_GetAll] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT * FROM spb_UserPointItems with (nolock) ORDER BY ApplicationID, DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取用户链接类别 */

CREATE PROCEDURE [dbo].[spb_UserLinkCategory_Get] 
(
    @CategoryID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_UserLinkCategories with (nolock) where CategoryID=@CategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 用户链接类别 */

CREATE PROCEDURE [dbo].[spb_UserLinkCategory_CreateUpdateDelete]
( 
    @Action int,
    @CategoryID	int output,
    @UserID	int = 0,
    @CategoryName nvarchar(256) = '',
    @Description	nvarchar(1024) = '',
    @DisplayOrder	int = 100
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
        delete from spb_UserLinkCategories where CategoryID = @CategoryID    --删除
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin
				--取用户的最大值
				--DECLARE @NewDisplayOrder int
				--select @NewDisplayOrder=max(DisplayOrder) from spb_UserLinkCategories where UserID=@UserID
				--if (@NewDisplayOrder is null) --新记录
					--begin
					--	set @NewDisplayOrder = 0
					--end
				--else 
				--	begin
				--		set @NewDisplayOrder = @NewDisplayOrder + 1
				--	end
				
                insert into spb_UserLinkCategories (UserID,CategoryName,Description,DisplayOrder) values (
                    @UserID,@CategoryName,@Description,@DisplayOrder)
            
                select @CategoryID = SCOPE_IDENTITY() 
            end       
         else --更新
            begin
                update spb_UserLinkCategories set 
                    CategoryName       = @CategoryName,
                    Description      = @Description,
                    DisplayOrder            = @DisplayOrder
                    where CategoryID = @CategoryID
            end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取用户链接类别 */

CREATE PROCEDURE [dbo].[spb_UserLinkCategories_GetByUserID] 
(
    @UserID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_UserLinkCategories with (nolock) where UserID=@UserID order by DisplayOrder asc
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
Create Procedure [dbo].[spb_CodeSets_Get]
as
select * from spb_CodeSets
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
Create Procedure [dbo].[spb_GetCode_Get]
(
	@CodeSetCode varchar(20)=''
)
as
select * from spb_CodeSets where Code=@CodeSetCode
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除NewsSection **/
CREATE PROCEDURE [dbo].[spb_NewsSection_CreateUpdateDelete]
(
	@Action int,
	@SectionID int output,
	@SectionName nvarchar(256)='',
	@ParentID int=0,
	@ParentIDList nvarchar(256)='',
	@Depth int=0,
	@Description nvarchar(2000)='',
	@NewsSectionType int=0,
	@DisplayOrder int=0,
	@IsActive bit = 1,
	@EnaleSearch bit = 1,
	
	@PageShowSection nvarchar(56)='',
	@PageList nvarchar(56)='',
	@PageDetail nvarchar(56)='',

	@PropertyNames ntext=null,
	@PropertyValues ntext=null
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

if @Action = 2 --删除
    begin

    begin transaction
		delete spb_ItemsInNewsTags where ItemID in (select ThreadID from spb_NewsThreads with (nolock) where SectionID=@SectionID)
		if (@@ERROR <> 0) goto failure
        delete spb_NewsReaders where ThreadID in (select ThreadID from spb_NewsThreads with (nolock) where SectionID=@SectionID)
		if (@@ERROR <> 0) goto failure
		delete spb_NewsRatings where ThreadID in (select ThreadID from spb_NewsThreads with (nolock) where SectionID=@SectionID)
        if (@@ERROR <> 0) goto failure
		delete spb_NewsThreads where SectionID=@SectionID
		if (@@ERROR <> 0) goto failure
		delete spb_NewsComments where SectionID=@SectionID
        if (@@ERROR <> 0) goto failure
		delete spb_NewsAttachments where SectionID=@SectionID
        if (@@ERROR <> 0) goto failure
        delete spb_NewsSections where SectionID=@SectionID
        if (@@ERROR <> 0) goto failure
     
      COMMIT TRANSACTION
	  return
      failure:
      ROLLBACK TRANSACTION
      return
    end

else if @Action =1 --更新
    begin
		update spb_NewsSections set SectionName=@SectionName,ParentID=@ParentID,ParentIDList=@ParentIDList,Depth=@Depth,
			Description=@Description,NewsSectionType=@NewsSectionType,DisplayOrder=@DisplayOrder,IsActive=@IsActive,EnaleSearch=@EnaleSearch,
			PageShowSection=@PageShowSection,PageList=@PageList,PageDetail=@PageDetail,PropertyNames=@PropertyNames,
			PropertyValues=@PropertyValues where SectionID=@SectionID
    end
else
    begin
        insert into spb_NewsSections(SectionName,ParentID,ParentIDList,Depth,Description,NewsSectionType,DisplayOrder,IsActive,EnaleSearch,PageShowSection,PageList,PageDetail,PropertyNames,PropertyValues)
			    values(@SectionName,@ParentID,@ParentIDList,@Depth,@Description,@NewsSectionType,@DisplayOrder,@IsActive,@EnaleSearch,@PageShowSection,@PageList,@PageDetail,@PropertyNames,@PropertyValues)
	      set @SectionID = SCOPE_IDENTITY()

		    if @ParentID>0
			    update spb_NewsSections set ChildCount=ChildCount+1 where SectionID=@ParentID
    end
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create PROCEDURE [dbo].[spb_Task_News_PerStage]
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
    --重置周浏览量
    update spb_NewsThreads set StageHitTimes=0 , StageCommentCount=0
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台资讯统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_NewsManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingCommentCount int out
)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
	
select @PendingThreadCount= count(ThreadID) from spb_NewsThreads with (nolock) where AuditingStatus=20
select @AgainThreadCount=count(ThreadID) from spb_NewsThreads with (nolock) where AuditingStatus=30
select @PendingCommentCount=count(CommentID) from spb_NewsComments  with (nolock) where AuditingStatus=20
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsComment_Create]
(
	@CommentID int output,
	@ParentID int=0,
	@ThreadID int,
	@SectionID int,
	@UserID int,
	@Author nvarchar(256)='',
	@Body ntext,
	@AuditingStatus int,
	@UserHostAddress nvarchar(64),
	@PropertyNames ntext=null,
	@PropertyValues ntext=null
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

insert into spb_NewsComments(ParentID,ThreadID,SectionID,UserID,Author,Body,AuditingStatus,UserHostAddress,
	PropertyNames,PropertyValues)values(@ParentID,@ThreadID,@SectionID,@UserID,@Author,@Body,@AuditingStatus,
	@UserHostAddress,@PropertyNames,@PropertyValues)
set @CommentID = SCOPE_IDENTITY()

update spb_NewsThreads set CommentCount=CommentCount+1 , StageCommentCount=StageCommentCount+1 where ThreadID=@ThreadID

update spb_NewsSections set CommentCount=CommentCount+1 where SectionID=@SectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** News计数 **/
CREATE PROCEDURE [dbo].[spb_NewsThreadView_Add]
(
	@ItemID int,
	@RssViewCount int = 0,
	@WebViewCount int = 0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_NewsThreads set HitTimes = HitTimes+@WebViewCount,StageHitTimes=StageHitTimes + @WebViewCount,
RssViewTimes = RssViewTimes+@RssViewCount where ThreadID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ownerUserID获取MicroBlogSection */

CREATE PROCEDURE [dbo].[spb_MicroBlogUserData_Get] 
(
	@UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if not exists (select 1 from spb_MicroBlogUserDatas with (nolock) where UserID = @UserID)
	insert into spb_MicroBlogUserDatas (UserID) values (@UserID)
select * from spb_MicroBlogUserDatas with (nolock) where UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*更新微博*/

Create PROCEDURE [dbo].[spb_MicroBlogUserData_Update] 
(
	@UserID int = 0,
	@Theme nvarchar(128) = '',
	@ThemeAppearance nvarchar(128) = ''
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

Update spb_MicroBlogUserDatas
Set Theme = @Theme,ThemeAppearance = @ThemeAppearance
Where UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除主题 */

CREATE PROCEDURE [dbo].[spb_MicroBlogThread_Delete] 
(
	@ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @OwnerUserID int
declare @ReplyCount int

select @OwnerUserID=OwnerUserID,@ReplyCount=ReplyCount from spb_MicroBlogThreads with (nolock) where ThreadID=@ThreadID

--更新话题计数
declare @idx1 int,@idx2 int,@length int
set @idx1 = -1
set @idx2 = -1
declare @body nvarchar(4000),@topic nvarchar(4000)
select @body = body from spb_MicroBlogThreads where threadID = @ThreadID
WHILE PATINDEX('%[#]%',@body) > 0
BEGIN
	if(@idx1 <= 0)
	Begin
		set @idx1 = patindex('%[#]%',@body)
		set @body=stuff(@body,patindex('%[#]%',@body),1,'') 
	End
	if(@idx1 > 0)
	Begin
		set @idx2 = patindex('%[#]%',@body)
		if(@idx2 > 0)
		Begin
			set @length = @idx2 - @idx1
			set @topic = substring(@body,@idx1,@length)
			set @idx1 = -1
			set @idx2 = -1
			set @body=stuff(@body,patindex('%[#]%',@body),1,'')
			Update spb_MicroBlogTopics 
			Set ItemCount = ItemCount - 1
			Where body like @topic and ItemCount > 0
		End
	End
END

delete spb_MicroBlogComments where ThreadID=@ThreadID
delete spb_MicroBlogThreads where ThreadID=@ThreadID

declare @MostRecentThreadDate datetime
declare @MostRecentThreadBody nvarchar(1024)
declare @MostRecentThreadID int

select top 1 @MostRecentThreadID=ThreadID,@MostRecentThreadBody=Body,@MostRecentThreadDate=DateCreated from spb_MicroBlogThreads with (nolock) where OwnerUserID=@OwnerUserID order by ThreadID desc

update spb_MicroBlogUserDatas set ThreadCount=ThreadCount-1,CommentCount=CommentCount-@ReplyCount,
 MostRecentThreadID=@MostRecentThreadID, MostRecentThreadBody=@MostRecentThreadBody,MostRecentThreadDate=@MostRecentThreadDate
 where UserID=@OwnerUserID
  
delete from spb_MicroBlogThreadsReferUsers where ThreadID = @ThreadID

Delete from spb_MicroBlogTimeLines where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置迷你博客主题审核状态 */

CREATE PROCEDURE [dbo].[spb_MicroBlogThread_UpdateAuditingStatus]
( 
    @ThreadID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @OwnerUserID int
select @OwnerUserID=OwnerUserID from spb_MicroBlogThreads with (nolock) where ThreadID=@ThreadID

--Thread不存在
if (@OwnerUserID is null)
  return

update spb_MicroBlogThreads set AuditingStatus=@AuditingStatus where ThreadID=@ThreadID

declare @MostRecentThreadID int
declare @DateCreated datetime
declare @Body nvarchar(1024)

select top 1 @MostRecentThreadID=ThreadID,@DateCreated=DateCreated,@Body=Body from spb_MicroBlogThreads with (nolock) where OwnerUserID=@OwnerUserID and AuditingStatus=40 order by DateCreated desc

if (@MostRecentThreadID is not null)
  update spb_MicroBlogUserDatas set MostRecentThreadDate=@DateCreated,MostRecentThreadBody=@Body,MostRecentThreadID=@MostRecentThreadID where UserID=@OwnerUserID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [dbo].[spb_Task_MicroBlog_PerStage]
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
    --重置阶段统计数
    update spb_MicroBlogTopics set StageItemCount = 0
    update spb_MicroBlogUserDatas set StageFollowerCount = 0
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除回复 */

CREATE PROCEDURE [dbo].[spb_MicroBlogComment_Delete] 
(
	@CommentID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @ThreadID int
declare @OwnerUserID int

select @ThreadID=ThreadID,@OwnerUserID=OwnerUserID from spb_MicroBlogComments where CommentID=@CommentID

delete spb_MicroBlogComments where CommentID=@CommentID

update spb_MicroBlogThreads set ReplyCount=ReplyCount-1 where ThreadID=@ThreadID

update spb_MicroBlogUserDatas set CommentCount=CommentCount-1 where UserID=@OwnerUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 回复主题 */

CREATE PROCEDURE [dbo].[spb_MicroBlogComment_Create] 
(
	@CommentID int output,
	@ThreadID int,
	@PanretID int,
	@OwnerUserID int,
	@UserID int,
	@Author nvarchar(64)='',
	@Body nvarchar(1024),
	@AuditingStatus int,
	@PostMode int,
	@PostSource nvarchar(64)=''
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

insert into spb_MicroBlogComments(ThreadID,ParentID,OwnerUserID,UserID,Author,Body,AuditingStatus,PostMode,PostSource)
	values(@ThreadID,@PanretID,@OwnerUserID,@UserID,@Author,@Body,@AuditingStatus,@PostMode,@PostSource)

select @CommentID=SCOPE_IDENTITY()

update spb_MicroBlogThreads set ReplyCount=ReplyCount+1 where ThreadID=@ThreadID

update spb_MicroBlogUserDatas set CommentCount=CommentCount+1 where UserID=@OwnerUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_MicroBlogsFavorite_Statistisc] 
(
	@Statistisc int,
	@UserID int,
	@FollowUserID int,
	@TimeScopes int = 30
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if (@Statistisc = 0)
Begin
	update spb_MicroBlogUserDatas
	Set FollowCount = FollowCount + 1
	where UserID = @UserID

	update spb_MicroBlogUserDatas
	Set FollowerCount = FollowerCount + 1,StageFollowerCount = StageFollowerCount + 1
	where UserID = @FollowUserID
    
    --加入时间线
    DECLARE @startDate datetime
	SET @startDate = convert(char(10),getdate() - @TimeScopes,120)
    insert into spb_MicroBlogTimeLines (UserID,ThreadID,FollowUserID) Select @UserID,ThreadID,@FollowUserID From spb_MicroBlogThreads Where DateCreated >= @startDate and OwnerUserID = @FollowUserID
 
end
else if (@Statistisc = 1)
Begin
	if(select FollowCount From spb_MicroBlogUserDatas Where UserID=@UserID)>0
	Begin
		update spb_MicroBlogUserDatas
		Set FollowCount = FollowCount - 1
		where UserID=@UserID and FollowCount > 0
	End
	
	if(select FollowerCount From spb_MicroBlogUserDatas Where UserID=@FollowUserID)>0
	Begin	
		update spb_MicroBlogUserDatas
		Set FollowerCount = FollowerCount - 1,StageFollowerCount = case when (StageFollowerCount > 0) then StageFollowerCount - 1 else 0 end
		where UserID = @FollowUserID and FollowerCount > 0
	End
	
	--退出时间线
	Delete From spb_MicroBlogTimeLines Where UserID = @UserID and FollowUserID = @FollowUserID
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 发布主题 */

CREATE PROCEDURE [dbo].[spb_MicroBlogThread_Create] 
(
	@ThreadID int output,
	@OriginalThreadID int=0,
	@ForwardedThreadID int=0,
	@OwnerUserID int,
	@Author nvarchar(64)='',
	@Body nvarchar(4000)='',
	@UserDataBody nvarchar(4000) = '',
	@AuditingStatus int,
	@HasPhoto bit,
	@HasVideo bit,
	@HasMusic bit,
	@PostMode int,
	@PostSource nvarchar(64)=''
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if not exists (select UserID from spb_MicroBlogUserDatas with (nolock) where UserID=@OwnerUserID)
	insert into spb_MicroBlogUserDatas(UserID)values(@OwnerUserID)

insert into spb_MicroBlogThreads(OriginalThreadID,ForwardedThreadID,OwnerUserID,Author,Body,AuditingStatus,HasPhoto,HasVideo,HasMusic,PostMode,PostSource)
	values(@OriginalThreadID,@ForwardedThreadID,@OwnerUserID,@Author,@Body,@AuditingStatus,@HasPhoto,@HasVideo,@HasMusic,@PostMode,@PostSource)

select @ThreadID=SCOPE_IDENTITY()
--更新相关时间线
INSERT INTO spb_MicroBlogTimeLines (UserID,ThreadID,OriginalThreadID,FollowUserID,HasPhoto,HasVideo,HasMusic) values (@OwnerUserID,@ThreadID,@OriginalThreadID,@OwnerUserID,@HasPhoto,@HasVideo,@HasMusic)
INSERT INTO spb_MicroBlogTimeLines (UserID,ThreadID,OriginalThreadID,FollowUserID,HasPhoto,HasVideo,HasMusic) SELECT UserID,@ThreadID,@OriginalThreadID,@OwnerUserID,@HasPhoto,@HasVideo,@HasMusic From spb_MicroBlogFollows where ItemID = @OwnerUserID

if (@AuditingStatus = 40)
  update spb_MicroBlogUserDatas 
  set MostRecentThreadDate = getdate(),MostRecentThreadBody = @UserDataBody,ThreadCount = ThreadCount + 1,
  MostRecentThreadID = case when @OriginalThreadID <=0 then @ThreadID else MostRecentThreadID end
  where UserID = @OwnerUserID
else
  update spb_MicroBlogUserDatas set ThreadCount = ThreadCount + 1 where UserID = @OwnerUserID

if exists (Select threadID From spb_MicroBlogThreads Where ThreadID = @ForwardedThreadID)
Begin
	Update spb_MicroBlogThreads
	Set ForwardedCount = ForwardedCount + 1
	Where ThreadID = @ForwardedThreadID
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户时处理处理迷你博客 */

CREATE PROCEDURE [dbo].[spb_MicroBlog_DeleteUser]
( 
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

BEGIN TRANSACTION

delete from spb_MicroBlogComments where UserID=@UserID
if(@@error<>0) goto failure
delete from spb_MicroBlogComments where ThreadID in (select ThreadID from spb_MicroBlogThreads with (nolock) where OwnerUserID=@UserID)
if(@@error<>0) goto failure
delete from spb_MicroBlogThreads where OwnerUserID=@UserID
if(@@error<>0) goto failure
delete from spb_MicroBlogUserDatas where UserID = @UserID 
if(@@error<>0) goto failure
delete from dbo.spb_MicroBlogThreadsReferUsers where UserID = @UserID 
if(@@error<>0) goto failure
delete from dbo.spb_MicroBlogTimeLines where UserID = @UserID or FollowUserID = @UserID
if(@@error<>0) goto failure
delete from dbo.spb_MicroBlogTopicesFavorites where UserID = @UserID 
if(@@error<>0) goto failure
delete from dbo.spb_MicroBlogsFavorites where UserID = @UserID 
if(@@error<>0) goto failure
delete from spb_MicroBlogScreenFavorites where ScreenID in (select ScreenID from spb_MicroBlogScreens where UserID=@UserID)
if(@@error<>0) goto failure
delete from spb_MicroBlogsOfScreens where ScreenID in (select ScreenID from spb_MicroBlogScreens where UserID=@UserID)
if(@@error<>0) goto failure
delete from spb_MicroBlogScreens where UserID = @UserID
if(@@error<>0) goto failure
COMMIT TRANSACTION
SELECT 1 -- Success
RETURN

failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
CREATE Procedure [dbo].[spb_PresentAreaApplication_CreateDelete]
(
	@Action int,
	@PresentAreaID int = 0,
	@OwnerID int = 0,
	@applicationID int = 0
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
if(@Action = 0)
Begin
	Insert into spb_OwnerApplicationInPresentAreas(PresentAreaID,OwnerID,applicationID) Values (@PresentAreaID,@OwnerID,@applicationID)
End
else if(@Action = 2)
Begin
	if exists (select ApplicationID from spb_ApplicationInAvailablePresentAreas where PresentAreaID = @PresentAreaID and applicationID = @applicationID)
	Begin
		Delete From spb_OwnerApplicationInPresentAreas where PresentAreaID = @PresentAreaID and OwnerID = @OwnerID and applicationID = @applicationID
		Delete From spb_OwnerNavigations where OwnerID = @OwnerID and ApplicationID = @applicationID
	End
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
CREATE Procedure [dbo].[spb_PresentAreaApplications_GetByPresentAreaID]
(
	@PresentAreaID int = 0
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Select * from spb_ApplicationInAvailablePresentAreas Where PresentAreaID = @PresentAreaID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_MicroBlogFavoriteTopices_Get] 
(
	@UserID int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_MicroBlogTopicesFavorites where UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、删除MicroBlogFavoriteTopic **/

Create PROCEDURE [dbo].[spb_MicroBlogFavoriteTopic_CreateDelete] 
(
    @Action int,
	@UserID int = 0,
	@Keyword nvarchar(64)=''

) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
begin
	INSERT spb_MicroBlogTopicesFavorites (UserID,Keyword)Values (@UserID,@Keyword)
End
else if (@Action = 2)
    delete from spb_MicroBlogTopicesFavorites where UserID = @UserID and Keyword = @Keyword
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
Create Procedure [dbo].[spb_CodeItem_Get]
(
	@CodeSetCode varchar(20)='',
	@ItemID int=0
)
as
select * from spb_CodeItems where CodeSetCode = @CodeSetCode and ItemID=@ItemID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE Procedure [dbo].[spb_CodeItem_CreateUpdateDelete]
(
	@Action int ,
	@CodeSetCode nvarchar(20)='',
	@ItemID int ,
	@ParentItemID int=0,
	@Name nvarchar(100)='',
	@DisplayOrder int=0,
	@Depth int=0
)
as
if(@Action=2)
Begin
    delete from spb_CodeItems where CodeSetCode=@CodeSetCode and ItemID=@ItemID
    if not exists (select * from spb_CodeItems where CodeSetCode=@CodeSetCode and ItemID=@ItemID)
	    delete from spb_CodeItems_Res where CodeSetCode=@CodeSetCode and CodeItemID=@ItemID
End
else if(@Action=1)
Begin
	Update spb_CodeItems
	set Name=@Name,DisplayOrder=@DisplayOrder,Depth=@Depth
	where CodeSetCode=@CodeSetCode and ItemID=@ItemID
End
else
Begin
	 if not exists (select * from spb_CodeItems where CodeSetCode=@CodeSetCode and ItemID=@ItemID)
	 Begin
    Insert into spb_CodeItems(CodeSetCode,ItemID,ParentItemID,Name,DisplayOrder,Depth)
	Values (@CodeSetCode,@ItemID,@ParentItemID,@Name,@DisplayOrder,@Depth)
	End
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
Create Procedure [dbo].[spb_CodeItems_Get]
(
	@CodeSetCode varchar(20)=''
)
as
select * from spb_CodeItems where CodeSetCode=@CodeSetCode
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除ForumThreadCategory **/

CREATE PROCEDURE [dbo].[spb_ForumThreadCategory_CreateUpdateDelete] 
(
	@Action int,
	@CategoryID	int  output ,
	@SectionID	int = 0 ,
	@CategoryName	nvarchar(128) =null,
	@CategoryDescription	nvarchar(1024)='',
	@DisplayOrder	int	=0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
			INSERT INTO spb_ForumThreadCategories
                      (SectionID, CategoryName, CategoryDescription, DisplayOrder)
			VALUES    (@SectionID,@CategoryName,@CategoryDescription,@DisplayOrder)

      select @CategoryID = SCOPE_IDENTITY()
	end

  else if @Action=1 --更新
	  begin
		UPDATE    spb_ForumThreadCategories
		SET       SectionID = @SectionID, 
				  CategoryName = @CategoryName, 
				  CategoryDescription = @CategoryDescription, 
				  DisplayOrder = @DisplayOrder
		WHERE     (CategoryID = @CategoryID)
    end
  else 
	  begin
	  if not exists(select * from spb_ForumThreadCategories with (nolock) where CategoryID = @CategoryID)
	  return
		Update spb_ForumThreads
        set CategoryID=0
		Where CategoryID=@CategoryID
		DELETE FROM spb_ForumThreadCategories
		WHERE     (CategoryID = @CategoryID)
		
	  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
群组统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Club_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--1.更新spb_Applications表
DECLARE @TotalCount INT
DECLARE @CountInPast24Hours INT
DECLARE @NewestID INT

DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate() - 1,120)  

SELECT @TotalCount=COUNT(ClubID) FROM spb_Clubs with (nolock)
SELECT @CountInPast24Hours=COUNT(ClubID) FROM spb_Clubs with (nolock) WHERE DateCreated > @currentDate
SELECT @NewestID=isnull(MAX(ClubID),0) FROM spb_Clubs with (nolock)

UPDATE spb_Applications SET TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
  WHERE (ApplicationID = 231)

--2.更新spb_SiteCategories表
declare @CategoryID int
DECLARE Categories_Cursor CURSOR FOR
SELECT CategoryID FROM spb_SiteCategories with (nolock) WHERE (ApplicationID = 231)
	
OPEN Categories_Cursor
FETCH NEXT FROM Categories_Cursor INTO @CategoryID
	
WHILE @@FETCH_STATUS = 0
  BEGIN	
    update spb_SiteCategories  
    set    ItemCount = (select count(*) from spb_Clubs with (nolock) where CategoryID = @CategoryID )
    where  CategoryID = @CategoryID

	FETCH NEXT FROM Categories_Cursor INTO @CategoryID
		
  END
	
CLOSE Categories_Cursor
DEALLOCATE Categories_Cursor

--3.更新spb_ClubAreaStatistics表
declare @AreaCode varchar(8)
DECLARE Areas_Cursor CURSOR FOR
SELECT AreaCode FROM spb_Areas with (nolock) 
	
OPEN Areas_Cursor
FETCH NEXT FROM Areas_Cursor INTO @AreaCode
	
WHILE @@FETCH_STATUS = 0
    BEGIN	
    if not exists(SELECT AreaCode FROM spb_ClubAreaStatistics with (nolock) WHERE (AreaCode = @AreaCode))      
      INSERT INTO spb_ClubAreaStatistics (AreaCode) VALUES (@AreaCode)      

    update spb_ClubAreaStatistics  
    set    TotalCount = (select count(*) from spb_Clubs with (nolock) where AreaCode=@AreaCode)
    where  (AreaCode = @AreaCode)

	FETCH NEXT FROM Areas_Cursor INTO @AreaCode
		
	  END
	
CLOSE Areas_Cursor
DEALLOCATE Areas_Cursor


--4.更新圈子积分

declare @ClubMemberCountForClubPointRate float
declare @ClubContentCountForClubPointRate float
declare @EventPointForClubPointRate float
declare @HitTimesForClubPointRate float

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=1001)  
  select @ClubMemberCountForClubPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID = 1001
else
  set @ClubMemberCountForClubPointRate=1

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=1002)  
  select @ClubContentCountForClubPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID = 1002
else
  set @ClubContentCountForClubPointRate=0.1

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=1010)  
  select @EventPointForClubPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID = 1010
else
  set @EventPointForClubPointRate=0.1

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=1011)  
  select @HitTimesForClubPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID = 1011
else
  set @HitTimesForClubPointRate=0.01


declare @RowCount_ClubID int

Create table #ClubIDTempTable(
  ClubID int
)
insert into #ClubIDTempTable(ClubID) 
  select ClubID from spb_Clubs with (nolock)
  
set @RowCount_ClubID = @@ROWCOUNT
  
  
create clustered index idx_ClubIDTempTable_ClubID On #ClubIDTempTable(ClubID) with FILLFACTOR = 100

--更新圈子积分并给圈主、圈副加声誉积分
declare @ClubID int
declare @ClubName nvarchar(100)
declare @ClubOwner_UserID int
declare @ClubContentCount int 

while @RowCount_ClubID > 0
Begin
  select top 1 @ClubID=ClubID from #ClubIDTempTable
  set @RowCount_ClubID = @@ROWCOUNT
    
  if @ClubID is not null
  begin
      select @ClubName = ClubName,@ClubOwner_UserID=ClubOwnerUserID from spb_Clubs where ClubID=@ClubID
      select @ClubContentCount = count(P.PostID) from spb_ForumThreads T  with (nolock) inner join spb_ForumSectionGroups G on G.GroupID = T.GroupID inner join spb_ForumPosts P with (nolock) on T.ThreadID = P.ThreadID where G.PresentAreaID = 13 and G.OwnerID = @ClubID
	  
	  update spb_Clubs 
	  set MemberCount = (select count(*) from spb_ClubMembers with (nolock) where ClubID = @ClubID)
	  where ClubID = @ClubID
	  update spb_Clubs 
	  set Points = MemberCount * @ClubMemberCountForClubPointRate + @ClubContentCount * @ClubContentCountForClubPointRate + HitTimes * @HitTimesForClubPointRate +
      (select isnull(sum(points),0) * @EventPointForClubPointRate from spb_EventThreads with (nolock) where ClubID = @ClubID) 
      where ClubID = @ClubID
  end

  delete from #ClubIDTempTable where ClubID = @ClubID
End

drop table #ClubIDTempTable
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置论坛主题图章 */

Create PROCEDURE [dbo].[spb_ForumThread_SetStamp]
(
	@ThreadID int,
	@StampID int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
UPDATE    
	spb_ForumThreads
SET              
	StampID = @StampID
WHERE 
	ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
论坛阶段性统计任务
*/

Create PROCEDURE [dbo].[spb_Task_Forum_PerStage]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
--重置阶段性浏览数
update spb_ForumThreads set StageHitTimes = 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ThreadID获取ForumThread */

CREATE PROCEDURE [dbo].[spb_ForumThread_Get]
(
    @ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE @GetPreAndNext bit
set @GetPreAndNext=1

DECLARE @NextThreadID int 
DECLARE @NextThreadSubject nvarchar(512)
DECLARE @PrevThreadID int  
DECLARE @PrevThreadSubject nvarchar(512)

if @GetPreAndNext=1
  begin
   EXEC spb_ForumThread_GetPrevNextThreadID @ThreadID, @NextThreadID OUTPUT,@PrevThreadID OUTPUT
  end
else
 begin
  select @NextThreadID=0
  select @PrevThreadID=0
 end


SELECT
    FT.*,
    FP.PostID,
    FP.ParentID,
    FP.Subject,
    FP.Body,
    FP.AuditingStatus,
    FP.UserHostAddress,
    FP.PropertyNames,
    FP.PropertyValues,
    FP.HighlightStyle,
    AttachmentFilename = ISNULL((SELECT top 1 [FileName] FROM spb_ForumPostAttachments with (nolock) WHERE PostID = FP.PostID), ''),
    NextThreadID=@NextThreadID,
    PrevThreadID=@PrevThreadID
FROM 
    spb_ForumThreads FT with (nolock) join spb_ForumPosts FP with (nolock) ON FT.ThreadID = FP.ThreadID
WHERE 
    FT.ThreadID = @ThreadID and FP.ParentID = 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE procedure [dbo].[spb_ForumRating_CreateUpdate]
(
	@ThreadID int,
	@UserID int,
	@Author nvarchar(64),
	@Rate int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

if exists (select ThreadID from spb_ForumRatings with (nolock) where ThreadID=@ThreadID and UserID=@UserID)
  begin
    UPDATE    spb_ForumThreads
    SET       RatingSum=RatingSum+@Rate-(select Rate from spb_ForumRatings with (nolock) where ThreadID=@ThreadID and UserID=@UserID)
    Where     ThreadID = @ThreadID
    
	update spb_ForumRatings set Rate=@Rate where ThreadID=@ThreadID and UserID=@UserID
  end
else
  begin
	insert into spb_ForumRatings(ThreadID,UserID,Author,Rate)values(@ThreadID,@UserID,@Author,@Rate)
    
    UPDATE    spb_ForumThreads
    SET       RatingSum=RatingSum + @Rate,TotalRatings=TotalRatings+1
    Where     ThreadID = @ThreadID
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台论坛统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_ForumManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingClubThreadCount int out,
@AgainClubThreadCount int out,
@PendingPostCount int out,
@AgainPostCount int out
)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
--独立论坛待审核主题数	
select @PendingThreadCount= count(sf.ThreadID) from spb_ForumThreads sf  INNER JOIN spb_ForumSectionGroups  sg  
on sf.GroupID=sg.GroupID inner join spb_ForumPosts sp on sf.ThreadID=sp.ThreadID where  sp.AuditingStatus=20  and PresentAreaID=10

--独立论坛需再审核主题数
select @AgainThreadCount= count(sf.ThreadID) from spb_ForumThreads sf  INNER JOIN spb_ForumSectionGroups  sg
on sf.GroupID=sg.GroupID inner join spb_ForumPosts sp on sf.ThreadID=sp.ThreadID where   sp.AuditingStatus=30 and PresentAreaID=10

-- 群组论坛待审核主题数
select @PendingClubThreadCount=count(sf.ThreadID) from spb_ForumThreads  sf INNER JOIN spb_ForumSectionGroups  sg
on sf.GroupID=sg.GroupID inner join spb_ForumPosts sp on sf.ThreadID=sp.ThreadID where sp.AuditingStatus=20 and PresentAreaID=13

--群组论坛需在审核主题数
select @AgainClubThreadCount=count(sf.ThreadID) from spb_ForumThreads sf inner join spb_ForumSectionGroups sg 
on sf.GroupID=sg.GroupID inner join spb_ForumPosts sp on sf.ThreadID=sp.ThreadID where sp.AuditingStatus=30 and PresentAreaID=13
-- 帖子待审核回复数
select @PendingPostCount=count(PostID) from spb_ForumPosts with(nolock) where AuditingStatus=20

--帖子需再审核回复数
select @AgainPostCount=count(PostID) from spb_ForumPosts with(nolock) where AuditingStatus=30

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_ForumThread_MergeThreads]
(
@SectionID int,
@toGroupID int
)
AS
BEGIN
    SET Transaction Isolation Level Read UNCOMMITTED
	SET NOCOUNT ON;
---合并论坛时更改后代板块的主题的ClubID
	update [dbo].[spb_ForumThreads] set GroupID=@toGroupID where SectionID=@SectionID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新论坛帖子 **/

CREATE PROCEDURE [dbo].[spb_ForumPost_CreateUpdate]
(
  @Action int,
  @UpdateSectionStatistics bit = 1,
  @PostID int out,
  @ParentID int = null,
  @ThreadID int= null,
  @SectionID int= null,

  @UserID int = 0,
  @Author nvarchar(64) = '',
  @Subject nvarchar(256) = '',
  @Body ntext,
  @AuditingStatus int = 40,
  @UserHostAddress nvarchar(64) = '',
  @PropertyNames ntext = null,
  @PropertyValues ntext = null
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON


if (@Action = 0) --添加
  begin

    INSERT spb_ForumPosts (ParentID,ThreadID,SectionID,UserID,Author,Subject,
		Body,AuditingStatus,UserHostAddress,PropertyNames,PropertyValues)
    values (@ParentID,@ThreadID,@SectionID,@UserID,@Author,@Subject,
		@Body,@AuditingStatus,@UserHostAddress,@PropertyNames,@PropertyValues)

    SELECT @PostID = SCOPE_IDENTITY() 
    
    update 
		spb_ForumThreads 
    set 
		ReplyCount=ReplyCount+1,
		LastRepliedDate=GetDate(),
        MostRecentPostAuthor=@Author,
        MostRecentPostAuthorID=@UserID,
        MostRecentPostID=@PostID
    where 
		ThreadID = @ThreadID
       
    -- Update the forumSection statitics
    IF @UpdateSectionStatistics = 1 AND @SectionID > 0
		begin
			update 
				spb_ForumSections 
			  set 
				MostRecentPostID=@PostID,
				MostRecentPostDate= GetDate(), 
				MostRecentPostAuthor=@Author,
				MostRecentPostAuthorID=@UserID,
				MostRecentThreadID=@ThreadID,
				MostRecentPostSubject=@Subject
			where 
				SectionID = @SectionID
		end
		
		if not exists (select * from spb_ForumUserDatas where UserID = @UserID)
			insert into spb_ForumUserDatas(UserID,Signature,ThreadCount,PostCount,ExperiencePoints) values (@UserID,'',0,1,0)	
		else
			update 	spb_ForumUserDatas
			Set PostCount = PostCount + 1
			Where UserID = @UserID
  end
else if @Action=1 --更新
	update 
		spb_ForumPosts 
	set 
		Subject=@Subject,
		Body=@Body,
		AuditingStatus=@AuditingStatus,
		PropertyNames=@PropertyNames,
		PropertyValues=@PropertyValues
	where 
		PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_ForumSection_MergeThreads] 
(
    @fromSectionID int ,
    @toSectionID int
)
AS
BEGIN
	SET Transaction Isolation Level Read UNCOMMITTED
	SET NOCOUNT ON
	
    --更新帖子和附件的板块ID
	Update [dbo].[spb_ForumPosts] set SectionID=@toSectionID where SectionID=@fromSectionID
	Update spb_ForumPostAttachments set SectionID=@toSectionID where SectionID=@fromSectionID
    --更新主题的GroupID和sectionID
	
	declare @oldGroupID int
	declare @newGroupID int
	--select @oldGroupID=GroupID from [dbo].[spb_ForumSections] with (nolock) where SectionID=@fromSectionID
	select @newGroupID=GroupID from [dbo].[spb_ForumSections] with (nolock) where SectionID=@toSectionID

	Update [dbo].[spb_ForumThreads] set GroupID = @newGroupID,SectionID = @toSectionID where SectionID = @fromSectionID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* ForumSection的添加、修改、删除 */

CREATE PROCEDURE [dbo].[spb_ForumSection_CreateUpdateDelete] 
(
	@Action int,
	@SectionID	int out,
	@ParentID int = 0,
	@GroupID int = 0,
	@ParentIDList nvarchar(1024) = '',
	@ChildCount int = 0,
	@Depth int = 0,
	@SectionName nvarchar(512) = '',	
	@Description	nvarchar(2000) = '',	
	@ForumType int = 0,
	@DisplayOrder int = 0,	
	@IsActive 	bit = 1,
	@EnaleSearch   bit = 1,	
	@LogoUrl nvarchar(255) = '',
	@EnableAnonymousPosting bit = 0,
    @InheriteModerator	bit = 1,
	@EnableRSS bit=1,
	@PropertyNames ntext = null,
	@PropertyValues ntext = null,
    @ImmediateModeratorsUserNames nvarchar(2000) = '',
	@ThreadCategoryStatus int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @ImmediateModeratorsSQL nvarchar(4000)
declare @UserID int

if @Action = 2 --删除

    begin
      --在论坛附件业务逻辑中删除
      --delete spb_ForumPostAttachments where SectionID=@SectionID
      if not exists(select * from spb_ForumSections with (nolock) where SectionID=@SectionID)
      return
      --删除论坛回复
      delete spb_ForumPosts where SectionID=@SectionID
      
      --删除论坛评价
      delete spb_ForumRatings where ThreadID in (select ThreadID from spb_ForumThreads with (nolock) where SectionID=@SectionID)
      
      --删除论坛标签关联
      delete spb_ItemsInForumTags where ItemID in (select ThreadID from spb_ForumThreads with (nolock) where SectionID=@SectionID)

      --删除论坛主题
      delete spb_ForumThreads where SectionID=@SectionID
		
      --删除论坛主题分类
      delete spb_ForumThreadCategories where SectionID=@SectionID
      
      --删除论坛版主
      delete spb_ForumModerators where SectionID = @SectionID
      
      --更新父版块计数
      select @ParentID=ParentID from spb_ForumSections with (nolock) where SectionID=@SectionID
      if (@ParentID>0)
        update spb_ForumSections set ChildCount=ChildCount-1 where SectionID = @ParentID

      delete spb_ForumSections where SectionID=@SectionID
      
    end

else if  @Action = 1 --修改
    begin
      delete from spb_ForumModerators where SectionID=@SectionID
      
      if (len(@ImmediateModeratorsUserNames)>0)--插入直接版主
      begin
        set @ImmediateModeratorsSQL = 'select ' + str(@SectionID) +',UserID,0 from spb_Users with (nolock) where LoweredUserName in ('+ @ImmediateModeratorsUserNames + ')'

        insert into spb_ForumModerators (SectionID,UserID,Inherited) 
          EXEC sp_executesql @ImmediateModeratorsSQL
      end
      
      if (@InheriteModerator=1 and @ParentID>0)
		begin
            insert into spb_ForumModerators (SectionID,UserID,Inherited) 
              select @SectionID,M2.UserID,1 from spb_ForumModerators M2 with (nolock) where M2.SectionID=@ParentID and UserID not in 
                (select M3.UserID from spb_ForumModerators M3 where M3.SectionID=@SectionID)
		end
          
      update spb_ForumSections set 
          GroupID=@GroupID,SectionName=@SectionName,Description=@Description,ForumType=@ForumType,DisplayOrder=@DisplayOrder,
          IsActive=@IsActive,EnaleSearch=@EnaleSearch,LogoUrl=@LogoUrl,EnableRSS=@EnableRSS,EnableAnonymousPosting=@EnableAnonymousPosting,
          InheriteModerator=@InheriteModerator,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues,
          ParentID=@ParentID,Depth=@Depth,ParentIDList=@ParentIDList,ThreadCategoryStatus=@ThreadCategoryStatus
      where SectionID=@SectionID

    end

else if @Action = 0 --添加

begin
    if (@ParentID>0) 
    begin
      if not exists (select SectionID from spb_ForumSections with (nolock) where SectionID = @ParentID)
        return

      update spb_ForumSections set ChildCount=ChildCount+1 where SectionID = @ParentID 
    end

    insert into spb_ForumSections (ParentID,GroupID,ParentIDList,ChildCount,Depth, SectionName,Description,ForumType,DisplayOrder,IsActive,EnaleSearch,LogoUrl,EnableRSS,EnableAnonymousPosting,InheriteModerator,PropertyNames,PropertyValues,ThreadCategoryStatus)
        values (@ParentID,@GroupID,@ParentIDList,@ChildCount,@Depth, @SectionName,@Description,@ForumType,@DisplayOrder,@IsActive,@EnaleSearch,@LogoUrl,@EnableRSS,@EnableAnonymousPosting,@InheriteModerator,@PropertyNames,@PropertyValues,@ThreadCategoryStatus)

    select @SectionID = SCOPE_IDENTITY()    
    
    if (len(@ImmediateModeratorsUserNames)>0)--插入直接版主
    begin
      set @ImmediateModeratorsSQL = 'select ' + str(@SectionID) +',UserID,0 from spb_Users with (nolock) where LoweredUserName in ('+ @ImmediateModeratorsUserNames + ')'

      insert into spb_ForumModerators (SectionID,UserID,Inherited) 
        EXEC sp_executesql @ImmediateModeratorsSQL
    end

    if (@InheriteModerator=1 and @ParentID>0)--插入继承的版主
		begin
            insert into spb_ForumModerators (SectionID,UserID,Inherited) 
              select @SectionID,M2.UserID,1 from spb_ForumModerators M2 with (nolock) where M2.SectionID=@ParentID and UserID not in 
                (select M3.UserID from spb_ForumModerators M3 where M3.SectionID=@SectionID)
		end
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新论坛主题 **/

CREATE PROCEDURE [dbo].[spb_ForumThread_CreateUpdate]
(
  @Action int,
  @UpdateSectionStatistics bit = 1,
  @EnableUserStatistics bit = 1,
  @PostID int out,
  @ThreadID int out,
  @SectionID int = 0,
  @UserID int = 0,
  @Author nvarchar(256) = '',
  @Subject nvarchar(512),
  @Body ntext,
  @AuditingStatus int = 40,
  @HighlightStyle nvarchar(200) = '',
  @UserHostAddress nvarchar(64)='000.000.000.000',
  @GroupID int = 0,	            	--ForumThread
  @IsLocked bit = 0,	        	--ForumThread
  @IsSticky bit = 0,				--ForumThread
  @ThreadStatus smallint = 0,		--ForumThread
  @StickyDate datetime = null,		--ForumThread
  @IsEssential bit =0,      		--ForumThread
  @EmoticonID int = 0,	        	--ForumThread
  @IsHidden bit = 0,				--ForumThread
  @HighlightDate Datetime = 0,		--ForumThread
  @StampID int = 0,					--ForumThread					

  @CategoryID int = 0,
  @Price int = 0,

  @PropertyNames ntext = null,
  @PropertyValues ntext = null
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
  begin

    BEGIN TRANSACTION

      -- check the StickyDate to ensure it's not null
      IF @StickyDate = null
       SELECT @StickyDate = GetDate()

      INSERT spb_ForumThreads (GroupID,SectionID,UserID,Author,IsLocked,IsSticky,StickyDate,ThreadStatus,IsEssential,EmoticonID,CategoryID,Price,IsHidden,HighlightDate,StampID)
        Values (@GroupID,@SectionID,@UserID,@Author,@IsLocked,@IsSticky,@StickyDate,@ThreadStatus,@IsEssential,@EmoticonID,@CategoryID,@Price,@IsHidden,@HighlightDate,@StampID)
      IF(@@ERROR<>0) GOTO FAILURE
      -- Get the new ThreadID
      SELECT @ThreadID = SCOPE_IDENTITY()

      -- add the new post
      INSERT spb_ForumPosts (ThreadID,SectionID,UserID,Author,Subject,Body,
			AuditingStatus,parentID,HighlightStyle,UserHostAddress,PropertyNames,PropertyValues)
        values (@ThreadID,@SectionID,@UserID,@Author,@Subject,@Body,
			@AuditingStatus,0,@HighlightStyle,@UserHostAddress,@PropertyNames,@PropertyValues)
      IF(@@ERROR<>0) GOTO FAILURE
      
      -- Get the new PostID
      SELECT @PostID = SCOPE_IDENTITY()

    if(@CategoryID>0)
	  begin
      UPDATE spb_ForumThreadCategories SET ThreadCount=ThreadCount+1 WHERE CategoryID=@CategoryID
	    IF(@@ERROR<>0) GOTO FAILURE
    end
      
    IF @UpdateSectionStatistics = 1 and @SectionID > 0
    begin
      update spb_ForumSections 
      set MostRecentPostDate= GetDate(),
	      MostRecentPostAuthor=@Author,
		  MostRecentPostAuthorID=@UserID,
		  MostRecentPostID=@PostID,
		  MostRecentThreadID=@ThreadID,
		  MostRecentPostSubject=@Subject
      where SectionID = @SectionID
      IF(@@ERROR<>0) GOTO FAILURE
    end
    
	if not exists (select * from spb_ForumUserDatas where UserID = @UserID)
		insert into spb_ForumUserDatas(UserID,Signature,ThreadCount,PostCount,ExperiencePoints) values (@UserID,'',1,1,0)	
	else
		update 	spb_ForumUserDatas
		Set ThreadCount = ThreadCount + 1,PostCount = PostCount + 1
		Where UserID = @UserID
			
    COMMIT TRANSACTION
    RETURN
    
    FAILURE:
    ROLLBACK TRANSACTION
    RETURN
  end

  else if @Action=1 --更新

  begin
      
      -- check the StickyDate to ensure it's not null
      IF @StickyDate = null
        SET @StickyDate = GetDate()

     update spb_ForumThreads set 
          IsLocked=@IsLocked,IsSticky=@IsSticky,StickyDate=@StickyDate,
          ThreadStatus=@ThreadStatus,IsEssential=@IsEssential,EmoticonID=@EmoticonID,
		  Price=@Price,IsHidden=@IsHidden,HighlightDate=@HighlightDate
      where ThreadID=@ThreadID
	  declare @oldCategoryID int
	  select @oldCategoryID=CategoryID from spb_ForumThreads with (nolock) where ThreadID=@ThreadID
      --更改了主题分类
      if(@oldCategoryID<>@CategoryID and @categoryID>0)
	  begin
		UPDATE spb_ForumThreadCategories SET ThreadCount=ThreadCount-1 WHERE CategoryID=@oldCategoryID
		UPDATE spb_ForumThreadCategories SET ThreadCount=ThreadCount+1 WHERE CategoryID=@CategoryID
        UPDATE spb_ForumThreads SET
        CategoryID=@CategoryID
        WHERE ThreadID=@ThreadID
      end
         
     update spb_ForumPosts set 
          Subject=@Subject,
          Body=@Body,
          AuditingStatus=@AuditingStatus,
          HighlightStyle=@HighlightStyle,
          UserHostAddress=@UserHostAddress,
          PropertyNames=@PropertyNames,
          PropertyValues=@PropertyValues
      where PostID = @PostID and ThreadID = @ThreadID
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置论坛主题 是否锁定 */

Create PROCEDURE [dbo].[spb_ForumThread_SetLock]
(
	@ThreadID int,
	@IsLocked bit
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
UPDATE    
	spb_ForumThreads
SET              
	IsLocked = @IsLocked
WHERE 
	ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 论坛主题点击计数 **/
CREATE PROCEDURE [dbo].[spb_ForumThreadView_Add]
(
	@ItemID int=0,
	@WebViewCount int=0,
	@RssViewTimes int=0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
set nocount on 
update 
	spb_ForumThreads 
set 
	HitTimes = HitTimes+@WebViewCount,
	RssViewTimes = RssViewTimes+@RssViewTimes,
	StageHitTimes = StageHitTimes + @WebViewCount
where ThreadID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 重置主题统计信息 **/
CREATE PROCEDURE [dbo].[spb_ForumThread_ResetStatistics]
(
	@ThreadID int
)
AS
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED
DECLARE @PostID int
DECLARE @UserID int
DECLARE @PostDate datetime
DECLARE @Author nvarchar(64)
DECLARE @Subject nvarchar(256)

-- Select the most recent post in the thread.
SELECT TOP 1
	@PostID = PostID,
	@UserID = UserID,
	@PostDate = PostDate,
	@Author = Author
FROM
	spb_ForumPosts with (nolock)
WHERE
	ThreadID = @ThreadID
ORDER BY
	PostID DESC

-- Update the thread.	
UPDATE 
	spb_ForumThreads
SET
	ReplyCount = (SELECT COUNT(PostID) FROM spb_ForumPosts with (nolock) WHERE ThreadID=@ThreadID AND ParentID>0),
	MostRecentPostAuthorID = @UserID,
	MostRecentPostAuthor = @Author,	
	MostRecentPostID = @PostID,
	LastRepliedDate = @PostDate
WHERE
	ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 重置论坛统计信息 **/

CREATE procedure [dbo].[spb_ForumSection_ResetStatistics]
(
	@SectionID int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
DECLARE @MostRecentThreadID int
DECLARE @MostRecentPostID int
DECLARE @MostRecentPostAuthorID int
DECLARE @MostRecentPostAuthor nvarchar(64)
DECLARE @MostRecentPostDate datetime
DECLARE @MostRecentPostSubject nvarchar(256)

 -- Select the most recent post from the forum.
 SELECT TOP 1
    @MostRecentThreadID=ThreadID,@MostRecentPostID=PostID,@MostRecentPostAuthorID=UserID,@MostRecentPostDate=PostDate,
     @MostRecentPostSubject=Subject,@MostRecentPostAuthor=Author
 FROM spb_ForumPosts with (nolock) WHERE SectionID = @SectionID AND AuditingStatus = 40
 ORDER BY PostID DESC

 -- If the thread is null, reset the forum statistics.
 IF @MostRecentThreadID IS NULL
    UPDATE spb_ForumSections
    SET ThreadCount = 0,
	    PostCount = 0,
		TodayPostCount = 0,
	    MostRecentPostID = null,
	    MostRecentThreadID = null,
	    MostRecentPostDate = null,
	    MostRecentPostAuthorID = null,
	    MostRecentPostSubject = null,
	    MostRecentPostAuthor = null
    WHERE SectionID = @SectionID
 ELSE
   begin
       DECLARE @ThreadCount int
       DECLARE @PostCount int
       DECLARE @TodayPostCount int
       DECLARE @currentDate datetime
       set @currentDate = convert(char(10),getdate(),120)  
       select @ThreadCount=COUNT(T.ThreadID) FROM spb_ForumThreads T with (nolock) Join spb_ForumPosts P on T.ThreadID=P.ThreadID and P.ParentID=0 WHERE T.SectionID = @SectionID
       select @PostCount=COUNT(P.PostID) FROM spb_ForumPosts P with (nolock) WHERE P.SectionID = @SectionID
	   
	   select @TodayPostCount = COUNT(PostID) FROM spb_ForumPosts with (nolock) WHERE SectionID = @SectionID AND [PostDate]> @currentDate
	  
       UPDATE spb_ForumSections
       SET PostCount = isnull(@PostCount,0),
           ThreadCount = isnull(@ThreadCount,0),
           TodayPostCount = @TodayPostCount,
           MostRecentPostID = @MostRecentPostID,
           MostRecentThreadID = isnull(@MostRecentThreadID,0),
           MostRecentPostDate = @MostRecentPostDate,
           MostRecentPostAuthorID = isnull(@MostRecentPostAuthorID,0),
           MostRecentPostSubject = @MostRecentPostSubject,
           MostRecentPostAuthor = @MostRecentPostAuthor
       WHERE SectionID = @SectionID
   end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
论坛统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Forum_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--1.更新spb_Applications表
DECLARE @TotalCount INT
DECLARE @CountInPast24Hours INT
DECLARE @NewestID INT

DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate() - 1,120)

SELECT @TotalCount=COUNT(T.ThreadID) FROM spb_ForumThreads T with (nolock) inner join spb_ForumSections S with (nolock) on T.SectionID=S.SectionID inner join spb_ForumSectionGroups G on S.GroupID=G.GroupID
SELECT @CountInPast24Hours=COUNT(T.ThreadID) FROM spb_ForumThreads T with (nolock) inner join spb_ForumSections S with (nolock) on T.SectionID=S.SectionID inner join spb_ForumSectionGroups G on S.GroupID=G.GroupID WHERE T.PostDate > @currentDate
SELECT @NewestID=isnull(MAX(T.ThreadID),0) FROM spb_ForumThreads T with (nolock) inner join spb_ForumSections S with (nolock) on T.SectionID=S.SectionID inner join spb_ForumSectionGroups G on  S.GroupID=G.GroupID

UPDATE    spb_Applications
SET       TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
WHERE     (ApplicationID = 211)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_ForumThread_Move] 
(
    @ThreadID int,
    @MoveToSectionID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE @SectionID INT

SELECT	
	@SectionID = SectionID
FROM
    spb_ForumThreads with (nolock)
WHERE
	ThreadID = @ThreadID

update spb_ForumPostAttachments set SectionID = @MoveToSectionID 
    where  PostID in (select PostID from spb_ForumPosts with (nolock) where ThreadID = @ThreadID)

update spb_ForumPosts set SectionID = @MoveToSectionID where ThreadID = @ThreadID

update spb_ForumThreads set SectionID = @MoveToSectionID where ThreadID = @ThreadID

Update spb_ForumSections
Set ThreadCount = case when ThreadCount > 0 then ThreadCount - 1 else 0 end,
PostCount = case when PostCount > 0 then PostCount - 1 else 0 end
where SectionID = @SectionID

Update spb_ForumSections
Set ThreadCount = ThreadCount + 1,PostCount = PostCount + 1
where SectionID = @MoveToSectionID

--主题分类
declare @CategoryID int
select @CategoryID=CategoryID from spb_ForumThreads with (nolock) where ThreadID=@ThreadID
UPDATE spb_ForumThreadCategories SET ThreadCount=ThreadCount-1 WHERE CategoryID=@CategoryID
UPDATE spb_ForumThreads SET CategoryID=0 WHERE ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取某个主题的前一个及后一个主题ID */
CREATE PROCEDURE [dbo].[spb_ForumThread_GetPrevNextThreadID] 
(
	@ThreadID int,
	@NextThreadID int OUTPUT,
	@PrevThreadID int OUTPUT
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @SectionID int

SELECT @SectionID=T.SectionID FROM	spb_ForumThreads T with (nolock) WHERE T.ThreadID = @ThreadID

SELECT TOP 1 
	@PrevThreadID = T.ThreadID
FROM 
	spb_ForumThreads T with (nolock) JOIN spb_ForumPosts P with (nolock) ON T.ThreadID=P.ThreadID
WHERE 
	T.SectionID = @SectionID AND T.ThreadID < @ThreadID  AND P.ParentID=0
ORDER BY P.ThreadID DESC

IF @@ROWCOUNT < 1
	SELECT @PrevThreadID = 0
	
SELECT TOP 1 
	@NextThreadID = T.ThreadID
FROM 
	spb_ForumThreads T with (nolock) JOIN spb_ForumPosts P with (nolock) ON T.ThreadID=P.ThreadID
WHERE 
	T.SectionID = @SectionID AND T.ThreadID > @ThreadID  AND P.ParentID=0
ORDER BY P.ThreadID ASC

IF @@ROWCOUNT < 1
	SELECT @NextThreadID = 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置论坛主题 是否精华 */

CREATE PROCEDURE [dbo].[spb_ForumThread_SetEssential]
(
	@ThreadID int,
	@IsEssential bit
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
UPDATE    
	spb_ForumThreads
SET              
	IsEssential = @IsEssential
WHERE 
	ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_UrlInfo_Create]
	@Alias nvarchar(16),
	@URL nvarchar(512) = '',
	@UrlSalt nvarchar(32) = '',
	@PlayUrl nvarchar(512) = '',
	@ThumbnailUrl nvarchar(512) = '',
	@MediaType int = 9999
AS
SET Transaction Isolation Level Read UNCOMMITTED
if not exists (select 1 From spb_UrlInfos where Alias = @Alias)
	insert into spb_UrlInfos(Alias,Url,UrlSalt,ThumbnailUrl,PlayUrl,MediaType) values (@Alias,@Url,@UrlSalt,@ThumbnailUrl,@PlayUrl,@MediaType)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
CREATE Procedure [dbo].[spb_OwnerApplicationsInPresentAreas_GetByOwnerID]
(
	@PresentAreaID int = 0,
	@OwnerID int = 0
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Select * from spb_OwnerApplicationInPresentAreas O
 inner join spb_Applications A on A.ApplicationID = O.ApplicationID
Where  O.OwnerID = @OwnerID and O.PresentAreaID = @PresentAreaID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
Create Procedure [dbo].[spb_PresentAreaApplication_GetsByOwnerID]
(
	@PresentAreaID int = 0,
	@OwnerID int = 0
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Select * from spb_OwnerApplicationInPresentAreas Where PresentAreaID = @PresentAreaID and OwnerID = @OwnerID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置论坛主题、评论审核状态 */

Create PROCEDURE [dbo].[spb_FroumPost_UpdateAuditingStatus]
( 
    @PostID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_ForumPosts set AuditingStatus=@AuditingStatus where PostID=@PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_ForumReplyUserIDs_GetByThreadID]
(
    @ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT UserID FROM spb_ForumPosts with (nolock) WHERE ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据PostID获取ForumPost */

CREATE PROCEDURE [dbo].[spb_ForumPost_Get]
(
    @PostID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    FP.*,
    AttachmentFilename = ISNULL((SELECT top 1 [FileName] FROM spb_ForumPostAttachments WHERE PostID = @PostID), '')
FROM    
	  spb_ForumPosts FP with (nolock)
WHERE 
    FP.PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE   procedure [dbo].[spb_Roles_Get]
(
    @UserID int = -1
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN

	IF (@UserID > 0)
    SELECT R.* FROM spb_Roles R with (nolock) inner join spb_UsersInRoles U with (nolock) on R.RoleID = U.RoleID where U.UserID =  @UserID
	ELSE
    SELECT * FROM spb_Roles with (nolock)

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_UserRole_RemoveUserFromAllRoles] 
  @UserID int
  
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

begin
  
  delete from spb_UsersInRoles where UserID = @UserID

end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_UserRole_AddUserToRole] 
  @UserID int,
  @RoleName nvarchar(64)
  
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

begin

  declare @RoleID	int
  select @RoleID=RoleID from spb_Roles with (nolock) where LoweredRoleName = lower(@RoleName)
  
  if  @@RowCount > 0
    begin
      if not exists (select RoleID from spb_UsersInRoles with (nolock) where RoleID=@RoleID and UserID=@UserID)
        insert into spb_UsersInRoles (UserID,RoleID) values (@UserID,@RoleID)      
    end

end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除角色 */

CREATE PROCEDURE [dbo].[spb_Role_CreateUpdateDelete] 
  @RoleID	int out,
  @RoleName	nvarchar(64) = null,
  @FriendlyRoleName	nvarchar(64) = null,
  @IsBuiltIn	bit = 1,
  @ConnectToUser	bit = null,
  @ApplicationID	smallint = null,
  @Description	nvarchar(256) = '',
  @Enabled	bit = 1,
  @IsPublic bit = 0,
  @Action int

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

begin
  if  @Action = 0 --添加
    begin
      if exists (select top 1 RoleID from spb_Roles with (nolock) where LoweredRoleName = lower(@RoleName))
        return
        
      insert into spb_Roles (RoleName,LoweredRoleName,FriendlyRoleName,IsBuiltIn,IsPublic,ConnectToUser,ApplicationID,Description,Enabled)
        values (@RoleName,lower(@RoleName),@FriendlyRoleName,@IsBuiltIn,@IsPublic,@ConnectToUser,@ApplicationID,@Description,@Enabled)

			SELECT @RoleID = SCOPE_IDENTITY() 
    end
  else if @Action = 1 --修改
    update spb_Roles set
      RoleName = @RoleName,
      LoweredRoleName = lower(@RoleName),
      FriendlyRoleName = @FriendlyRoleName,
      IsBuiltIn = @IsBuiltIn,
	  IsPublic = @IsPublic,
      ConnectToUser = @ConnectToUser,
      ApplicationID = @ApplicationID,
      Description = @Description,
      Enabled = @Enabled
      where RoleID=@RoleID
  else if @Action = 2 --删除
    begin
      BEGIN TRANSACTION   
      DELETE FROM spb_UsersInRoles  WHERE @RoleId = RoleId
      IF( @@ERROR <> 0 )
        goto Cleanup
      DELETE FROM spb_Roles  WHERE @RoleId = RoleId
      IF( @@ERROR <> 0 )
        goto Cleanup
	  DELETE FROM spb_AuditingItemSettingsInUserRoles WHERE @RoleId = RoleId
      IF( @@ERROR <> 0 )
        goto Cleanup
	  DELETE FROM spb_PermissionItemRolesInUserRoles WHERE @RoleId = RoleId
      IF( @@ERROR <> 0 )
        goto Cleanup
      
      COMMIT TRANSACTION
      
      return
      
      Cleanup:
          ROLLBACK TRANSACTION
      return
    end
  
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 通过ClubID获取所有Forum **/

CREATE procedure [dbo].[spb_ForumSections_GetByGroupID]
(
  @GroupID int,
  @MaxDepth int out
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

SELECT * FROM spb_ForumSections WHERE GroupID = @GroupID order by DisplayOrder,DateCreated desc
select @MaxDepth = max(depth) from spb_ForumSections with (nolock) WHERE GroupID = @GroupID
select FM.*,U.UserName,U.CommonName,U.NickName from spb_ForumModerators as FM with (nolock) inner join spb_Users as U with (nolock) on FM.UserID = U.UserID where FM.SectionID in (select SectionID from spb_ForumSections with (nolock) where GroupID = @GroupID) order by FM.SectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户时调用 */

CREATE PROCEDURE [dbo].[spb_Forum_DeleteUser]
( 
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END

delete spb_ForumModerators where UserID=@UserID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
Create Procedure [dbo].[spb_CodeSetNameRes_Get]
(
	@CodeSetCode varchar(20)=''
)
as
select * from spb_CodeSets_Res where CodeSetCode=@CodeSetCode
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
Create Procedure [dbo].[spb_CodeItemNameRes_Get]
(
	@CodeSetCode varchar(20)='',
	@CodeItemID int=0
)
as
select * from spb_CodeItems_Res where CodeSetCode = @CodeSetCode and CodeItemID=@CodeItemID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
Create Procedure [dbo].[spb_CodeItemNameRes_Update]
(
  @CodeSetCode varchar(20)='',
  @CodeItemID int =0,
  @LanguageCode varchar(20)='',
  @Name nvarchar(100)=''
)
as
if exists (select * from spb_CodeItems_Res where CodeSetCode=@CodeSetCode and CodeItemID=@CodeItemID)
	update spb_CodeItems_Res
	set LanguageCode = @LanguageCode,Name=@Name
	where CodeSetCode=@CodeSetCode and CodeItemID=@CodeItemID
else
	insert into spb_CodeItems_Res(CodeSetCode,CodeItemID,LanguageCode,Name)
	Values(@CodeSetCode,@CodeItemID,@LanguageCode,@Name)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create Procedure [dbo].[spb_DefaultNavigationNameRes_Get]
(
	@DefaultNavigationID int
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Select * From [dbo].[spb_DefaultNavigations_Res] with (nolock) Where DefaultNavigationID = 	@DefaultNavigationID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE Procedure [dbo].[spb_DefaultNavigationNameRes_Update]
(
    @DefaultNavigationID int,
    @LanguageCode varchar(20) = '',
    @Name nvarchar(128) = ''
)
as
if exists(select * from spb_DefaultNavigations_Res where DefaultNavigationID=@DefaultNavigationID)
Update spb_DefaultNavigations_Res Set Name=@Name Where DefaultNavigationID=@DefaultNavigationID and LanguageCode=@LanguageCode
else
Insert into spb_DefaultNavigations_Res(DefaultNavigationID,LanguageCode,Name) values(@DefaultNavigationID,@LanguageCode,@Name)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
Create Procedure [dbo].[spb_OwnerNavigation_Get]
(
    @OwnerNavigationID int
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
	 Select * from  [dbo].[spb_OwnerNavigations] Where OwnerNavigationID = @OwnerNavigationID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_OwnerNavigations_Get]
(
	@PresentAreaID int = 0,
	@OwnerID int = 0
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
	 Select * from  [dbo].[spb_OwnerNavigations]
	 Where PresentAreaID = @PresentAreaID and OwnerID = @OwnerID
	 order by displayorder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_OwnerNavigation_CreateUpdateDelete]
(
    @Action int,
    @DefaultNavigationID int = 0,
    @OwnerID int = 0,
    @OwnerNavigationID int = 0 output,
	@NavigationType int = 0,
	@ApplicationID int = 0,
	@NavigationText nvarchar(64) = N'',	
	@NavigationUrl nvarchar(512)	= N'', 
	@NavigationTarget nvarchar(64) = N'',	
	@DisplayOrder int = 0,	
	@IsEnabled bit = 0,
	@OnlyOwnerVisible bit = 0,	
	@PresentAreaID int = 0,
	@SecondaryID int = 0,	
	@UrlRouteName nvarchar(64) = N''
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
if(@Action = 0)--创建
begin   
	Insert into dbo.spb_OwnerNavigations(DefaultNavigationID,OwnerID,NavigationType,ApplicationID,NavigationText,NavigationUrl,NavigationTarget,DisplayOrder,
	IsEnabled,OnlyOwnerVisible,PresentAreaID,SecondaryID,UrlRouteName)
	Values
	(@DefaultNavigationID,@OwnerID,@NavigationType,@ApplicationID,@NavigationText,@NavigationUrl,@NavigationTarget,@DisplayOrder,@IsEnabled,@OnlyOwnerVisible,
	@PresentAreaID,@SecondaryID,@UrlRouteName)
	set @OwnerNavigationID = SCOPE_IDENTITY()

end
else if(@Action = 1)--更新
Begin
		Update [dbo].[spb_OwnerNavigations]
		Set DefaultNavigationID = @DefaultNavigationID,OwnerID = @OwnerID,NavigationType = @NavigationType,ApplicationID = @ApplicationID,
		NavigationText = @NavigationText,NavigationUrl = @NavigationUrl,NavigationTarget = @NavigationTarget,DisplayOrder = @DisplayOrder,
		IsEnabled = @IsEnabled,OnlyOwnerVisible = @OnlyOwnerVisible,PresentAreaID = @PresentAreaID,SecondaryID = @SecondaryID,
		UrlRouteName = @UrlRouteName
		Where OwnerNavigationID = @OwnerNavigationID
End
else if(@Action = 2)--删除
begin
	Delete From [dbo].[spb_OwnerNavigations] Where OwnerNavigationID = @OwnerNavigationID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
CREATE Procedure [dbo].[spb_DefaultNavigation_CreateUpdateDelete]
(
    @Action int,
    @DefaultNavigationID int = 0,
	@NavigationType int = 0,
	@ApplicationID int = 0,
	@NavigationText nvarchar(64) = N'',	
	@NavigationUrl nvarchar(512)	= N'', 
	@NavigationTarget nvarchar(64) = N'',	
	@DisplayOrder int = 0,	
	@IsEnabled bit = 0,
	@OnlyOwnerVisible bit = 0,	
	@PresentAreaID int = 0,
	@SecondaryID int = 0,	
	@UrlRouteName nvarchar(64) = N''
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
if(@Action = 0)--创建
begin   
	Insert into dbo.spb_DefaultNavigations(DefaultNavigationID,NavigationType,ApplicationID,NavigationText,NavigationUrl,NavigationTarget,DisplayOrder,
	IsEnabled,OnlyOwnerVisible,PresentAreaID,SecondaryID,UrlRouteName)
	Values
	(@DefaultNavigationID,@NavigationType,@ApplicationID,@NavigationText,@NavigationUrl,@NavigationTarget,@DisplayOrder,@IsEnabled,@OnlyOwnerVisible,
	@PresentAreaID,@SecondaryID,@UrlRouteName)
end
else if(@Action = 1)--更新
Begin
	IF EXISTS(SELECT DefaultNavigationID FROM spb_DefaultNavigations WHERE DefaultNavigationID = @DefaultNavigationID)
	BEGIN
		Update [dbo].[spb_DefaultNavigations]
		Set NavigationType = @NavigationType,ApplicationID = @ApplicationID,NavigationText = @NavigationText,NavigationUrl = @NavigationUrl,
		NavigationTarget = @NavigationTarget,DisplayOrder = @DisplayOrder,IsEnabled = @IsEnabled,OnlyOwnerVisible = @OnlyOwnerVisible,
		PresentAreaID = @PresentAreaID,SecondaryID = @SecondaryID,UrlRouteName = @UrlRouteName
		Where DefaultNavigationID = @DefaultNavigationID
    END
    ELSE
    BEGIN
		Insert into dbo.spb_DefaultNavigations(DefaultNavigationID,NavigationType,ApplicationID,NavigationText,NavigationUrl,NavigationTarget,DisplayOrder,
		IsEnabled,OnlyOwnerVisible,PresentAreaID,SecondaryID,UrlRouteName)
		Values
		(@DefaultNavigationID,@NavigationType,@ApplicationID,@NavigationText,@NavigationUrl,@NavigationTarget,@DisplayOrder,@IsEnabled,@OnlyOwnerVisible,
		@PresentAreaID,@SecondaryID,@UrlRouteName)
    END
End
else if(@Action = 2)--删除
begin
	Delete From [dbo].[spb_DefaultNavigations] Where DefaultNavigationID = @DefaultNavigationID
	Delete From [dbo].[spb_OwnerNavigations] Where DefaultNavigationID = @DefaultNavigationID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取主题分类 */

CREATE PROCEDURE [dbo].[spb_ForumThreadCategory_Get]
( 
    @CategoryID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     *
FROM         spb_ForumThreadCategories with (nolock)
WHERE     (CategoryID = @CategoryID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取某一板块下的分类集合 */

CREATE PROCEDURE [dbo].[spb_ForumThreadCategories_Get]
( 
    @SectionID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     *
FROM spb_ForumThreadCategories with (nolock)
WHERE SectionID = @SectionID order by DisplayOrder
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_UserRankNameRes_Update]
(
    @Rank int,
    @LanguageCode varchar(20)='',
    @RankName1 nvarchar(128)='',
    @RankName2 nvarchar(128)='',
    @RankName3 nvarchar(128)='',
    @RankName4 nvarchar(128)='',
    @RankName5 nvarchar(128)='',
    @RankName6 nvarchar(128)='',
    @RankName7 nvarchar(128)='',
    @RankName8 nvarchar(128)='',
    @RankName9 nvarchar(128)='',
    @RankName10 nvarchar(128)=''
)
as
if exists(select * from spb_UserRanks_Res where Rank=@Rank and LanguageCode=@LanguageCode)
Update spb_UserRanks_Res Set RankName1=@RankName1,RankName2=@RankName2,RankName3=@RankName3,
							 RankName4=@RankName4,RankName5=@RankName5,RankName6=@RankName6,
							 RankName7=@RankName7,RankName8=@RankName8,RankName9=@RankName9,
							 RankName10=@RankName10
							 Where Rank=@Rank and LanguageCode=@LanguageCode
else
Insert into spb_UserRanks_Res(Rank,LanguageCode,RankName1,RankName2,RankName3,RankName4,RankName5,RankName6,
								RankName7,RankName8,RankName9,RankName10)
 values(@Rank,@LanguageCode,@RankName1,@RankName2,@RankName3,@RankName4,@RankName5,@RankName6,@RankName7,@RankName8,@RankName9,@RankName10)
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_UserRankNameRes_Get]
(
    @Rank int
)
as
select * from spb_UserRanks_Res where Rank = @Rank
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、更新用户管制状态
*/

CREATE PROCEDURE [dbo].[spb_Task_User_UpdateUserModeratedStatus]
(
	@NoModeratedUserPoint int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Update spb_Users
Set IsModerated = 0
Where IsForceModerated = 0 and IsModerated = 1 and (BasicPoints * 0.5 + ReportPoints * 1) > @NoModeratedUserPoint
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [dbo].[spb_vw_CompanyUsers_FullUser]
AS
SELECT     dbo.spb_Users.UserID, dbo.spb_Users.UserName, dbo.spb_Users.Password, dbo.spb_Users.PasswordFormat, dbo.spb_Users.PasswordQuestion, 
                      dbo.spb_Users.PasswordAnswer, dbo.spb_Users.PasswordSalt, dbo.spb_Users.PrivateEmail, dbo.spb_Users.MembershipID, 
                      dbo.spb_Users.CommonName, dbo.spb_Users.Nickname, dbo.spb_Users.ForceLogin, dbo.spb_Users.UserAccountStatus, dbo.spb_Users.LastActivity, 
                      dbo.spb_Users.LastAction, dbo.spb_Users.IPCreated, dbo.spb_Users.IPLastActivity, dbo.spb_Users.DatabaseQuota, 
                      dbo.spb_Users.DatabaseQuotaUsed, dbo.spb_Users.EnableAvatar, dbo.spb_Users.EnableDisplayInMemberList, dbo.spb_Users.EnableOnlineStatus, 
                      dbo.spb_Users.EnableEmail, dbo.spb_Users.EnableHtmlEmail, dbo.spb_Users.IsAvatarApproved, dbo.spb_Users.UserRankType, 
                      dbo.spb_Users.UserType, dbo.spb_Users.PublicEmail, dbo.spb_Users.Mobile, dbo.spb_Users.MsnIM, dbo.spb_Users.QQIM, 
                      dbo.spb_Users.YahooIM, dbo.spb_Users.SkypeIM, dbo.spb_Users.PersonalHomepage, dbo.spb_Users.InviteUserID, dbo.spb_Users.InviteClubID, 
                      dbo.spb_Users.PropertyNames, dbo.spb_Users.PropertyValues, dbo.spb_Users.MemberLevel, dbo.spb_Users.DateCreated, 
                      dbo.spb_Users.BasicPoints, dbo.spb_Users.TradePoints, dbo.spb_Users.PrepayTradePoints, dbo.spb_Users.ReportPoints, 
                      dbo.spb_Users.CreditPoints, dbo.spb_Users.ExpertPoints, dbo.spb_Users.Rank, dbo.spb_Users.RMBMoney, dbo.spb_Users.PrepayRMBMoney, 
                      dbo.spb_Users.ProfileIntegrity, dbo.spb_Users.FriendCount, dbo.spb_Users.InviteFriendCount, dbo.spb_Users.loginTimes, dbo.spb_Users.HitTimes, 
                      dbo.spb_CompanyUserProfile.Licence, dbo.spb_CompanyUserProfile.Trade, dbo.spb_CompanyUserProfile.CompanyProperty, 
                      dbo.spb_CompanyUserProfile.Fund, dbo.spb_CompanyUserProfile.EmployeeNum, dbo.spb_CompanyUserProfile.Intro, 
                      dbo.spb_CompanyUserProfile.Linkman, dbo.spb_CompanyUserProfile.LinkmanDuty, dbo.spb_CompanyUserProfile.LinkTel, 
                      dbo.spb_CompanyUserProfile.LinkTelPrivacy, dbo.spb_CompanyUserProfile.Fax, dbo.spb_CompanyUserProfile.FaxPrivacy, 
                      dbo.spb_CompanyUserProfile.Address, dbo.spb_CompanyUserProfile.ValidateStatus, dbo.spb_CompanyUserProfile.ValidateDate, 
                      dbo.spb_CompanyUserProfile.AreaCode, dbo.spb_Users.Theme, dbo.spb_Users.ThemeAppearance, dbo.spb_Users.IsEmailVerified, 
                      dbo.spb_Users.StageHitTimes, dbo.spb_Users.IsModerated, dbo.spb_Users.IsForceModerated
FROM         dbo.spb_CompanyUserProfile INNER JOIN
                      dbo.spb_Users ON dbo.spb_CompanyUserProfile.UserID = dbo.spb_Users.UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE procedure [dbo].[spb_CompanyUser_CreateUpdate] 
(
  -- spb_users内容    
  @UserID int out,  
  
  @UserName   nvarchar (64) = '',
  @Password nvarchar (128) = null,
  @PasswordSalt nvarchar (128) = null,
  @PasswordFormat int = 1,
  @PasswordQuestion nvarchar(64) = null,
  @PasswordAnswer nvarchar(128) = null,
  @PrivateEmail nvarchar(64) = null,    
  @RequiresUniqueEmail bit = 2,
  @MembershipID uniqueidentifier = null,
  
  @CommonName	nvarchar(64) = '',
  @NickName nvarchar(64) = '',
  @ForceLogin   bit   = 0,	
  @UserAccountStatus  smallint = 1,	
  @IPCreated nvarchar(32) = '000.000.000.000',
  @DatabaseQuota int = 10240,
  @DatabaseQuotaUsed int=0,
  @IsModerated  bit  = 1,
  @IsForceModerated bit = 0,	
  @MemberLevel  int  = 0,	
  @EnableAvatar    bit  = 1, -- 启用头像	
  @EnableDisplayInMemberList  bit  = 1,	
  @EnableOnlineStatus   bit  = 1,
  @EnableEmail bit = 1, --默认接收网站email
  @EnableHtmlEmail   bit  = 1,	
  @IsAvatarApproved   bit  = 1, --头像审核通过
  @UserRankType smallint = 0,
  @InviteUserID	int = 0,
  @InviteClubID	int	= 0,
  @IsEmailVerified bit = 0,

  @mobile nvarchar(64) = '',
  @PublicEmail nvarchar(64) = '',
  @MsnIM		nvarchar(64) = '',
  @QQIM		nvarchar(64) = '',
  @YahooIM		nvarchar(64) = '',
  @SkypeIM		nvarchar(64) = '',
  @PersonalHomepage		nvarchar(256) = '',
  @Theme nvarchar(128) = '',
  @ThemeAppearance	nvarchar(128) = '',
  @PropertyNames ntext = null,
  @PropertyValues ntext = null,    
  -- spb_users内容 End	
  
  -- spb_CompanyUsersProfile 内容
  @Licence nvarchar(64) = '',
  @Trade smallint = 0,
  @CompanyProperty smallint = 0,
  @Fund smallint = 0,
  @EmployeeNum smallint = 0,
  @AreaCode varchar(8) = '',
  @Intro ntext = '',
  
  @linkman	nvarchar(64) = '',
  @linkmanduty nvarchar(64) = '',
  @linkTel	nvarchar(64) = '',
  @linkTelPrivacy smallint = '',
  @fax	nvarchar(64) = '',
  @FaxPrivacy smallint = '',
  @Address	nvarchar(128) = '',
  -- spb_PersonUsersProfile end

  @Action    int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
/*
This sproc returns an int that indicates the CreateUserStatus enum value:
  UnknownFailure = 0
  Created = 1
  DuplicateUsername = 2
  DuplicateEmailAddress = 3
  InvalidFirstCharacter = 4
  DisallowedUsername = 5
  Updated = 6
  Deleted = 7
  InvalidQuestionAnswer = 8
  InvalidPassword = 9
*/

declare @UserType smallint
set @UserType = 2

--删除用户未处理

IF @Action = 0  
    BEGIN
      if exists (select UserID from spb_Users with (nolock) where LoweredUserName = lower(@UserName))
      begin
        select 2
        return 
      end      
      
      if (@RequiresUniqueEmail = 1)
      begin
        if exists (select UserID from spb_Users with (nolock) where LoweredPrivateEmail = lower(@PrivateEmail))
        begin
          select 3
          return
        end
      end

      insert into [spb_Users] (UserName,LoweredUserName,Password,PasswordSalt,PasswordFormat,PasswordQuestion,PasswordAnswer,PrivateEmail,LoweredPrivateEmail,MembershipID,
          CommonName,Nickname,ForceLogin,UserAccountStatus,IPCreated,IPLastActivity,IsModerated,MemberLevel,EnableAvatar,EnableDisplayInMemberList,
          EnableOnlineStatus,EnableEmail,EnableHtmlEmail,UserRankType,mobile,PublicEmail,MsnIM,QQIM,YahooIM,SkypeIM,PersonalHomepage,UserType,InviteUserID,InviteClubID,IsEmailVerified,Theme,ThemeAppearance,PropertyNames,PropertyValues)
      values (@UserName,lower(@UserName),@Password,@PasswordSalt,@PasswordFormat,@PasswordQuestion,@PasswordAnswer,@PrivateEmail,lower(@PrivateEmail),@MembershipID,
          @CommonName,@NickName,@ForceLogin,@UserAccountStatus,@IPCreated,@IPCreated,@IsModerated,@MemberLevel,@EnableAvatar,@EnableDisplayInMemberList,
          @EnableOnlineStatus,@EnableEmail,@EnableHtmlEmail,@UserRankType,@mobile,@PublicEmail,@MsnIM,@QQIM,@YahooIM,@SkypeIM,@PersonalHomepage,@UserType,@InviteUserID,@InviteClubID,@IsEmailVerified,@Theme,@ThemeAppearance,@PropertyNames,@PropertyValues)

      Select @UserID = SCOPE_IDENTITY()

      insert into spb_CompanyUserProfile ([UserID],[Licence],[Trade],[CompanyProperty],[Fund],[EmployeeNum],[AreaCode],
          [Intro],[linkman],[linkmanduty],[linkTel],[linkTelPrivacy],[fax],[FaxPrivacy],[Address])
      values (@UserID,@Licence,@Trade,@CompanyProperty,@Fund,@EmployeeNum,@AreaCode,@Intro,@linkman,@linkmanduty,
          @linkTel,@linkTelPrivacy,@fax,@FaxPrivacy,@Address)


      Select 1
      RETURN
      
    End
Else IF @Action = 1
    Begin
    
      if (@RequiresUniqueEmail = 1)
      begin
        if exists (select UserID from spb_Users with (nolock) where UserID<>@UserID and LoweredPrivateEmail = lower(@PrivateEmail))
        begin
          select 3
          return
        end
      end
    
    
      UPDATE
        spb_CompanyUserProfile
      SET
            Licence = @Licence,
            Trade = @Trade,
            CompanyProperty = @CompanyProperty,
            Fund = @Fund,
            EmployeeNum = @EmployeeNum,
            AreaCode = @AreaCode,
            Intro = @Intro,
            linkman = @linkman,
            linkmanduty = @linkmanduty,
            linkTel = @linkTel,
            linkTelPrivacy = @linkTelPrivacy,
            fax = @fax,
            FaxPrivacy=@FaxPrivacy,
            Address = @Address
        WHERE UserID = @UserID

      UPDATE spb_Users
        SET
            PrivateEmail = @PrivateEmail,
            LoweredPrivateEmail = lower(@PrivateEmail),
            CommonName = @CommonName,
            Nickname = @NickName,
            ForceLogin = @ForceLogin,
            UserAccountStatus = @UserAccountStatus,
            DatabaseQuota = @DatabaseQuota,
            DatabaseQuotaUsed=@DatabaseQuotaUsed,
            IsModerated = @IsModerated,
            IsForceModerated = @IsForceModerated,	
            MemberLevel = @MemberLevel,
            EnableAvatar = @EnableAvatar,
            EnableDisplayInMemberList = @EnableDisplayInMemberList,
            EnableOnlineStatus = @EnableOnlineStatus,
            EnableEmail = @EnableEmail,
            EnableHtmlEmail = @EnableHtmlEmail,
			IsEmailVerified = @IsEmailVerified,
            IsAvatarApproved = @IsAvatarApproved,
            UserRankType = @UserRankType,
            mobile = @mobile,
            publicEmail = @PublicEmail,
            MsnIM = @MsnIM,
            QQIM = @QQIM,
            YahooIM = @YahooIM,
            SkypeIM = @SkypeIM,
            PersonalHomepage = @PersonalHomepage,
            Theme = @Theme,
            ThemeAppearance = @ThemeAppearance,
            PropertyNames = @PropertyNames,
            PropertyValues = @PropertyValues
        WHERE UserID = @UserID
      
      Select 5

    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**平台数据统计**/
     
-- PendingPersonUserCount = 0,待审核的个人用户数
--PendingCompanyUserCount = 1,待审核的企业用户数
-- ImpeachMessageCount = 2,举报信息数
-- PendingConvertibleGiftExchangeApplyCount = 3,待审核的礼品兑换申请数
--  NoReadMessageCount = 4,未读消息数
-- UserGuestbookCount = 5用户留言数
--1 个人用户2 企业用户
CREATE PROCEDURE [dbo].[spb_ServiceManageableCounts_Get]
(
@ImpeachMessageCount int out,
@NoReadMessageCount int out,
@PendingCompanyUserCount int out,
@PendingConvertibleGiftExchangeApplyCount int out,
@PendingPersonUserCount int out,
@UserGuestbookCount int out
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	SET NOCOUNT ON;
	--待审核企业用户数
select @PendingCompanyUserCount=count(UserID) from spb_Users where UserAccountStatus=0 and UserType=2
--待审核用户留言数
select @UserGuestbookCount =count(PostID) from spb_UserGuestbookPosts where AuditingStatus=20
--举报信息数
select @ImpeachMessageCount=count(ReportID) from spb_ImpeachReports where IsComplete= 0
--待审核的礼品兑换申请数
select @PendingConvertibleGiftExchangeApplyCount=count(ApplyID) 
from spb_ConvertibleGift_ExchangeApplies where ApplyStatus=0
--未读消息数
select  @NoReadMessageCount=count(ThreadID) from spb_PrivateMessageInbox where UserID=-102 and IsRead=0

-- 待审核个人用户数

select @PendingPersonUserCount=count(UserID) from spb_Users where UserAccountStatus=0 and UserType=1
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 用户等级 */

CREATE PROCEDURE [dbo].[spb_UserRank_CreateUpdateDelete]
( 
	@Action int,
	@Rank	int	,
	@PointUpper	int =0,
	@PointLower	int =0,
	@PropertyNames	ntext =null,
	@PropertyValues	ntext =null	
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
		delete from spb_UserRanks where Rank = @Rank
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin				
				insert into spb_UserRanks(Rank,PointUpper,PointLower,PropertyNames,PropertyValues)
                values(@Rank,@PointUpper,@PointLower,@PropertyNames,@PropertyValues)
            end       
         else --更新
            begin
				update spb_UserRanks
				set PointUpper = @PointUpper,
					PointLower = @PointLower,
					PropertyNames = @PropertyNames,
					PropertyValues = @PropertyValues
				where Rank = @Rank
            end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取用户等级详细信息 */

CREATE PROCEDURE [dbo].[spb_UserRank_Get]
( 
    @Rank int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

Select 
	spb_UserRanks.* FROM spb_UserRanks with (nolock)  WHERE Rank = @Rank
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取用户等级详细信息 */

CREATE PROCEDURE [dbo].[spb_UserRanks_Get]
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

Select 
	spb_UserRanks.* FROM spb_UserRanks with (nolock)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_ForumThreadExchange_GetExchanges]
(
@ThreadID int
)
AS
set nocount on
BEGIN
 select * from spb_ForumThreadExchanges with (nolock) where ThreadID=@ThreadID 
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_ForumThreadExchange_Create]
(
@ThreadID int,
@UserID int,
@Price int,
@UserDisplayName nvarchar(256)
)
AS
set nocount on
BEGIN
	INSERT INTO [spb_ForumThreadExchanges]
           ([ThreadID]
           ,[UserID]
           ,[UserDisplayName]
           ,[Price])
     VALUES
           (@ThreadID, 
           @UserID,
           @UserDisplayName,
           @Price)
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_ForumThreadExchange_DeleteExchanges]
(
@ThreadID int
)
AS
set nocount on
BEGIN
 DELETE FROM spb_ForumThreadExchanges WHERE ThreadID=@ThreadID 
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有通知项集合 **/

CREATE PROCEDURE [dbo].[spb_NoticeItems_GetAll] 
(
	@userType int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if(@userType=1)
	begin
		SELECT     N.*
		FROM       spb_NoticeItems AS N WITH (NOLOCK),spb_Applications as A WITH (NOLOCK)
		WHERE		N.ApplicationID=A.ApplicationID and A.IsEnabled=1 and N.AllowPersonUser=1			 
		ORDER BY   N.DisplayOrder
	end
else if(@userType=2)
	begin
		SELECT     N.*
		FROM         spb_NoticeItems AS N WITH (NOLOCK), spb_Applications as A WITH (NOLOCK)
		WHERE N.ApplicationID=A.ApplicationID and A.IsEnabled=1	and N.AllowCompanyUser=1		 
		ORDER BY   N.DisplayOrder
	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除ForumPostAttachment */

CREATE PROCEDURE [dbo].[spb_ForumPostAttachment_Delete] 
(
    @AttachmentID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

delete spb_ForumPostAttachments where AttachmentID = @AttachmentID
delete spb_ForumPostAttachmentExchanges where AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--创建帖子附件交易记录
CREATE PROCEDURE [dbo].[spb_ForumPostAttachmentExchange_Create]
(
	@AttachmentID	int,
	@UserID	int,
	@UserDisplayName	nvarchar(256)='',
	@Price	int
)
AS
set nocount on
BEGIN
	INSERT INTO spb_ForumPostAttachmentExchanges
                      (AttachmentID, UserID, UserDisplayName, Price, DateCreated)
VALUES     (@AttachmentID,@UserID,@UserDisplayName,@Price, GETDATE())
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--获取帖子附件交易记录集合
CREATE PROCEDURE [dbo].[spb_ForumPostAttachmentExchanges_Get]
(
	@AttachmentID	int
)
AS
set nocount on
BEGIN
	SELECT     AttachmentID, UserID, UserDisplayName, Price, DateCreated
FROM         spb_ForumPostAttachmentExchanges with (nolock)
WHERE     (AttachmentID = @AttachmentID)
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除ForumThreadAttachment */

CREATE PROCEDURE [dbo].[spb_ForumPostAttachments_DeleteByPostID] 
(
    @PostID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
delete spb_ForumPostAttachmentExchanges where AttachmentID 
in (select AttachmentID from spb_ForumPostAttachments with (nolock) where PostID = @PostID )

delete spb_ForumPostAttachments where PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除ForumPostAttachments */

CREATE PROCEDURE [dbo].[spb_ForumPostAttachments_DeleteBySectionID] 
(
    @SectionID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select PostID from spb_ForumPostAttachments with (nolock) where SectionID = @SectionID

delete spb_ForumPostAttachmentExchanges where AttachmentID 
in (select AttachmentID from spb_ForumPostAttachments with (nolock) where SectionID = @SectionID)

delete spb_ForumPostAttachments where SectionID = @SectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除Theme **/

CREATE PROCEDURE [dbo].[spb_Theme_Delete] 
(
    @PresentAreaID	int,
    @DirectoryName	nvarchar(32)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
 
BEGIN TRANSACTION

delete from spb_WidgetsInZones where ZoneID in (select ZoneID from spb_WidgetZones where PresentAreaID=@PresentAreaID and Theme=@DirectoryName) 
IF (@@ERROR <> 0) GOTO Failure

delete from spb_WidgetZones where PresentAreaID=@PresentAreaID and Theme=@DirectoryName
IF (@@ERROR <> 0) GOTO Failure

delete from spb_LayoutPages where PresentAreaID=@PresentAreaID and Theme=@DirectoryName
IF (@@ERROR <> 0) GOTO Failure

delete from spb_ThemeAppearances where PresentAreaID=@PresentAreaID and Theme=@DirectoryName
IF (@@ERROR <> 0) GOTO Failure

delete from spb_Themes where PresentAreaID=@PresentAreaID and DirectoryName=@DirectoryName
IF (@@ERROR <> 0) GOTO Failure

COMMIT TRANSACTION
RETURN

Failure:
	ROLLBACK TRANSACTION
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建ThemeAppearance **/

CREATE PROCEDURE [dbo].[spb_ThemeAppearance_CreateDelete] 
(
    @Action int,
    @PresentAreaID	int,
    @Theme	nvarchar(32),
    @DirectoryName	nvarchar(32),
    @Title	nvarchar(64) = '',
    @Description	nvarchar(1024) = '',
    @CssFileName	nvarchar(256) = '',
    @PreviewImage	nvarchar(256) = null,
    @PreviewLargeImage	nvarchar(256) = '',
    @LogoUrl nvarchar(256)='',
    @Roles	nvarchar(256) = '',
    @RequiredRank	int = 0,
    @TypeName	nvarchar(64) = '',
    @Author	nvarchar(128) = '',
    @Copyright	nvarchar(256) = '',
    @ThemeVersion	nvarchar(32) = '',
    @ForProductVersion	nvarchar(32) = '',
    @DateCreated	nvarchar(32) = '',
    @DisplayOrder int = 0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if(@Action=0) --添加
begin
    if exists (select DirectoryName from spb_ThemeAppearances with (nolock) where PresentAreaID=@PresentAreaID and Theme=@Theme and DirectoryName=@DirectoryName)
        update spb_ThemeAppearances set Title=@Title, [Description]=@Description,CssFileName=@CssFileName,PreviewImage=@PreviewImage,PreviewLargeImage=@PreviewLargeImage,LogoUrl=@LogoUrl,
            Roles=@Roles,RequiredRank=@RequiredRank,TypeName=@TypeName,Author=@Author,Copyright=@Copyright,ThemeVersion=@ThemeVersion,
            ForProductVersion=@ForProductVersion,DateCreated=@DateCreated,DisplayOrder=@DisplayOrder where PresentAreaID=@PresentAreaID and Theme=@Theme and DirectoryName=@DirectoryName
    else
        insert into spb_ThemeAppearances (PresentAreaID,Theme,DirectoryName,Title,[Description],CssFileName,PreviewImage,PreviewLargeImage,LogoUrl, Roles,RequiredRank,TypeName,Author,Copyright,ThemeVersion,ForProductVersion,DateCreated,DisplayOrder)
            values (@PresentAreaID,@Theme,@DirectoryName,@Title,@Description,@CssFileName,@PreviewImage,@PreviewLargeImage,@LogoUrl,@Roles,@RequiredRank,@TypeName,@Author,@Copyright,@ThemeVersion,@ForProductVersion,@DateCreated,@DisplayOrder) 
end
else if(@Action = 2)  --删除
    delete from spb_ThemeAppearances where PresentAreaID=@PresentAreaID and Theme=@Theme and DirectoryName=@DirectoryName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取启用的ThemeAppearance **/

CREATE PROCEDURE [dbo].[spb_ThemeAppearances_GetEnabled] 
(
    @PresentAreaID	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select A.* from spb_ThemeAppearances A with (nolock) inner join spb_Themes T with (nolock)
    on A.PresentAreaID=T.PresentAreaID and A.Theme=T.DirectoryName 
    where A.PresentAreaID=@PresentAreaID order by A.DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取ThemeAppearance **/

CREATE PROCEDURE [dbo].[spb_ThemeAppearance_Get] 
(
    @PresentAreaID	int,
    @Theme	nvarchar(32),
    @DirectoryName	nvarchar(32)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_ThemeAppearances with (nolock) where PresentAreaID=@PresentAreaID and Theme=@Theme and DirectoryName=@DirectoryName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取ThemeAppearance **/

CREATE PROCEDURE [dbo].[spb_ThemeAppearance_GetByTheme] 
(
    @PresentAreaID	int,
    @Theme	nvarchar(32)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_ThemeAppearances with (nolock) where PresentAreaID=@PresentAreaID and Theme=@Theme order by DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 启用/禁用 ThemeAppearance **/

CREATE PROCEDURE [dbo].[spb_ThemeAppearance_SetEnabled] 
(
    @PresentAreaID	int,
    @Theme	nvarchar(32),
    @DirectoryName	nvarchar(32),
    @IsEnabled	bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
update spb_ThemeAppearances set IsEnabled=@IsEnabled 
    where PresentAreaID=@PresentAreaID and Theme=@Theme and DirectoryName=@DirectoryName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 创建、删除微博大屏幕 */
CREATE PROCEDURE [dbo].[spb_MicroBlogScreen_CreateDelete] 
(
    @Action int,
	@ScreenID int output,
	@ScreenName nvarchar(64) = '''',
	@UserID Int = 0,
	@Keyword nvarchar(150) = '''',
	@IsFilter bit = 0,
	@IsDeadline bit = 0,
	@IsPause bit = 0,
	@StartDate datetime = '''',
	@EndDate datetime = '''',
	@AuditingStatus int = 40
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if @Action = 0
Begin
	insert into spb_MicroBlogScreens(ScreenName,UserID,Keyword,IsFilter,IsDeadline,StartDate,EndDate,AuditingStatus)
	values (@ScreenName,@UserID,@Keyword,@IsFilter,@IsDeadline,@StartDate,@EndDate,@AuditingStatus)
	select @ScreenID = SCOPE_IDENTITY()
End
else if @Action = 1 
Begin
	Update spb_MicroBlogScreens
	Set ScreenName = @ScreenName,Keyword = @Keyword,IsFilter = @IsFilter,IsDeadline = @IsDeadline,
	IsPause = @IsPause,StartDate = @StartDate,EndDate = @EndDate
	Where ScreenID = @ScreenID
End
else if  @Action = 2
	delete from spb_MicroBlogScreens where ScreenID = @ScreenID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取大屏幕 */

Create PROCEDURE [dbo].[spb_MicroBlogScreen_Get] 
(
	@ScreenID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_MicroBlogScreens with (nolock) where ScreenID = @ScreenID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置微博大屏幕的审核状态 */
Create PROCEDURE [dbo].[spb_MicroBlogScreen_UpdateAuditingStatus]
( 
    @ScreenID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_MicroBlogScreens set AuditingStatus= @AuditingStatus where ScreenID=@ScreenID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建NewsAttachment  **/

CREATE PROCEDURE [dbo].[spb_NewsAttachment_Create] 
(
    @AttachmentID int out,
    @ThreadID int,
	@SectionID int,
	@UserID int,
    @FileName nvarchar(512) ,
    @FriendlyFileName nvarchar(512),
	@ContentType nvarchar(64),
 	@ContentSize int ,
    @Height int,
    @Width int,
	@IsRemote bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

INSERT spb_NewsAttachments (ThreadID,SectionID,UserID,FileName,FriendlyFileName,ContentType,ContentSize,Height,Width,IsRemote)
		values (@ThreadID,@SectionID,@UserID,@FileName,@FriendlyFileName,@ContentType,@ContentSize,@Height,@Width,@IsRemote)

SELECT @AttachmentID = SCOPE_IDENTITY()
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除NewsThreadAttachment */

CREATE PROCEDURE [dbo].[spb_NewsAttachment_Delete] 
(
    @AttachmentID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

delete spb_NewsAttachments where AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据AttachmentID获取NewsThreadAttachment */

CREATE PROCEDURE [dbo].[spb_NewsAttachment_Get]
(
    @AttachmentID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_NewsAttachments WITH (NOLOCK)
WHERE 
    AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ThreadID获取NewsThreadAttachment */

CREATE PROCEDURE [dbo].[spb_NewsAttachments_GetByThreadID]
(
    @ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_NewsAttachments WITH (NOLOCK)
WHERE 
    ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除NewsThreadAttachment */

CREATE PROCEDURE [dbo].[spb_NewsAttachments_DeleteBySectionID] 
(
    @SectionID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select ThreadID from spb_NewsAttachments WITH (NOLOCK) where SectionID = @SectionID

delete spb_NewsAttachments where SectionID = @SectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_NewsAttachment_UpdateAssociateID]
(
    @AttachmentID int,
    @AssociateID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_NewsAttachments set
	ThreadID=@AssociateID
WHERE 
    AttachmentID=@AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 合并spb_NewsSections */

CREATE PROCEDURE [dbo].[spb_NewsSections_Merge] 
(
    @fromSectionID int ,
    @toSectionID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @childCount int
declare @oldParentID int
declare @ThreadCount int
declare @CommentCount int
select @childCount=ChildCount,@oldParentID=ParentID,@ThreadCount=ThreadCount,@CommentCount=CommentCount from spb_NewsSections WITH (NOLOCK) where SectionID=@fromSectionID

--更新新类的ChildCount
update spb_NewsSections set ChildCount=ChildCount+@childCount,ThreadCount = ThreadCount + @ThreadCount,CommentCount = CommentCount + @CommentCount where SectionID=@toSectionID

update spb_NewsSections set ChildCount=ChildCount-1 where SectionID=@oldParentID

Update spb_NewsThreads set SectionID=@toSectionID where SectionID=@fromSectionID
Update spb_NewsAttachments set SectionID=@toSectionID where SectionID=@fromSectionID

delete from spb_NewsSections where SectionID=@fromSectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除NewsThreadAttachment */

CREATE PROCEDURE [dbo].[spb_NewsAttachments_DeleteByThreadID] 
(
    @ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

delete spb_NewsAttachments where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsTemporaryAttachmentIDs_GetByUserID]
(
    @UserID int,
    @OwnerID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
IF @OwnerID is Null
	SELECT * FROM spb_NewsAttachments with (nolock) WHERE UserID =@UserID  and ThreadID<=0
ELSE
	SELECT * FROM spb_NewsAttachments with (nolock) WHERE UserID =@UserID  and ThreadID<=0 and SectionID=@OwnerID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_WidgetInstances_UserInitialize]
(
    @OwnerID int,
    @PageCode char(4),
    @Theme nvarchar(32)
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@OwnerID<>0)
begin
    Begin transaction
    delete from spb_LayoutPages where OwnerID=@OwnerID and PageCode=@PageCode and Theme=@Theme
    if(@@error<>0) goto Failure
    
    delete from spb_WidgetsInZones where OwnerID=@OwnerID and ZoneID in 
        (select ZoneID from spb_WidgetZones where PageCode=@PageCode and Theme=@Theme)
    if(@@error<>0) goto Failure 
    
    insert into spb_WidgetsInZones (WidgetID,OwnerID,ZoneID,WidgetXml,DisplayOrder)
      (select W.WidgetID,@OwnerID,W.ZoneID,W.WidgetXml,W.DisplayOrder from spb_WidgetsInZones W with (nolock) inner join spb_WidgetZones Z with (nolock)
          on W.ZoneID = Z.ZoneID where W.OwnerID=0 and Z.PageCode=@PageCode and Z.Theme=@Theme)
    if(@@error<>0) goto Failure
    
    commit transaction
    return
    
    Failure:
    rollback transaction
    return
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 保存用户或圈子的LayoutPage **/

CREATE PROCEDURE [dbo].[spb_LayoutPage_SaveAsOwner] 
(
    @OwnerID	int,
    @Theme	nvarchar(32),
    @PageCode	char(4),
    @LayoutMode	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if exists (select * from spb_LayoutPages with (nolock) where PageCode=@PageCode and Theme=@Theme and OwnerID=@OwnerID)
    update spb_LayoutPages set LayoutMode=@LayoutMode where PageCode=@PageCode and Theme=@Theme and OwnerID=@OwnerID
else
begin
    declare @PageName nvarchar(128)
    declare @Description nvarchar(1024)
    declare @PresentAreaID int
    
    if exists (select * from spb_LayoutPages with (nolock) where PageCode=@PageCode and Theme=@Theme and OwnerID=0)
    begin
        select @PageName=PageName,@Description=[Description],@PresentAreaID=PresentAreaID from spb_LayoutPages with (nolock) where PageCode=@PageCode and Theme=@Theme and OwnerID=0
        
		INSERT INTO spb_LayoutPages
							  (PageCode, Theme, OwnerID, PresentAreaID, PageName, LayoutMode, Description)
		VALUES     (@PageCode,@Theme,@OwnerID,@PresentAreaID,@PageName,@LayoutMode,@Description)
    end
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户或圈子的Layout **/

CREATE PROCEDURE [dbo].[spb_LayoutPage_GetOwnerLayout] 
(
    @OwnerID	int,
    @Theme	nvarchar(32),
    @PageCode	char(4)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if exists (select * from spb_LayoutPages with (nolock) where PageCode=@PageCode and Theme=@Theme and OwnerID=@OwnerID)
    select LayoutMode from spb_LayoutPages with (nolock) where PageCode=@PageCode and Theme=@Theme and OwnerID=@OwnerID
else
    select LayoutMode from spb_LayoutPages with (nolock) where PageCode=@PageCode and Theme=@Theme and OwnerID=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建LayoutPage **/

CREATE PROCEDURE [dbo].[spb_LayoutPage_Create] 
(
    @PageCode	char(4),
    @Theme	nvarchar(32),
    @OwnerID	int,
    @PresentAreaID	int,
    @PageName	nvarchar(128),
    @LayoutMode	int,
    @Description	nvarchar(1024)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON


insert into spb_LayoutPages (PageCode,Theme,OwnerID,PresentAreaID,PageName,LayoutMode,[Description])
    values (@PageCode,@Theme,@OwnerID,@PresentAreaID,@PageName,@LayoutMode,@Description)
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_WidgetInstances_RestoreDefault]
(
    @OwnerID int,
    @PageCode char(4),
    @Theme nvarchar(32)
    
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@OwnerID<>0)
begin
    delete from spb_LayoutPages where OwnerID=@OwnerID and PageCode=@PageCode and Theme=@Theme
    delete from spb_WidgetsInZones where OwnerID=@OwnerID and ZoneID in 
        (select ZoneID from spb_WidgetZones where PageCode=@PageCode and Theme=@Theme)
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_club_SharedClubIDs_Get]
(
@detailsUrl nvarchar(400)
)
AS
BEGIN
	SET NOCOUNT ON;
	SELECT [ClubID] FROM [spb_ClubSharedContents] with (nolock) WHERE [DetailsUrl] = @detailsUrl
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_club_SharedContents_SetEssential]
(@contentID int,
@isEssential bit)
AS
BEGIN
	SET NOCOUNT ON;
	UPDATE [spb_ClubSharedContents] SET [IsEssential]=@isEssential WHERE [ContentID]=@contentID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_club_SharedContents_Delete]
(	
	@contentID int
)
AS
BEGIN
	SET NOCOUNT ON;
	DELETE FROM [spb_ClubSharedContents] WHERE ContentID = @contentID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_club_SharedContents_Create]
(@ContentID int OUTPUT,
@ClubID int,
@ApplicationID int,
@Subject nvarchar(256),
@Body nvarchar(2048),
@ThumbnailUrl nvarchar(512),
@DetailsUrl nvarchar(400),
@Author nvarchar(64),
@AuthorUserID int,
@Sharer nvarchar(64),
@SharerUserID int,
@IsEssential bit,
@SpecialOrder int,
@StickyDate datetime,
--@AuditingStatus int,
@PropertyNames ntext= null,
@PropertyValues ntext= null)
AS
BEGIN
	SET NOCOUNT ON;
if (select count(*) from spb_ClubSharedContents with (nolock) where ClubID=@ClubID and DetailsUrl=@DetailsUrl) = 0
begin

INSERT INTO [spb_ClubSharedContents]
           ([ClubID]
           ,[ApplicationID]
           ,[Subject]
           ,[Body]
           ,[ThumbnailUrl]
           ,[DetailsUrl]
           ,[Author]
           ,[AuthorUserID]
           ,[Sharer]
           ,[SharerUserID]
           ,[IsEssential]
           ,[SpecialOrder]
           ,[StickyDate]
--           ,[AuditingStatus]
           ,[PropertyNames]
           ,[PropertyValues])
     VALUES
           (@ClubID,
           @ApplicationID,
           @Subject,
           @Body,
           @ThumbnailUrl,
           @DetailsUrl,
           @Author,
           @AuthorUserID,
           @Sharer,
           @SharerUserID,
           @IsEssential,
           @SpecialOrder,
           @StickyDate,
--           @AuditingStatus,
           @PropertyNames,
           @PropertyValues)
   SET @ContentID = SCOPE_IDENTITY();           
   return 1
END
  return 0
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_club_SharedContents_SetSticky]
(@contentID int,
@specialOrder int)
AS
BEGIN
	SET NOCOUNT ON;
	UPDATE [spb_ClubSharedContents] SET [SpecialOrder]=@specialOrder WHERE [ContentID]=@contentID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_club_SharedContent_Get]
(
@contentID int
)
AS
BEGIN
	SET NOCOUNT ON;
	SELECT * FROM [spb_ClubSharedContents] with (nolock) WHERE [ContentID]=@contentID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户并删除分享的内容以及他在圈子当中的成员身份 */

CREATE PROCEDURE [dbo].[spb_Club_DeleteUserShareContentsAndMember]
( 
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END


BEGIN TRANSACTION
  
  delete from spb_ClubMembers where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  delete from spb_ClubSharedContents where SharerUserID=@UserID or AuthorUserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure
  delete from spb_ClubUserDatas where UserID=@UserID
  IF (@@ERROR <> 0) GOTO Failure

COMMIT TRANSACTION
SELECT 1 -- Success
RETURN


Failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_SiteCategorieNameRes_Get]
(
    @CategoryID int
)
as
select * from spb_SiteCategories_Res where CategoryID = @CategoryID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_SiteCategorieNameRes_Update]
(
    @CategoryID int,
    @LanguageCode varchar(20)='',
    @Name nvarchar(128)=''
)
as
if exists(select * from spb_SiteCategories_Res where CategoryID=@CategoryID and LanguageCode=@LanguageCode)
Update spb_SiteCategories_Res Set Name=@Name Where CategoryID=@CategoryID and LanguageCode=@LanguageCode
else
Insert into spb_SiteCategories_Res(CategoryID,LanguageCode,Name) values(@CategoryID,@LanguageCode,@Name)
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_UserShareThread_CreateUpdateDelete]
(
    @UserThreadID int output,
    @ThreadID int=0,
    @UserID int=0,
    @Author nvarchar(64) = '',
    @Body nvarchar(512)= '',
    @PrivacyStatus int = null,
    @UserHostAddress nvarchar(64)=N'000.000.000.000',
    @Action int,
	@PropertyNames ntext = null,
	@PropertyValues ntext = null
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
    
    if(@Action=0) --添加
    Begin
        Begin Transaction
			INSERT INTO spb_UserShareThreads
								  (ThreadID, UserID, Author, Body, PrivacyStatus, UserHostAddress, PropertyNames, PropertyValues)
			VALUES     (@ThreadID,@UserID,@Author,@Body,@PrivacyStatus,@UserHostAddress,@PropertyNames,@PropertyValues) 
			
			if(@@error<>0) goto FAILURE 
			            
			set @UserThreadID=SCOPE_IDENTITY()

            update spb_ShareThreads
            set UserCount=UserCount+1,DayUserCount=DayUserCount+1,StageUserCount=StageUserCount+1
            where ThreadID=@ThreadID
            if(@@error<>0) goto FAILURE 
            
          commit transaction
          return
          
          FAILURE:
          rollback transaction
          return
    End
    else if(@Action=1) --更新
    Begin
        Update spb_UserShareThreads
        set Body=@Body,PrivacyStatus=@PrivacyStatus,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
        Where UserThreadID=@UserThreadID
    End
    else if(@Action=2) --删除
    Begin
		if not exists (select * from spb_UserShareThreads with (nolock) where UserThreadID = @UserThreadID)
		   return   
        Begin Transaction   
            delete from spb_ShareComments where UserThreadID = @UserThreadID
            IF(@@error<>0) goto Failures
            
            select @UserID=userID from spb_UserShareThreads where UserThreadID = @UserThreadID
            
            delete  from spb_UserShareThreads where UserThreadID = @UserThreadID
            IF(@@error<>0) goto Failures
            
            declare @userCount int
            declare @fristShareUserID int
            select @userCount=2
            select @userCount=userCount,@fristShareUserID=userID from spb_ShareThreads with (nolock) where ThreadID=@ThreadID            
            
            if (@userCount<=1)
            Begin
                delete from spb_ShareThreads where ThreadID=@ThreadID
                IF(@@error<>0) goto Failures
                
                delete from spb_ShareComments where ThreadID=@ThreadID
                IF(@@error<>0) goto Failures
            end
            
            if(@userID=@fristShareUserID)
            Begin
				declare @newUserID int
				declare @newAuthor nvarchar(36)
				declare @newPrivacyStatus int
				SELECT TOP 1 @newUserID = UserID,@newAuthor=author,@newPrivacyStatus=PrivacyStatus from spb_UserShareThreads with (nolock) where ThreadID=@ThreadID
                update spb_ShareThreads set userID = @newUserID,author=@newAuthor,PrivacyStatus=@newPrivacyStatus where ThreadID=@ThreadID
				IF(@@error<>0) goto Failures
            End
            
            update spb_ShareThreads
            set UserCount=UserCount-1,DayUserCount=DayUserCount-1,StageUserCount=StageUserCount-1
            where ThreadID=@ThreadID
            IF(@@error<>0) goto Failures
            
        Commit Transaction
        return
        
        Failures:
        rollback Transaction
        return
    End
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
分享统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Share_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--1.更新spb_Applications表
DECLARE @TotalCount INT
DECLARE @CountInPast24Hours INT
DECLARE @NewestID INT

DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate() - 1,120)

SELECT @TotalCount=COUNT(ThreadID) FROM spb_ShareThreads with (nolock)
SELECT @CountInPast24Hours=COUNT(*) FROM spb_ShareThreads with (nolock) WHERE DateCreated > @currentDate
SELECT @NewestID=isnull(MAX(ThreadID),0) FROM spb_ShareThreads with (nolock)

UPDATE spb_Applications SET TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
  WHERE (ApplicationID = 261)
  
--2.更新spb_SiteCategories表
declare @CategoryID int
DECLARE Categories_Cursor CURSOR FOR
SELECT CategoryID FROM spb_SiteCategories with (nolock) WHERE (ApplicationID = 261)
	
OPEN Categories_Cursor
FETCH NEXT FROM Categories_Cursor INTO @CategoryID
	
WHILE @@FETCH_STATUS = 0
    BEGIN	
    update spb_SiteCategories  
    set    ItemCount = (select count(*) from spb_ShareThreads with (nolock) where SiteCategoryID = @CategoryID and AuditingStatus=40 )
    where  CategoryID = @CategoryID

	FETCH NEXT FROM Categories_Cursor INTO @CategoryID
		
	END
	
CLOSE Categories_Cursor
DEALLOCATE Categories_Cursor
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
Create procedure [dbo].[spb_ShareThread_Delete]
(
    @ThreadID int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
    begin Transaction
        delete from spb_ShareThreads where ThreadID=@ThreadID
        if(@@error<>0) goto failure
        delete from spb_UserShareThreads where ThreadID=@ThreadID
        if(@@error<>0) goto failure
        delete from spb_ShareComments where ThreadID=@ThreadID
        if(@@error<>0) goto failure
    commit Transaction
    return
    failure:
    rollback transaction
    return
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure [dbo].[spb_ShareThread_Get]
(
    @ThreadID int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
    select * from spb_ShareThreads with (nolock) where ThreadID=@ThreadID
end
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_ShareThread_UrlSaltIsExist]
(
    @ThreadID int=0 output,
    @URLSalt nvarchar(16)=''
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
   select @ThreadID=ThreadID from spb_ShareThreads with (nolock) where URLSalt=@URLSalt
   if @ThreadID <> null and @ThreadID > 0
        select 1
    else
        select 0
        if @ThreadID = null
        select @ThreadID = 0
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
/**更行日,周,总浏览数**/

CREATE procedure [dbo].[spb_ShareThreadView_Add]
(
    @ItemID int = 0,
    @WebViewCount int = 0 
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_ShareThreads
set HitTimes=HitTimes + @WebViewCount,StageHitTimes=StageHitTimes + @WebViewCount,DayHitTimes=DayHitTimes+@WebViewCount
where ThreadID=@ItemID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_ShareThread_CreateUpdate]
(
    @ThreadID int=0 output,
    @UserID int=0,
    @Author nvarchar(64)='',
    @URL nvarchar(512)='',
    @URLSalt nvarchar(16)='',
    @Subject nvarchar(256)='',
    @Body ntext='',
    @ThumbnailUrl nvarchar(512)='',
    @SiteCategoryID int=0,
    @MediaType int = 0,
    @ApplicationID int=0,
    @PrivacyStatus int=30,
    @AuditingStatus int=40,
	@PropertyNames ntext = null,
	@PropertyValues ntext = null,
	@BackerCount int = 0,
	@DissenterCount int = 0,
    @Action int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
    if(@Action=0) --添加
    Begin
        if not exists (select URLSalt from spb_ShareThreads with (nolock) where URLSalt=@URLSalt)
        Begin
            Insert into spb_ShareThreads(URL,URLSalt,UserID,Author,Subject,Body,ThumbnailUrl,SiteCategoryID,MediaType,ApplicationID,AuditingStatus,PrivacyStatus,PropertyNames,PropertyValues)
            values (@URL,@URLSalt,@UserID,@Author,@Subject,@Body,@ThumbnailUrl,@SiteCategoryID,@MediaType,@ApplicationID,@AuditingStatus,@PrivacyStatus,@PropertyNames,@PropertyValues)
            select @ThreadID = SCOPE_IDENTITY()
            select 1
            return
        End
        else
            select 2
            return
        select 0
    End
    else if(@Action=1) --更新
    Begin
    UPDATE spb_ShareThreads
    SET URL=@Url,Subject = @Subject,UserID=@UserID, Body = @Body,URLSalt=@URLSalt,ThumbnailUrl=@ThumbnailUrl,BackerCount=@BackerCount,DissenterCount=@DissenterCount,
    SiteCategoryID=@SiteCategoryID,MediaType=@MediaType,ApplicationID=@ApplicationID,AuditingStatus=@AuditingStatus,PrivacyStatus=@PrivacyStatus,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
    WHERE ThreadID = @ThreadID
        select 3
        return
    End
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_ShareComment_Create]
(
    @CommentID int output,
    @ParentID int=0,
    @ThreadID int=0,
    @UserThreadID int=0,
    @OwnerUserID int=0,
    @UserID int=0,
    @Author nvarchar(64)='',
    @Body nvarchar(2000)='',
    @AuditingStatus int=40,
    @UserHostAddress nvarchar(64)=N'000.000.000.000',
    @PropertyNames ntext=null,
    @PropertyValues ntext=null
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
    Insert into spb_ShareComments (ParentID,ThreadID,UserThreadID,OwnerUserID,UserID,Author,Body,AuditingStatus,UserHostAddress,PropertyNames,PropertyValues)
    values(@ParentID,@ThreadID,@UserThreadID,@OwnerUserID,@UserID,@Author,@Body,@AuditingStatus,@UserHostAddress,@PropertyNames,@PropertyValues)
    set @CommentID = SCOPE_IDENTITY()
    update spb_ShareThreads
    set CommentCount=CommentCount+1
    where ThreadID=@ThreadID
    if(@UserThreadID>0)
    begin
        update spb_UserShareThreads
        set CommentCount=CommentCount+1
        where UserThreadID=@UserThreadID
    End
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_ShareComment_Delete]
(
    @CommentID int = 0,
    @ThreadID int = 0,
    @UserThreadID int = 0
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
    if not exists (select * from spb_ShareComments with (nolock) where CommentID=@CommentID)
    return
    Begin Transaction
         delete from spb_ShareComments where CommentID=@CommentID
         if(@@error<>0) goto failure
         update spb_ShareThreads 
         set CommentCount=CommentCount-1
         where ThreadID=@ThreadID
         if(@@error<>0) goto failure
         if(@UserThreadID>0)
         Begin
            update spb_UserShareThreads
            set CommentCount=CommentCount-1
            where UserThreadID=@UserThreadID
            if(@@error<>0) goto failure
         End
    commit transaction
    return
    failure:
    rollback transaction
    return
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_ShareThread_UpdateAuditingStatus]
(
    @AuditingStatus int=40,
    @ThreadID int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
    update spb_ShareThreads
    set AuditingStatus=@AuditingStatus
    where ThreadID=@ThreadID
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台分享统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_ShareManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingCommentCount int out
)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
	
select @PendingThreadCount= count(ThreadID) from spb_ShareThreads with (nolock) where AuditingStatus=20
select @AgainThreadCount=count(ThreadID) from spb_ShareThreads with (nolock) where AuditingStatus=30
select @PendingCommentCount=count(CommentID) from spb_ShareComments  with(nolock) where AuditingStatus=20
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、用户统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_User_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

    --统计总用户数、24小时新增用户数
    DECLARE @TotalCount INT
    DECLARE @CountInPast24Hours INT
    DECLARE @NewestID INT

	DECLARE @currentDate datetime
	set @currentDate = convert(char(10),getdate() - 1,120)

    SELECT @TotalCount=COUNT(*) FROM spb_Users with (nolock)
    SELECT @CountInPast24Hours=COUNT(*) FROM spb_Users with (nolock) WHERE DateCreated > @currentDate
    SELECT @NewestID=isnull(MAX(UserID),0) FROM spb_Users with (nolock)

    UPDATE    spb_Applications
    SET       TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
    WHERE     (ApplicationID = 11)
	
	Update spb_UserPointStatisticsPerDay
	Set BasicPoints = 0,ReportPoints = 0,CreditPoints = 0,TradePoints = 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 添加、修改、删除UserPointRecord **/
CREATE PROCEDURE [dbo].[spb_UserPointRecord_CreateUpdateDelete]
(
    @Action int,
    @RecordID int = 0,
    @UserID int = 0,
    @ItemID int = 0,
    @PointCategory	smallint = 0,
    @PointItemName nvarchar(64) = 0,
    @Points float = 0,
    @IsIncome	bit	= 1,
    @Description nvarchar(521) = ''
)
	
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if @Action = 2 --删除记录
    delete from spb_UserPointRecords where RecordID = @RecordID
else
begin 
	declare @BasicPointQuota int,@ReportPointQuota int,@CreditPointQuota int,@TradePointQuota int
	Declare @isLimits int
	Set @isLimits = 1
	Select @BasicPointQuota = BasicPointQuota,@ReportPointQuota = ReportPointQuota,@CreditPointQuota = CreditPointQuota,@TradePointQuota = TradePointQuota
	From spb_UserPointItemRules with (nolock) Where ItemID = @ItemID
    if @Action = 0
        begin  
			if(@PointCategory = 11 and @BasicPointQuota > 0 and @ItemID > 0)
			Begin
				if(select BasicPoints from spb_UserPointStatisticsPerDay where UserID = @UserID and ItemID = @ItemID) >= @BasicPointQuota 
				Begin    
					Set @isLimits = 0
				End
				ELSE
				BEGIN
					if exists (select UserID from spb_UserPointStatisticsPerDay where UserID = @UserID and ItemID = @ItemID)
					Begin
						Update spb_UserPointStatisticsPerDay
						Set BasicPoints = BasicPoints + @Points
						Where ItemID = @ItemID and UserID = @UserID
					End
					else
					Begin
						insert into spb_UserPointStatisticsPerDay(UserID,ItemID,BasicPoints) values (@UserID,@ItemID,@Points)
					End
				eND
			End
			else if(@PointCategory = 21 and @TradePointQuota > 0 and @ItemID > 0)
			Begin
				if(select TradePoints from spb_UserPointStatisticsPerDay where UserID = @UserID and ItemID = @ItemID) >= @TradePointQuota 
				Begin
					Set @isLimits = 0
				End
				else
				Begin
					if exists (select UserID from spb_UserPointStatisticsPerDay where UserID = @UserID and ItemID = @ItemID)
					Begin
						Update spb_UserPointStatisticsPerDay
						Set TradePoints = TradePoints + @Points
						Where ItemID = @ItemID and UserID = @UserID
					End
					else
					Begin
						insert into spb_UserPointStatisticsPerDay(UserID,ItemID,TradePoints) values (@UserID,@ItemID,@Points)
					End
				End
			End
			else if(@PointCategory = 41 and @ReportPointQuota > 0 and @ItemID > 0)
			Begin
				if(select ReportPoints from spb_UserPointStatisticsPerDay where UserID = @UserID and ItemID = @ItemID) >= @ReportPointQuota 
				Begin
					Set @isLimits = 0
			    End
			    ELSE
			    Begin
					if exists (select UserID from spb_UserPointStatisticsPerDay where UserID = @UserID and ItemID = @ItemID)
					Begin
						Update spb_UserPointStatisticsPerDay
						Set ReportPoints = ReportPoints + @Points
						Where ItemID = @ItemID and UserID = @UserID
					End
					else
					Begin
						insert into spb_UserPointStatisticsPerDay(UserID,ItemID,ReportPoints) values (@UserID,@ItemID,@Points)
					End
				END
			End
			else if(@PointCategory = 51 and @CreditPointQuota > 0 and @ItemID > 0)
			Begin
				if(select CreditPoints from spb_UserPointStatisticsPerDay where UserID = @UserID and ItemID = @ItemID) >= @CreditPointQuota 
				Begin
					Set @isLimits = 0
				End
				ELSE
				BEGIN
					if exists (select UserID from spb_UserPointStatisticsPerDay where UserID = @UserID and ItemID = @ItemID)
					Begin
						Update spb_UserPointStatisticsPerDay
						Set CreditPoints = CreditPoints + @Points
						Where ItemID = @ItemID and UserID = @UserID
					End
					else
					Begin
						insert into spb_UserPointStatisticsPerDay(UserID,ItemID,CreditPoints) values (@UserID,@ItemID,@Points)
					End
				END
			End
			if(@isLimits > 0)
			Begin
				insert into spb_UserPointRecords (UserID,PointCategory,PointItemName,Points,IsIncome,Description) values (@UserID,@PointCategory,@PointItemName,@Points,@IsIncome,@Description)
			End
			
			select @isLimits
        End
    else
        update spb_UserPointRecords set Points = @Points,Description = @Description where RecordID = @RecordID
end
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
/**每天执行的任务**/
Create procedure [dbo].[spb_Task_Point_PerDay]
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
    update spb_UserPointStatisticsPerDay 
    set BasicPoints=0,ReportPoints=0,CreditPoints=0,TradePoints=0
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取某一位置的广告记录 */

create PROCEDURE [dbo].[spb_Advertisings_GetIDs] 
(
	@PositionCode nvarchar(16),
	@OwnerID int,
	@includeSystem bit
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if @includeSystem=1
	select a.AdvertisingID from spb_Advertisings a with (nolock) inner join spb_AdvertisingsInPositions i with (nolock) on a.AdvertisingID=i.AdvertisingID
	 where i.PositionCode=@PositionCode and (a.OwnerID=@OwnerID or a.presentAreaID = 10)
else
	select a.AdvertisingID from spb_Advertisings a with (nolock) inner join spb_AdvertisingsInPositions i with (nolock) on a.AdvertisingID=i.AdvertisingID
	 where i.PositionCode=@PositionCode and a.OwnerID=@OwnerID and a.presentAreaID <> 10
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 广告 */

CREATE PROCEDURE [dbo].[spb_Advertising_CreateUpdateDelete]
( 
    @Action int,
	@AdvertisingID int output,
	@OwnerID int = 0,
	@AdvertisingName ntext = '',
	@Script ntext = '',
	@PresentAreaID int = 10,
	@AdvertisingType int =0,
	@DisplayTimes int=0,
	@HitTimes int=0,
	@EffectiveDateFrom datetime=null,
	@EffectiveDateTo datetime=null,
	@IsEnabled bit=1,
	@UseredPositions int=0,
	@PropertyNames ntext=null,
	@PropertyValues ntext=null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
        delete from spb_Advertisings where AdvertisingID = @AdvertisingID    --删除

		update spb_AdvertisingPositions set UseredAdvertisings=UseredAdvertisings-1 
			where UseredAdvertisings > 0 and PositionCode in (select PositionCode from spb_AdvertisingsInPositions where AdvertisingID=@AdvertisingID)

		--删除已投放的广告
		delete from spb_AdvertisingsInPositions
			where AdvertisingID=@AdvertisingID
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin
				INSERT INTO [spb_Advertisings] ([OwnerID],[AdvertisingName],[Script],[PresentAreaID],[AdvertisingType],[DisplayTimes],[HitTimes],[EffectiveDateFrom],[EffectiveDateTo],[IsEnabled],[UseredPositions],[PropertyNames],[PropertyValues])
				 VALUES
					   (@OwnerID,@AdvertisingName,@Script,@PresentAreaID,@AdvertisingType,@DisplayTimes,@HitTimes,@EffectiveDateFrom,@EffectiveDateTo,@IsEnabled,@UseredPositions,@PropertyNames,@PropertyValues)

                select @AdvertisingID = SCOPE_IDENTITY()

            end       
         else --更新
            begin
				UPDATE [spb_Advertisings]
				   SET [OwnerID]=@OwnerID
					  ,[AdvertisingName] = @AdvertisingName
					  ,[Script] = @Script
					  ,[PresentAreaID]=@PresentAreaID
					  ,[AdvertisingType]= @AdvertisingType
					  ,	[DisplayTimes]=@DisplayTimes
					  ,	[HitTimes] = @HitTimes
					  ,	[EffectiveDateFrom] = @EffectiveDateFrom
					  ,	[EffectiveDateTo] = @EffectiveDateTo
					  ,[IsEnabled]=@IsEnabled
					  ,[UseredPositions]=@UseredPositions
					  ,[PropertyNames]=@PropertyNames
					  ,[PropertyValues]=@PropertyValues
				 WHERE AdvertisingID = @AdvertisingID
            end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_AdvertisingsInPositions_Update] 
(
	@AdvertisingID int,
	@PositionCode nvarchar(16)=''
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

insert into spb_AdvertisingsInPositions(AdvertisingID, PositionCode)values(@AdvertisingID,@PositionCode)

update spb_AdvertisingPositions set UseredAdvertisings=UseredAdvertisings+1 
	where PositionCode=@PositionCode

update spb_Advertisings set UseredPositions=UseredPositions+1
	where AdvertisingID=@AdvertisingID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取广告 */

CREATE PROCEDURE [dbo].[spb_Advertising_Get] 
(
    @AdvertisingID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_Advertisings with (nolock) where AdvertisingID=@AdvertisingID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 广告位置 */

CREATE PROCEDURE [dbo].[spb_AdvertisingPosition_CreateUpdateDelete]
( 
    @Action int,
	@PositionCode nvarchar(16),
	@PresentAreaID int=10,
	@Width int = 0,
	@Height int = 0,
	@Description nvarchar(512) = '',
	@Maximum int=1,
	@UseredAdvertisings int=0,
	@AllowSystem bit=1,
	@ImageUrl nvarchar(256)=''
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
        delete from spb_AdvertisingPositions where PositionCode = @PositionCode    --删除

		update spb_Advertisings set UseredPositions=UseredPositions-1 
			where AdvertisingID in (select AdvertisingID from spb_AdvertisingsInPositions with (nolock) where PositionCode = @PositionCode)

		--删除广告位上已投放的广告
		delete from spb_AdvertisingsInPositions
			where PositionCode=@PositionCode
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin
				INSERT INTO [spb_AdvertisingPositions]
						   ([PositionCode],[PresentAreaID],[Width],[Height],[Description],[Maximum],[UseredAdvertisings],[AllowSystem],[ImageUrl])
					 VALUES
						   (@PositionCode,@PresentAreaID,@Width,@Height,@Description,@Maximum,@UseredAdvertisings,@AllowSystem,@ImageUrl)				
            end       
         else --更新
            begin
				UPDATE [spb_AdvertisingPositions]
				   SET [PresentAreaID]=@PresentAreaID
					  ,[Width] = @Width
					  ,[Height] = @Height
					  ,[Description] = @Description
					  ,[Maximum] = @Maximum
					  ,[UseredAdvertisings]=@UseredAdvertisings
					  ,[AllowSystem] = @AllowSystem
					  ,[ImageUrl]=@ImageUrl
				 WHERE [PositionCode] = @PositionCode
            end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取某一广告的位置记录 */

CREATE PROCEDURE [dbo].[spb_AdvertisingsInPositions_Delete] 
(
	@AdvertisingID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_AdvertisingPositions set UseredAdvertisings=UseredAdvertisings-1 
	where UseredAdvertisings > 0 and PositionCode in (select PositionCode from spb_AdvertisingsInPositions with (nolock) where AdvertisingID=@AdvertisingID)

update spb_Advertisings set UseredPositions=0 where AdvertisingID = @AdvertisingID

delete spb_AdvertisingsInPositions where AdvertisingID=@AdvertisingID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台招贴统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_ListingManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingCommentCount int out
)
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN
	
	SET NOCOUNT ON;
select @PendingThreadCount=count(ThreadID) from Tunynet_Listing_Threads with (nolock) where AuditingStatus=20

select @AgainThreadCount=count(ThreadID) from Tunynet_Listing_Threads with (nolock) where AuditingStatus=30

select @PendingCommentCount=count(CommentID) from Tunynet_Listing_Comments with (nolock) where AuditingStatus=20


   
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新积分规则项目 **/

CREATE PROCEDURE [dbo].[spb_IntegratedPointRule_Update] 
(
    @RuleID	int,
    @RuleItemName	nvarchar(256),
    @Description	nvarchar(1024),
    @ScoringRate	float	
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
if exists (select RuleID from spb_IntegratedPointRules with (nolock) where RuleID=@RuleID)
      UPDATE    spb_IntegratedPointRules
      SET       RuleItemName = @RuleItemName, Description = @Description, ScoringRate = @ScoringRate
      WHERE     (RuleID = @RuleID)
--如果要更新的项目不存在则创建
else
      INSERT INTO spb_IntegratedPointRules
                (RuleID, RuleItemName, Description, ScoringRate)
      VALUES    (@RuleID,@RuleItemName,@Description,@ScoringRate)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有积分规则项目 **/

CREATE PROCEDURE [dbo].[spb_IntegratedPointRules_GetAll]
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     spb_IntegratedPointRules.*
FROM         spb_IntegratedPointRules with (nolock)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取需要结束的活动记录 */

CREATE PROCEDURE [dbo].[spb_EventThreads_GetNeedFinished] 

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @EventMemberCountForEventPointRate float
declare @PhotoCountForEventPointRate float
declare @PostCountForEventPointRate float
declare @HitTimesForEventPointRate float

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=2001)  
  select @EventMemberCountForEventPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=2001
else
  set @EventMemberCountForEventPointRate=1

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=2002)  
  select @PhotoCountForEventPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=2002
else
  set @PhotoCountForEventPointRate=0.5

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=2003)  
  select @PostCountForEventPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=2003
else
  set @PostCountForEventPointRate=0.2

if exists (select ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=2004)  
  select @HitTimesForEventPointRate=ScoringRate from spb_IntegratedPointRules with (nolock) where RuleID=2004
else
  set @HitTimesForEventPointRate=0.01

--更新活动积分以及活动状态
update spb_EventThreads set Points = MemberCount*@EventMemberCountForEventPointRate 
+ PhotoCount*@PhotoCountForEventPointRate + PostCount*@PostCountForEventPointRate 
+ HitTimes * @HitTimesForEventPointRate
where EventStatus = 1 and GetDate()>EndTime

       
SELECT     *
FROM         spb_EventThreads with (nolock)
WHERE       EventStatus=1 and GetDate()>EndTime
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_JobSortNameRes_Get]
(
    @Code nchar(4)
)
as
select * from spb_JobSorts_Res where Code = @Code
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据AttachmentID获取ForumPostAttachment */

CREATE PROCEDURE [dbo].[spb_ForumPostAttachment_Get]
(
    @AttachmentID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_ForumPostAttachments with (nolock)
WHERE 
    AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_ForumTemporaryAttachmentIDs_GetByUserID]
(
    @UserID int,
    @OwnerID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
IF @OwnerID is null 
	SELECT * FROM spb_ForumPostAttachments with (nolock) WHERE UserID =@UserID  and PostID<=0
ELSE
Begin
	if not exists (SELECT 1 FROM spb_ForumPostAttachments with (nolock) WHERE UserID = @UserID and PostID <= 0 and SectionID = @OwnerID)
		Update spb_ForumPostAttachments
		Set SectionID = @OwnerID 
		Where UserID = @UserID and PostID <= 0 and SectionID = 0
	SELECT * FROM spb_ForumPostAttachments with (nolock) WHERE UserID = @UserID and PostID <= 0 and SectionID = @OwnerID
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据PostID获取ForumPostAttachment */

CREATE PROCEDURE [dbo].[spb_ForumPostAttachments_GetByPostID]
(
    @PostID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_ForumPostAttachments with (nolock)
WHERE 
    PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新ForumAttachment  **/

CREATE PROCEDURE [dbo].[spb_ForumPostAttachment_CreateUpdate] 
(
    @Action int,
    @AttachmentID int out,
    @PostID int,
	@SectionID int,
	@UserID int,
    @FileName nvarchar(512) ,
    @FriendlyFileName nvarchar(512),
	@ContentType nvarchar(64),
 	@ContentSize int,
    @Height int,
    @Width int,
    @IsRemote bit =0,
	@Price int = 0,
	@IsHidden bit = 0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加

	begin	
		INSERT spb_ForumPostAttachments 
			(PostID,SectionID,UserID,[FileName],FriendlyFileName,ContentType,ContentSize,Height,Width,IsRemote,Price,IsHidden)
		values (@PostID,@SectionID,@UserID,@FileName,@FriendlyFileName,@ContentType,@ContentSize,@Height,@Width,@IsRemote,@Price,@IsHidden)

		-- Grab the new PostID and update the ThreadID's info
		SELECT @AttachmentID = SCOPE_IDENTITY() 

	end

  else if @Action=1 --更新

	 update spb_ForumPostAttachments 
	 set 
		PostID=@PostID,
		UserID=@UserID,
		[FileName]=@FileName,
		FriendlyFileName=@FriendlyFileName,
		ContentType=@ContentType,
		ContentSize=@ContentSize,
		Height=@Height,
		Width=@Width,
		Price=@Price,
		IsHidden=@IsHidden
	 where AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_ForumPostAttachment_UpdateAssociateID]
(
    @AttachmentID int,
    @AssociateID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_ForumPostAttachments set
	PostID=@AssociateID
WHERE 
    AttachmentID=@AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 论坛计数 **/
Create PROCEDURE [dbo].[spb_ForumAttachmentDownloadCount_Add]
(
	@ItemID int,
    @DownloadCount int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_ForumPostAttachments set DownloadCount = DownloadCount + @DownloadCount where AttachmentID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取预置的Widgets **/

CREATE PROCEDURE [dbo].[spb_Widgets_GetInitialWidgets] 
(
    @PresentAreaID	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select W.WidgetID from spb_Widgets W inner join spb_Applications A on W.ApplicationID = A.ApplicationID where W.OwnerID=0 and W.PresentAreaID=@PresentAreaID and A.IsEnabled=1
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有应用设置 **/

CREATE proc [dbo].[spb_Applications_Get]
as
SET NOCOUNT ON
SET Transaction Isolation Level Read UNCOMMITTED
	select * from spb_Applications with (nolock) order by DisplayOrder
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_Task_Vote_Statistics]
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
    --更新spb_Applications表
    Declare @TotalCount INT
    DECLARE @CountInPast24Hours INT
    DECLARE @NewestID INT

	DECLARE @currentDate datetime
	set @currentDate = convert(char(10),getdate() - 1,120)

    Select @TotalCount = count(*) from spb_VoteThreads with (nolock)
    Select @CountInPast24Hours=count(*) from spb_VoteThreads with (nolock) where DateCreated > @currentDate
    select @NewestID=isnull(max(ThreadID),0) from spb_VoteThreads with (nolock)
    
    update spb_Applications
    set TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
    where (ApplicationID=241)
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
资讯统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_News_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--1.更新spb_Applications表
DECLARE @TotalCount INT
DECLARE @CountInPast24Hours INT
DECLARE @NewestID INT

DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate() - 1,120)

SELECT @TotalCount=COUNT(ThreadID) FROM spb_NewsThreads with (nolock)
SELECT @CountInPast24Hours=COUNT(*) FROM spb_NewsThreads with (nolock) WHERE PostDate > @currentDate
SELECT @NewestID=isnull(MAX(ThreadID),0) FROM spb_NewsThreads with (nolock)

UPDATE spb_Applications SET TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
  WHERE (ApplicationID = 201)

--2.清除过期的置顶信息
update spb_NewsThreads set SpecialOrder=0 where SpecialOrder>0 and getdate()>StickyDate
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
迷你博客统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_MicroBlog_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--1.更新spb_Applications表
DECLARE @TotalCount INT
DECLARE @CountInPast24Hours INT
DECLARE @NewestID INT

DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate() - 1,120)

SELECT @TotalCount=COUNT(ThreadID) FROM spb_MicroBlogThreads with (nolock)
SELECT @CountInPast24Hours=COUNT(*) FROM spb_MicroBlogThreads with (nolock) WHERE DateCreated > @currentDate
SELECT @NewestID=isnull(MAX(ThreadID),0) FROM spb_MicroBlogThreads with (nolock)

UPDATE spb_Applications SET TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
  WHERE (ApplicationID = 121)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、活动统计任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Event_Statistics]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--1.更新spb_Applications表
DECLARE @TotalCount INT
DECLARE @CountInPast24Hours INT
DECLARE @NewestID INT

DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate() - 1,120)  

SELECT @TotalCount=COUNT(*) FROM spb_EventThreads with (nolock)
SELECT @CountInPast24Hours=COUNT(*) FROM spb_EventThreads with (nolock) WHERE DateCreated > @currentDate
SELECT @NewestID=isnull(MAX(EventID),0) FROM spb_EventThreads with (nolock)

UPDATE    spb_Applications
SET              TotalCount = @TotalCount, CountInPast24Hours = @CountInPast24Hours, NewestID = @NewestID
WHERE     (ApplicationID = 221)

--2.更新spb_SiteCategories表
declare @CategoryID int
DECLARE Categories_Cursor CURSOR FOR
SELECT CategoryID FROM spb_SiteCategories with (nolock) WHERE (ApplicationID = 221)
	
OPEN Categories_Cursor
FETCH NEXT FROM Categories_Cursor INTO @CategoryID
	
WHILE @@FETCH_STATUS = 0
    BEGIN	
    update spb_SiteCategories  
    set    ItemCount = (select count(*) from spb_EventThreads with (nolock) where SiteCategoryID = @CategoryID and EventStatus=1 and AuditingStatus>=30)
    where  CategoryID = @CategoryID

	FETCH NEXT FROM Categories_Cursor INTO @CategoryID
		
	END
	
CLOSE Categories_Cursor
DEALLOCATE Categories_Cursor

--3.更新spb_EventAreaStatistics表
declare @AreaCode varchar(8)
DECLARE Areas_Cursor CURSOR FOR
SELECT AreaCode FROM spb_Areas with (nolock) 
	
OPEN Areas_Cursor
FETCH NEXT FROM Areas_Cursor INTO @AreaCode
	
WHILE @@FETCH_STATUS = 0
    BEGIN	
    if not exists(SELECT AreaCode FROM spb_EventAreaStatistics with (nolock) WHERE (AreaCode = @AreaCode))      
      INSERT INTO spb_EventAreaStatistics (AreaCode) VALUES (@AreaCode)      
    update spb_EventAreaStatistics  
    set    PublishedCount = (select count(*) from spb_EventThreads with (nolock) where AreaCode=@AreaCode and EventStatus=1),
            FinishedCount=(select count(*) from spb_EventThreads with (nolock) where AreaCode=@AreaCode and EventStatus=9),
            TotalCount=(select count(*) from spb_EventThreads with (nolock) where AreaCode=@AreaCode)
    where  (AreaCode = @AreaCode)
	FETCH NEXT FROM Areas_Cursor INTO @AreaCode		
	  END
	
CLOSE Areas_Cursor
DEALLOCATE Areas_Cursor
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新Application **/

create PROCEDURE [dbo].[spb_Application_Update] 
(
  @ApplicationID int=null,
  @IsEnabled	bit=null,
  @PropertyNames	ntext=null,
  @PropertyValues	ntext=null	
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
  UPDATE    spb_Applications
  SET       IsEnabled = @IsEnabled, PropertyNames = @PropertyNames,PropertyValues = @PropertyValues
  WHERE     (ApplicationID = @ApplicationID)	 
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_NewsSectionNameRes_Get]
(
    @sectionID int
)
as
select * from spb_NewsSections_Res where SectionID = @sectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_NewsSectionNameRes_Update]
(
    @SectionID int,
    @LanguageCode varchar(20)='',
    @SectionName nvarchar(256)=''
)
as
if exists(select * from spb_NewsSections_Res where SectionID=@SectionID and LanguageCode=@LanguageCode)
Update spb_NewsSections_Res Set SectionName=@SectionName Where SectionID=@SectionID and LanguageCode=@LanguageCode
else
Insert into spb_NewsSections_Res(SectionID,LanguageCode,SectionName) values(@SectionID,@LanguageCode,@SectionName)
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_ActivityItemNameRes_Get]
(
    @ItemID int
)
as
select * from spb_ActivityItems_Res where ItemID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_SystemTradePoints_Update]
(
	@TradePoints int = 0
)
as
set transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if not exists (select * from spb_SystemData)
	insert into spb_SystemData(TradePoints) values (@TradePoints)
else
	Update spb_SystemData
	Set TradePoints = TradePoints + @TradePoints
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create Procedure [dbo].[spb_SystemTradePoints_Get]
as
set transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Select * from spb_SystemData with (nolock)
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_NoticeItemNameRes_Get]
(
    @ItemID int
)
as
select * from spb_NoticeItems_Res where ItemID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create Procedure [dbo].[spb_NewsUserData_Get]
(
	@UserID int
)
as
select * from spb_NewsUserDatas with(nolock) where UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create Procedure [dbo].[spb_NewsUserData_Create]
(
	@UserID int
)
as

if(not exists(select UserID from spb_NewsUserDatas where UserID = @UserID))
  insert into spb_NewsUserDatas (UserID) Values (@UserID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**公告删除 修改 添加**/
CREATE PROCEDURE [dbo].[spb_Announcement_CreateUpdateDelete]
(
@Action int,
@ThreadID int output,
@Subject nvarchar(256)='',
@Body ntext='',
@SubjectStyle nvarchar(256)='',
@AnnouncementStatus int=0,
@IsHyperLink bit=0,
@DateExpired datetime= null,
@ReleaseDate datetime= null,
@UserID int=0,
@IPAddress nvarchar(32)=N'000.000.000.000',
@IsSticky bit=0,
@DisplayOrder int=100,
@PrentAreaIDs nvarchar(1024)=0,
@PropertyNames ntext= null,
@PropertyValues ntext= null,
@HyperLinkUrl nvarchar(512)=''
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	SET NOCOUNT ON;
	
if(@Action=2)--删除
begin
delete spb_Announcements where ThreadID=@threadID
delete spb_AnnouncementsInPresentAreas where ThreadID=@threadID
end
ELSE IF(@Action=1)--修改
update spb_Announcements 
set [Subject]=@Subject,SubjectStyle=@SubjectStyle,IsHyperLink=@IsHyperLink,
Body=@Body,AnnouncementStatus=@AnnouncementStatus,DateExpired=@DateExpired, ReleaseDate=@ReleaseDate,
UserID=@UserID,IPAddress=@IPAddress,LastModified=getdate(), IsSticky=@IsSticky,
DisplayOrder=@DisplayOrder,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues,HyperLinkUrl=@HyperLinkUrl
where ThreadID=@ThreadID

 
 else if (@Action=0) --添加
 begin
	 INSERT INTO spb_Announcements
						  ([Subject], SubjectStyle, IsHyperLink, Body, AnnouncementStatus, ReleaseDate, DateExpired,
							UserID, IPAddress, 
						  IsSticky, DisplayOrder, PropertyNames, PropertyValues,HyperLinkUrl)
	VALUES     (@Subject,@SubjectStyle,@IsHyperLink,@Body,@AnnouncementStatus,@ReleaseDate,@DateExpired,
	@UserID,@IPAddress,@IsSticky,@DisplayOrder,@PropertyNames,@PropertyValues,@HyperLinkUrl)
	SELECT @ThreadID = SCOPE_IDENTITY() 

end

if(@Action=0 or @Action=1)
	begin	
		declare @sql nvarchar(4000)
		delete from spb_AnnouncementsInPresentAreas where ThreadID=@ThreadID
		set @sql = ' insert into spb_AnnouncementsInPresentAreas(ThreadID,PresentAreaID) select @ThreadID, '''+replace(@PrentAreaIDs,',',''' union select @ThreadID, ''')+''''
		exec sp_executesql @sql, N'@ThreadID int',@ThreadID = @ThreadID
	end

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**获取单个公告**/
CREATE PROCEDURE [dbo].[spb_Announcement_Get]
(
@ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	SET NOCOUNT ON;
	declare @GetPreAndNext bit
	set @GetPreAndNext=1
DECLARE @NextThreadID int 
DECLARE @NextThreadSubject nvarchar(256)
DECLARE @PrevThreadID int  
DECLARE @PrevThreadSubject nvarchar(256)
if @GetPreAndNext=1
begin
exec spb_Announcements_GetPreNextThread @ThreadID,@NextThreadID output,@NextThreadSubject output,@PrevThreadID OUTPUT,@PrevThreadSubject OUTPUT
end
else
 begin
  set @NextThreadID=0
  set @NextThreadSubject=''
  set @PrevThreadID=0
  set @PrevThreadSubject=''
 end
 select BT.*,
  NextThreadID=@NextThreadID,
    NextThreadSubject=@NextThreadSubject,
    PrevThreadID=@PrevThreadID,
    PrevThreadSubject=@PrevThreadSubject
    from
    spb_Announcements BT
    where BT.ThreadID=@ThreadID
select PresentAreaID from spb_AnnouncementsInPresentAreas where ThreadID=@ThreadID
   
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**每天定期更新公告状态**/
CREATE PROCEDURE [dbo].[spb_Task_UpdateAnnouncementStatus]

AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN
	
	SET NOCOUNT ON;
	
	--显示状态（0-未发布1-已发布2-已过期）
	--已发布
    update spb_Announcements set AnnouncementStatus=1 where ReleaseDate<getdate()
            
    --已过期
    update spb_Announcements set AnnouncementStatus=2 where DateExpired< getdate()
--未发布
update spb_Announcements set AnnouncementStatus=0 where ReleaseDate>getdate()
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取公告的前一条和后一条**/
CREATE PROCEDURE [dbo].[spb_Announcements_GetPreNextThread]
(
	@ThreadID int,	
	@NextThreadID int OUTPUT,
    @NextThreadSubject  nvarchar(512) OUTPUT,
	@PrevThreadID int OUTPUT,
    @PrevThreadSubject  nvarchar(512) OUTPUT
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN	
	SET NOCOUNT ON;
	declare  @releaseDate datetime
	select @releaseDate=releaseDate from spb_Announcements where ThreadID=@ThreadID
	
	SELECT TOP 1 
	@PrevThreadID = ThreadID,@PrevThreadSubject=Subject
FROM 
	spb_Announcements with (nolock) 
WHERE 	AnnouncementStatus=1  AND releaseDate>@releaseDate
ORDER BY ReleaseDate desc 

--ThreadID DESC
IF @@ROWCOUNT < 1
  begin
	SELECT @PrevThreadID = 0
    SELECT @PrevThreadSubject=''
  end
	
SELECT TOP 1 
	@NextThreadID = ThreadID,@NextThreadSubject=Subject
FROM 
	spb_Announcements with (nolock)
WHERE 
	 AnnouncementStatus=1 AND releaseDate<@releaseDate
	 
ORDER BY ReleaseDate desc

--ThreadID ASC



IF @@ROWCOUNT < 1
  begin
	SELECT @NextThreadID = 0
    SELECT @NextThreadSubject=''
  end
   
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_AnnouncementView_Add]
(
@ItemID int,
@WebViewCount int=0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	SET NOCOUNT ON;

update spb_Announcements set HitTimes = HitTimes+@WebViewCount where ThreadID=@ItemID

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据照片ID获取照片中所有的圈人标记 */

CREATE PROCEDURE [dbo].[spb_TagUserInPhoto_GetByThreadID]
(
    @ThreadID int    
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     spb_TagUsersInPhotos.*
FROM         spb_TagUsersInPhotos with (nolock)
WHERE     (ThreadID = @ThreadID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除照片圈人 **/

CREATE PROCEDURE [dbo].[spb_TagUserInPhoto_CreateUpdateDelete] 
(
    @Action int,
	@ID int out,
	@UserID	int =0	,
	@DisplayName	nvarchar(256)='',
	@ThreadID	int	= 0,
	@OperatorUserID	int = 0	,
	@AreaX	int	= 0,
	@AreaY	int = 0	,
	@AreaWidth	int	= 0,
	@AreaHeight	int	= 0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
		INSERT INTO spb_TagUsersInPhotos
                      (UserID, DisplayName, ThreadID, OperatorUserID, AreaX, AreaY, AreaWidth, AreaHeight)
         VALUES     (@UserID,@DisplayName,@ThreadID,@OperatorUserID,@AreaX,@AreaY,@AreaWidth,@AreaHeight)

		-- Get the new ID
		SELECT @ID = @@IDENTITY
	end

  else if @Action=1 --更新
	begin
		UPDATE spb_TagUsersInPhotos
        SET UserID = @UserID, DisplayName = @DisplayName, ThreadID = @ThreadID, OperatorUserID = @OperatorUserID, AreaX = @AreaX, AreaY = @AreaY, 
        AreaWidth = @AreaWidth, AreaHeight = @AreaHeight
	end
  else
	begin	   
	  DELETE FROM spb_TagUsersInPhotos WHERE (ID = @ID)
	end
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_PrivacyItemNameRes_Get]
(
    @ItemID int
)
as
select * from spb_PrivacyItems_Res where ItemID = @ItemID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE PROCEDURE [dbo].[spb_PrivacyDescriptionRes_Get]
(
 @ItemID int
)
AS
BEGIN
	select Description,LanguageCode from spb_PrivacyItems_Res where ItemID = @ItemID
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsComment_Delete]
(
	@CommentID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

declare @ThreadID int
declare @SectionID int
select @ThreadID=ThreadID,@SectionID=SectionID from spb_NewsComments WITH (NOLOCK) where CommentID=@CommentID

delete spb_NewsComments where CommentID=@CommentID

update spb_NewsThreads set CommentCount=CommentCount-1 where ThreadID=@ThreadID

update spb_NewsSections set CommentCount=CommentCount-1 where SectionID=@SectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsComment_Get]
(
	@CommentID int 
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select * from spb_NewsComments WITH (NOLOCK) where CommentID=@CommentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_NewsComment_UpdateAuditingStatus]
( 
    @CommentID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_NewsComments set AuditingStatus=@AuditingStatus where CommentID=@CommentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_EventFavoriteCount_Update]
(
	@UserID int,
	@EventID int,
	@CountDirection int
)
AS

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

if (@CountDirection=0)
	begin
		--更新用户的关注活动数
		if not exists (select * from spb_EventUserDatas with (nolock) WHERE [UserID] = @UserID)
				INSERT INTO spb_EventUserDatas (UserID,FavoriteThreadCount)values(@UserID,1)
		else
				Update spb_EventUserDatas set FavoriteThreadCount=FavoriteThreadCount+1 where UserID=@UserID
	    --更新活动的被关注数	    
	    Update spb_EventThreads set FaviteCount=FaviteCount+1 where EventID=@EventID
	end
else
    begin
		--更新用户的关注活动数
		Update spb_EventUserDatas set FavoriteThreadCount=FavoriteThreadCount-1 where UserID=@UserID
		--更新活动的被关注数
		Update spb_EventThreads set FaviteCount=FaviteCount-1 where EventID=@EventID
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除EventMember **/
CREATE PROCEDURE [dbo].[spb_EventMember_CreateUpdateDelete] 
(
  @Action int,
  @MemberID	int output,
  @EventID	int=null,
  @UserID	int=null,
  @BringCount int=0,
  @IsManager	bit=null,
  @IsApproved	bit=null,
  @PropertyNames	ntext=null,
  @PropertyValues	ntext=null
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
	if exists(select * from spb_EventMembers with (nolock) WHERE  EventID = @EventID and UserID=@UserID and @UserID>0)
		return;
		
      BEGIN TRANSACTION
      INSERT INTO spb_EventMembers
      (EventID, UserID,BringCount,IsManager, IsApproved, SignUpDate, PropertyNames, PropertyValues)
      VALUES (@EventID,@UserID,@BringCount,@IsManager,@IsApproved, GETDATE(),@PropertyNames,@PropertyValues)
      if(@@error<>0) goto FIALURE
	  SELECT @MemberID = SCOPE_IDENTITY()
      if(@MemberID > 0)
		 begin
		   UPDATE spb_EventThreads SET MemberCount = MemberCount + 1 + @BringCount where EventID=@EventID
			-- spb_EventUserDatas 计数
			if exists (select * from spb_EventUserDatas with (nolock) where UserID=@UserID)
				update spb_EventUserDatas set JoinedThreadCount=JoinedThreadCount+1 where UserID=@UserID
			else
				insert into spb_EventUserDatas (UserID,JoinedThreadCount) values (@UserID,1)	

		   if(@@error<>0) goto FIALURE
		 end
	  COMMIT TRANSACTION
	  RETURN
      FIALURE:
      ROLLBACK TRANSACTION
      RETURN
	
	end
  else if @Action=1 --更新
	  begin
      UPDATE    spb_EventMembers
      SET       EventID = @EventID, UserID = @UserID, IsManager = @IsManager, IsApproved = @IsApproved, 
                PropertyNames = @PropertyNames,PropertyValues = @PropertyValues
      WHERE     (MemberID = @MemberID)	
    end

  else 
	  begin
		  if not exists (select * from spb_EventMembers with (nolock) WHERE  MemberID = @MemberID)
		  return
		  DELETE FROM spb_EventMembers WHERE  (MemberID = @MemberID)	 
		  UPDATE spb_EventThreads SET MemberCount = MemberCount - 1 - @BringCount where EventID=@EventID and MemberCount>0
		  update spb_EventUserDatas set JoinedThreadCount=JoinedThreadCount-1 where UserID=@UserID
	  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除EventPost **/

CREATE PROCEDURE [dbo].[spb_EventPost_CreateUpdateDelete] 
(
  @Action int,
  @PostID	int output,
  @EventID	int=null,
  @UserID	int=null,
  @ParentID int=0,
  @ParentUserID int=0,
  @Author	nvarchar(64)=null,
  @Body	ntext=null,
  @AuditingStatus int=null,
  @PropertyNames ntext='',
  @PropertyValues ntext=''
	) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
      BEGIN TRANSACTION
      
      INSERT INTO spb_EventPosts
      (EventID, UserID,ParentID,ParentUserID, Author, Body, PostDate, AuditingStatus,PropertyNames,PropertyValues)
      VALUES     (@EventID,@UserID,@ParentID,@ParentUserID,@Author,@Body, GETDATE(),@AuditingStatus,@PropertyNames,@PropertyValues)
      IF(@@ERROR<>0) GOTO failure		
      	
      SELECT @PostID = SCOPE_IDENTITY()
      if(@PostID > 0)
		 begin
			-- spb_EventUserDatas 计数
			if exists (select * from spb_EventUserDatas with (nolock) where UserID=@UserID)
				update spb_EventUserDatas set PostCount=PostCount+1 where UserID=@UserID
			else
				insert into spb_EventUserDatas (UserID,PostCount) values (@UserID,1)

			UPDATE spb_EventThreads SET PostCount = PostCount + 1 WHERE (EventID = @EventID)
			IF(@@ERROR<>0) GOTO failure
		 end
	
	  COMMIT TRANSACTION
      return
      
      failure:
      rollback TRANSACTION
      return  
	end
  else if @Action=1 --更新
	  begin
      UPDATE    spb_EventPosts
      SET EventID = @EventID, UserID = @UserID,ParentID=@ParentID,ParentUserID=@ParentUserID, Author = @Author, Body = @Body, PostDate = GETDATE(), AuditingStatus = @AuditingStatus,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
      WHERE     (PostID = @PostID) 
   end
  else 
  	  if not exists(select * from spb_EventPosts with (nolock) WHERE PostID = @PostID)
  	  return
	  begin
			UPDATE    spb_EventThreads 
      SET PostCount = PostCount - 1 
      WHERE (EventID = (Select EventID from spb_EventPosts with (nolock) where (PostID = @PostID) )) 
      and (PostCount>0)

      DELETE FROM spb_EventPosts  WHERE  (PostID = @PostID)
	  update spb_EventUserDatas set PostCount=PostCount-1 where UserID=@UserID

	  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_EventUserData_ChangeExperiencePoints]
(
	@UserID int,
	@ExperiencePoints int
)
AS

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

if not exists (select * from spb_EventUserDatas with (nolock) WHERE [UserID] = @UserID)
		INSERT INTO spb_EventUserDatas (UserID,ExperiencePoints)values(@UserID,@ExperiencePoints)
else
		Update spb_EventUserDatas set ExperiencePoints=ExperiencePoints+@ExperiencePoints where UserID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_EventUserData_Get]
	@UserID int
AS

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

SELECT  *
FROM
	spb_EventUserDatas with (nolock)
WHERE
	UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新EventThread **/

CREATE PROCEDURE [dbo].[spb_EventThread_CreateUpdateDelete] 
(
  @Action int,  
  @EventID	int output,
  @EventName	nvarchar(64)=null,
  @UserID	int=null,
  @Sponsor	nvarchar(64)=null,
  @ClubID	int= -1,
  @SiteCategoryID	int=null,
  @AreaCode	nvarchar(8)=null,
  @StartTime	datetime=null,
  @EndTime	datetime=null,
  @SignEndTime	datetime=null,
  @Location	nvarchar(256)=null,
  @Body	ntext=null,
  @FeaturedPhotoID	int=null,
  @EventStatus	int=null,
  @IsPublic	bit=1,
  @AuditingStatus	int=null,
  @IsEssential	bit=null,
  @PayType	int=null,
  @IsOnlyAllowClubMemberSignUp	bit=null,
  @Points int =null,
  @IsPointsEncashed bit =null,
	@UserHostAddress varchar(64)='000.000.000.000',
  @PropertyNames	ntext=null,
  @PropertyValues	ntext=null	
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
		BEGIN TRANSACTION
        INSERT INTO spb_EventThreads
                              (EventName, UserID, Sponsor, ClubID, SiteCategoryID, AreaCode, StartTime, EndTime, SignEndTime, Location, Body, FeaturedPhotoID, EventStatus, 
                              IsPublic, AuditingStatus, IsEssential, PayType, IsOnlyAllowClubMemberSignUp, DateCreated, LastModified, PropertyNames, PropertyValues, Points, 
                              IsPointsEncashed,UserHostAddress)
        VALUES     (@EventName,@UserID,@Sponsor,@ClubID,@SiteCategoryID,@AreaCode,@StartTime,@EndTime,@SignEndTime,@Location,@Body,@FeaturedPhotoID,@EventStatus,@IsPublic,@AuditingStatus,@IsEssential,@PayType,@IsOnlyAllowClubMemberSignUp,
                               GETDATE(), GETDATE(),@PropertyNames,@PropertyValues,@Points,@IsPointsEncashed,@UserHostAddress)	SELECT @EventID = SCOPE_IDENTITY()
        if(@@error<>0) goto FAILURE
        
			if exists (select * from spb_EventUserDatas with (nolock) where UserID=@UserID)
				update spb_EventUserDatas set CreatedThreadCount=CreatedThreadCount+1 where UserID=@UserID
			else
				insert into spb_EventUserDatas (UserID,CreatedThreadCount) values (@UserID,1)
		
		if(@@error<>0) goto FAILURE

    COMMIT TRANSACTION
    RETURN
    FAILURE:
    ROLLBACK TRANSACTION
    RETURN		
	end

  else if @Action=1 --更新
	  begin
        UPDATE    spb_EventThreads
        SET              EventName = @EventName, UserID = @UserID, Sponsor = @Sponsor, ClubID = @ClubID, SiteCategoryID = @SiteCategoryID, AreaCode = @AreaCode, 
                              StartTime = @StartTime, EndTime = @EndTime, SignEndTime = @SignEndTime, Location = @Location,  
                              FeaturedPhotoID = @FeaturedPhotoID, EventStatus = @EventStatus, IsPublic = @IsPublic, AuditingStatus = @AuditingStatus, 
                              IsEssential = @IsEssential, PayType = @PayType, IsOnlyAllowClubMemberSignUp = @IsOnlyAllowClubMemberSignUp, 
                              LastModified = GETDATE(), PropertyNames = @PropertyNames, PropertyValues = @PropertyValues, Points = @Points, 
                              IsPointsEncashed = @IsPointsEncashed,UserHostAddress=@UserHostAddress
                  where EventID=@EventID
		if @Body is not null 
        UPDATE    spb_EventThreads
        SET				Body = @Body      
                  where EventID=@EventID          
     end

  else 
	  begin
	  if not exists (select * FROM spb_EventThreads with (nolock) WHERE EventID = @EventID)
   	  return
      BEGIN TRANSACTION
      DELETE FROM spb_EventThreads WHERE  (EventID = @EventID)
      if(@@error<>0) goto FAILURES
      DELETE FROM spb_EventMembers WHERE  (EventID = @EventID)	 
      if(@@error<>0) goto FAILURES
      DELETE FROM spb_EventPhotos  WHERE  (EventID = @EventID)
      if(@@error<>0) goto FAILURES
      DELETE FROM spb_EventPosts   WHERE  (EventID = @EventID)
      if(@@error<>0) goto FAILURES
      DELETE FROM spb_EventRatings WHERE  (EventID = @EventID)
	  -- UserApplicationSettiings 计数		
	  update spb_EventUserDatas set CreatedThreadCount=CreatedThreadCount-1 where UserID=@UserID and CreatedThreadCount > 0

	    COMMIT TRANSACTION
        RETURN
        
        
        FAILURES:
        ROLLBACK TRANSACTION
        RETURN
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除EventPhoto **/

CREATE PROCEDURE [dbo].[spb_EventPhotoComment_CreateUpdateDelete] 
(
    @Action int,
    @CommentID	int output,
	@ParentID	int= null,
	@AttachmentID	int= null,
	@UserID	int= null,
	@Author	nvarchar(64)= null,
	@Body	ntext= null,
	@AuditingStatus	int= null,
	@PropertyNames	ntext= null,
	@PropertyValues	ntext= null	
	) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
		BEGIN TRAN
		INSERT INTO [spb_EventPhotoComments]
							  ( ParentID, AttachmentID, UserID, Author, Body, AuditingStatus, DateCreated, PropertyNames, PropertyValues)
		VALUES     (@ParentID,@AttachmentID,@UserID,@Author,@Body,@AuditingStatus, GETDATE(),@PropertyNames,@PropertyValues)
	    if(@@error<>0) goto FAILURE
		SELECT @CommentID = SCOPE_IDENTITY()
        if(@CommentID>0)
		  begin
	        UPDATE spb_EventPhotos SET CommentCount = CommentCount + 1 WHERE (AttachmentID = @AttachmentID)
			if(@@error<>0) goto FAILURE
			-- spb_EventUserDatas 计数
			if exists (select * from spb_EventUserDatas with (nolock) where UserID=@UserID)
				update spb_EventUserDatas set PhotoCommentCount=PhotoCommentCount+1 where UserID=@UserID
			else
				insert into spb_EventUserDatas (UserID,PhotoCommentCount) values (@UserID,1)
	      end
	    COMMIT TRANSACTION
        RETURN
        FAILURE:
        ROLLBACK TRANSACTION
        RETURN
    end

  else if @Action=1 --更新
	  begin
	  UPDATE    [spb_ EventPhotoComments]
	  SET              ParentID = @ParentID, AttachmentID = @AttachmentID, UserID = @UserID, Author = @Author, Body = @Body, AuditingStatus = @AuditingStatus, 
						  PropertyNames = @PropertyNames, PropertyValues = @PropertyValues
	  WHERE     (CommentID = @CommentID)	  
	  end
  else 
	  begin
	  if not exists(select * from [spb_EventPhotoComments] with (nolock) WHERE CommentID = @CommentID)
	  return
		DELETE FROM [spb_EventPhotoComments]
		WHERE     (CommentID = @CommentID)
		if(@AttachmentID > 0)
		begin
			UPDATE    spb_EventPhotos SET CommentCount = CommentCount - 1 WHERE (AttachmentID = @AttachmentID)
		    update spb_EventUserDatas set PhotoCommentCount=PhotoCommentCount-1 where UserID=@UserID
		end
	  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除EventPhoto **/

CREATE PROCEDURE [dbo].[spb_EventPhoto_CreateUpdateDelete] 
(
  @Action int,
  @AttachmentID	int output,
  @EventID	int=null,
  @FriendlyFileName	nvarchar(64)=null,
  @Description	nvarchar(2048)=null,
  @UserID	int=null,
  @Author	nvarchar(64)=null,
  @FileName	nvarchar(64)=null,
  @ContentType	nvarchar(64)=null,
  @ContentSize	int=null,
  @Height	int=null,
  @Width	int=null,
  @UserHostAddress	nvarchar(64)=null,
  @AuditingStatus int=null
	) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
	  BEGIN TRAN
      INSERT INTO spb_EventPhotos
      (EventID, FriendlyFileName, Description, UserID, Author, FileName, ContentType, ContentSize, Height, Width, UserHostAddress, DateCreated, 
      AuditingStatus)
      VALUES (@EventID,@FriendlyFileName,@Description,@UserID,@Author,@FileName,@ContentType,@ContentSize,@Height,@Width,@UserHostAddress, 
      GETDATE(),@AuditingStatus) 
      if(@@error<>0) goto FIALURE
      SELECT @AttachmentID = SCOPE_IDENTITY()
		
      if(@AttachmentID>0)
		begin
	      UPDATE spb_EventThreads SET PhotoCount = PhotoCount + 1 WHERE (EventID = @EventID)
			-- spb_EventUserDatas 计数
			if exists (select * from spb_EventUserDatas with (nolock) where UserID=@UserID)
				update spb_EventUserDatas set PhotoCount=PhotoCount+1 where UserID=@UserID
			else
				insert into spb_EventUserDatas (UserID,PhotoCount) values (@UserID,1)

		  if(@@error<>0) goto FIALURE
        end
	  COMMIT TRANSACTION
	  RETURN
      FIALURE:
      ROLLBACK TRANSACTION
      RETURN
	end
  else if @Action=1 --更新
	  begin
UPDATE    spb_EventPhotos
SET              EventID = @EventID, FriendlyFileName = @FriendlyFileName, Description = @Description, UserID = @UserID, Author = @Author, 
                      FileName = @FileName, ContentType = @ContentType, ContentSize = @ContentSize, Height = @Height, Width = @Width, 
                      UserHostAddress = @UserHostAddress, AuditingStatus = @AuditingStatus
WHERE     (AttachmentID = @AttachmentID)    end
  else 
	  begin
	  if not exists (select * from spb_EventPhotos with (nolock) WHERE AttachmentID = @AttachmentID)
	  return
      DELETE FROM spb_EventPhotos  WHERE  (AttachmentID = @AttachmentID)
	  UPDATE    spb_EventThreads SET PhotoCount = PhotoCount - 1 WHERE (EventID = @EventID) and (PhotoCount>0)
	  update spb_EventUserDatas set PhotoCount=PhotoCount-1 where UserID=@UserID

	   if exists(select EventID from spb_EventThreads with (nolock) where (EventID = @EventID) and (FeaturedPhotoID=@AttachmentID))
         UPDATE    spb_EventThreads SET FeaturedPhotoID = 0 WHERE (EventID = @EventID)
	  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据AttachmentID获取EventPhoto */

CREATE PROCEDURE [dbo].[spb_EventPhoto_Get]
(
    @AttachmentID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT      spb_EventPhotos.*
FROM       spb_EventPhotos with (nolock)
WHERE     (AttachmentID = @AttachmentID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置活动照片审核状态 */

Create PROCEDURE [dbo].[spb_EventPhoto_UpdateAuditingStatus]
( 
    @AttachmentID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_EventPhotos set AuditingStatus=@AuditingStatus where AttachmentID=@AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户时处理处理活动 */

CREATE PROCEDURE [dbo].[spb_Event_DeleteUser]
( 
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

BEGIN TRANSACTION

--活动 start
delete from spb_EventMembers where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_EventPhotos where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_EventPhotoComments where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_EventPosts where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_EventRatings where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

--活动 end

COMMIT TRANSACTION
SELECT 1 -- Success
RETURN

Failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除用户并重设用户内容时处理与活动相关的内容 */

CREATE PROCEDURE [dbo].[spb_Event_DeleteUserAndReassignContent]
( 
    @UserID int,
	  @ReassignUserName		nvarchar(64)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE	@ReassignUserID	int
SELECT	@ReassignUserID = UserID from spb_Users with (nolock) where UserType=1 and UserName=@ReassignUserName

-- does the reassign user exist?
IF (@ReassignUserID IS NULL)
BEGIN
	SELECT 2 -- InvalidReassignUserName
	RETURN
END

IF not exists (select UserID from spb_Users with (nolock) where UserID=@UserID)
BEGIN
	SELECT 3 -- 待删除的用户不存在
	RETURN
END


BEGIN TRANSACTION

--活动 start
IF (@UserID >0)
begin
delete from spb_EventMembers where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_EventPosts where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_EventRatings where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

delete from spb_EventPhotoComments where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

update spb_EventThreads set UserID=@ReassignUserID where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure

update spb_EventPhotos set UserID=@ReassignUserID where UserID=@UserID
IF (@@ERROR <> 0) GOTO Failure
end
--活动 end

COMMIT TRANSACTION
SELECT 1 -- Success
RETURN

Failure:
	ROLLBACK TRANSACTION
	SELECT 10 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据EventID获取EventPhotoAttachmentIDs */

create PROCEDURE [dbo].[spb_EventPhotoAttachmentIDs_GetByEventID]
(
    @EventID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    AttachmentID
FROM    
	spb_EventPhotos with (nolock)
WHERE 
    EventID = @EventID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_EventPhoto_UpdateAssociateID]
(
    @AttachmentID int,
    @AssociateID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_EventPhotos set
	EventID=@AssociateID
WHERE 
    AttachmentID=@AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_EventTemporaryAttachmentIDs_GetByUserID]
(
    @OwnerUserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_EventPhotos with (nolock)
WHERE 
    UserID = @OwnerUserID and EventID<=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台活动统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_EventManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingPhotoCount int out,
@PendingPhotoCommentCount int out,
@PendingPostCount int out,
@AgainPhotoCount int out
)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
	
select @PendingThreadCount= count([EventID]) from spb_EventThreads with (nolock) where AuditingStatus=20
select @AgainThreadCount=count([EventID]) from spb_EventThreads with (nolock) where AuditingStatus=30

select @PendingPhotoCount=count(AttachmentID) from spb_EventPhotos (nolock) where AuditingStatus=20
select @PendingPhotoCommentCount=count(CommentID) from spb_EventPhotoComments (nolock) where AuditingStatus=20

select @PendingPostCount=count(PostID) from spb_EventPosts (nolock) where AuditingStatus=20

select @AgainPhotoCount=count(AttachmentID) from spb_EventPhotos (nolock) where AuditingStatus=30
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新默认隐私项目设置 **/

CREATE PROCEDURE [dbo].[spb_PrivacyItemSettingsInGlobal_Update] 
(
  @ItemID	int,
  @PrivacyDegree	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
if exists (select ItemID from spb_GlobalPrivacyItemSettings with (nolock) where ItemID=@ItemID)
  UPDATE spb_GlobalPrivacyItemSettings
  SET PrivacyDegree = @PrivacyDegree
  WHERE (ItemID = @ItemID)
--如果要更新的项目不存在则创建
else
  INSERT INTO spb_GlobalPrivacyItemSettings
      (ItemID, PrivacyDegree)
  VALUES  (@ItemID,@PrivacyDegree)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取通知项目默认设置 **/

CREATE PROCEDURE [dbo].[spb_PrivacyItemSettingssInGlobal_GetAll] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT   P.*, G.PrivacyDegree
FROM     spb_PrivacyItems AS P with (nolock) INNER JOIN
         spb_GlobalPrivacyItemSettings AS G with (nolock) ON P.ItemID = G.ItemID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_UserPointItemNameRes_Get]
(
    @ItemID int
)
as
select * from spb_UserPointItems_Res where ItemID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除访客记录 **/

create Proc [dbo].[spb_UserVisit_Delete]
(
	@VisitID int
)
as
SET Transaction Isolation Level Read UNCOMMITTED

delete spb_UserVisits where VisitID=@VisitID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 设置访客记录针对被访问者是否可见 **/

create Proc [dbo].[spb_UserVisit_SetVisible]
(
	@VisitID int,
	@IsVisible bit
)
as
SET Transaction Isolation Level Read UNCOMMITTED

update spb_UserVisits set IsVisible = @IsVisible where VisitID=@VisitID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户访客 **/

Create Proc [dbo].[spb_UserVisit_Get]
(
	@visitID int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
select * from spb_UserVisits with (nolock) where VisitID = @visitID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 批量删除某个人或所有人的访客记录 **/
CREATE PROCEDURE [dbo].[spb_UserVisits_BatchDelete] 
(
  @userID int=-1,
  @beforeDays	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @currentDate datetime
declare @numberOfDelete int
set @currentDate = getdate()

  if(@userID>0)
    select @numberOfDelete = count(VisitID) from spb_UserVisits with (nolock) where (DateDiff(day,LastVisitTime,@currentDate) >= @beforeDays) and (FromUserID=@userID)
  else
    select @numberOfDelete = count(VisitID) from spb_UserVisits with (nolock) where (DateDiff(day,LastVisitTime,@currentDate) >= @beforeDays)


  if(@userID>0)
    delete from spb_UserVisits where (DateDiff(day,LastVisitTime,@currentDate) >= @beforeDays) and (FromUserID=@userID)
  else
    delete from spb_UserVisits where (DateDiff(day,LastVisitTime,@currentDate) >= @beforeDays)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 添加用户访客 **/

CREATE Proc [dbo].[spb_UserVisit_Create]
(
	@FromUserID int,
    @FromUserDisplayName nvarchar(64),
    @FromUserType int,
	@ToUserID int,
    @ToUserDisplayName nvarchar(64),
    @ToUserType int,
	@VisitTimes int = 0,
	@LastVisitTime DateTime = null
)
as
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @VisitID int

select @VisitID = VisitID from spb_UserVisits with (nolock) where FromUserID=@FromUserID and ToUserID = @ToUserID

if (@VisitID is null)
  insert spb_UserVisits (FromUserID,FromUserDisplayName,FromUserType,ToUserID,ToUserDisplayName,ToUserType,VisitTimes,LastVisitTime) values
    (@FromUserID,@FromUserDisplayName,@FromUserType,@ToUserID,@ToUserDisplayName,@ToUserType,@VisitTimes,@LastVisitTime)
else
  update spb_UserVisits set VisitTimes = VisitTimes + @VisitTimes, LastVisitTime = @LastVisitTime,FromUserDisplayName=@FromUserDisplayName,ToUserDisplayName=@ToUserDisplayName
    where VisitID=@VisitID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_MicroBlogFollow_CreateDelete] 
(
    @Action int,
	@FollowID int output,
	@UserID int = 0,
	@ItemID int = 0,
    @PropertyNames	ntext=null,
    @PropertyValues	ntext=null	
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if @Action = 0 --添加
begin
	insert into spb_MicroBlogFollows(UserID,ItemID) values (@UserID,@ItemID)
	SELECT @FollowID = SCOPE_IDENTITY() 
end
else if @Action = 2
begin
	Delete From spb_MicroBlogFollows Where FollowID = @FollowID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_MicroBlogFollow_Get] 
(
	@FollowID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
select * from spb_MicroBlogFollows where FollowID = @FollowID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_MicroBlogFollow_GetItemIDsWithIdentityOfUserID] 
(
	@UserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
select FollowID,ItemID from spb_MicroBlogFollows where UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新权限项目针对用户等级的设置，如果该PermissionItemRole不存在则创建 **/

CREATE PROCEDURE [dbo].[spb_PermissionItemRoleInUserRank_Update] 
(
  @ItemID	int,
  @Rank	int,
  @AllowType	int,
  @AllowedValue	float
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
--如果权限设置项PermissionItemRole不存在，则创建
if exists (select ItemID,Rank from spb_PermissionItemRolesInUserRanks with (nolock) where ItemID=@ItemID and Rank=@Rank)
    UPDATE  spb_PermissionItemRolesInUserRanks
		    SET AllowType = @AllowType, AllowedValue = @AllowedValue
		    WHERE (ItemID = @ItemID) AND (Rank=@Rank)
else
		INSERT INTO spb_PermissionItemRolesInUserRanks (ItemID, Rank, AllowType, AllowedValue)
		    VALUES (@ItemID,@Rank,@AllowType,@AllowedValue)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取Rank对应的权限规则 **/

CREATE PROCEDURE [dbo].[spb_PermissionItemRolesInUserRank_Get] 
(
	@Rank int,
	@ApplicationID  int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     P.*, PIU.Rank, PIU.AllowedValue, PIU.AllowType
FROM         spb_PermissionItemRolesInUserRanks AS PIU with (nolock) INNER JOIN
                      spb_PermissionItems AS P with (nolock) ON PIU.ItemID = P.ItemID
WHERE     (PIU.Rank = @Rank) AND (P.ApplicationID = @ApplicationID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取链接 */

CREATE PROCEDURE [dbo].[spb_ClubLink_Get] 
(
    @LinkID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select l.*,c.CategoryName
from spb_ClubLinks as l with (nolock) inner join spb_ClubLinkCategories as c with (nolock) on l.categoryid=c.categoryid where l.LinkID=@LinkID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 用户链接类别 */

CREATE PROCEDURE [dbo].[spb_ClubLink_CreateUpdateDelete]
( 
    @Action int,
	@LinkID	int output,
	@ClubID	int = 0,
	@CategoryID	int = 0,
	@Title nvarchar(256) = '',
	@ImageUrl nvarchar(256) = '',
	@LinkTitle nvarchar(256) = '',
	@LinkHref nvarchar(256) = '',
	@LinkType int = 0,
	@IsEnabled bit = 1,
	@DisplayOrder int = 0 output
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
        delete from spb_ClubLinks where LinkID = @LinkID    --删除
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin
--				--取用户的最大值
--				DECLARE @NewDisplayOrder int
--				select @NewDisplayOrder=max(DisplayOrder) from spb_ClubLinks where ClubID=@ClubID
--				if (@NewDisplayOrder is null) --新记录
--					begin
--						set @NewDisplayOrder = 0
--					end
--				else 
--					begin
--						set @NewDisplayOrder = @NewDisplayOrder + 1
--					end
				INSERT INTO [spb_ClubLinks] ([ClubID],[CategoryID],[Title],[ImageUrl],[LinkTitle],[LinkHref],[LinkType],[IsEnabled],[DisplayOrder])
                      VALUES (@ClubID,@CategoryID,@Title,@ImageUrl,@LinkTitle,@LinkHref,@LinkType,@IsEnabled,@DisplayOrder)
            
				select @DisplayOrder = @DisplayOrder
                select @LinkID = SCOPE_IDENTITY() 
            end       
         else --更新
            begin
				UPDATE [spb_ClubLinks]
				   SET [CategoryID] = @CategoryID
					  ,[Title] = @Title
					  ,[ImageUrl] = @ImageUrl
					  ,[LinkTitle] = @LinkTitle
					  ,[LinkHref] = @LinkHref
					  ,[LinkType] = @LinkType
					  ,[IsEnabled] = @IsEnabled
					  ,[DisplayOrder] = @DisplayOrder
					where LinkID=@LinkID
            end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除圈子某个类别的链接 */

Create PROCEDURE [dbo].[spb_ClubLinks_DeleteByCategoryID]
(
	@CategoryID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

delete from spb_ClubLinks where CategoryID=@CategoryID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteComment_UpdateAuditingStatus]
(
    @CommentID int,
    @AuditingStatus int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
update spb_VoteComments
set AuditingStatus = @AuditingStatus
Where CommentID=@CommentID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteComment_CreateDelete]
(
    @CommentID int output,
    @ParentID int = 0,
    @ThreadID int = 0,
    @ThreadOwnerID int = 0,
    @UserID int = 0,
    @PresentAreaID int = 0,
    @Author nvarchar(256) = '',
    @Body ntext = '',
    @AuditingStatus int = 40,
    @UserHostAddress nvarchar(64) = N'000.000.000.000',
    @PropertyNames ntext=null,
    @PropertyValues ntext=null,
    @Action int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if(@Action=0)
begin   
   insert into spb_VoteComments
   (ParentID,ThreadID,ThreadOwnerID,UserID,PresentAreaID,Author,Body,AuditingStatus,UserHostAddress,PropertyNames,PropertyValues)
   values
   (@ParentID,@ThreadID,@ThreadOwnerID,@UserID,@PresentAreaID,@Author,@Body,@AuditingStatus,@UserHostAddress,@PropertyNames,@PropertyValues)
   set @CommentID=SCOPE_IDENTITY()
   
   update spb_VoteThreads
   set CommentCount=CommentCount+1
   Where ThreadID = @ThreadID
   
end
else if(@Action=2)
begin
	if not exists(select * from spb_VoteComments with (nolock) where CommentID=@CommentID)
		return
	delete from spb_VoteComments where CommentID=@CommentID
	
    update spb_VoteThreads
    set CommentCount=CommentCount-1
    where ThreadID = @ThreadID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台投票统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_VoteManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingCommentCount int out,
@PendingClubThreadCount int out,
@AgainClubThreadCount int out,
@PendingClubCommentCount int out
)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
	
select @PendingThreadCount= count(ThreadID) from spb_VoteThreads with (nolock) where AuditingStatus=20 and PresentAreaID=11
select @AgainThreadCount=count(ThreadID) from spb_VoteThreads with (nolock) where AuditingStatus=30 and PresentAreaID=11
select @PendingCommentCount=count(CommentID) from spb_VoteComments with (nolock) where AuditingStatus=20 and PresentAreaID=11

select @PendingClubThreadCount= count(ThreadID) from spb_VoteThreads with (nolock) where AuditingStatus=20 and PresentAreaID=13
select @AgainClubThreadCount=count(ThreadID) from spb_VoteThreads with (nolock) where AuditingStatus=30 and PresentAreaID=13
select @PendingClubCommentCount=count(CommentID) from spb_VoteComments with (nolock) where AuditingStatus=20 and PresentAreaID=13

END
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteComment_Get]
(
    @CommentID int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
    select * from spb_VoteComments where CommentID = @CommentID
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据AttachmentID获取NewsThreadAttachment */

create PROCEDURE [dbo].[spb_FileAttachment_Get]
(
    @AttachmentID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_FileAttachments WITH (NOLOCK)
WHERE 
    AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建NewsAttachment  **/

create PROCEDURE [dbo].[spb_FileAttachment_Create] 
(
    @AttachmentID int out,
    @ThreadID int,	
	@UserID int,
    @FileName nvarchar(512) ,
    @FriendlyFileName nvarchar(512),
	@ContentType nvarchar(64),
 	@ContentSize int ,
    @Height int,
    @Width int,
	@IsRemote bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

INSERT spb_FileAttachments (ThreadID,UserID,FileName,FriendlyFileName,ContentType,ContentSize,Height,Width,IsRemote)
		values (@ThreadID,@UserID,@FileName,@FriendlyFileName,@ContentType,@ContentSize,@Height,@Width,@IsRemote)

SELECT @AttachmentID = SCOPE_IDENTITY()
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除NewsThreadAttachment */

create PROCEDURE [dbo].[spb_FileAttachments_DeleteByThreadID] 
(
    @ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

delete spb_FileAttachments where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除FileAttachments */

create PROCEDURE [dbo].[spb_FileAttachment_Delete] 
(
    @AttachmentID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

delete spb_FileAttachments where AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ThreadID获取NewsThreadAttachment */

create PROCEDURE [dbo].[spb_FileAttachments_GetByThreadID]
(
    @ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_FileAttachments WITH (NOLOCK)
WHERE 
    ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除FileThreadAttachment */

CREATE PROCEDURE [dbo].[spb_FileAttachments_DeleteByOwnerUserID] 
(
    @OwnerUserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select ThreadID from spb_FileAttachments WITH (NOLOCK) where UserID = @OwnerUserID

delete spb_FileAttachments where UserID = @OwnerUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ThreadID获取FileThreadAttachment */

CREATE PROCEDURE [dbo].[spb_FileTemporaryAttachmentIDs_GetByUserID]
(
    @UserID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    AttachmentID
FROM    
	spb_FileAttachments WITH (NOLOCK)
WHERE 
    UserID =  @UserID and ThreadID<=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_FileAttachment_UpdateAssociateID]
(
    @AttachmentID int,
    @AssociateID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_FileAttachments set
	ThreadID=@AssociateID
WHERE 
    AttachmentID=@AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取RoleID对应的权限规则 **/

CREATE PROCEDURE [dbo].[spb_PermissionItemRolesInUserRole_Get] 
(
	@RoleID int,
	@ApplicationID  int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
SELECT     P.*, PIU.RoleID, PIU.AllowedValue, PIU.AllowType ,PIU.IsLocked
FROM         spb_PermissionItemRolesInUserRoles AS PIU INNER JOIN
                      spb_PermissionItems AS P ON PIU.ItemID = P.ItemID
WHERE     (PIU.RoleID = @RoleID) AND (P.ApplicationID = @ApplicationID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新权限项目针对用户角色的设置，如果该PermissionItemRole不存在则创建 **/

CREATE PROCEDURE [dbo].[spb_PermissionItemRoleInUserRole_Update] 
(
  @ItemID	int,
  @RoleID	int,
  @AllowType	int,
  @AllowedValue	float,
  @IsLocked bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
--如果权限设置项PermissionItemRole不存在，则创建
if exists (select ItemID,RoleID from spb_PermissionItemRolesInUserRoles with (nolock) where ItemID=@ItemID and RoleID=@RoleID)
    UPDATE  spb_PermissionItemRolesInUserRoles
		    SET AllowType = @AllowType, AllowedValue = @AllowedValue,IsLocked=@IsLocked
		    WHERE (ItemID = @ItemID) AND (RoleID = @RoleID)
else
		INSERT INTO spb_PermissionItemRolesInUserRoles (ItemID, RoleID, AllowType, AllowedValue,IsLocked)
		    VALUES (@ItemID,@RoleID,@AllowType,@AllowedValue,@IsLocked)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 批量删除某个人或所有人的个人动态 **/
CREATE PROCEDURE [dbo].[spb_UserActivities_BatchDelete] 
(
  @userID int=-1,
  @beforeDays	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @currentDate datetime
declare @numberOfDelete int
set @currentDate = getdate()
  if(@userID>0)
    select @numberOfDelete = count(ActivityID) from spb_UserActivities with (nolock) where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays) and (LeadingActorUserID=@userID)
  else
    select @numberOfDelete = count(ActivityID) from spb_UserActivities with (nolock) where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays)

  if(@userID>0)
   delete from spb_UserActivities where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays) and (LeadingActorUserID=@userID)
  else
    delete from spb_UserActivities where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays)

SELECT @numberOfDelete -- Success
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取个人动态详细信息 */

CREATE PROCEDURE [dbo].[spb_UserActivity_Get]
( 
    @ActivityID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_UserActivities with (nolock) where ActivityID=@ActivityID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_UserActivities_Delete] 
(
  @applicationID int=-1,
  @relativeItemID int=-1
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

delete dbo.spb_FriendActivityInbox where [ActivityID] in (SELECT [ActivityID] FROM [dbo].[spb_FriendActivities] where [ApplicationID] = @applicationID and [RelativeItemID] = @relativeItemID)
delete dbo.spb_FriendActivities where [ApplicationID] = @applicationID and [RelativeItemID] = @relativeItemID

delete dbo.spb_UserActivities where [ApplicationID] = @applicationID and [RelativeItemID] = @relativeItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除数据库Email队列中的Email **/

CREATE proc [dbo].[spb_EmailQueue_Delete]
	@EmailID uniqueidentifier 
as
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED
	delete from spb_EmailQueue where EmailID = @EmailID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 把Email队列存到数据库 **/

CREATE  PROCEDURE [dbo].[spb_Emails_Enqueue]
(
	@EmailTo	nvarchar(2000),
	@EmailCc	ntext,
	@EmailBcc	ntext,
	@EmailFrom	nvarchar(256),
	@EmailSubject	nvarchar(1024),
	@EmailBody	ntext,
	@EmailPriority	int,
	@IsBodyHtml int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
BEGIN

	INSERT INTO
		spb_EmailQueue
		(
			emailTo,
			emailCc,
			emailBcc,
			EmailFrom,
			EmailSubject,
			EmailBody,
			emailPriority,
			IsBodyHtml
		)
	VALUES
		(
			@EmailTo,
			@EmailCc,
			@EmailBcc,
			@EmailFrom,
			@EmailSubject,
			@EmailBody,
			@EmailPriority,
			@IsBodyHtml
		)		
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** Email发送失败后，处理失败计数，如果失败次数超过一定数量则删除此Email **/

CREATE proc [dbo].[spb_EmailQueue_Failure]
	@EmailID uniqueidentifier,
	@FailureInterval int,
	@MaxNumberOfTries int
as
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @NumberOfTries int
select @NumberOfTries = NumberOfTries + 1 from spb_EmailQueue with (nolock) where EmailID = @EmailID

if @NumberOfTries <= @MaxNumberOfTries
	update spb_EmailQueue set
		NumberOfTries = @NumberOfTries,
		NextTryTime = dateadd(minute, @NumberOfTries * @FailureInterval, getdate())
	where EmailID = @EmailID
else
	delete from spb_EmailQueue where EmailID = @EmailID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 从数据库取出Email队列 **/

CREATE PROCEDURE [dbo].[spb_Emails_Dequeue]
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
BEGIN

	SELECT * FROM spb_EmailQueue with (nolock) Where NextTryTime < getdate()
	
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、删除MicroBlogTopic **/
CREATE PROCEDURE [dbo].[spb_MicroBlogTopic_CreateUpdateDelete] 
(
    @Action int,
	@TopicID int output,
	@Title nvarchar(150) = '''',
	@IsFeatured bit = 0,
	@Body nvarchar(150)='''',
 	@UserID int = 0,
 	
 	@Description nvarchar(512) = '''',
 	@FileName nvarchar(255) = '''',
 	@UserNames varchar(200) = ''''
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if @Action = 0 --添加
begin
    declare @temTopicID int
    select @temTopicID = TopicID from spb_MicroBlogTopics where Body like @Body
	if @temTopicID <= 0 or @temTopicID is null
	Begin
		INSERT spb_MicroBlogTopics (Title,Body,UserID,IsFeatured,ItemCount,StageItemCount)Values (@Title,@Body,@UserID,@IsFeatured,1,1)
		Set @TopicID = SCOPE_IDENTITY()
		if @IsFeatured = 0
		Begin
			Insert into spb_MicroBlogFeaturedTopics(TopicID,Description,FileName,UserNames)
			values (@TopicID,@Description,@FileName,@UserNames)
		End
	End
	else
	Begin
		update spb_MicroBlogTopics
		Set Title = @Title,IsFeatured = @IsFeatured,ItemCount = ItemCount + 1,StageItemCount = StageItemCount + 1
		where Body like @Body
		if exists (select 1 from spb_MicroBlogFeaturedTopics where TopicID = @temTopicID)
			update spb_MicroBlogFeaturedTopics 
			set Description = @Description,FileName = @FileName,UserNames = @UserNames
			where TopicID = @temTopicID
		else
			Insert into spb_MicroBlogFeaturedTopics(TopicID,Description,FileName,UserNames)
			values (@temTopicID,@Description,@FileName,@UserNames)
		Set @TopicID = @temTopicID
	ENd
End
else if @Action = 1 
Begin
	update spb_MicroBlogTopics
	set Title = @Title,IsFeatured = @IsFeatured
	where TopicID = @TopicID
	if exists (select 1 from spb_MicroBlogFeaturedTopics where TopicID = @TopicID)
		update spb_MicroBlogFeaturedTopics 
		set Description = @Description,FileName = @FileName,UserNames = @UserNames
		where TopicID = @TopicID
	else
		Insert into spb_MicroBlogFeaturedTopics(TopicID,Description,FileName,UserNames)
		values (@TopicID,@Description,@FileName,@UserNames)

End
else if @Action = 2
    delete from spb_MicroBlogTopics where TopicID = @TopicID
SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_MicroBlogTopic_Get]
(
    @TopicID int = 0
)   
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
    select T.TopicID,T.Title,T.Body,T.UserID,T.IsFeatured,T.ItemCount,T.StageItemCount,T.DateCreated,FT.Description,FT.FileName,FT.UserNames
    from spb_MicroBlogTopics T with (nolock) left join
    spb_MicroBlogFeaturedTopics FT with (nolock) on T.TopicID = FT.TopicID where T.TopicID = @TopicID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_MicroBlog_GetTopicWithTopicID] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
select TopicID,Body from spb_MicroBlogTopics with (nolock)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_MicroBlogThreadReferUser_Create] 
(
	@ThreadID int,
	@UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
insert into spb_MicroBlogThreadsReferUsers(ThreadID,UserID)
	values(@ThreadID,@UserID)
Set NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有标题前缀 **/
CREATE PROCEDURE [dbo].[spb_NewsTitlePrefixes_Get]

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
	
select * from spb_NewsTitlePrefixes WITH (NOLOCK)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建资讯标题前缀 **/
CREATE PROCEDURE [dbo].[spb_NewsTitlePrefix_Create]
(
	@Name nvarchar(64),
	@PrefixID int = 0 output
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if not exists (select PrefixID from spb_NewsTitlePrefixes WITH (NOLOCK) where Name=@Name)
	begin	
		insert into spb_NewsTitlePrefixes(Name)values(@Name)
		set @PrefixID=SCOPE_IDENTITY()
	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除资讯标题前缀 **/
CREATE PROCEDURE [dbo].[spb_NewsTitlePrefix_Delete]
(
	@PrefixID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
	
delete spb_NewsTitlePrefixes where PrefixID=@PrefixID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新资讯标题前缀 **/
CREATE PROCEDURE [dbo].[spb_NewsTitlePrefix_Update]
(
	@PrefixID int,
	@Name nvarchar(64),
	@isSuccess bit output
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if not exists (select PrefixID from spb_NewsTitlePrefixes WITH (NOLOCK) where Name=@Name)
	begin	
		update spb_NewsTitlePrefixes set Name=@Name where PrefixID=@PrefixID
		set @isSuccess=1
	end
else
	set @isSuccess=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 添加私信 **/

CREATE PROCEDURE [dbo].[spb_PrivateMessage_Create] 
(
    @ThreadID int out,
    @SenderUserID	int,
    @Sender	nvarchar(64),
    @ReceiverUserID	int,
    @Receiver	nvarchar(64),
    @RelativeItemID	int,
    @RelativeItemName	nvarchar(64),
    @MessageType	int,
    @IsLocked	bit,
    @PropertyNames	ntext = null,
    @PropertyValues	ntext = null,
	  @Subject nvarchar(512),
	  @Body nvarchar(3000),
    @UserHostAddress nvarchar(64)
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

BEGIN
  insert into spb_PrivateMessageThreads (SenderUserID,Sender,ReceiverUserID,Receiver,RelativeItemID,RelativeItemName,MessageType,IsLocked,PropertyNames,PropertyValues)
      values (@SenderUserID,@Sender,@ReceiverUserID,@Receiver,@RelativeItemID,@RelativeItemName,@MessageType,@IsLocked,@PropertyNames,@PropertyValues)
      
	-- Get the new ThreadID
	SELECT @ThreadID = SCOPE_IDENTITY()

  declare @PostID int
  insert into spb_PrivateMessagePosts (ParentPostID,ThreadID,UserID,Author,Subject,Body,UserHostAddress) 
      values (0,@ThreadID,@SenderUserID,@Sender,@Subject,@Body,@UserHostAddress)

	-- Get the new PostID
	SELECT @PostID = SCOPE_IDENTITY()


  --处理发件箱
  insert into spb_PrivateMessageOutbox (UserID,ThreadID,MessageType,IsLocked,ReceiverUserID,Receiver,MostRecentPostDate
        ,MostRecentPostID,MostRecentPostSubject,MostRecentPostBody)
      values (@SenderUserID,@ThreadID,@MessageType,@IsLocked,@ReceiverUserID,@Receiver,getdate(),@PostID,@Subject,@Body)

--处理收件箱
  insert into spb_PrivateMessageInbox (UserID,ThreadID,MessageType,IsLocked,SenderUserID,Sender,MostRecentPostDate,
        MostRecentPostID,MostRecentPostSubject,MostRecentPostBody,IsRead)
      values (@ReceiverUserID,@ThreadID,@MessageType,@IsLocked,@SenderUserID,@Sender,getdate(),@PostID,@Subject,@Body,0)

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取私信及回复 **/
CREATE PROCEDURE [dbo].[spb_PrivateMessage_Get] 
(
  @ThreadID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_PrivateMessageThreads with (nolock) where ThreadID=@ThreadID
select * from spb_PrivateMessagePosts with (nolock) where ThreadID=@ThreadID order by PostDate
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 尝试删除私信及回复（依据：发件箱、收件箱都已经删除的情况下） **/
CREATE PROCEDURE [dbo].[spb_PrivateMessage_TryDelete] 
(
  @ThreadID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (not exists (select ThreadID from spb_PrivateMessageInbox with (nolock) where ThreadID=@ThreadID)) and
  (not exists (select ThreadID from spb_PrivateMessageOutbox with (nolock) where ThreadID=@ThreadID))
begin
  delete from spb_PrivateMessagePosts where  ThreadID=@ThreadID
  delete from spb_PrivateMessageThreads where ThreadID=@ThreadID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 回复私信 **/
CREATE PROCEDURE [dbo].[spb_PrivateMessage_Reply] 
(
  @ThreadID	int,
  @ParentPostID	int = -1,
  @UserID	int,
  @Author	nvarchar(64),
  @Subject	nvarchar(512),
  @Body	nvarchar(3000),
  @UserHostAddress	nvarchar(64)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare  @SenderUserID	int
declare  @Sender	nvarchar(256)
declare  @ReceiverUserID	int
declare  @Receiver	nvarchar(256)
declare  @MessageType	int
declare  @IsLocked	bit

select  @SenderUserID=SenderUserID,@Sender=Sender,@ReceiverUserID=ReceiverUserID,@Receiver=Receiver,
  @MessageType=MessageType,@IsLocked=IsLocked from spb_PrivateMessageThreads with (nolock) where ThreadID=@ThreadID

if @ParentPostID=-1
  select @ParentPostID=PostID from spb_PrivateMessagePosts with (nolock) where ThreadID=@ThreadID and ParentPostID=0

insert into spb_PrivateMessagePosts (ThreadID,ParentPostID,UserID,Author,Subject,Body,UserHostAddress) values
    (@ThreadID,@ParentPostID,@UserID,@Author,@Subject,@Body,@UserHostAddress)

declare @MostRecentPostID int
SELECT @MostRecentPostID = SCOPE_IDENTITY()

--更新私信的回复计数
update spb_PrivateMessageThreads set ReplyCount = ReplyCount+1 where ThreadID=@ThreadID


declare  @ReceiverUserIDOfOutbox	int --在回复人的 发件箱中的接收人
declare  @ReceiverOfOutbox	nvarchar(256) --在回复人的 发件箱中的接收人
declare  @UserIDOfInbox	int --谁接收

if (@UserID=@SenderUserID)
  begin
    set @ReceiverUserIDOfOutbox=@ReceiverUserID
    set @ReceiverOfOutbox=@Receiver
    set @UserIDOfInbox=@ReceiverUserID
  end
else
  begin
    set @ReceiverUserIDOfOutbox=@SenderUserID
    set @ReceiverOfOutbox=@Sender
    set @UserIDOfInbox=@SenderUserID
  end

--处理发件箱
if exists (select ThreadID from spb_PrivateMessageOutbox with (nolock) where UserID=@UserID and ThreadID=@ThreadID)
  update spb_PrivateMessageOutbox set 
    MostRecentPostDate=getdate(), MostRecentPostID=@MostRecentPostID,MostRecentPostSubject=@Subject,MostRecentPostBody=@Body
    where UserID=@UserID and ThreadID=@ThreadID
else
  insert into spb_PrivateMessageOutbox (UserID,ThreadID,MessageType,IsLocked,ReceiverUserID,Receiver,MostRecentPostDate
        ,MostRecentPostID,MostRecentPostSubject,MostRecentPostBody)
      values (@UserID,@ThreadID,@MessageType,@IsLocked,@ReceiverUserIDOfOutbox,@ReceiverOfOutbox,getdate()
        ,@MostRecentPostID,@Subject,@Body)

--处理收件箱
if exists (select ThreadID from spb_PrivateMessageInbox with (nolock) where UserID=@UserIDOfInbox and ThreadID=@ThreadID)
  update spb_PrivateMessageInbox set
    MostRecentPostDate=getdate(), IsRead=0, MostRecentPostID=@MostRecentPostID,MostRecentPostSubject=@Subject,MostRecentPostBody=@Body
    where UserID=@UserIDOfInbox and ThreadID=@ThreadID
else
  insert into spb_PrivateMessageInbox (UserID,ThreadID,MessageType,IsLocked,SenderUserID,Sender,MostRecentPostDate,
        MostRecentPostID,MostRecentPostSubject,MostRecentPostBody,IsRead)
      values (@UserIDOfInbox,@ThreadID,@MessageType,@IsLocked,@UserID,@Author,getdate()
        ,@MostRecentPostID,@Subject,@Body,0)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 批量删除过期私信 **/
CREATE PROCEDURE [dbo].[spb_PrivateMessages_BatchDelete] 
(
  @beforeDays	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @currentDate datetime
declare @numberOfDelete int
set @currentDate = getdate()

select @numberOfDelete = count(ThreadID) from spb_PrivateMessageThreads with (nolock) where DateDiff(day,LastRepliedDate,@currentDate) >= @beforeDays

BEGIN TRANSACTION

delete from spb_PrivateMessageInbox where ThreadID in
	(select ThreadID from spb_PrivateMessageThreads with (nolock) where DateDiff(day,LastRepliedDate,@currentDate) >= @beforeDays)
if (@@ERROR <> 0) GOTO Failure
delete from spb_PrivateMessageOutbox where ThreadID in
	(select ThreadID from spb_PrivateMessageThreads with (nolock) where DateDiff(day,LastRepliedDate,@currentDate) >= @beforeDays)
if (@@ERROR <> 0) GOTO Failure
delete from spb_PrivateMessagePosts where ThreadID in
	(select ThreadID from spb_PrivateMessageThreads with (nolock) where DateDiff(day,LastRepliedDate,@currentDate) >= @beforeDays)
if (@@ERROR <> 0) GOTO Failure
delete from spb_PrivateMessageThreads where DateDiff(day,LastRepliedDate,@currentDate) >= @beforeDays
if (@@ERROR <> 0) GOTO Failure
COMMIT TRANSACTION
SELECT @numberOfDelete -- Success
RETURN
Failure:
	ROLLBACK TRANSACTION
	SELECT 0 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 圈子链接类别 */
CREATE PROCEDURE [dbo].[spb_ClubLinkCategory_CreateUpdateDelete]
( 
    @Action int,
    @CategoryID	int output,
    @ClubID	int = 0,
    @CategoryName nvarchar(256) = '',
    @Description	nvarchar(1024) = '',
    @DisplayOrder	int = 100
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
        delete from spb_ClubLinkCategories where CategoryID = @CategoryID    --删除
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
           begin
--				DECLARE @NewDisplayOrder int
--				select @NewDisplayOrder=max(DisplayOrder) from spb_ClubLinkCategories where ClubID=@ClubID
--				if (@NewDisplayOrder is null) --新记录
--					begin
--						set @NewDisplayOrder = 0
--					end
--				else 
--					begin
--						set @NewDisplayOrder = @NewDisplayOrder + 1
--					end
				
                insert into spb_ClubLinkCategories (ClubID,CategoryName,Description,DisplayOrder) values (
                    @ClubID,@CategoryName,@Description,@DisplayOrder)
            
                select @CategoryID = SCOPE_IDENTITY() 
            end       
		else --更新
			begin
                update spb_ClubLinkCategories set 
                    CategoryName     = @CategoryName,
                    Description      = @Description,
                    DisplayOrder     = @DisplayOrder
                    where CategoryID = @CategoryID
            end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--获得链接类别
CREATE PROCEDURE [dbo].[spb_ClubLinkCategory_Get] 
(
@CategoryID int
)
AS
BEGIN
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_ClubLinkCategories with (nolock) where CategoryID=@CategoryID

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
--获得链接类别集合
CREATE PROCEDURE [dbo].[spb_ClubLinkCategories_GetByClubID] 
(
  @ClubID int
)
AS
BEGIN
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_ClubLinkCategories with (nolock) where ClubID=@ClubID order by DisplayOrder

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE procedure [dbo].[spb_NewsRatings_CreateUpdate]
(
	@ThreadID int,
	@UserID int,
	@Author nvarchar(64),
	@Rate int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

if exists (select ThreadID from spb_NewsRatings WITH (NOLOCK) where ThreadID=@ThreadID and UserID=@UserID)
  begin
    UPDATE    spb_NewsThreads
    SET       RatingSum=RatingSum+@Rate-(select Rate from spb_NewsRatings with (nolock) where ThreadID=@ThreadID and UserID=@UserID)
    Where     ThreadID = @ThreadID
    
	update spb_NewsRatings set Rate=@Rate where ThreadID=@ThreadID and UserID=@UserID
  end
else
  begin
	insert into spb_NewsRatings(ThreadID,UserID,Author,Rate)values(@ThreadID,@UserID,@Author,@Rate)
    
    UPDATE    spb_NewsThreads
    SET       RatingSum=RatingSum + @Rate,TotalRatings=TotalRatings+1
    Where     ThreadID = @ThreadID
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 活动点击计数 **/
CREATE PROCEDURE [dbo].[spb_EventThreadView_Add]
(
	@ItemID int=0,
	@WebViewCount int=0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_EventThreads set HitTimes = HitTimes+@WebViewCount where EventID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 处理需要结束的活动 */

CREATE PROCEDURE [dbo].[spb_EventThreads_ApplyNeedFinished] 

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON        


--更新活动积分以及活动状态
update spb_EventThreads set 
EventStatus = 9
where EventStatus = 1 and GetDate()>EndTime
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据EventID获取EventThread */

CREATE PROCEDURE [dbo].[spb_EventThread_Get]
(
    @EventID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     *
FROM       spb_EventThreads WITH (NOLOCK)
WHERE     (EventID = @EventID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 取消活动 */

CREATE PROCEDURE [dbo].[spb_EventThread_Cancel]
( 
    @EventID int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_EventThreads set EventStatus=2 where EventID=@EventID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置站点网摘类别 */

Create PROCEDURE [dbo].[spb_EventThread_UpdateSiteCategoryByCategoryID]
( 
    @fromSiteCategoryID int,
    @toSiteCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_EventThreads set SiteCategoryID=@toSiteCategoryID where SiteCategoryID=@fromSiteCategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置活动审核状态 */

create PROCEDURE [dbo].[spb_EventThread_UpdateAuditingStatus]
( 
    @EventID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_EventThreads set AuditingStatus=@AuditingStatus where EventID=@EventID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置活动精华状态 */

create PROCEDURE [dbo].[spb_EventThread_UpdateIsEssential]
( 
    @EventID int,
    @IsEssential	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_EventThreads set IsEssential=@IsEssential where EventID=@EventID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 添加资讯读者 **/
CREATE PROCEDURE [dbo].[spb_NewsReader_Create]
(
	@ThreadID int,
	@UserID int,
	@ReaderDisplayName nvarchar(256),
	@ConsumedPoint float
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if not exists (select ThreadID from spb_NewsReaders with (nolock) where ThreadID=@ThreadID and UserID=@UserID)
	insert into spb_NewsReaders(ThreadID,UserID,ReaderDisplayName,ConsumedPoint)
		values(@ThreadID,@UserID,@ReaderDisplayName,@ConsumedPoint)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_NewsReaders_GetByThreadID]
(
	@ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select UserID from spb_NewsReaders WITH (NOLOCK) where ThreadID=@ThreadID

set nocount OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* add/update/delete item prepare for index */
CREATE PROCEDURE [dbo].[spb_ItemForIndex_CreateUpdateDelete]
(
    @Action int,
    @ItemID int,
    @SearchTypeCode nvarchar(64),
    @ClubID int = 0,
    @DataAction int = null
)
	    
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --insert
begin
    if  exists (select ItemID from spb_ItemsForIndex with (nolock) where ItemID = @ItemID and SearchTypeCode = @SearchTypeCode)
        delete from spb_ItemsForIndex where ItemID = @ItemID and SearchTypeCode = @SearchTypeCode

    insert into spb_ItemsForIndex (ItemID,DataAction,SearchTypeCode,ClubID) values (@ItemID,@DataAction,@SearchTypeCode,@ClubID)
end

else if (@Action = 1) --update
    update spb_ItemsForIndex set DataAction = @DataAction where ItemID = @ItemID and SearchTypeCode = @SearchTypeCode
else if (@Action = 2) --delete
    delete from spb_ItemsForIndex where ItemID = @ItemID and SearchTypeCode = @SearchTypeCode
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* get items prepare for index */
CREATE PROCEDURE [dbo].[spb_ItemsForIndex_Gets]
(
    @SearchTypeCode nvarchar(64),
    @ReturnCount int = 1000
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
SET ROWCOUNT @ReturnCount
select * from spb_ItemsForIndex with (nolock) where SearchTypeCode = @SearchTypeCode order by DateCreated
SET ROWCOUNT 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有活动地区统计以及最大深度 **/

CREATE PROCEDURE [dbo].[spb_EventAreaStatisticss_GetAll] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     A.*,isnull(E.PublishedCount,0) as PublishedCount,isnull(E.FinishedCount,0) as FinishedCount, isnull(E.TotalCount,0) as TotalCount
FROM         spb_Areas A with (nolock) left JOIN
                      spb_EventAreaStatistics E with (nolock) ON A.AreaCode = E.AreaCode

SELECT     MAX(A.Depth) AS MaxDepth
FROM         spb_Areas A with (nolock)  left JOIN
           spb_EventAreaStatistics E with (nolock) ON A.AreaCode = E.AreaCode
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新默认动态项目设置 **/

CREATE PROCEDURE [dbo].[spb_ActivityItemSettingsInGlobal_Update] 
(
    @ItemID	int,
    @IsAllowSending	bit,
    @IsAllowReceiving	bit
	) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
if exists (select ItemID from spb_GlobalActivityItemSettings with (nolock) where ItemID=@ItemID)
    UPDATE    spb_GlobalActivityItemSettings
    SET   IsAllowSending = @IsAllowSending, IsAllowReceiving = @IsAllowReceiving
    WHERE   (ItemID = @ItemID)
--如果要更新的项目不存在则创建
else
    INSERT INTO spb_GlobalActivityItemSettings
        (ItemID, IsAllowSending, IsAllowReceiving)
    VALUES  (@ItemID,@IsAllowSending,@IsAllowReceiving)
    
SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取某个用户的所有站内会员的朋友 **/

CREATE PROCEDURE [dbo].[spb_Friends_GetByUserID]  
(
	@UserID int,
	@CategoryID int=-1
	
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if(@CategoryID > 0)
begin
	SELECT     F.FriendUserID,F.FriendID
	FROM       spb_Friends F with (nolock) join spb_FriendsInUserCategories I on  F.FriendID = I.ItemID
	WHERE      F.UserID=@UserID and F.FriendID>0 and I.CategoryID=@CategoryID
end
else
begin
	SELECT     F.FriendUserID,F.FriendID
	FROM       spb_Friends F with (nolock) 
	WHERE  F.UserID=@UserID and F.FriendID>0
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据获取用户的所有朋友UserID **/

CREATE PROCEDURE [dbo].[spb_Friend_GetFriendUserIDs] 
(
    @UserID int,
    @categoryID int = -1,
	@MaxRecords int = -1
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@MaxRecords>0)
  set RowCount @MaxRecords
  
if(@categoryID > 0)
begin
select F.FriendUserID from spb_Friends F with (nolock) inner join spb_FriendsInUserCategories i with (nolock) on i.ItemID = F.[FriendID] where F.UserID=@UserID and i.CategoryID = @categoryID
end
else
begin
select F.FriendUserID from spb_Friends F with (nolock) where F.UserID=@UserID
end

if (@MaxRecords>0)
  set RowCount 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有权限项集合 **/

CREATE PROCEDURE [dbo].[spb_PermissionItems_GetAll] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     *
FROM         spb_PermissionItems with (nolock)
ORDER BY ApplicationID, DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取图片的元数据 **/

CREATE PROCEDURE [dbo].[spb_PhotoMetaData_Get]
	@ThreadID int
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
select MetaKey, MetaType, MetaValue from spb_PhotoMetaData  with (nolock) where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 更新图片的元数据 */

CREATE PROCEDURE [dbo].[spb_PhotoMetaData_Update]
(
	@ThreadID int,
	@MetadataList ntext
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
delete from spb_PhotoMetaData where ThreadID = @ThreadID

if @MetadataList is null --or len(ltrim(rtrim(@MetadataList))) = 0
return

declare @idoc int

EXEC sp_xml_preparedocument @idoc OUTPUT, @MetadataList

insert into spb_PhotoMetaData (ThreadID, MetaKey, MetaType, MetaValue)
	select @ThreadID, M.[key], M.[type], M.[value]
	from openxml(@idoc, '/entries/entry', 1)
		with ([key] nvarchar(100), [type] nvarchar(100), [value] nvarchar(50)) as M

EXEC sp_xml_removedocument @idoc
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 批准BlogPost */

CREATE PROCEDURE [dbo].[spb_BlogComment_Approve] 
(
    @PostID		int,
    @IsApproved bit = 1
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_BlogComments set IsApproved = @IsApproved where PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据PostID获取BlogPost */

CREATE PROCEDURE [dbo].[spb_BlogComment_Get]
(
    @PostID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_BlogComments BP with (nolock)
WHERE 
    BP.PostID = @PostID

SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置博客文章审核状态 */

CREATE PROCEDURE [dbo].[spb_BlogComment_UpdateAuditingStatus]
( 
    @PostID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_BlogComments set AuditingStatus=@AuditingStatus where PostID=@PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_ForumUserData_ChangeExperiencePoints]
(
	@UserID int,
	@ExperiencePoints int
)
AS

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

if not exists (select * from spb_ForumUserDatas with (nolock) WHERE [UserID] = @UserID)
		INSERT INTO spb_ForumUserDatas (UserID,ExperiencePoints)values(@UserID,@ExperiencePoints)
else
		Update spb_ForumUserDatas set ExperiencePoints=ExperiencePoints+@ExperiencePoints where UserID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create procedure [dbo].[spb_ForumUserData_Get]
(
  @UserID int
)
AS
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED
select * from spb_ForumUserDatas with (nolock) where UserID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_ForumUserData_Update]
(
	@UserID int,
	@Signature nvarchar(1024)
)
AS

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

if not exists (select * from spb_ForumUserDatas with (nolock) WHERE [UserID] = @UserID)
		INSERT INTO spb_ForumUserDatas (UserID,Signature)values(@UserID,@Signature)
else
		Update spb_ForumUserDatas set Signature=@Signature where UserID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除礼品兑换申请 */

CREATE PROCEDURE [dbo].[spb_ConvertibleGiftExchangeApply_CreateUpdateDelete] 
(
    @Action int,
    @ApplyID int out,
    @UserID int=1,
    @GiftID	int=1,
	@UserDisplayName nvarchar(64)='',
	@Price int =0,
	@ApplyStatus int=0,
	@TotalCount int=0,
	@PropertyNames ntext='',
	@PropertyValues ntext=''
	) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加

	begin

		INSERT spb_ConvertibleGift_ExchangeApplies (GiftID,UserID,UserDisplayName,ApplyStatus,Price,TotalCount,PropertyNames,PropertyValues)
				values (@GiftID,@UserID,@UserDisplayName,@ApplyStatus,@Price,@TotalCount,@PropertyNames,@PropertyValues)

		-- Grab the new PostID and update the ThreadID's info
		SELECT @ApplyID = SCOPE_IDENTITY() 


	end

  else if @Action=1 --更新
	begin
	BEGIN TRAN
	 update spb_ConvertibleGift_ExchangeApplies set 
	        GiftID=@GiftID,UserID=@UserID,LastModified=getdate(),UserDisplayName=@UserDisplayName,ApplyStatus=@ApplyStatus,Price=@Price,TotalCount=@TotalCount,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
	 where ApplyID = @ApplyID
	 
	 if(@ApplyStatus=1)
	 update spb_ConvertibleGifts set TotalCount=TotalCount-@TotalCount,ExchangedCount=ExchangedCount+@TotalCount 
	 where GiftID=@GiftID
	 
	 update spb_Users set CreditPoints=CreditPoints-@Price where UserID=@UserID
	 COMMIT TRANSACTION
		return FAILURE:
       ROLLBACK TRANSACTION
       RETURN
	 
	 	 end
else --删除
begin
delete from spb_ConvertibleGift_ExchangeApplies where ApplyID=@ApplyID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除ConvertibleGift **/

CREATE PROCEDURE [dbo].[spb_ConvertibleGift_CreateUpdateDelete] 
(
    @Action int,
    @GiftID	int output,
	@Subject nvarchar(256)='',
	@Body	ntext= null,
	@Price int =0,
	@ImageFileName varchar(256),
	@IsEnabled bit=1,
	@DisplayOrder int,
	@TotalCount int=0,
	@ExchangedCount int=0
	) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
		
		INSERT INTO [spb_ConvertibleGifts]
				 ( [Subject],Body,Price,ImageFileName,IsEnabled,DisplayOrder, TotalCount,ExchangedCount)
		VALUES     (@Subject,@Body,@Price,@ImageFileName,@IsEnabled,@DisplayOrder, @TotalCount,@ExchangedCount)
	    
	    
		SELECT @GiftID = SCOPE_IDENTITY()
        
    end

  else if @Action=1 --更新
	  begin
	  UPDATE    [spb_ConvertibleGifts]
	  SET  [Subject] = @Subject, 
	  Body = @Body, Price = @Price,
	   ImageFileName = @ImageFileName, 
	   IsEnabled = @IsEnabled,
	    DisplayOrder = @DisplayOrder,
	    TotalCount = @TotalCount, 
	  ExchangedCount = @ExchangedCount,
	  LastModified=getdate()
	  WHERE (GiftID = @GiftID)	  
	  end
  else --删除
	  begin
	  BEGIN TRAN
		DELETE FROM [spb_ConvertibleGifts]WHERE (GiftID = @GiftID)	  
		delete from spb_ConvertibleGift_ExchangeApplies where GiftID = @GiftID
		delete from spb_ConvertibleGift_ExchangeRecords where GiftID = @GiftID
		COMMIT TRANSACTION
		return FAILURE:
       ROLLBACK TRANSACTION
       RETURN
	  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ApplyID获取spb_ConvertibleGifts */

CREATE PROCEDURE [dbo].[spb_ConvertibleGiftExchangeApply_Get]
(
    @ApplyID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT     *
FROM       spb_ConvertibleGift_ExchangeApplies with (nolock)
WHERE     ApplyID = @ApplyID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据serID获取spb_ConvertibleGifts */

create PROCEDURE [dbo].[spb_ConvertibleGiftExchangeApplyIDs_GetByUserID]
(
    @UserID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT     *
FROM       spb_ConvertibleGift_ExchangeApplies with (nolock)
WHERE     UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新用户动态项目设置 **/

CREATE PROCEDURE [dbo].[spb_ActivityItemSettingsInUser_Update] 
(
    @UserID int,
    @ItemID	int,
    @IsAllowSending	bit,
    @IsAllowReceiving	bit
	) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if exists (select ItemID from spb_UserActivityItemSettings with (nolock) where UserID = @UserID  and ItemID=@ItemID)
    UPDATE    spb_UserActivityItemSettings
    SET   IsAllowSending = @IsAllowSending, IsAllowReceiving = @IsAllowReceiving
    WHERE   (UserID = @UserID) and (ItemID = @ItemID)
--如果要更新的项目不存在则创建
else
    INSERT INTO spb_UserActivityItemSettings
        (UserID,ItemID, IsAllowSending, IsAllowReceiving)
    VALUES  (@UserID,@ItemID,@IsAllowSending,@IsAllowReceiving)
SET NOCOUNT off
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ThreadID获取MicroBlogThreadAttachment */

Create PROCEDURE [dbo].[spb_MicroBlogAttachments_GetByThreadID]
(
    @ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    AttachmentID
FROM    
	spb_MicroBlogAttachments with (nolock)
WHERE 
    ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除MicroBlogThreadAttachment */

Create PROCEDURE [dbo].[spb_MicroBlogAttachments_DeleteByThreadID] 
(
    @ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

delete spb_MicroBlogAttachments where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除OwnerAttachment */

Create PROCEDURE [dbo].[spb_MicroBlogAttachments_DeleteByOwnerUserID] 
(
    @UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
delete spb_MicroBlogAttachments where UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建MicroBlogAttachment  **/

Create PROCEDURE [dbo].[spb_MicroBlogAttachment_Create] 
(
    @AttachmentID int out,
    @ThreadID int,	
	@UserID int,
    @FileName nvarchar(512) ,
    @FriendlyFileName nvarchar(512),
	@ContentType nvarchar(64),
 	@ContentSize int ,
    @Height int,
    @Width int,
	@IsRemote bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

INSERT spb_MicroBlogAttachments (ThreadID,UserID,FileName,FriendlyFileName,ContentType,ContentSize,Height,Width,IsRemote)
		values (@ThreadID,@UserID,@FileName,@FriendlyFileName,@ContentType,@ContentSize,@Height,@Width,@IsRemote)

SELECT @AttachmentID = SCOPE_IDENTITY()
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_MicroBlogAttachment_UpdateAssociateID]
(
    @AttachmentID int,
    @AssociateID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_MicroBlogAttachments set
	ThreadID=@AssociateID
WHERE 
    AttachmentID=@AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除MicroBlogAttachments */

Create PROCEDURE [dbo].[spb_MicroBlogAttachment_Delete] 
(
    @AttachmentID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

delete spb_MicroBlogAttachments where AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据AttachmentID获取MicroBlogThreadAttachment */

Create PROCEDURE [dbo].[spb_MicroBlogAttachment_Get]
(
    @AttachmentID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT * FROM spb_MicroBlogAttachments WITH (NOLOCK) WHERE AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据UserID获取临时附件 */

CREATE PROCEDURE [dbo].[spb_MicroBlogTemporaryAttachmentIDs_GetByUserID]
(
    @UserID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT AttachmentID FROM spb_MicroBlogAttachments WITH (NOLOCK) WHERE UserID = @UserID AND ThreadID <= 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 圈子成员 */

CREATE PROCEDURE [dbo].[spb_ClubMember_CreateUpdateDelete] 
(
    @Action int,   
	@ClubID	int=0, 
    @UserID	int=0,
	@Rank	int = 0,
    @Points	int = 0,
	@ClubMemberRole int = 1,
	@Status	int = 1,
	@ApplyRemark	nvarchar(2000) = '',
	@InviteUserID	int = 0,
	@InviteUserDisplayName nvarchar(64) = '',
	@EnableManagerNotification bit = 0,
	@EnableNotificationed bit = 1,
	@DisplayName nvarchar(64)='',
	@UserDisplayInformation nvarchar(2000)='',
	@VisitTimes int =0,

    @PropertyNames ntext = null,
	@PropertyValues ntext = null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    begin
        if not exists(select * from spb_ClubMembers with (nolock) where UserID = @UserID and ClubID = @ClubID)
        return
        select @ClubMemberRole = ClubMemberRole,@Status=Status from spb_ClubMembers with (nolock) where UserID = @UserID and ClubID = @ClubID
        if (@ClubMemberRole < 3)   --圈主不允许删除
            delete spb_ClubMembers where UserID = @UserID and ClubID = @ClubID
        if(@Status=1)
            update spb_Clubs set MemberCount=MemberCount-1 where ClubID = @ClubID
            
        update spb_ClubUserDatas set JoinedClubCount=JoinedClubCount-1 where UserID = @UserID and JoinedClubCount > 0
    end
ELSE 
    BEGIN
        if (@Action = 0) --添加
            BEGIN
              if not exists (select UserID from spb_ClubMembers with (nolock) where UserID = @UserID and ClubID = @ClubID)
		        INSERT INTO spb_ClubMembers (ClubID,UserID,[Rank],Points,ClubMemberRole,Status,ApplyRemark,InviteUserID,InviteUserDisplayName
					,EnableManagerNotification,EnableNotificationed,DisplayName,UserDisplayInformation,VisitTimes,PropertyNames,PropertyValues) 
		            VALUES (@ClubID,@UserID,@Rank,@Points,@ClubMemberRole,@Status,@ApplyRemark,@InviteUserID,@InviteUserDisplayName
					,@EnableManagerNotification,@EnableNotificationed,@DisplayName,@UserDisplayInformation,@VisitTimes,@PropertyNames,@PropertyValues)
              if(@Status=1)
                update spb_Clubs set MemberCount=MemberCount+1 where ClubID = @ClubID
                
                if exists (select * from spb_ClubUserDatas with (nolock) where UserID=@UserID)
				    update spb_ClubUserDatas set JoinedClubCount=JoinedClubCount+1 where UserID=@UserID
			    else
			    Begin
					if (@ClubMemberRole < 3) 
						insert into spb_ClubUserDatas (UserID,JoinedClubCount) values (@UserID,1)
				    else
						insert into spb_ClubUserDatas (UserID,CreatedClubCount) values (@UserID,1)
				End
            END
	    ELSE --更新
		    UPDATE spb_ClubMembers SET
				[Rank]					= @Rank,
				Points					= @Points,
				ClubMemberRole					= @ClubMemberRole,
				Status					= @Status,
				ApplyRemark					= @ApplyRemark,
				InviteUserID					= @InviteUserID,
				InviteUserDisplayName					= @InviteUserDisplayName,
				EnableManagerNotification					= @EnableManagerNotification,      
                EnableNotificationed    = @EnableNotificationed,
				DisplayName    = @DisplayName,
				UserDisplayInformation    = @UserDisplayInformation,
				VisitTimes    = @VisitTimes,

                PropertyNames           = @PropertyNames,
                PropertyValues          = @PropertyValues
		    WHERE
			    UserID = @UserID and ClubID = @ClubID
    END
/****** Object:  StoredProcedure [dbo].[spb_EventMember_CreateUpdateDelete]    Script Date: 01/09/2010 07:00:59 ******/
SET ANSI_NULLS ON
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 更新 圈子成员 状态*/

CREATE PROCEDURE [dbo].[spb_ClubMember_UpdateStatus]
( 
    @UserID	int,
    @ClubID	int,
    @Status	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin Transaction
	Declare @OldStatus int
	Select @OldStatus = [Status] FROM spb_ClubMembers WHERE UserID = @UserID and ClubID = @ClubID
    if(@@ERROR<>0) goto Failure 	
    UPDATE spb_ClubMembers SET [Status] = @Status WHERE UserID = @UserID and ClubID = @ClubID
    if(@@ERROR<>0) goto Failure 	
    if (@Status = 1 or @Status=21) and @OldStatus not in (1,21)
    Begin
		update spb_Clubs set MemberCount=MemberCount+1 where ClubID = @ClubID
		if(@@ERROR<>0) goto Failure
	End
	else if(@Status = 11 or @Status = 0) and @OldStatus not in (11,0)
	Begin
		update spb_Clubs set MemberCount=MemberCount-1 where ClubID = @ClubID
	    if(@@ERROR<>0) goto Failure
	End
commit transaction
return
Failure:
	rollback transaction
	return
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台群组统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_ClubManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out

)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
	
select @PendingThreadCount= count(ClubID) from spb_Clubs with (nolock) where AuditingStatus=20
select @AgainThreadCount=count(ClubID) from spb_Clubs with (nolock) where AuditingStatus=30
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 圈子计数 **/
CREATE PROCEDURE [dbo].[spb_ClubView_Add]
(
	@ItemID int,
	@WebViewCount int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Clubs set HitTimes = HitTimes+@WebViewCount,StageHitTimes=StageHitTimes+@WebViewCount where ClubID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、圈子应用每月执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Club_PerStage]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
    --重置周浏览量
    update spb_Clubs set StageHitTimes=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置站点网摘类别 */

Create PROCEDURE [dbo].[spb_Club_UpdateSiteCategoryByCategoryID]
( 
    @fromSiteCategoryID int,
    @toSiteCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Clubs set CategoryID=@toSiteCategoryID where CategoryID=@fromSiteCategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置圈子审核状态 */

CREATE PROCEDURE [dbo].[spb_Club_UpdateAuditingStatus]
( 
    @ClubID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Clubs set AuditingStatus=@AuditingStatus where ClubID=@ClubID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 检查圈子的域名是否存在 */

CREATE PROCEDURE [dbo].[spb_Club_ClubDomainNameIsExist]
    @DomainName nvarchar(50),
    @IsExist bit output
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
if exists(select ClubID from spb_Clubs with (nolock) where DomainName = @DomainName)
    set @IsExist = 1
else
    set @IsExist = 0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据DomainName或ClubID获取圈子 */

CREATE PROCEDURE [dbo].[spb_Club_Get]
(
    @DomainName nvarchar(50) = '',
    @ClubID int = 0
)   
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
if (@DomainName <> '')
    select * from spb_Clubs with (nolock) where DomainName = @DomainName
else
    select * from spb_Clubs with (nolock) where ClubID = @ClubID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ClubID获取圈子DomainName */

CREATE PROCEDURE [dbo].[spb_Club_GetDomainNameByClubID]
    @ClubID int

AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
    select DomainName from spb_Clubs with (nolock) where ClubID = @ClubID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_MicroBlogThreadIDs_GetOfScreen] 
(
	@ScreenID int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Select ItemID,ThreadID from spb_MicroBlogsOfScreens where ScreenID = @ScreenID and Status = 0 order by DateCreated
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取主题 */

CREATE PROCEDURE [dbo].[spb_MicroBlogThread_Get] 
(
	@ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_MicroBlogThreads with (nolock) where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_MicroBlogForwardedThreadIDs_Get] 
(
	@UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Select ForwardedThreadID from spb_MicroBlogThreads where OwnerUserID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台微博统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_MicroBlogManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingCommentCount int out
)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
	
select @PendingThreadCount= count(ThreadID) from spb_MicroBlogThreads with (nolock) where AuditingStatus=20
select @AgainThreadCount=count(ThreadID) from spb_MicroBlogThreads with (nolock) where AuditingStatus=30
select @PendingCommentCount=count(CommentID) from spb_MicroBlogComments with (nolock) where AuditingStatus=20
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 批准(或不批准)PhotoComment(回复) */

CREATE PROCEDURE [dbo].[spb_PhotoComment_Approve] 
(
    @PostID	int,
    @IsApproved bit = 1
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_PhotoComments set IsApproved = @IsApproved where PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置博客文章审核状态 */

create PROCEDURE [dbo].[spb_PhotoComment_UpdateAuditingStatus]
( 
    @PostID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_PhotoComments set AuditingStatus=@AuditingStatus where PostID=@PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据PostID获取PhotoComment */

CREATE PROCEDURE [dbo].[spb_PhotoComment_Get]
(
    @PostID int,
    @IsApprovedFilter bit = 0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@IsApprovedFilter = 0)

SELECT
    *
FROM    
	spb_PhotoComments BP with (nolock)
WHERE 
    BP.PostID = @PostID

else

SELECT
    *
FROM    
	spb_PhotoComments BP with (nolock)
WHERE 
    BP.PostID = @PostID and IsApproved=1
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台相册统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
create PROCEDURE [dbo].[spb_PhotoManageableCounts_Get]
(
@PendingThreadCount int out,
@AgainThreadCount int out,
@PendingCommentCount int out
)
  
    
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN

	SET NOCOUNT ON;
	
select @PendingThreadCount= count(ThreadID) from spb_Photos with (nolock) where AuditingStatus=20
select @AgainThreadCount=count(ThreadID) from spb_Photos with (nolock) where AuditingStatus=30
select @PendingCommentCount=count(PostID) from spb_PhotoComments  with(nolock) where AuditingStatus=20
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新接收动态时忽略的朋友列表,圈子列表 **/

CREATE PROCEDURE [dbo].[spb_UserActivitySettings_Update] 
(
    @UserID int,    
    @IgnoredFriendUsersForReceiveActivities nvarchar(2000),
    @IgnoredClubsForReceiveClubActivities nvarchar(2000)
	) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if exists (select UserID from spb_UserActivitySettings with (nolock) where UserID=@UserID)
    UPDATE    spb_UserActivitySettings
    SET   IgnoredFriendUsersForReceiveActivities = @IgnoredFriendUsersForReceiveActivities,
		  IgnoredClubsForReceiveClubActivities = @IgnoredClubsForReceiveClubActivities
    WHERE   (UserID = @UserID)
else
	INSERT INTO spb_UserActivitySettings
			   (UserID, IgnoredFriendUsersForReceiveActivities)
	VALUES     (@UserID,@IgnoredFriendUsersForReceiveActivities)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户动态设置 **/

CREATE PROCEDURE [dbo].[spb_ActivitySettingssInUser_Get]
(
  @UserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT     IgnoredFriendUsersForReceiveActivities,IgnoredClubsForReceiveClubActivities
FROM       spb_UserActivitySettings with (nolock)
WHERE     (UserID = @UserID)
SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**后台招聘统计数据**/
-- Fail = 10,未通过
-- Pending = 20,待审核       
--Again = 30,需再次审核       
--Success = 40通过验证
CREATE PROCEDURE [dbo].[spb_JobManageableCounts_Get]
(
@PendingJobCount int out,
@AgainJobCount int out,
@PendingResumeCount int out,
@AgainResumeCount int out)
AS
SET Transaction Isolation Level Read UNCOMMITTED

BEGIN
	
	SET NOCOUNT ON;
select @PendingJobCount=count(ApplyID) from Tunynet_Job_JobApplys with (nolock) where ApplyStatus=20

select @AgainJobCount=count(ApplyID) from Tunynet_Job_JobApplys with (nolock) where ApplyStatus=30

select @PendingResumeCount=count(UserID) from Tunynet_Job_Resumes with (nolock) where AuditingStatus=20

select @PendingResumeCount=count(UserID) from Tunynet_Job_Resumes with (nolock) where AuditingStatus=30

   
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_ClubUserData_ChangeExperiencePoints]
(
	@UserID int,
	@ExperiencePoints int
)
AS

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

if not exists (select * from spb_ClubUserDatas with (nolock) WHERE [UserID] = @UserID)
		INSERT INTO spb_ClubUserDatas (UserID,ExperiencePoints)values(@UserID,@ExperiencePoints)
else
		Update spb_ClubUserDatas set ExperiencePoints=ExperiencePoints+@ExperiencePoints where UserID=@UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_ClubUserData_Get]
	@UserID int
AS

SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ COMMITTED

SELECT  *
FROM
	spb_ClubUserDatas with (nolock)
WHERE
	UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 批量删除过期用户积分记录 **/
CREATE PROCEDURE [dbo].[spb_UserPointRecords_BatchDelete] 
(
  @beforeDays	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @currentDate datetime
declare @numberOfDelete int
set @currentDate = getdate()

select @numberOfDelete = count(RecordID) from spb_UserPointRecords with (nolock) where DateDiff(day,CreateDate,@currentDate) >= @beforeDays

delete from spb_UserPointRecords where (DateDiff(day,CreateDate,@currentDate) >= @beforeDays)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取圈子成员*/

CREATE PROCEDURE [dbo].[spb_ClubMember_Get]
( 
    @UserID	int,
    @ClubID	int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_ClubMembers with (nolock) where UserID = @UserID and ClubID = @ClubID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取圈子成员*/

CREATE PROCEDURE [dbo].[spb_ClubMembers_GetSimpleClubMember]
( 
	@ClubID	int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_ClubMembers with (nolock) where ClubID = @ClubID and status=1
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取圈子成员*/

CREATE PROCEDURE [dbo].[spb_ClubMember_UpdateVisits]
( 
	@ClubID	int,
    @UserID	int,
	@VisitTimes int,
	@LastVisitTime datetime
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_ClubMembers set VisitTimes=@VisitTimes,LastVisitTime=@LastVisitTime where UserID = @UserID and ClubID = @ClubID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_MicroBlogFavoriteThreadIDs_Get] 
(
	@UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Select ThreadID from spb_MicroBlogsFavorites where UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_MicroBlogFavorite_CreateDelete] 
(
    @Action int,
	@UserID int = 0,
	@ThreadID int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if @Action = 0
	insert into spb_MicroBlogsFavorites(UserID,ThreadID) values (@UserID,@ThreadID)
else if  @Action = 2
	delete from spb_MicroBlogsFavorites where UserID = @UserID and ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有审核项集合 **/

CREATE PROCEDURE [dbo].[spb_AuditingItems_Get] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT * FROM spb_AuditingItems with (nolock) ORDER BY DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取RoleID对应的审核规则 **/

CREATE PROCEDURE [dbo].[spb_AuditingItemSettingsInUserRole_Get] 
(
	@RoleID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
SELECT     A.*, AIU.StrictDegree,AIU.IsLocked
FROM         spb_AuditingItemSettingsInUserRoles AIU with (nolock) INNER JOIN
                      spb_AuditingItems A with (nolock) ON AIU.ItemID = A.ItemID
WHERE     AIU.RoleID = @RoleID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取RankID对应的审核规则 **/

CREATE PROCEDURE [dbo].[spb_AuditingItemSettingsInUserRank_Get] 
(
	@Rank int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
SELECT     A.*, AIU.StrictDegree
FROM         spb_AuditingItemSettingsInUserRanks AIU with (nolock) INNER JOIN
                      spb_AuditingItems A with (nolock) ON AIU.ItemID = A.ItemID
WHERE     AIU.Rank = @Rank
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取某一广告的位置记录 */

CREATE PROCEDURE [dbo].[spb_AdvertisingPositions_GetByAdvertisingID] 
(
	@AdvertisingID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select p.* from spb_AdvertisingPositions p with (nolock) inner join spb_AdvertisingsInPositions i with (nolock) 
	on i.PositionCode=p.PositionCode where i.AdvertisingID=@AdvertisingID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除礼品兑换申请 */

create PROCEDURE [dbo].[spb_ConvertibleGiftExchangeRecord_Create]
(
    @Action int,
    @RecordID int out,
    @UserID int,
    @GiftID	int,
	@UserDisplayName nvarchar(64)='',
	@Price int =0,
	@TotalCount int=0
	) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加

	begin

		INSERT spb_ConvertibleGift_ExchangeRecords (GiftID,UserID,UserDisplayName,Price,TotalCount)
				values (@GiftID,@UserID,@UserDisplayName,@Price,@TotalCount)

		-- Grab the new PostID and update the ThreadID's info
		SELECT @RecordID = SCOPE_IDENTITY() 


	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**删除身份标识**/
CREATE PROCEDURE [dbo].[spb_Identity_Delete]
@IdentityID int
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	SET NOCOUNT ON;

    delete spb_Identities where IdentityID=@IdentityID
    delete spb_UserIdentities where IdentityID=@IdentityID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_Identities_GetAll]
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	SET NOCOUNT ON;
select * from spb_Identities 
    
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新身份标识 **/
CREATE PROCEDURE [dbo].[spb_Identity_CreateUpdate]
(
@Action int,
@Name nvarchar(64)='',
@Description nvarchar(512)='',
@IdentityID int out
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	SET NOCOUNT ON;
   if(@Action=0)--添加
   begin
   insert spb_Identities (Name,[Description]) values(@Name,@Description)
   select @IdentityID=SCOPE_IDENTITY() 
   end
	else if @Action=1 --更新
	update spb_Identities set Name=@Name,[Description]=@Description where IdentityID=@IdentityID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据用户ID获取用户分享字典集合 **/

Create PROCEDURE [dbo].[spb_UserShareThreads_GetByUserID]  
(
	@UserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     ThreadID,UserThreadID
FROM       spb_UserShareThreads with (nolock)
WHERE      UserID = @UserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据站点分享ID获取用户分享ID集合 **/

Create PROCEDURE [dbo].[spb_UserShareThreads_GetByThreadID]  
(
	@ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     UserThreadID
FROM       spb_UserShareThreads with (nolock)
WHERE      ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取某分享的前一条及后一条分享UserThreadID */
CREATE PROCEDURE [dbo].[spb_UserShareThread_GetPrevNextUserThread] 
(
	@UserThreadID int,
	@NextUserThreadID int OUTPUT,
	@PrevUserThreadID int OUTPUT
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @UserID int

SELECT @UserID=T.UserID FROM	spb_UserShareThreads T  with (nolock) WHERE T.UserThreadID = @UserThreadID

SELECT TOP 1 
	@PrevUserThreadID = UserThreadID
FROM 
	spb_UserShareThreads with (nolock) 
WHERE 
	UserID = @UserID AND UserThreadID < @UserThreadID
ORDER BY UserThreadID DESC

IF @@ROWCOUNT < 1
  begin
	SELECT @PrevUserThreadID = 0
  end
SELECT TOP 1 
	@NextUserThreadID = UserThreadID
FROM
	spb_UserShareThreads with (nolock)
WHERE 
	UserID = @UserID AND UserThreadID > @UserThreadID
ORDER BY UserThreadID ASC

IF @@ROWCOUNT < 1
  begin
	SELECT @NextUserThreadID = 0
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ThreadID获取BlogThreadAttachment */

CREATE PROCEDURE [dbo].[spb_BlogThreadAttachments_GetByThreadID]
(
    @ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_BlogThreadAttachments with (nolock)
WHERE 
    ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_BlogThreadAttachment_UpdateAssociateID]
(
    @AttachmentID int,
    @AssociateID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_BlogThreadAttachments set
	ThreadID=@AssociateID
WHERE 
    AttachmentID=@AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_BlogTemporaryAttachmentIDs_GetByUserID]
(
    @OwnerUserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_BlogThreadAttachments with (nolock)
WHERE 
    OwnerUserID = @OwnerUserID and ThreadID<=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除BlogThreadAttachment */

CREATE PROCEDURE [dbo].[spb_BlogThreadAttachments_DeleteByOwnerUserID] 
(
    @OwnerUserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select ThreadID from spb_BlogThreadAttachments WITH (NOLOCK) where OwnerUserID = @OwnerUserID

delete spb_BlogThreadAttachments where OwnerUserID = @OwnerUserID

set nocount OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新BlogAttachment  **/

CREATE PROCEDURE [dbo].[spb_BlogThreadAttachment_CreateUpdate] 
(
    @Action int,
    @AttachmentID int out,
    @ThreadID int,
	@OwnerUserID int,
    @FileName nvarchar(512) ,
    @FriendlyFileName nvarchar(512),
	@ContentType nvarchar(64),
 	@ContentSize int ,
    @Height int,
    @Width int,
	@IsCreatedByAdministrator bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加

	begin
	
		INSERT spb_BlogThreadAttachments (ThreadID,OwnerUserID,FileName,FriendlyFileName,ContentType,ContentSize,Height,Width,IsCreatedByAdministrator)
				values (@ThreadID,@OwnerUserID,@FileName,@FriendlyFileName,@ContentType,@ContentSize,@Height,@Width,@IsCreatedByAdministrator)

		-- Grab the new PostID and update the ThreadID's info
		SELECT @AttachmentID = SCOPE_IDENTITY() 

	end

  else if @Action=1 --更新

	 update spb_BlogThreadAttachments set 
	        ThreadID=@ThreadID,OwnerUserID=@OwnerUserID,FileName=@FileName,FriendlyFileName=@FriendlyFileName,ContentType=@ContentType,ContentSize=@ContentSize,Height=@Height,Width=@Width,IsCreatedByAdministrator=@IsCreatedByAdministrator
	 where AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据AttachmentID获取BlogThreadAttachment */

CREATE PROCEDURE [dbo].[spb_BlogThreadAttachment_Get]
(
    @AttachmentID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_BlogThreadAttachments with (nolock) 
WHERE 
    AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除BlogThreadAttachment */

CREATE PROCEDURE [dbo].[spb_BlogThreadAttachments_DeleteByThreadID] 
(
    @ThreadID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
delete spb_BlogThreadAttachments where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除BlogThreadAttachment */

CREATE PROCEDURE [dbo].[spb_BlogThreadAttachment_Delete] 
(
    @AttachmentID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

delete spb_BlogThreadAttachments where AttachmentID = @AttachmentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据OwnerUserID获取BlogThreadAttachment */

CREATE PROCEDURE [dbo].[spb_BlogThreadAttachments_GetByOwnerUserID]
(
    @OwnerUserID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_BlogThreadAttachments with (nolock)
WHERE 
    OwnerUserID = @OwnerUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 批量删除某个人或所有人的朋友动态 **/
CREATE PROCEDURE [dbo].[spb_FriendActivitiesByActivityItemID_Delete] 
(
  @userID int=-1,
  @activityItemID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @numberOfDelete int
  if(@userID>0)
      SELECT    @numberOfDelete = count(spb_FriendActivities.ActivityID)
      FROM      spb_FriendActivities with (nolock) INNER JOIN
                            spb_FriendActivityInbox with (nolock) ON spb_FriendActivities.ActivityID = spb_FriendActivityInbox.ActivityID
      WHERE     (spb_FriendActivities.ActivityItemID=@activityItemID)
                and (spb_FriendActivityInbox.UserID=@userID)
  else
    select @numberOfDelete = count(ActivityID) from spb_FriendActivities with (nolock) where (spb_FriendActivities.ActivityItemID=@activityItemID)

BEGIN TRANSACTION
  if(@userID>0)
   	  begin  
    delete from spb_FriendActivityInbox where UserID=@userID and ActivityID in  
      (select ActivityID from spb_FriendActivities with (nolock) where (spb_FriendActivities.ActivityItemID=@activityItemID))
        if (@@ERROR <> 0) GOTO Failure
      end
  --else
  --  begin  
  --    delete from spb_FriendActivityInbox where ActivityID in
	 --   (select ActivityID from spb_FriendActivities with (nolock) where (spb_FriendActivities.ActivityItemID=@activityItemID))
  --    if (@@ERROR <> 0) GOTO Failure
  --    delete from spb_FriendActivities where (spb_FriendActivities.ActivityItemID=@activityItemID)
      
  --    if (@@ERROR <> 0) GOTO Failure
  --  end


COMMIT TRANSACTION
SELECT @numberOfDelete -- Success
RETURN

Failure:
	ROLLBACK TRANSACTION
	SELECT 0 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 批量删除某个人或所有人的朋友动态 **/
CREATE PROCEDURE [dbo].[spb_FriendActivitiesByUser_Delete] 
(
  @userID int=-1,
  @leadingActorUserID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @numberOfDelete int
  if(@userID>0)
      SELECT    @numberOfDelete = count(spb_FriendActivities.ActivityID)
      FROM      spb_FriendActivities with (nolock) INNER JOIN
                            spb_FriendActivityInbox with (nolock) ON spb_FriendActivities.ActivityID = spb_FriendActivityInbox.ActivityID
      WHERE     (spb_FriendActivities.LeadingActorUserID=@leadingActorUserID)
                and (spb_FriendActivityInbox.UserID=@userID)
  else
    select @numberOfDelete = count(ActivityID) from spb_FriendActivities with (nolock) where (spb_FriendActivities.LeadingActorUserID=@leadingActorUserID)

BEGIN TRANSACTION
  if(@userID>0)
   	  begin  
    delete from spb_FriendActivityInbox where UserID=@userID and ActivityID in  
      (select ActivityID from spb_FriendActivities with (nolock) where (spb_FriendActivities.LeadingActorUserID=@leadingActorUserID))
        if (@@ERROR <> 0) GOTO Failure
      end
  --else
  --  begin  
  --    delete from spb_FriendActivityInbox where ActivityID in
	 --   (select ActivityID from spb_FriendActivities with (nolock) where (spb_FriendActivities.LeadingActorUserID=@leadingActorUserID))
  --    if (@@ERROR <> 0) GOTO Failure
  --    delete from spb_FriendActivities where (spb_FriendActivities.LeadingActorUserID=@leadingActorUserID)
   
      
  --    if (@@ERROR <> 0) GOTO Failure
  --  end


COMMIT TRANSACTION
SELECT @numberOfDelete -- Success
RETURN

Failure:
	ROLLBACK TRANSACTION
	SELECT 0 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 批量删除某个人或所有人的朋友动态 **/
CREATE PROCEDURE [dbo].[spb_FriendActivities_BatchDelete] 
(
  @userID int=-1,
  @beforeDays	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @currentDate datetime
declare @numberOfDelete int
set @currentDate = getdate()
  if(@userID>0)
      SELECT    @numberOfDelete = count(spb_FriendActivities.ActivityID)
      FROM      spb_FriendActivities with (nolock) INNER JOIN
                            spb_FriendActivityInbox with (nolock) ON spb_FriendActivities.ActivityID = spb_FriendActivityInbox.ActivityID
      WHERE     (DateDiff(day,spb_FriendActivities.DateCreated,@currentDate) >= @beforeDays)
                and (spb_FriendActivityInbox.UserID=@userID)
  else
    select @numberOfDelete = count(ActivityID) from spb_FriendActivities with (nolock) where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays)

BEGIN TRANSACTION
  if(@userID>0)
   	  begin  
    delete from spb_FriendActivityInbox where UserID=@userID and ActivityID in  
      (select ActivityID from spb_FriendActivities with (nolock) where DateDiff(day,DateCreated,@currentDate) >= @beforeDays)
        if (@@ERROR <> 0) GOTO Failure
      end
  else
    begin  
      delete from spb_FriendActivityInbox where ActivityID in
	    (select ActivityID from spb_FriendActivities with (nolock) where DateDiff(day,DateCreated,@currentDate) >= @beforeDays)
      if (@@ERROR <> 0) GOTO Failure
      delete from spb_FriendActivities where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays)
      if (@@ERROR <> 0) GOTO Failure
    end


COMMIT TRANSACTION
SELECT @numberOfDelete -- Success
RETURN

Failure:
	ROLLBACK TRANSACTION
	SELECT 0 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除朋友动态收件箱的项目 **/
CREATE PROCEDURE [dbo].[spb_FriendActivityInbox_Delete]
(   
    @UserID int,
    @ActivityID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

delete from spb_FriendActivityInbox where UserID=@UserID and ActivityID=@ActivityID

if not exists (select ActivityID from spb_FriendActivityInbox with (nolock) where ActivityID=@ActivityID)
  delete from spb_FriendActivities where ActivityID=@ActivityID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取朋友动态详细信息 */

CREATE PROCEDURE [dbo].[spb_FriendActivity_Get]
( 
    @ActivityID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_FriendActivities with (nolock) where ActivityID=@ActivityID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置私信 已读/未读 状态 */
CREATE PROCEDURE [dbo].[spb_PrivateMessageInbox_SetReadFlag] 
(
	@UserID int, 
	@ThreadID int,
	@IsRead bit 
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
update spb_PrivateMessageInbox set IsRead=@IsRead where UserID=@UserID and ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取用户未读的私信数 */
CREATE PROCEDURE [dbo].[spb_PrivateMessageInboxNoReadCount_Get] 
(
	@UserID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
select count(ThreadID) from spb_PrivateMessageInbox with (nolock) where UserID=@UserID and IsRead=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置文件评论审核状态 */

CREATE PROCEDURE [dbo].[spb_FileComment_UpdateAuditingStatus]
( 
    @PostID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_FileComments set AuditingStatus=@AuditingStatus where PostID=@PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 批准(或不批准)FilePost(回复) */

CREATE PROCEDURE [dbo].[spb_FileComment_Approve] 
(
    @PostID	int,
    @IsApproved bit = 1
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_FileComments set IsApproved = @IsApproved where PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据PostID获取FileComment */

CREATE PROCEDURE [dbo].[spb_FileComment_Get]
(
    @PostID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON


SELECT
    *
FROM    
	spb_FileComments BP with (nolock)
WHERE 
    BP.PostID = @PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据CommentID获取EventPhotoComment */

CREATE PROCEDURE [dbo].[spb_EventPhotoComment_Get]
(
    @CommentID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT      spb_EventPhotoComments.*
FROM       spb_EventPhotoComments with (nolock)
WHERE     (CommentID = @CommentID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置活动照片评论审核状态 */

CREATE PROCEDURE [dbo].[spb_EventPhotoComment_UpdateAuditingStatus]
( 
    @CommentID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_EventPhotoComments set AuditingStatus=@AuditingStatus where CommentID=@CommentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新审核项目针对用户角色的设置，如果该AuditingItemSettings不存在则创建 **/

CREATE PROCEDURE [dbo].[spb_AuditingItemSettingsInUserRole_Update] 
(
  @ItemID	int,
  @RoleID	int,
  @StrictDegree int,
  @IsLocked bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
--如果该AuditingItemSettings不存在则创建
if exists (select ItemID from spb_AuditingItemSettingsInUserRoles with (nolock) where ItemID=@ItemID and RoleID=@RoleID)
    UPDATE  spb_AuditingItemSettingsInUserRoles
		    SET StrictDegree=@StrictDegree,IsLocked=@IsLocked
		    WHERE (ItemID = @ItemID) AND (RoleID = @RoleID)
else
		INSERT INTO spb_AuditingItemSettingsInUserRoles (ItemID, RoleID, StrictDegree,IsLocked)
		    VALUES (@ItemID,@RoleID,@StrictDegree,@IsLocked)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新用户隐私项目设置 **/

CREATE PROCEDURE [dbo].[spb_PrivacyItemSettingsInUser_Update] 
(
  @UserID int,
  @ItemID	int,
  @PrivacyDegree	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
if exists (select ItemID from spb_UserPrivacyItemSettings with (nolock) where UserID = @UserID and ItemID=@ItemID)
    UPDATE    spb_UserPrivacyItemSettings
    SET   PrivacyDegree = @PrivacyDegree
    WHERE     (ItemID = @ItemID) AND (UserID = @UserID)
--如果要更新的项目不存在则创建
else
  INSERT INTO spb_UserPrivacyItemSettings
             (UserID,ItemID, PrivacyDegree)
  VALUES     (@UserID,@ItemID,@PrivacyDegree)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取隐私项目用户设置 **/

CREATE PROCEDURE [dbo].[spb_PrivacyItemSettingssInUser_Get]
(
  @UserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT   P.*, U.UserID, U.PrivacyDegree
FROM     spb_UserPrivacyItemSettings AS U with (nolock) INNER JOIN
         spb_PrivacyItems AS P with (nolock) ON U.ItemID = P.ItemID
WHERE    (U.UserID = @UserID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新审核项目针对用户等级的设置，如果该AuditingItemSettings不存在则创建 **/

CREATE PROCEDURE [dbo].[spb_AuditingItemSettingsInUserRank_Update] 
(
  @ItemID	int,
  @Rank	int,
  @StrictDegree int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
----如果@StrictDegree=3即审核设置为未设置则删除记录
--if(@StrictDegree=3)
--Begin
-- Delete From spb_AuditingItemSettingsInUserRanks where ItemID=@ItemID and Rank=@Rank
-- return
--End


--如果该AuditingItemSettings不存在则创建
if exists (select ItemID from spb_AuditingItemSettingsInUserRanks with (nolock) where ItemID=@ItemID and Rank=@Rank)
    UPDATE  spb_AuditingItemSettingsInUserRanks
		    SET StrictDegree=@StrictDegree
		    WHERE (ItemID = @ItemID) AND (Rank = @Rank)
else
		INSERT INTO spb_AuditingItemSettingsInUserRanks (ItemID, Rank, StrictDegree)
		    VALUES (@ItemID,@Rank,@StrictDegree)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置博客文章审核状态 */

create PROCEDURE [dbo].[spb_Photo_UpdateAuditingStatus]
( 
    @ThreadID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Photos set AuditingStatus=@AuditingStatus where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取某图片的前一张及后一张ThreadID */
CREATE PROCEDURE [dbo].[spb_Photo_GetPrevNextThread] 
(
	@ThreadID int,
    @UserCategoryID int,
	@NextThreadID int OUTPUT,
	@PrevThreadID int OUTPUT
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
declare @OwnerUserID int


SELECT @OwnerUserID=T.OwnerUserID FROM	spb_Photos T with (nolock) WHERE T.ThreadID = @ThreadID AND  T.UserCategoryID=@UserCategoryID 



SELECT TOP 1 
	@PrevThreadID = ThreadID
FROM 
	spb_Photos with (nolock) 
WHERE 
	OwnerUserID = @OwnerUserID AND ThreadID < @ThreadID  AND UserCategoryID=@UserCategoryID 
ORDER BY ThreadID DESC

IF @@ROWCOUNT < 1
  begin
	SELECT @PrevThreadID = 0
  end
	
SELECT TOP 1 
	@NextThreadID = ThreadID
FROM 
	spb_Photos with (nolock)
WHERE 
	OwnerUserID = @OwnerUserID AND ThreadID > @ThreadID  AND UserCategoryID=@UserCategoryID 
ORDER BY ThreadID ASC

IF @@ROWCOUNT < 1
  begin
	SELECT @NextThreadID = 0
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置站点文件类别 */

CREATE PROCEDURE [dbo].[spb_Photo_UpdateUserCategory]
( 
    @ThreadID int,
    @UserCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

      DECLARE @OldUserCategoryID nvarchar(8)
      select  @OldUserCategoryID=UserCategoryID from spb_Photos with (nolock) where (ThreadID=@ThreadID)
      UPDATE    spb_Photos
      SET       UserCategoryID=@UserCategoryID
      WHERE     ThreadID=@ThreadID

      if(@OldUserCategoryID<>@UserCategoryID)
        begin
            --原类别的内容数减1
            UPDATE   spb_PhotoUserCategories SET ItemCount = ItemCount - 1 WHERE (CategoryID = @OldUserCategoryID) AND (ItemCount>0)
            --新类别的内容数加1
            UPDATE   spb_PhotoUserCategories SET ItemCount = ItemCount + 1 WHERE (CategoryID = @UserCategoryID) 
        end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置取消精华 */

CREATE PROCEDURE [dbo].[spb_Photo_SetEssential] 
(
    @ThreadID int,
    @IsEssential bit
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
if exists (select ThreadID from spb_Photos with (nolock) where ThreadID=@ThreadID)
  update spb_Photos set IsEssential = @IsEssential where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户所有照片的ID **/

CREATE procedure [dbo].[spb_PhotoIDs_GetByOwnerID]
(
    @OwnerUserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
    
select ThreadID from spb_Photos with (nolock) where OwnerUserID=@OwnerUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置图片站点类别 */

create PROCEDURE [dbo].[spb_Photo_UpdateSiteCategoryByCategoryID]
( 
    @fromSiteCategoryID int,
    @toSiteCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Photos set SiteCategoryID=@toSiteCategoryID where SiteCategoryID=@fromSiteCategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 置顶 */

CREATE PROCEDURE [dbo].[spb_Photo_SetSticky] 
(
    @ThreadID int,
    @SpecialOrder int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED

if exists (select ThreadID from spb_Photos where ThreadID=@ThreadID)
  update spb_Photos set SpecialOrder = @SpecialOrder where ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 照片计数 **/
CREATE PROCEDURE [dbo].[spb_PhotoView_Add]
(
	@ItemID int,
	@RssViewCount int = 0,
	@WebViewCount int = 0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Photos set HitTimes = HitTimes+@WebViewCount,RssViewTimes = RssViewTimes+@RssViewCount where ThreadID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置博客文章审核状态 */

create PROCEDURE [dbo].[spb_Photo_UpdatePrivacyStatus]
( 
    @ThreadID int,
    @PrivacyStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Photos set PrivacyStatus=@PrivacyStatus where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置站点文件类别 */

CREATE PROCEDURE [dbo].[spb_Photo_UpdateSiteCategory]
( 
    @ThreadID int,
    @SiteCategoryID	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_Photos set SiteCategoryID=@SiteCategoryID where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新Picture **/

CREATE PROCEDURE [dbo].[spb_Photo_CreateUpdate] 
(
    @Action int,
	--@AllowDuplicatePosts bit,
	--@DuplicateIntervalInMinutes int = 0,
    @UpdateSectionStatistics bit = 1,
    @EnableUserStatistics bit = 1,

    @ThreadID int out,
    @OwnerUserID int = 0,
    @Author nvarchar(256) = '',
    @PropertyNames ntext = null,
    @PropertyValues ntext = null,
    @PrivacyStatus int = 30,--Photo
  	@IsLocked bit = 0,	--Photo
    @Password nvarchar(64) = '',
    @AuditingStatus int,
    @IsEssential bit,
    @SpecialOrder int=0,
    @StickyDate datetime,
    @Subject nvarchar(512),
    @Body ntext,
    @UserHostAddress	nvarchar(64) = null,
    @FileName nvarchar(512)='',
    @ContentType nvarchar(64),
    @ContentSize int,
    @Height int,
    @Width int,
    @SiteCategoryID int =0,
    @UserCategoryID int =0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
		BEGIN TRANSACTION
			INSERT spb_Photos (OwnerUserID,Author,PrivacyStatus,IsLocked,SiteCategoryID,UserCategoryID,Password,AuditingStatus,IsEssential,SpecialOrder,StickyDate,Subject,Body,UserHostAddress,FileName,ContentType,ContentSize,Height,Width)
				Values (@OwnerUserID,@Author,@PrivacyStatus,@IsLocked,@SiteCategoryID,@UserCategoryID,@Password,@AuditingStatus,@IsEssential,@SpecialOrder,@StickyDate,@Subject,@Body,@UserHostAddress,@FileName,@ContentType,@ContentSize,@Height,@Width)
            IF(@@ERROR<>0) GOTO FAILURE
			-- Get the new ThreadID
			
			SELECT @ThreadID = SCOPE_IDENTITY()
		
        -- 用户标签计数  -- 站点标签计数 【创建标签关联项时处理】
      
        -- 用户分类计数
        if exists (select UserID from spb_PhotoUserCategories with (nolock) where CategoryID=@UserCategoryID)
	    begin
			update spb_PhotoUserCategories set ItemCount=ItemCount+1 where CategoryID=@UserCategoryID
			IF(@@ERROR<>0) GOTO FAILURE
		end
        
	    COMMIT TRANSACTION
        RETURN
        
        FAILURE:
        ROLLBACK TRANSACTION
        RETURN
	end
  else if @Action=1 --更新

	begin
        declare @oldUserCategoryID int
        declare @oldPrivacyStatus int
	    select @oldUserCategoryID = UserCategoryID,@oldPrivacyStatus = PrivacyStatus  from spb_Photos with (nolock) where ThreadID=@ThreadID   

	   update spb_Photos set 
	        PrivacyStatus=@PrivacyStatus,IsLocked=@IsLocked,Password=@Password,AuditingStatus=@AuditingStatus,IsEssential=@IsEssential,SpecialOrder=@SpecialOrder,StickyDate=@StickyDate,
            Subject=@Subject,UserHostAddress=@UserHostAddress,FileName=@FileName,ContentType=@ContentType,ContentSize=@ContentSize,Height=@Height,Width=@Width,SiteCategoryID=@SiteCategoryID,UserCategoryID=@UserCategoryID
	    where ThreadID=@ThreadID
	       
	   if @Body is not null UPDATE spb_Photos SET	Body = @Body  where ThreadID=@ThreadID  
      
       if @UserCategoryID <> @oldUserCategoryID 
         begin
          update spb_PhotoUserCategories set ItemCount=ItemCount+1,MostRecentUpdateDate=getdate() where CategoryID=@UserCategoryID
          update spb_PhotoUserCategories set ItemCount=ItemCount-1 ,MostRecentUpdateDate=getdate()  where CategoryID=@oldUserCategoryID
         end
       
           declare @newThreadID int
           declare @newSubject nvarchar(512)
           declare @newExcerpt nvarchar(512)
           declare @newRecentPostDate datetime
      
	end
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteOption_CreateUpdate]
(
    @OptionID int output,
    @ThreadID int = 0,
    @OptionName nvarchar(512)='',
    @Action int
)
as
set transaction Isolation Level Read UNCOMMITTED
set nocount on
if(@Action=0)
begin
	insert into spb_VoteOptions (ThreadID,OptionName) values(@ThreadID,@OptionName)
	set @OptionID = SCOPE_IDENTITY()
end
else
Begin
	update spb_VoteOptions
    set OptionName=@OptionName
    where OptionID=@OptionID
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteRecord_Create]
(
    @UserID int = 0,
    @UserDisplayName nvarchar(256) = '',
    @OptionID int = 0,
    @ThreadID int = 0,
    @IsAnonymousVote bit = 0
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
insert into spb_VoteRecords(UserID,UserDisplayName,OptionID,ThreadID,IsAnonymousVote)
values
(@UserID,@UserDisplayName,@OptionID,@ThreadID,@IsAnonymousVote)
select SCOPE_IDENTITY()

update spb_VoteOptions
set VoteCount=VoteCount+1
where ThreadID=@ThreadID and OptionID=@OptionID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteOption_Create]
(
    @VoteOptionTableName nvarchar(64),
    @OptionID int output,
    @ThreadID int = 0,
    @OptionName nvarchar(512)=''
)
as
set transaction Isolation Level Read UNCOMMITTED
set nocount on
insert into spb_VoteOptions (ThreadID,OptionName) values(@ThreadID,@OptionName)
set @OptionID = SCOPE_IDENTITY()
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteThread_Get]
(
    @ThreadID int
)
as
set transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
select * from spb_VoteThreads with(nolock) where ThreadID=@ThreadID
select * from spb_VoteOptions with(nolock) where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取回复 */

create PROCEDURE [dbo].[spb_MicroBlogComment_Get] 
(
	@CommentID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_MicroBlogComments where CommentID=@CommentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置微博评论的审核状态 */
CREATE PROCEDURE [dbo].[spb_MicroBlogComment_UpdateAuditingStatus]
( 
    @CommentID int,
    @AuditingStatus	int
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_MicroBlogComments set AuditingStatus=@AuditingStatus where CommentID=@CommentID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取某个活动的所有站内会员的成员 **/

CREATE PROCEDURE [dbo].[spb_EventMembers_GetByEventID]  
(
	@EventID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     UserID,MemberID
FROM       spb_EventMembers with (nolock)
WHERE      EventID=@EventID and UserID>0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据MemberID获取EventMember */

CREATE PROCEDURE [dbo].[spb_EventMember_Get]
(
    @MemberID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     *
FROM       spb_EventMembers with (nolock)
WHERE     (MemberID = @MemberID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 添加朋友动态接收人 **/
CREATE PROCEDURE [dbo].[spb_FriendActivityInbox_Create]
(   
    @UserID int,
    @ActivityID int,
    @ApplicationID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if not exists (select UserID from spb_FriendActivityInbox with (nolock) where UserID=@UserID and ActivityID=@ActivityID)
  insert into spb_FriendActivityInbox (UserID,ActivityID,ApplicationID) values (@UserID,@ActivityID,@ApplicationID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
create PROCEDURE [dbo].[spb_ClubActivities_Delete] 
(
  @applicationID int=-1,
  @relativeItemID int=-1
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

delete dbo.spb_ClubActivityInbox where [ActivityID] in (SELECT [ActivityID] FROM [dbo].[spb_ClubActivities] where [ApplicationID] = @applicationID and [RelativeItemID] = @relativeItemID)
delete dbo.spb_ClubActivities where [ApplicationID] = @applicationID and [RelativeItemID] = @relativeItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、删除 圈子动态 */

CREATE PROCEDURE [dbo].[spb_ClubActivity_CreateDelete]
( 
    @Action int,
    @ActivityID int out,
	@ClubID int = 0,
	@ApplicationID	int =0,
	@LeadingActorUserID	int =0,
	@LeadingActor	nvarchar(256) ='',
    @RelativeItemID int =0,
    @RelativeItemName nvarchar(256) ='',
    @Subject nvarchar(512) ='',
    @Body ntext ='',
    @PropertyNames ntext =null,
    @PropertyValues ntext =null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
	begin
	delete from	spb_ClubActivities where ActivityID = @ActivityID
	delete from spb_ClubActivityInbox where ActivityID = @ActivityID
	end
else 
    begin
        if (@Action = 0) --添加
          begin
	        insert into spb_ClubActivities (ClubID,ApplicationID,LeadingActorUserID,LeadingActor,RelativeItemID,RelativeItemName,Subject,Body,DateCreated,PropertyNames,PropertyValues)
                                values (@ClubID,@ApplicationID,@LeadingActorUserID,@LeadingActor,@RelativeItemID,@RelativeItemName,@Subject,@Body,GetDate(),@PropertyNames,@PropertyValues)
            set  @ActivityID = SCOPE_IDENTITY()
          end       
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 批量删除某个人或所有人的个人动态 **/
CREATE PROCEDURE [dbo].[spb_ClubActivities_BatchDelete] 
(
  @clubID int=-1,
  @beforeDays	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @currentDate datetime
declare @numberOfDelete int
set @currentDate = getdate()

  if(@clubID>0)
    select @numberOfDelete = count(ActivityID) from spb_ClubActivities with (nolock) where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays) and (ClubID=@clubID)
  else
    select @numberOfDelete = count(ActivityID) from spb_ClubActivities with (nolock) where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays)


  if(@clubID>0)
    delete from spb_ClubActivities where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays) and (ClubID=@clubID)
  else
    delete from spb_ClubActivities where (DateDiff(day,DateCreated,@currentDate) >= @beforeDays)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
Create PROCEDURE [dbo].[spb_ClubActivity_Get] 
(
@ActivityID int
)
AS
BEGIN
	SET NOCOUNT ON;
    SELECT * FROM [dbo].[spb_ClubActivities] with (nolock) Where ActivityID = @ActivityID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据GiftID获取spb_ConvertibleGifts */

CREATE PROCEDURE [dbo].[spb_ConvertibleGift_Get]
(
    @GiftID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT     *
FROM       spb_ConvertibleGifts with (nolock)
WHERE     (GiftID = @GiftID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除特许隐私设置的用户 **/
create PROCEDURE [dbo].[spb_SpecialPrivacyItemSettingssInUser_Delete]
(   
    @UserID int,
    @ToUserID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

delete from spb_SpecialPrivacyUsers where UserID=@UserID and  ToUserID=@ToUserID

delete from spb_UserSpecialPrivacyItemSettings where UserID=@UserID and  ToUserID=@ToUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新用户特定隐私设置 **/

CREATE PROCEDURE [dbo].[spb_SpecialPrivacyItemSettingsInUser_Update] 
(
  @UserID	int,
  @ToUserID	int,
  @ItemID	int,
  @IsAllowed	bit,
  @ToUserDisplayName	nvarchar(64)	
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
--如果特许用户不存在则创建
 if not exists(select UserID,ToUserID from spb_SpecialPrivacyUsers with (nolock) where UserID=@UserID and ToUserID =@ToUserID)
    INSERT INTO spb_SpecialPrivacyUsers
                (UserID, ToUserID, ToUserDisplayName)
    VALUES      (@UserID,@ToUserID,@ToUserDisplayName)

if exists (select UserID,ToUserID,ItemID from spb_UserSpecialPrivacyItemSettings with (nolock) where UserID=@UserID and ToUserID =@ToUserID and ItemID=@ItemID)
    UPDATE    spb_UserSpecialPrivacyItemSettings
    SET       IsAllowed = @IsAllowed
    WHERE     (ItemID = @ItemID) AND (UserID = @UserID) AND (ToUserID = @ToUserID)
--如果要更新的项目不存在则创建
else
    INSERT INTO spb_UserSpecialPrivacyItemSettings
               (UserID,ToUserID,ItemID,IsAllowed)
    VALUES     (@UserID,@ToUserID,@ItemID,@IsAllowed)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取特许隐私设置的用户 **/

CREATE PROCEDURE [dbo].[spb_SpecialPrivacyUsers_Get]
(
  @UserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT *
FROM spb_SpecialPrivacyUsers with (nolock)
WHERE (UserID = @UserID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户特定隐私设置 **/

CREATE PROCEDURE [dbo].[spb_SpecialPrivacyItemSettingssInUser_Get]
(
  @UserID int,
  @ToUserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     P.*, U.UserID, U.ToUserID, U.IsAllowed
FROM       spb_PrivacyItems AS P with (nolock) INNER JOIN
           spb_UserSpecialPrivacyItemSettings AS U with (nolock) ON P.ItemID = U.ItemID
WHERE      UserID=@UserID and ToUserID=@ToUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、删除 阻止的用户 */

CREATE PROCEDURE [dbo].[spb_StopedUser_CreateDelete]
( 
    @Action int,
    @UserID	int=0,
    @ToUserID	int=0,
    @ToUserDisplayName	nvarchar(64)=''
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
	begin
	delete from	spb_StopedUsers where UserID = @UserID and ToUserID=@ToUserID
	end

else if (@Action = 0) --添加      
  begin
    if not exists (select UserID from spb_StopedUsers with (nolock) where UserID=@UserID and ToUserID=@ToUserID)
      INSERT INTO spb_StopedUsers
               (UserID, ToUserID, ToUserDisplayName)
      VALUES   (@UserID,@ToUserID,@ToUserDisplayName)
  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取阻止的用户 **/

CREATE PROCEDURE [dbo].[spb_StopedUsers_Get]
(
  @UserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     *
FROM         spb_StopedUsers with (nolock)
WHERE     (UserID = @UserID)
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
Create procedure [dbo].[spb_ShareComment_Get]
(
    @CommentID int
)
as
Begin
    select * from spb_ShareComments with (nolock) where CommentID=@CommentID
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure [dbo].[spb_ShareComment_UpdateAuditingStatus]
(
    @CommentID int=0,
    @AuditingStatus int=40
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
    update spb_ShareComments
    set AuditingStatus=@AuditingStatus
    where CommentID=@CommentID
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
create Procedure [dbo].[spb_AccountBindings_Get]
(
	@UserID int=0
)
as
select * from spb_AccountBindings where UserID=@UserID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
--创建、更新、删除第三方账号绑定信息
CREATE Procedure [dbo].[spb_AccountBinding_CreateUpdateDelete]
(
	@Action int ,
	@UserID int =0,
	@AccountType int=0,
	@Identification nvarchar(256)='',
	@OauthToken nvarchar(256)='',
	@OauthTokenSecret nvarchar(256)=''
)
as 
if(@Action=0)
Begin
  	 if not exists (select * from spb_AccountBindings where AccountType = @AccountType and Identification=@Identification)
	 Begin
		INSERT INTO spb_AccountBindings
							  (UserID, AccountType, Identification, OauthToken, OauthTokenSecret)
		VALUES     (@UserID,@AccountType,@Identification,@OauthToken,@OauthTokenSecret)	
	End

End
else if(@Action=1)
	Begin
		Update spb_AccountBindings
		set Identification=@Identification
		where UserID=@UserID and AccountType=@AccountType
	End
else
	Begin
		delete from spb_AccountBindings 
		where UserID=@UserID and AccountType=@AccountType
	End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE Procedure [dbo].[spb_UserID_GetByAccountBinding]
(
	@AccountType int=0,
	@Identification nvarchar(256)=''
)
as
select UserID from spb_AccountBindings where AccountType = @AccountType and Identification=@Identification
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取留言薄 */
CREATE PROCEDURE [dbo].[spb_UserGuestbook_Get] 
(
	@GuestbookID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_UserGuestbooks with (nolock) where GuestbookID=@GuestbookID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 创建、更新、删除留言薄 */
CREATE PROCEDURE [dbo].[spb_UserGuestbook_CreateUpdateDelete] 
(
	@Action int,
	@GuestbookID int,
	@IsActive	bit = 1, 
	@MostRecentPostDate datetime, 
	@EnableAnonymousPosting	bit = 1,  
	@PostCount int,
	@PropertyNames	ntext = null,
	@PropertyValues	ntext = null
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if @Action = 2 --删除

  --暂不需要
  delete from spb_UserGuestbooks where GuestbookID=@GuestbookID

else if  @Action = 1 --修改

    update spb_UserGuestbooks set IsActive=@IsActive,MostRecentPostDate=@MostRecentPostDate,EnableAnonymousPosting=@EnableAnonymousPosting,
        PostCount=@PostCount,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
        where GuestbookID=@GuestbookID

else if @Action = 0 --添加
    insert into spb_UserGuestbooks (GuestbookID,IsActive,MostRecentPostDate,EnableAnonymousPosting,PostCount,PropertyNames,PropertyValues)
        values (@GuestbookID,@IsActive,@MostRecentPostDate,@EnableAnonymousPosting,@PostCount,@PropertyNames,@PropertyValues)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 批量删除用户留言 **/
CREATE PROCEDURE [dbo].[spb_UserGuestbookPosts_BatchDelete] 
(
  @beforeDays	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @currentDate datetime
declare @numberOfDelete int
set @currentDate = getdate()

select @numberOfDelete = count(PostID) from spb_UserGuestbookPosts with (nolock) where DateDiff(day,PostDate,@currentDate) >= @beforeDays

BEGIN TRANSACTION

UPDATE    spb_UserGuestbooks
SET              PostCount = spb_UserGuestbooks.PostCount - 1
FROM      spb_UserGuestbooks INNER JOIN
          spb_UserGuestbookPosts ON spb_UserGuestbooks.GuestbookID = spb_UserGuestbookPosts.GuestbookID
WHERE     (DateDiff(day,spb_UserGuestbookPosts.PostDate,@currentDate) >= @beforeDays)
if (@@ERROR <> 0) GOTO Failure
delete from spb_UserGuestbookPosts where (DateDiff(day,PostDate,@currentDate) >= @beforeDays)
if (@@ERROR <> 0) GOTO Failure
COMMIT TRANSACTION
SELECT @numberOfDelete -- Success
RETURN

Failure:
	ROLLBACK TRANSACTION
	SELECT 0 -- UnknownFailure
	RETURN
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 创建、更新、删除留言 */
CREATE PROCEDURE [dbo].[spb_UserGuestbookPost_CreateUpdateDelete] 
(
	@Action int,
	@PostID	int out,
	@ParentID int = 0,
	@ParentUserID int = 0,
	@IsPrivate bit = 0 ,
	@GuestbookID	int = 0,
	@UserID	int = 0,
	@Author	nvarchar(256) = '',
	@Subject nvarchar(512) = '',
	@Body ntext = '',
	@IsApproved	bit = 1,
	@AuditingStatus int=40,
	@UserHostAddress nvarchar(64) = '',
	@PropertyNames	ntext = null,
	@PropertyValues	ntext = null
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

if @Action = 2 --删除
begin
  select @GuestbookID=GuestbookID,@ParentID=ParentID from spb_UserGuestbookPosts with (nolock) where PostID=@PostID
  if (@GuestbookID is not null)
    update spb_UserGuestbooks set PostCount=PostCount-1 where GuestbookID=@GuestbookID

  delete from spb_UserGuestbookPosts where PostID=@PostID
end
else if  @Action = 1 --修改

  update spb_UserGuestbookPosts set Author=@Author,Subject=@Subject,Body=@Body,IsApproved=@IsApproved,
      UserHostAddress=@UserHostAddress,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
      where PostID=@PostID

else if @Action = 0 --添加
begin
    if not exists (select GuestbookID from spb_UserGuestbooks with (nolock) where GuestbookID=@GuestbookID)
      INSERT INTO spb_UserGuestbooks (GuestbookID) VALUES (@GuestbookID)

    insert into spb_UserGuestbookPosts (ParentID,ParentUserID,IsPrivate,GuestbookID,UserID,Author,Subject,Body,IsApproved,AuditingStatus,UserHostAddress,PropertyNames,PropertyValues)
        values (@ParentID,@ParentUserID,@IsPrivate,@GuestbookID,@UserID,@Author,@Subject,@Body,@IsApproved,@AuditingStatus,@UserHostAddress,@PropertyNames,@PropertyValues)

    select @PostID=SCOPE_IDENTITY()

    update spb_UserGuestbooks set PostCount=PostCount+1 where GuestbookID=@GuestbookID

end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 保存站点配置信息 */
CREATE procedure [dbo].[spb_SiteSettings_Save]
(
	@SettingsID 	int,
	@SettingsXML	ntext = null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
BEGIN
    if exists(select * from spb_SiteSettings with (nolock))
		  UPDATE
			  spb_SiteSettings
		  SET
			  SettingsXML = @SettingsXML
		  WHERE
			  SettingsID  = @SettingsID
		else
		  insert into spb_SiteSettings (SettingsXML) values (@SettingsXML)
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取站点配置信息 **/

CREATE  PROCEDURE [dbo].[spb_SiteSettings_Get]
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
Select top 1 * FROM spb_SiteSettings with (nolock)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取圈子所有地区统计以及最大深度 **/

CREATE PROCEDURE [dbo].[spb_ClubAreaStatisticses_GetAll] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     A.*,isnull(E.TotalCount,0) as TotalCount
FROM         spb_Areas A with (nolock) left JOIN
                      spb_ClubAreaStatistics E with (nolock) ON A.AreaCode = E.AreaCode
ORDER BY E.TotalCount DESC

SELECT     MAX(A.Depth) AS MaxDepth
FROM         spb_Areas A with (nolock) left JOIN
      spb_ClubAreaStatistics E with (nolock) ON A.AreaCode = E.AreaCode
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户在页面中已经使用的WidgetID **/

CREATE PROCEDURE [dbo].[spb_WidgetInstances_GetUsedWidgetIDsByPageCode] 
(
    @OwnerID int,
    @PageCode char(4),
    @Theme nvarchar(32)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select I.WidgetID,I.InstanceID from spb_WidgetsInZones I with (nolock) inner join spb_WidgetZones Z with (nolock)
    on I.ZoneID=Z.ZoneID where I.OwnerID=@OwnerID and Z.PageCode=@PageCode and Z.Theme = @Theme
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 附加WidgetInstance **/

create PROCEDURE [dbo].[spb_WidgetInstance_Append] 
(
    @InstanceID	int,
    @ToZoneID	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @MaxDisplayOrder int

select @MaxDisplayOrder=isnull(max(DisplayOrder),0) from spb_WidgetsInZones with (nolock) where ZoneID=@ToZoneID
update spb_WidgetsInZones set DisplayOrder=@MaxDisplayOrder+1,ZoneID=@ToZoneID where InstanceID=@InstanceID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建/删除 Widget **/

CREATE PROCEDURE [dbo].[spb_Widget_CreateUpdateDelete] 
(
    @Action int,
    @WidgetID	char(16),
    @OwnerID	int = 0,
    @IsBuiltIn bit = 0,
    @WidgetName	nvarchar(128) = '',
    @ApplicationID	int = '9999',
    @PresentAreaID	int = 1,    
    @WidgetXml	ntext = null
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON


if(@Action=0) --添加
    insert into  spb_Widgets (WidgetID,OwnerID,IsBuiltIn,WidgetName,ApplicationID,PresentAreaID,WidgetXml)
        values (@WidgetID,@OwnerID,@IsBuiltIn,@WidgetName,@ApplicationID,@PresentAreaID,@WidgetXml)
else if(@Action = 1)  --更新
begin
    update spb_Widgets set WidgetXml=@WidgetXml,WidgetName=@WidgetName,ApplicationID=@ApplicationID,IsBuiltIn=@IsBuiltIn where WidgetID=@WidgetID
    update spb_WidgetsInZones set WidgetXml=@WidgetXml where WidgetID=@WidgetID
end    
else if(@Action = 2)  --删除
begin
    delete from spb_WidgetsInZones where WidgetID=@WidgetID
    delete from spb_Widgets where WidgetID=@WidgetID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 插入 WidgetInstance **/

create PROCEDURE [dbo].[spb_WidgetInstance_Insert] 
(
    @WidgetID	char(16) = null,
    @OwnerID	int = 0,
    @ZoneID	int = null,
    @WidgetXml	ntext = null,
    @DisplayOrder int = null
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_WidgetsInZones set DisplayOrder=DisplayOrder+1 where OwnerID=@OwnerID and ZoneID=@ZoneID and DisplayOrder>=@DisplayOrder

insert into spb_WidgetsInZones (WidgetID,OwnerID,ZoneID,WidgetXml,DisplayOrder)
    values (@WidgetID,@OwnerID,@ZoneID,@WidgetXml,@DisplayOrder)

select SCOPE_IDENTITY()
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 移动WidgetInstance **/

CREATE PROCEDURE [dbo].[spb_WidgetInstance_Move] 
(
    @InstanceID	int,
    @ToZoneID	int,
    @ToBeforeInstanceID	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @OwnerID int
declare @ZoneID int
declare @DisplayOrder int

declare @ToDisplayOrder int

select @OwnerID=OwnerID,@ZoneID=ZoneID,@DisplayOrder=DisplayOrder from spb_WidgetsInZones with (nolock) where InstanceID=@InstanceID

update spb_WidgetsInZones set DisplayOrder=DisplayOrder-1 where OwnerID=@OwnerID and ZoneID=@ZoneID and DisplayOrder>@DisplayOrder

if (@ToBeforeInstanceID>0)
begin
    select @ToDisplayOrder=DisplayOrder from spb_WidgetsInZones with (nolock) where InstanceID=@ToBeforeInstanceID
    update spb_WidgetsInZones set DisplayOrder=DisplayOrder+1 where OwnerID=@OwnerID and ZoneID=@ToZoneID and DisplayOrder>=@ToDisplayOrder
end    
else
begin
    select @ToDisplayOrder= ISNULL(max(DisplayOrder),0) from spb_WidgetsInZones with (nolock) where ZoneID=@ToZoneID
    set @ToDisplayOrder=@ToDisplayOrder+1    
end    

update spb_WidgetsInZones set DisplayOrder=@ToDisplayOrder,ZoneID=@ToZoneID where InstanceID=@InstanceID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取WidgetZone中的WidgetInstance **/

CREATE PROCEDURE [dbo].[spb_WidgetInstances_GetByZone] 
(
    @OwnerID int,
    @ZoneID	int,
    @AutoCreate bit = 0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@AutoCreate = 1)
begin
    if not exists (select * from spb_WidgetsInZones with (nolock) where OwnerID=@OwnerID and ZoneID=@ZoneID)
        insert into spb_WidgetsInZones (WidgetID,OwnerID,ZoneID,WidgetXml,DisplayOrder)
            (select WidgetID,@OwnerID,ZoneID,WidgetXml,DisplayOrder from spb_WidgetsInZones with (nolock) where OwnerID=0 and ZoneID=@ZoneID)
end

select * from spb_WidgetsInZones with (nolock) where OwnerID=@OwnerID and ZoneID=@ZoneID order by DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建/更新/删除 WidgetInstance **/

CREATE PROCEDURE [dbo].[spb_WidgetInstance_CreateUpdateDelete] 
(
    @Action int,
    @InstanceID	int = null,    
    @WidgetID	char(16) = null,
    @OwnerID	int = 0,
    @ZoneID	int = null,
    @WidgetXml	ntext = null,
    @DisplayOrder int = null
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if(@Action=0) --添加
begin
    insert into spb_WidgetsInZones (WidgetID,OwnerID,ZoneID,WidgetXml,DisplayOrder)
        values (@WidgetID,@OwnerID,@ZoneID,@WidgetXml,@DisplayOrder)

    select SCOPE_IDENTITY()
end
else if(@Action=1) --更新
begin
    update spb_WidgetsInZones set WidgetXml=@WidgetXml where InstanceID=@InstanceID
end    
else if(@Action = 2)  --删除
begin
    select @OwnerID=OwnerID, @ZoneID=ZoneID,@DisplayOrder=DisplayOrder from spb_WidgetsInZones with (nolock) where InstanceID=@InstanceID
    if (@OwnerID is not null)
    begin
        delete spb_WidgetsInZones where InstanceID=@InstanceID
        update spb_WidgetsInZones set DisplayOrder=DisplayOrder-1 where OwnerID=@OwnerID and ZoneID=@ZoneID and DisplayOrder>@DisplayOrder
    end
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取WidgetInstance **/

create PROCEDURE [dbo].[spb_WidgetInstance_Get] 
(
    @InstanceID	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_WidgetsInZones with (nolock) where InstanceID=@InstanceID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE Procedure [dbo].[spb_Voters_Get]
(
    @ThreadID int = 0
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
select UserID from spb_VoteRecords where ThreadID=@ThreadID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteRecord_Get]
(
    @RecordID int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
select * from spb_VoteRecords where RecordID=@RecordID
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取需某个活动的所有评价 **/

CREATE proc [dbo].[spb_EventRatings_Get]
(
  @ItemID int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
SELECT    *
FROM      spb_EventRatings with (nolock)
WHERE     (EventID = @ItemID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 对 活动 进行评价 */

CREATE PROCEDURE [dbo].[spb_EventRating_Rate]
( 
	@ItemID	int,
	@UserID	int,
	@Author	nvarchar(64) = '',
	@Rate	int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if exists (select EventID from spb_EventRatings with (nolock) where EventID=@ItemID and UserID=@UserID)

	begin
		UPDATE    spb_EventRatings
    SET       Author = @Author, Rate = @Rate
    WHERE    (EventID = @ItemID) AND (UserID = @UserID)
	end
	
else
	begin
    INSERT INTO spb_EventRatings
               (EventID, UserID, Author, Rate)
    VALUES     (@ItemID,@UserID,@Author,@Rate)
	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、删除 圈子成员接受的圈子动态 */

CREATE PROCEDURE [dbo].[spb_ClubActivityInbox_CreateDelete]
( 
    @Action int,
    @ActivityID int = 0,
	@UserID int = 0,
    @ApplicationID	int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
	begin
	delete from spb_ClubActivityInbox where UserID=@UserID and ActivityID = @ActivityID  
	end
else 
    begin
        if (@Action = 0) --添加
          begin
	        insert into spb_ClubActivityInbox (UserID,ActivityID,ApplicationID)
                                values (@UserID,@ActivityID,@ApplicationID)
            set  @ActivityID = SCOPE_IDENTITY()
          end
    end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_UserIdentity_Delete]
@UserID INT
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN	
	SET NOCOUNT ON;
delete  from spb_UserIdentities where UserID =@UserID
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_UserIdentity_CreateUpdate]
(@Action int,
@UserID int,
@IdentityID int,
@IdentityDescription nvarchar(512)=''
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	SET NOCOUNT ON;

  if(@Action=0) --创建
  begin
  insert  spb_UserIdentities(IdentityID,IdentityDescription,UserID) values (@IdentityID,@IdentityDescription,@UserID) 
     select @IdentityID=SCOPE_IDENTITY() 
  end
  else if(@Action=1) --更新
  update spb_UserIdentities set IdentityID=@IdentityID,IdentityDescription=@IdentityDescription where UserID=@UserID
  
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_UserIdentity_Get]
@UserID INT
AS
SET Transaction Isolation Level Read UNCOMMITTED
BEGIN
	
	SET NOCOUNT ON;

   select * from spb_UserIdentities where UserID=@UserID
END
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteThread_UpdateAuditingStatus]
(
    @AuditingStatus int=40,
    @ThreadID int
)
as
set transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
update spb_VoteThreads 
set AuditingStatus = @AuditingStatus
where ThreadID=@ThreadID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE PROCEDURE [dbo].[spb_Task_Vote_PerStage]
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
    --重置周浏览量
    update spb_VoteThreads set StageHitTimes=0
end
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteThreadView_Add]
(
    @ItemID int = 0,
    @WebViewCount int = 0 
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Begin
    update spb_VoteThreads
    set HitTimes=HitTimes + @WebViewCount,StageHitTimes=StageHitTimes + @WebViewCount
    where ThreadID=@ItemID
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_VoteSection_ResetStatistics]
(
	@SectionID int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
Declare @PresentAreaID int,@OwnerID int,@TotalThreadCount int
select @PresentAreaID = PresentAreaID,@OwnerID=OwnerID From [dbo].[spb_VoteSections] with (nolock) Where SectionID = @SectionID
IF (@PresentAreaID > 0 and @OwnerID > 0)
BEGIN		
		SELECT 
			@TotalThreadCount=Count(ThreadID)
		FROM 
			dbo.spb_VoteThreads with (nolock)
		WHERE 
			OwnerID = @OwnerID and PresentAreaID = @PresentAreaID
			
		Update spb_VoteSections
		Set TotalThreadCount = IsNull(@TotalThreadCount,0)
		Where SectionID = @SectionID
END
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_VoteThread_AddVoterCount]
(
    @ThreadID int
)
as
set transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_VoteThreads
set VoterCount = VoterCount+1
where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_FilesOfPendingDeletion_Create]
(
	@StorageProviderName nvarchar(256) = '',
	@FullDirectory nvarchar(1024) = '',
	@FileName nvarchar(256) = ''
)
AS
insert into spb_FilesOfPendingDeletion(StorageProviderName,FullDirectory,FileName) Values (@StorageProviderName,@FullDirectory,@FileName)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/**重新统计版块组**/

CREATE procedure [dbo].[spb_ForumSectionGroup_ResetStatistics]
(
	@GroupID int = 0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

DECLARE @ThreadCount int
DECLARE @PostCount int
select @ThreadCount=Sum(S.ThreadCount),@PostCount=Sum(S.PostCount) FROM spb_ForumSections S with (nolock) Join spb_ForumSectionGroups G on S.GroupID = G.GroupID WHERE G.GroupID = @GroupID

UPDATE spb_ForumSectionGroups
SET PostCount = isnull(@PostCount,0),
    ThreadCount = isnull(@ThreadCount,0)
WHERE GroupID = @GroupID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取SiteGroupID */

CREATE PROCEDURE [dbo].[spb_ForumSectionGroupIDs_Get]
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT GroupID FROM spb_ForumSectionGroups with (nolock) WHERE PresentAreaID = 10 order by displayorder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据GroupID获取ForumSectionGroup */

CREATE PROCEDURE [dbo].[spb_ForumSectionGroup_Get]
(
    @GroupID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT * FROM spb_ForumSectionGroups with (nolock) WHERE GroupID = @GroupID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除论坛版块组 **/

CREATE PROCEDURE [dbo].[spb_ForumSectionGroup_CreateUpdateDelete]
(
	@Action int,
	@GroupID int out,
	@OwnerID int = 0,
	@PresentAreaID int = 0,
	@GroupName nvarchar(512) = '',
	@DisplayOrder int = 0,
	@ThreadCount int = 0,
	@PostCount int = 0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
begin
  INSERT spb_ForumSectionGroups (GroupName,PresentAreaID,OwnerID,DisplayOrder,ThreadCount,PostCount)
  values (@GroupName,@PresentAreaID,@OwnerID,@DisplayOrder,@ThreadCount,@PostCount)
  SELECT @GroupID = SCOPE_IDENTITY() 
END
else if @Action=1 --更新
Begin
	update spb_ForumSectionGroups 
	set GroupName=@GroupName,
		PresentAreaID=@PresentAreaID,
		OwnerID=@OwnerID,
		DisplayOrder=@DisplayOrder,
		ThreadCount=@ThreadCount,
		PostCount=@PostCount
	where GroupID = @GroupID
END
else
BEGIN
	DELETE FROM spb_ForumSectionGroups WHERE GroupID = @GroupID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据OwnerID获取GroupID */

CREATE PROCEDURE [dbo].[spb_ForumSectionGroupID_GetByOwnerID]
(
    @OwnerID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
SELECT GroupID FROM spb_ForumSectionGroups with (nolock) WHERE OwnerID = @OwnerID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spb_Role_Get] 
  @RoleID	int = -1,
  @RoleName	nvarchar(64) = null

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

begin

  if (@RoleID > 0)
    select * from spb_Roles with (nolock) where RoleID = @RoleID
  else if ( @RoleName is not null)
    select * from spb_Roles with (nolock) where LoweredRoleName = lower(@RoleName)

end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除ImpeachReport **/

create PROCEDURE [dbo].[spb_ImpeachReport_Delete] 
(
  @ReportID	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
DELETE FROM spb_ImpeachReports WHERE ReportID=@ReportID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取举报信息 **/

Create PROCEDURE [dbo].[spb_ImpeachReport_Get] 
(
	@ReportID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
select * from spb_ImpeachReports with (nolock) where ReportID = @ReportID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新 ImpeachReport **/

create PROCEDURE [dbo].[spb_ImpeachReport_UpdateStatus] 
(
  @ReportID	int,
  @IsComplete	bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
UPDATE spb_ImpeachReports SET IsComplete=@IsComplete WHERE ReportID=@ReportID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建 ImpeachReport **/

CREATE PROCEDURE [dbo].[spb_ImpeachReport_Create] 
(
  @UserID	int,
  @Author	nvarchar(64),
  @OriginalUrl nvarchar(1024),
  @Reason int,
  @Remark nvarchar(2048),
  @PropertyNames ntext=null,
  @PropertyValues ntext=null
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
INSERT INTO spb_ImpeachReports (UserID,Author,OriginalUrl,Reason,Remark,PropertyNames,PropertyValues)
		    VALUES (@UserID,@Author,@OriginalUrl,@Reason,@Remark,@PropertyNames,@PropertyValues)
SELECT SCOPE_IDENTITY()
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
CREATE Procedure [dbo].[spb_DefaultNavigations_Get]
(
    @PresentAreaID int
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Select DefaultNavigationID From [dbo].[spb_DefaultNavigations] with (nolock) Where PresentAreaID = @PresentAreaID order by displayorder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
Create Procedure [dbo].[spb_DefaultNavigations_GetSecondaryID]
(
	@PresentAreaID int = 0,
	@ApplicationID int = 0
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Select SecondaryID from spb_DefaultNavigations Where PresentAreaID = @PresentAreaID and ApplicationID = @ApplicationID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-----
Create Procedure [dbo].[spb_DefaultNavigation_Get]
(
	@DefaultNavigationID int = 0
)
as
SET TRANSACTION ISOLATION LEVEl READ UNCOMMITTED
SET NOCOUNT ON
Select * from spb_DefaultNavigations Where DefaultNavigationID = @DefaultNavigationID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新BlogThreadType **/

CREATE PROCEDURE [dbo].[spb_BlogThreadType_CreateUpdate] 
(
    @Action int,
    @TypeID int out,
	@TypeName nvarchar(64)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin

		INSERT spb_BlogThreadTypes (TypeName)
			Values (@TypeName)

        SELECT @TypeID = SCOPE_IDENTITY() 
	end

  else if @Action=1 --更新

	begin
	    
	   update spb_BlogThreadTypes set 
	        TypeName=@TypeName
	    where TypeID=@TypeID

	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 所有文章类型 **/

CREATE  PROCEDURE [dbo].[spb_BlogThreadTypes_Get]
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
Select  * FROM spb_BlogThreadTypes with (nolock)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据typeID删除BlogThreadType */

CREATE PROCEDURE [dbo].[spb_BlogThreadType_Delete]
(
    @TypeID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

delete spb_BlogThreadTypes where TypeID = @TypeID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据typeID获取BlogThreadType */

CREATE PROCEDURE [dbo].[spb_BlogThreadType_Get]
(
    @TypeID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT
    *
FROM    
	spb_BlogThreadTypes with (nolock)
WHERE 
    TypeID = @TypeID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 移动spb_ForumSections */

CREATE PROCEDURE [dbo].[spb_ForumSection_Move] 
(
    @fromSectionID int ,
    @toSectionID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @oldParentID int
select @oldParentID=ParentID from spb_ForumSections with (nolock) where SectionID=@fromSectionID

--更新旧父类ChildCount
update spb_ForumSections set ChildCount=ChildCount-1 where SectionID=@oldParentID
--更新新父类ChildCount
update spb_ForumSections set ChildCount=ChildCount+1 where SectionID=@toSectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 通过ClubID获取所有Forum **/

CREATE procedure [dbo].[spb_ForumSection_GetGroupIDBySectionID]
(
  @SectionID int
)
AS
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED
select GroupID from spb_ForumSections with (nolock) where SectionID=@SectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 修改地区的深度 **/
CREATE PROCEDURE [dbo].[spb_Area_UpdateDepth] 
(
    @AreaCode nvarchar(8)='',
	@DifferenceDepth int =0
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--更新地区的深度
UPDATE  spb_Areas SET Depth = Depth + @DifferenceDepth WHERE (AreaCode = @AreaCode) and Depth >= -@DifferenceDepth
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、更新、删除Area **/

CREATE PROCEDURE [dbo].[spb_Area_CreateUpdateDelete] 
(
  @Action int,
  @AreaCode	nvarchar(8)='',
  @ParentCode	nvarchar(8) ='',
  @Name	nvarchar(128)=null,
  @PostCode	nvarchar(8)='',
  @DisplayOrder	int=0
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin
    BEGIN TRAN
      INSERT INTO spb_Areas
      (AreaCode,ParentCode, Name, PostCode, DisplayOrder)
      VALUES (@AreaCode,@ParentCode,@Name,@PostCode,@DisplayOrder)
	  IF(@@error<>0) goto failure
	  
      if(@AreaCode <> '')
      begin
        if(@ParentCode <> '')--如果新地区的父地区存在，则父地区的子地区数加1，新地区的深度等于父地区的深度加1
		  begin            
            UPDATE   spb_Areas SET ChildCount = ChildCount + 1 WHERE (AreaCode = @ParentCode)
		    IF(@@error<>0) goto failure
		    
            DECLARE @ParentDepth int
            select @ParentDepth=Depth from spb_Areas with (nolock) where (AreaCode = @ParentCode)

            UPDATE   spb_Areas SET Depth = @ParentDepth + 1 WHERE (AreaCode = @AreaCode)
			IF(@@error<>0) goto failure
          end
      end
      COMMIT TRANSACTION
	  return
      failure:
      ROLLBACK TRANSACTION
      return
	end

  else if @Action=1 --更新
	  begin
      DECLARE @OldParentCode nvarchar(8)
      select  @OldParentCode=ParentCode from spb_Areas with (nolock) where (AreaCode=@AreaCode)
      UPDATE    spb_Areas
      SET       ParentCode = @ParentCode, Name = @Name, PostCode = @PostCode, DisplayOrder = @DisplayOrder
      WHERE     AreaCode=@AreaCode

      if(@ParentCode<>@OldParentCode)
        begin
            --原父地区的子地区数减1
            UPDATE   spb_Areas SET ChildCount = ChildCount - 1 WHERE (AreaCode = @OldParentCode) AND (ChildCount>0)
            --新父地区的子地区数加1
            UPDATE   spb_Areas SET ChildCount = ChildCount + 1 WHERE (AreaCode = @ParentCode) 
            DECLARE @NewParentDepth int--新父地区的深度
            select @NewParentDepth=Depth from spb_Areas with (nolock) where (AreaCode = @ParentCode) 
            --更新地区的深度
            UPDATE   spb_Areas SET Depth = @NewParentDepth + 1 WHERE (AreaCode = @AreaCode) 
        end
    end
  else 
	  begin
          if not exists (select * FROM spb_Areas WHERE AreaCode = @AreaCode)
          return
          DECLARE @TheParentCode nvarchar(8)
          select  @TheParentCode=ParentCode from spb_Areas with (nolock) where (AreaCode=@AreaCode)
          DELETE FROM spb_Areas WHERE (AreaCode = @AreaCode)
          UPDATE spb_Areas SET ChildCount = ChildCount - 1 WHERE (AreaCode =@TheParentCode ) AND (ChildCount>0)
	  end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有地区以及最大深度 **/

CREATE PROCEDURE [dbo].[spb_Areas_GetAll] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT     spb_Areas.*
FROM       spb_Areas with (nolock)
order by DisplayOrder,AreaCode

select Max(Depth) as MaxDepth
from spb_Areas with (nolock)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 检查用户是否在ThreadID上留过脚印 **/

CREATE PROCEDURE [dbo].[spb_FootPrint_IsExists] 
(
    @ThreadID int ,
    @UserID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @IsExists bit   
   
if exists (select * from spb_FootPrints with (nolock) where ThreadID=@ThreadID and UserID=@UserID)
set @IsExists = 1
else
set @IsExists = 0
   
select @IsExists
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据ThreadID  ShowCount 获取脚印 **/

CREATE PROCEDURE [dbo].[spb_FootPrints_GetByThreadID] 
(
    @ThreadID int 
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
select * from spb_FootPrints with (nolock) where ThreadID = @ThreadID order by FootprintID desc

SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 根据FootPrintID获取单个脚印 **/

CREATE PROCEDURE [dbo].[spb_FootPrint_Get] 
(
    @FootPrintID int 
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
   
  Select * From spb_FootPrints with (nolock)  where FootPrintID=@FootPrintID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 删除根据ThreadID批量删除脚印 **/

CREATE PROCEDURE [dbo].[spb_FootPrints_DeleteByThreadID] 
(
    @ThreadID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
   
delete spb_FootPrints  where ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建、删除脚印 **/

CREATE PROCEDURE [dbo].[spb_FootPrint_CreateDelete] 
(
    @Action int,
    @FootprintID int out,
    @UserID int,
	@Author nvarchar(64),
    @ThreadID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@Action = 0) --添加
	begin

		INSERT spb_FootPrints (UserID,Author,ThreadID)
			Values (@UserID,@Author,@ThreadID)

        SELECT @FootprintID = SCOPE_IDENTITY() 

	end

else  --删除

	begin
	    
	   delete spb_FootPrints  where FootprintID=@FootprintID

	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建CreateDownLoadRecord  **/

CREATE PROCEDURE [dbo].[spb_FileDownLoadRecord_Create] 
(
    @RecordID int output,
    @UserID int,	
	@ThreadID int,
    @UserDisplayName nvarchar(256),  
 	@Price int,
 	@UserHostAddress nvarchar(64),
 	@FromUrl nvarchar(2000)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

INSERT dbo.spb_FileDownLoadRecords (UserID,ThreadID,UserDisplayName,Price,FromUrl,UserHostAddress)
		values (@UserID,@ThreadID,@UserDisplayName,@Price,@FromUrl,@UserHostAddress)

SELECT @RecordID = SCOPE_IDENTITY()
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取BlogSection */

CREATE PROCEDURE [dbo].[spb_BlogSection_Get]
(	
  @OwnerUserID int = 0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

if (@OwnerUserID>0)

select * from spb_BlogSections with (nolock) where OwnerUserID = @OwnerUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* BlogSection的添加、修改、删除 */

CREATE PROCEDURE [dbo].[spb_BlogSection_CreateUpdateDelete] 
(
    @Action int,
    @OwnerUserID int,
	@SectionName nvarchar(512) = '',	
	@Description	nvarchar(2000) = '',	
	@IsActive 	bit = 0,
	@EnableSearch   bit = 1,	
	@PropertyNames ntext = null,
	@PropertyValues ntext = null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON


if @Action = 2 --删除

 delete spb_BlogSections where OwnerUserID=@OwnerUserID

else if  @Action = 1 --修改

    update spb_BlogSections set 
        SectionName=@SectionName,Description=@Description,IsActive=@IsActive,EnableSearch=@EnableSearch,
        PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
    where OwnerUserID=@OwnerUserID

else if @Action = 0 --添加
begin

    insert into spb_BlogSections (OwnerUserID,SectionName,Description,IsActive,EnableSearch,PropertyNames,PropertyValues)
        values (@OwnerUserID,@SectionName,@Description,@IsActive,@EnableSearch,@PropertyNames,@PropertyValues)
        
        
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** Weblog计数 **/
CREATE PROCEDURE [dbo].[spb_BlogSectionView_Add]
(
	@ItemID int,
	@WebViewCount int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_BlogSections set HitTimes = HitTimes+@WebViewCount,StageHitTimes = StageHitTimes+@WebViewCount where OwnerUserID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、博客每月执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Blog_PerStage]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

    update spb_BlogSections set StageHitTimes=0
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取好友的BlogSection */

CREATE PROCEDURE [dbo].[spb_BlogSections_GetSectionIDOfFriends]
(	
  @UserID int = 0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select top 500 OwnerUserID from spb_BlogSections with (nolock) where OwnerUserID 
  in (select FriendUserID from spb_Friends with (nolock) where userID= @UserID) and MostRecentThreadID >0 order by MostRecentThreadID desc
  

SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取用户或圈子 定义的Widgets **/

CREATE PROCEDURE [dbo].[spb_Widgets_GetCustomWidgets] 
(
    @PresentAreaID	int,
    @OwnerID int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select WidgetID from spb_Widgets where OwnerID=@OwnerID and PresentAreaID=@PresentAreaID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取Widget **/

CREATE PROCEDURE [dbo].[spb_Widget_Get] 
(
    @WidgetID	char(16)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_Widgets where WidgetID=@WidgetID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除某个类别的链接 */

create PROCEDURE [dbo].[spb_SiteLinks_DeleteByCategoryID] 
(
	@CategoryID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

delete from spb_SiteLinks where CategoryID=@CategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 用户链接类别 */

CREATE PROCEDURE [dbo].[spb_SiteLink_CreateUpdateDelete]
( 
    @Action int,
	@LinkID	int output,
	@CategoryID	int = 0,
	@Title nvarchar(256) = '',
	@ImageUrl nvarchar(256) = '',
	@LinkTitle nvarchar(256) = '',
	@LinkHref nvarchar(256) = '',
	@LinkType smallint = 0,
	@IsEnabled bit = 1,
	@DisplayOrder int = 0 output
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
        delete from spb_SiteLinks where LinkID = @LinkID    --删除
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin
--				--取链接的最大值
--				DECLARE @NewDisplayOrder int
--				select @NewDisplayOrder=max(DisplayOrder) from spb_SiteLinks
--				if (@NewDisplayOrder is null) --新记录
--					begin
--						set @NewDisplayOrder = 0
--					end
--				else 
--					begin
--						set @NewDisplayOrder = @NewDisplayOrder + 1
--					end
				INSERT INTO [spb_SiteLinks] ([CategoryID],[Title],[ImageUrl],[LinkTitle],[LinkHref],[LinkType],[IsEnabled],[DisplayOrder])
                      VALUES (@CategoryID,@Title,@ImageUrl,@LinkTitle,@LinkHref,@LinkType,@IsEnabled,@DisplayOrder)
            
				select @DisplayOrder = @DisplayOrder
                select @LinkID = SCOPE_IDENTITY() 
            end       
         else --更新
            begin
				UPDATE [spb_SiteLinks]
				   SET [CategoryID] = @CategoryID
					  ,[Title] = @Title
					  ,[ImageUrl] = @ImageUrl
					  ,[LinkTitle] = @LinkTitle
					  ,[LinkHref] = @LinkHref
					  ,[LinkType] = @LinkType
					  ,[IsEnabled] = @IsEnabled
					  ,[DisplayOrder] = @DisplayOrder
					where LinkID=@LinkID
            end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取站点链接类别 */

CREATE PROCEDURE [dbo].[spb_SiteLink_Get] 
(
    @LinkID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select l.*,c.CategoryName
from spb_SiteLinks as l with (nolock) inner join spb_SiteLinkCategories as c with (nolock) on l.categoryid=c.categoryid
where l.LinkID=@LinkID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* FileSection的添加、修改、删除 */

CREATE PROCEDURE [dbo].[spb_FileSection_CreateUpdateDelete] 
(
    @Action int,
    @OwnerUserID int,
	@SectionName nvarchar(512) = '',
    @Description nvarchar(2000)='',
	@IsActive bit = 1,
	@EnableSearch bit = 1,	
	@PropertyNames ntext = null,
	@PropertyValues ntext = null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON


if @Action = 2 --删除

    begin
      
      delete spb_FileSections where OwnerUserID=@OwnerUserID
      
    end

else if  @Action = 1 --修改

    update spb_FileSections set 
        SectionName=@SectionName,Description=@Description,IsActive=@IsActive,EnableSearch=@EnableSearch,
        PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
    where OwnerUserID=@OwnerUserID

else if @Action = 0 --添加

begin

    insert into spb_FileSections (OwnerUserID,SectionName,Description,IsActive,EnableSearch,PropertyNames,PropertyValues)
        values (@OwnerUserID,@SectionName,@Description,@IsActive,@EnableSearch,@PropertyNames,@PropertyValues)
        
        
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取FileSection */

CREATE PROCEDURE [dbo].[spb_FileSection_Get]
(	
    @OwnerUserID int = 0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
select * from spb_FileSections with (nolock) where OwnerUserID = @OwnerUserID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** FileSection计数 **/
CREATE PROCEDURE [dbo].[spb_FileSectionView_Add]
(
	@ItemID int,
	@WebViewCount int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_FileSections set HitTimes = HitTimes+@WebViewCount,StageHitTimes = StageHitTimes+@WebViewCount where OwnerUserID = @ItemID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取好友的FileSection */

CREATE PROCEDURE [dbo].[spb_FileSections_GetSectionIDOfFriends]
(	
  @UserID int = 0
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select top 500 OwnerUserID from spb_FileSections with (nolock) where OwnerUserID 
  in (select FriendUserID from spb_Friends with (nolock) where userID= @UserID) and MostRecentThreadID >0 order by MostRecentThreadID desc

SET NOCOUNT OFF
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取WidgetZone **/

Create PROCEDURE [dbo].[spb_WidgetZone_Get] 
(
    @ZoneID	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
select * from spb_WidgetZones with (nolock) where ZoneID=@ZoneID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取Column中的WidgetZone **/

CREATE PROCEDURE [dbo].[spb_WidgetZones_Get] 
(
    @PageCode	char(4),
    @Theme	nvarchar(32),
    @ColumnNumber	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
select * from spb_WidgetZones with (nolock) where PageCode=@PageCode and Theme=@Theme and ColumnNumber=@ColumnNumber
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建WidgetZone **/

CREATE PROCEDURE [dbo].[spb_WidgetZone_Create] 
(
    @Theme	nvarchar(32),
    @PresentAreaID	int,
    @PageCode	char(4),
    @ColumnNumber	int,
    @IsFrozen	bit,
    @DisplayOrder	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
insert into spb_WidgetZones (Theme,PresentAreaID,DisplayOrder,PageCode,ColumnNumber,[IsFrozen] )
    values (@Theme,@PresentAreaID,@DisplayOrder,@PageCode,@ColumnNumber,@IsFrozen )

select SCOPE_IDENTITY()
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_VoteSection_Get]
(
	@PresentAreaID int,
	@OwnerID int
)
as 
if EXISTS (select 1 from spb_VoteSections with(nolock) where PresentAreaID = @PresentAreaID and OwnerID = @OwnerID)
Begin
	select * from spb_VoteSections with(nolock) where PresentAreaID = @PresentAreaID and OwnerID = @OwnerID
End	
ELSE
BEGIN
  DECLARE @TotalThreadCount INT
  select @TotalThreadCount = Count(ThreadID) from spb_VoteThreads with (nolock) where PresentAreaID = @PresentAreaID and OwnerID = @OwnerID
  INSERT into spb_VoteSections (PresentAreaID,OwnerID,TotalThreadCount) values (@PresentAreaID,@OwnerID,@TotalThreadCount) 
  select * from spb_VoteSections with(nolock) where PresentAreaID = @PresentAreaID and OwnerID = @OwnerID
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE Procedure [dbo].[spb_VoteSection_CreateDelete]
(
	@Action int,
	@PresentAreaID int,
	@OwnerID int
)
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
if(@Action = 0) --添加
begin
	insert into spb_VoteSections(PresentAreaID,OwnerID) Values (@PresentAreaID,@OwnerID)
End
else if(@Action = 2) 
Begin
	Delete From spb_VoteSections Where PresentAreaID = @PresentAreaID and OwnerID = @OwnerID
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取所有隐私项集合 **/

CREATE PROCEDURE [dbo].[spb_PrivacyItems_GetAll] 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

SELECT * FROM  spb_PrivacyItems with (nolock) ORDER BY DisplayOrder
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取广告位置编码 */

CREATE PROCEDURE [dbo].[spb_AdvertisingPositionCodes_Get] 
(
  @presentAreaID int = -1,
	@AllowSystem bit = null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if (@AllowSystem is null)	
  begin 
    if @presentAreaID>10
	    select PositionCode from spb_AdvertisingPositions with (nolock) where presentAreaID=@presentAreaID
	  else
	    select PositionCode from spb_AdvertisingPositions with (nolock)
	end
else
  begin
    if (@presentAreaID>10)
	    select PositionCode from spb_AdvertisingPositions with (nolock) where AllowSystem=@AllowSystem and presentAreaID=@presentAreaID
    else
	    select PositionCode from spb_AdvertisingPositions with (nolock) where AllowSystem=@AllowSystem
	end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取广告位置 */

CREATE PROCEDURE [dbo].[spb_AdvertisingPosition_Get] 
(
    @PositionCode nvarchar(16)
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_AdvertisingPositions with (nolock) where PositionCode=@PositionCode
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		zhengw
-- Update date: 2009-3-28
-- Description:	 合并SiteCategories
-- =============================================


CREATE PROCEDURE [dbo].[spb_SiteCategory_Merge] 
    @fromCategoryID int ,
    @toCategoryID int
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @childCount int
select @childCount=ChildCount from spb_SiteCategories with (nolock) where CategoryID=@fromCategoryID
--更新原类别所有的子类别的ParentID为新类别的ID
update spb_SiteCategories set ParentID=@toCategoryID where ParentID=@fromCategoryID
--更新新类的ChildCount
update spb_SiteCategories set ChildCount=ChildCount+@childCount where CategoryID=@toCategoryID

declare @oldParentID int
select @oldParentID=ParentID from spb_SiteCategories with (nolock) where CategoryID=@fromCategoryID
update spb_SiteCategories set ChildCount=ChildCount-1 where CategoryID=@oldParentID

delete from spb_SiteCategories where CategoryID=@fromCategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 移动SiteCategories */

CREATE PROCEDURE [dbo].[spb_SiteCategory_Move] 
    @fromCategoryID int ,
    @toCategoryID int
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

declare @oldParentID int
select @oldParentID=ParentID from spb_SiteCategories with (nolock) where CategoryID=@fromCategoryID

update spb_SiteCategories set ParentID=@toCategoryID where CategoryID=@fromCategoryID
--更新旧父类ChildCount
update spb_SiteCategories set ChildCount=ChildCount-1 where CategoryID=@oldParentID
--更新新父类ChildCount
update spb_SiteCategories set ChildCount=ChildCount+1 where CategoryID=@toCategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		zhengw
-- Create date: 2009-3-28
-- Description:	更新某站点类别的深度
-- =============================================

create PROCEDURE [dbo].[spb_SiteCategory_UpdateDepth] 
    @CategoryID int ,
    @Depth int
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

update spb_SiteCategories set Depth=@Depth where CategoryID=@CategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 站点类别 */

CREATE PROCEDURE [dbo].[spb_SiteCategory_CreateUpdateDelete]
( 
    @Action int,
    @CategoryID	int out,
    @ParentID	int = 0,
    @ApplicationID int=0,
    @CategoryName nvarchar(128)='',
    @Description nvarchar(512)='',
    @DisplayOrder int=0,
    @ItemCount int=0,
    @PropertyNames ntext=null,
    @PropertyValues ntext=null
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
        declare @ParentCategoryID int
        select @ParentCategoryID=ParentID from spb_SiteCategories with (nolock) where CategoryID=@CategoryID
        UPDATE  spb_SiteCategories SET  ChildCount = ChildCount - 1 WHERE (CategoryID = @ParentCategoryID ) and  (ChildCount>0)
        
        delete from spb_SiteCategories where CategoryID=@CategoryID
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin
                insert into spb_SiteCategories (ParentID,ApplicationID,CategoryName,Description,DisplayOrder,PropertyNames,PropertyValues) 
                    values (@ParentID,@ApplicationID,@CategoryName,@Description,@DisplayOrder,@PropertyNames,@PropertyValues)
                set @CategoryID = SCOPE_IDENTITY()                
                if(@CategoryID >0 and @ParentID>0)
					begin                
					  UPDATE  spb_SiteCategories SET  ChildCount = ChildCount + 1 WHERE (CategoryID = @ParentID )
						DECLARE @ParentDepth int
						select @ParentDepth=Depth from spb_SiteCategories with (nolock) where (CategoryID = @ParentID) 
						UPDATE   spb_SiteCategories SET Depth = @ParentDepth + 1 WHERE (CategoryID = @CategoryID) 
				    end        
            end
         else --更新
            begin
              update spb_SiteCategories set ApplicationID=@ApplicationID,CategoryName=@CategoryName,
                  Description=@Description,DisplayOrder=@DisplayOrder,ItemCount=@ItemCount,
                  PropertyNames=@PropertyNames,PropertyValues=@PropertyValues where CategoryID=@CategoryID
             end 
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取SiteCategories */

CREATE PROCEDURE [dbo].[spb_SiteCategories_Get] 
    @MaxDepth int out,
    @ApplicationID int
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_SiteCategories with (nolock) where ApplicationID=@ApplicationID order by DisplayOrder

set @MaxDepth=(select max(Depth) from spb_SiteCategories with (nolock) where ApplicationID=@ApplicationID)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建Theme **/

CREATE PROCEDURE [dbo].[spb_Theme_SetEnabled] 
(
    @PresentAreaID int,
    @DirectoryName	nvarchar(32),
    @IsEnabled	bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
update spb_Themes set IsEnabled=@IsEnabled where PresentAreaID=@PresentAreaID and DirectoryName=@DirectoryName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 创建Theme **/

CREATE PROCEDURE [dbo].[spb_Theme_Create] 
(
    @PresentAreaID	int,
    @DirectoryName	nvarchar(32),
    @Parent	nvarchar(32),
    @DefaultAppearanceName	nvarchar(32),
    @EnableChangeLayout	bit,
    @EnablePrintCSS bit
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
if exists (select DirectoryName from spb_Themes with (nolock) where PresentAreaID=@PresentAreaID and DirectoryName=@DirectoryName)
    update spb_Themes set Parent=@Parent,DefaultAppearanceName=@DefaultAppearanceName,EnableChangeLayout=@EnableChangeLayout,EnablePrintCSS=@EnablePrintCSS
        where PresentAreaID=@PresentAreaID and DirectoryName=@DirectoryName
else
    INSERT INTO spb_Themes (PresentAreaID,DirectoryName,Parent,DefaultAppearanceName,EnableChangeLayout,EnablePrintCSS)
        VALUES  (@PresentAreaID,@DirectoryName,@Parent,@DefaultAppearanceName,@EnableChangeLayout,@EnablePrintCSS)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取Theme **/

CREATE PROCEDURE [dbo].[spb_Theme_Get] 
(
    @PresentAreaID	int,
    @DirectoryName	nvarchar(32)
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
select * from spb_Themes where PresentAreaID=@PresentAreaID and DirectoryName=@DirectoryName
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 获取themeCategory下的Theme的DirectoryName **/

CREATE PROCEDURE [dbo].[spb_Theme_GetDirectoryNames] 
(
    @PresentAreaID	int
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
select DirectoryName from spb_Themes where PresentAreaID=@PresentAreaID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新匿名用户 **/

CREATE PROCEDURE [dbo].[spb_UserAnonymous_Update]
(
	@UserGuid char(36),
	@LastActivityDateTime datetime,
	@LastAction nvarchar(1024) = '',
	@IPAddress nvarchar(32) = '000.000.000.000'
)
AS
set nocount on
BEGIN
	-- Does the user already exist?
	IF EXISTS (SELECT UserGuid FROM spb_AnonymousUsers with (nolock) WHERE UserGuid = @UserGuid)
		UPDATE spb_AnonymousUsers	SET LastActivityDateTime = @LastActivityDateTime, LastAction = @LastAction, IPAddress = @IPAddress WHERE	UserGuid = @UserGuid
	ELSE
		INSERT INTO spb_AnonymousUsers (UserGuid, LastActivityDateTime, LastAction, IPAddress) VALUES (@UserGuid, @LastActivityDateTime, @LastAction, @IPAddress)

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新站点统计中的匿名用户计数，并且删除不再活动的匿名用户 **/

CREATE  procedure [dbo].[spb_UserAnonymous_Count]
(
  @AnonymousUserOnlineTimeWindow int = 30,
  @AnonymousUserCount int out
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
BEGIN
DECLARE @StatDate datetime

	-- Clean up the anonymous users table
	DELETE spb_AnonymousUsers WHERE LastActivityDateTime < DateAdd(minute, -@AnonymousUserOnlineTimeWindow, GetDate())

	-- Get a count of anonymous users
	SET @AnonymousUserCount = (SELECT count(UserGuid) FROM spb_AnonymousUsers with (nolock))

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置留言的审核状态 */
create PROCEDURE [dbo].[spb_UserGuestbookPost_UpdateAuditingStatus] 
(
  @PostID int,
  @AuditingStatus int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

update spb_UserGuestbookPosts set AuditingStatus=@AuditingStatus where PostID=@PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取留言 */
CREATE PROCEDURE [dbo].[spb_UserGuestbookPost_Get] 
(  
  @PostID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on

select * from spb_UserGuestbookPosts with (nolock) where PostID=@PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 设置留言的批准状态 */
create PROCEDURE [dbo].[spb_UserGuestbookPost_UpdateApprovalStatus] 
(
  @PostID	int,
  @IsApproved	bit = 1
)
AS

SET Transaction Isolation Level Read UNCOMMITTED

update spb_UserGuestbookPosts set IsApproved=@IsApproved where PostID=@PostID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/** 更新用户积分项目规则 **/

CREATE PROCEDURE [dbo].[spb_UserPointItemRole_Update] 
(
  @ItemID	int,
  @BasicPoints	float,
  @ReportPoints	float,
  @CreditPoints	float,
  @TradePoints	float,
  @BasicPointQuota int,
  @ReportPointQuota int,
  @CreditPointQuota int,
  @TradePointQuota int	
) 
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
 
if exists (select ItemID from spb_UserPointItemRules with (nolock) where ItemID=@ItemID)
UPDATE    spb_UserPointItemRules
SET       BasicPoints = @BasicPoints, ReportPoints = @ReportPoints,
          CreditPoints = @CreditPoints, TradePoints = @TradePoints,BasicPointQuota = @BasicPointQuota,
          ReportPointQuota = @ReportPointQuota,CreditPointQuota = @CreditPointQuota,
          TradePointQuota = @TradePointQuota
WHERE     (ItemID = @ItemID)
--如果要更新的项目不存在则创建
else
INSERT INTO spb_UserPointItemRules
           (ItemID, BasicPoints, ReportPoints, CreditPoints, TradePoints,BasicPointQuota,ReportPointQuota,CreditPointQuota,TradePointQuota)
VALUES     (@ItemID,@BasicPoints,@ReportPoints,@CreditPoints,@TradePoints,@BasicPointQuota,@ReportPointQuota,@CreditPointQuota,@TradePointQuota)
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*删除过期的推荐项*/

create PROCEDURE [dbo].[spb_RecommendedItem_DeleteDelayed]

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

delete from spb_RecommendedItems where Deadline < getdate()
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*创建、更新、删除 对信息的推荐*/

CREATE PROCEDURE [dbo].[spb_RecommendedItem_CreateUpdateDelete]
(
    @Action int,
    @CommendID int Output,
    @CommendTypeID int = null,
    @ItemID	int = null,
    @ItemName nvarchar(256)='',
    @Commender nvarchar(64) ='',
    @CommenderUserID int,
    @Author	nvarchar(64)='',
    @AuthorUserID int = null,
	@DisplayOrder int = null,
	@Deadline datetime = null,
    @PropertyNames ntext=null,
	@PropertyValues ntext=null
)

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

    if @Action = 0 --添加    
      begin
        if not exists (select CommendID from spb_RecommendedItems with (nolock) where CommendTypeID=@CommendTypeID and ItemID=@ItemID)
        begin
          insert into spb_RecommendedItems(CommendTypeID,ItemID,ItemName,Commender,CommenderUserID,Author,AuthorUserID,DisplayOrder,Deadline,PropertyNames,PropertyValues)
            values (@CommendTypeID,@ItemID,@ItemName,@Commender,@CommenderUserID,@Author,@AuthorUserID,@DisplayOrder,@Deadline,@PropertyNames,@PropertyValues)
          set @CommendID = SCOPE_IDENTITY()
        end
      end      
    else if @Action = 1 --更新 
        update spb_RecommendedItems set 
            Deadline=@Deadline,ItemName=@ItemName,DisplayOrder=@DisplayOrder,PropertyNames=@PropertyNames,PropertyValues=@PropertyValues
         where CommendID = @CommendID
    else
      delete spb_RecommendedItems where CommendID = @CommendID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取站点链接类别 */

CREATE PROCEDURE [dbo].[spb_SiteLinkCategory_Get] 
(
    @CategoryID	int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_SiteLinkCategories with (nolock) where CategoryID=@CategoryID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 获取站点链接类别 */

CREATE PROCEDURE [dbo].[spb_SiteLinkCategories_Get] 

AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

select * from spb_SiteLinkCategories with (nolock) order by DisplayOrder asc
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 添加、修改、删除 用户链接类别 */

CREATE PROCEDURE [dbo].[spb_SiteLinkCategory_CreateUpdateDelete]
( 
    @Action int,
    @CategoryID	int output,
    @CategoryName nvarchar(256) = '',
    @Description	nvarchar(1024) = '',
    @DisplayOrder	int = 100
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

if( @Action = 2 ) --删除
    BEGIN
        delete from spb_SiteLinkCategories where CategoryID = @CategoryID    --删除
    END
ELSE 
    BEGIN
        if (@Action = 0) --添加
            begin
--				--取用户的最大值
--				DECLARE @NewDisplayOrder int
--				select @NewDisplayOrder=max(DisplayOrder) from spb_SiteLinkCategories
--				if (@NewDisplayOrder is null) --新记录
--					begin
--						set @NewDisplayOrder = 0
--					end
--				else 
--					begin
--						set @NewDisplayOrder = @NewDisplayOrder + 1
--					end
--				
                insert into spb_SiteLinkCategories (CategoryName,Description,DisplayOrder) values (
                    @CategoryName,@Description,@DisplayOrder)
            
                select @CategoryID = SCOPE_IDENTITY() 
            end       
         else --更新
            begin
                update spb_SiteLinkCategories set 
                    CategoryName       = @CategoryName,
                    Description      = @Description,
                    DisplayOrder            = @DisplayOrder
                    where CategoryID = @CategoryID
            end
    END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、文件每天执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_File_PerDay]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

exec spb_Task_File_Statistics

update spb_FileThreads set UserCategoryID=0
Where not exists
	(select CategoryID 
	from spb_FileUserCategories AS BUC with (nolock)
	where spb_FileThreads.UserCategoryID= BUC.CategoryID and BUC.CategoryID>0
	 )
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据threadID获取FileThread */

CREATE PROCEDURE [dbo].[spb_FileThread_Get]
(
    @ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE @GetPreAndNext bit
set @GetPreAndNext=1

DECLARE @NextThreadID int 
DECLARE @NextThreadSubject nvarchar(512)
DECLARE @PrevThreadID int  
DECLARE @PrevThreadSubject nvarchar(512)
DECLARE @UserCategoryID int 


if @GetPreAndNext=1
  begin
   select @UserCategoryID=UserCategoryID from spb_FileThreads with (nolock) where ThreadID=@ThreadID
   EXEC spb_FileThread_GetPrevNextThread @ThreadID,@UserCategoryID, @NextThreadID OUTPUT, @NextThreadSubject OUTPUT, @PrevThreadID OUTPUT,@PrevThreadSubject OUTPUT
  end
else
 begin
  select @NextThreadID=0
  select @NextThreadSubject=''
  select @PrevThreadID=0
  select @PrevThreadSubject=''
 end

SELECT
	FT.*,
	NextThreadID=@NextThreadID,
	NextThreadSubject=@NextThreadSubject,
	PrevThreadID=@PrevThreadID,
	PrevThreadSubject=@PrevThreadSubject
FROM 
	spb_FileThreads FT with (nolock)
WHERE 
	FT.ThreadID=@ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据PostID获取BlogThread */

CREATE PROCEDURE [dbo].[spb_BlogThread_Get]
(
    @ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE @GetPreAndNext bit
set @GetPreAndNext=1

DECLARE @NextThreadID int 
DECLARE @NextThreadSubject nvarchar(512)
DECLARE @PrevThreadID int  
DECLARE @PrevThreadSubject nvarchar(512)

if @GetPreAndNext=1
  begin
   EXEC spb_BlogThread_GetPrevNextThread @ThreadID, @NextThreadID OUTPUT, @NextThreadSubject OUTPUT, @PrevThreadID OUTPUT,@PrevThreadSubject OUTPUT
  end
else
 begin
  select @NextThreadID=0
  select @NextThreadSubject=''
  select @PrevThreadID=0
  select @PrevThreadSubject=''
 end

SELECT
    BT.*,
    NextThreadID=@NextThreadID,
    NextThreadSubject=@NextThreadSubject,
    PrevThreadID=@PrevThreadID,
    PrevThreadSubject=@PrevThreadSubject
    
FROM 
    spb_BlogThreads BT 
WHERE 
    BT.ThreadID = @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、相册每天执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Photo_PerDay]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

exec spb_Task_Photo_Statistics


update spb_Photos set UserCategoryID=0
Where not exists
	(select CategoryID 
	from spb_PhotoUserCategories AS BUC with (nolock)
	where spb_Photos.UserCategoryID= BUC.CategoryID and BUC.CategoryID>0
	 )
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_UserShareThread_Get]
(
    @UserThreadID int
)   
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
	DECLARE @NextUserThreadID int 
	DECLARE @PrevUserThreadID int
    EXEC spb_UserShareThread_GetPrevNextUserThread @UserThreadID, @NextUserThreadID OUTPUT, @PrevUserThreadID OUTPUT	 
    select  *,
			NextUserThreadID=@NextUserThreadID,
			PrevUserThreadID=@PrevUserThreadID
	from spb_UserShareThreads with (nolock) 
	where UserThreadID=@UserThreadID
end
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/*
1、论坛每天执行任务
*/

CREATE PROCEDURE [dbo].[spb_Task_Forum_PerDay]
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

exec spb_Task_Forum_Statistics

--重置今日发帖数
Update spb_ForumSections set TodayPostCount = 0

--处理到期置顶
DECLARE @currentDate datetime
set @currentDate = convert(char(10),getdate(),120)

Update spb_ForumThreads Set IsSticky = case when @currentDate > StickyDate then 0 ELSE 1 end where IsSticky = 1
Update P
Set HighlightStyle = ''
From spb_ForumPosts P,spb_ForumThreads T
where P.ThreadID = T.ThreadID and @currentDate > T.HighlightDate
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
CREATE procedure [dbo].[spb_Task_Vote_PerDay]
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
update spb_VoteThreads
set VoteStaus = 1
where getdate() > EndDate
exec spb_Task_Vote_Statistics
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 合并spb_ForumSections */

CREATE PROCEDURE [dbo].[spb_ForumSection_Merge] 
(
    @fromSectionID int ,
    @toSectionID int
)
AS
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

--转换帖子（不包含后代板块）
exec [dbo].[spb_ForumSection_MergeThreads] @fromSectionID,@toSectionID

declare @childCount int
select @childCount=ChildCount from spb_ForumSections with (nolock) where SectionID=@fromSectionID

--declare @Depth int
--select @Depth=Depth from spb_ForumSections where SectionID=@toSectionID
--更新新类的ChildCount，Depth
update spb_ForumSections set ChildCount=ChildCount+@childCount where SectionID=@toSectionID
update spb_ForumThreadCategories set SectionID=@toSectionID where sectionID=@fromSectionID
declare @oldParentID int
select @oldParentID=ParentID from spb_ForumSections with (nolock) where SectionID=@fromSectionID
if(@oldParentID>0)
	begin
		update spb_ForumSections set ChildCount=ChildCount-1 where SectionID=@oldParentID
	end

delete from spb_ForumSections where SectionID=@fromSectionID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 根据ThreadID获取Photo */

CREATE PROCEDURE [dbo].[spb_Photo_Get]
(
    @ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON

DECLARE @GetPreAndNext bit
set @GetPreAndNext=1

DECLARE @NextThreadID int 
DECLARE @PrevThreadID int  
DECLARE @UserCategoryID int 

select @UserCategoryID = UserCategoryID from spb_Photos with (nolock) Where ThreadID=@ThreadID

if @GetPreAndNext=1
  begin
   EXEC spb_Photo_GetPrevNextThread @ThreadID,@UserCategoryID, @NextThreadID OUTPUT, @PrevThreadID OUTPUT
  end
else
 begin
  select @NextThreadID=0
  select @PrevThreadID=0
 end

SELECT
    BT.*,
    NextThreadID=@NextThreadID,
    PrevThreadID=@PrevThreadID
FROM 
    spb_Photos BT with (nolock)
WHERE 
    BT.ThreadID = @ThreadID
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
/**每天执行的任务**/
Create procedure [dbo].[spb_Task_Share_PerDay]
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
exec spb_Task_Share_Statistics
--重置日浏览、分享人数
    update spb_ShareThreads set DayHitTimes=0,DayUserCount=0
End
GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
/**每周执行的任务**/
CREATE procedure [dbo].[spb_Task_Share_PerStage] 
as
SET Transaction Isolation Level Read UNCOMMITTED
SET NOCOUNT ON
begin
exec spb_Task_Share_Statistics
--重置周浏览、分享人数
    update spb_ShareThreads set StageHitTimes=0,StageUserCount=0
End
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除收件箱的项目 */
CREATE PROCEDURE [dbo].[spb_PrivateMessageInbox_Delete] 
(
	@UserID int, 
	@ThreadID int
)
AS
set nocount on
SET Transaction Isolation Level Read UNCOMMITTED

delete from spb_PrivateMessageInbox where UserID=@UserID and ThreadID=@ThreadID

exec spb_PrivateMessage_TryDelete @ThreadID
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
/* 删除发件箱的项目 */
CREATE PROCEDURE [dbo].[spb_PrivateMessageOutbox_Delete] 
(
	@UserID int, 
	@ThreadID int
)
AS

SET Transaction Isolation Level Read UNCOMMITTED
set nocount on
delete from spb_PrivateMessageOutbox where UserID=@UserID and ThreadID=@ThreadID

exec spb_PrivateMessage_TryDelete @ThreadID
GO
ALTER TABLE [dbo].[MicroBlogFollowingsUserCategories] ADD  CONSTRAINT [DF_MicroBlogFollowingsUserCategories_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[MicroBlogFollowingsUserCategories] ADD  CONSTRAINT [DF_MicroBlogFollowingsUserCategories_CategoryName]  DEFAULT ('') FOR [CategoryName]
GO
ALTER TABLE [dbo].[MicroBlogFollowingsUserCategories] ADD  CONSTRAINT [DF_MicroBlogFollowingsUserCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[MicroBlogFollowingsUserCategories] ADD  CONSTRAINT [DF_MicroBlogFollowingsUserCategories_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[MicroBlogFollowingsUserCategories] ADD  CONSTRAINT [DF_MicroBlogFollowingsUserCategories_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[MicroBlogFollowingsUserCategories] ADD  CONSTRAINT [DF_MicroBlogFollowingsUserCategories_MostRecentUpdateDate]  DEFAULT (getdate()) FOR [MostRecentUpdateDate]
GO
ALTER TABLE [dbo].[MicroBlogFollowingsUserCategories] ADD  CONSTRAINT [DF_MicroBlogFollowingsUserCategories_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_AccountBindings] ADD  CONSTRAINT [DF_spb_AccountBindings_AccountType]  DEFAULT (0) FOR [AccountType]
GO
ALTER TABLE [dbo].[spb_AccountBindings] ADD  CONSTRAINT [DF_spb_AccountBindings_Identification]  DEFAULT ('') FOR [Identification]
GO
ALTER TABLE [dbo].[spb_AccountBindings] ADD  CONSTRAINT [DF_spb_AccountBindings_OauthToken]  DEFAULT ('') FOR [OauthToken]
GO
ALTER TABLE [dbo].[spb_AccountBindings] ADD  CONSTRAINT [DF_spb_AccountBindings_OauthTokenSecret]  DEFAULT ('') FOR [OauthTokenSecret]
GO
ALTER TABLE [dbo].[spb_ActivityItems] ADD  CONSTRAINT [DF_spb_ActivityItems_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_ActivityItems] ADD  CONSTRAINT [DF_spb_ActivityItems_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_ActivityItems] ADD  CONSTRAINT [DF_spb_ActivityItems_OnlyOneTimePerDay]  DEFAULT (0) FOR [OnlyOneTimePerDay]
GO
ALTER TABLE [dbo].[spb_ActivityItems_Res] ADD  CONSTRAINT [DF_spb_ActivityItems_Res_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_AdvertisingPositions] ADD  CONSTRAINT [DF_spb_AdvertisingPositions_ApplicationID]  DEFAULT (10) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_AdvertisingPositions] ADD  CONSTRAINT [DF_spb_AdvertisingPositions_Width]  DEFAULT (0) FOR [Width]
GO
ALTER TABLE [dbo].[spb_AdvertisingPositions] ADD  CONSTRAINT [DF_spb_AdvertisingPositions_Height]  DEFAULT (0) FOR [Height]
GO
ALTER TABLE [dbo].[spb_AdvertisingPositions] ADD  CONSTRAINT [DF_spb_AdvertisingPositions_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_AdvertisingPositions] ADD  CONSTRAINT [DF_spb_AdvertisingPositions_Maximum]  DEFAULT (1) FOR [Maximum]
GO
ALTER TABLE [dbo].[spb_AdvertisingPositions] ADD  CONSTRAINT [DF_spb_AdvertisingPositions_UseredAdvertisings]  DEFAULT (0) FOR [UseredAdvertisings]
GO
ALTER TABLE [dbo].[spb_AdvertisingPositions] ADD  CONSTRAINT [DF_spb_AdvertisingPositions_AllowSystem]  DEFAULT (1) FOR [AllowSystem]
GO
ALTER TABLE [dbo].[spb_AdvertisingPositions] ADD  CONSTRAINT [DF_spb_AdvertisingPositions_ImageUrl]  DEFAULT ('') FOR [ImageUrl]
GO
ALTER TABLE [dbo].[spb_Advertisings] ADD  CONSTRAINT [DF_spb_Advertisings_OwnerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_Advertisings] ADD  CONSTRAINT [DF_spb_Advertisings_AdvertisingName]  DEFAULT ('') FOR [AdvertisingName]
GO
ALTER TABLE [dbo].[spb_Advertisings] ADD  CONSTRAINT [DF_spb_Advertisings_Script]  DEFAULT ('') FOR [Script]
GO
ALTER TABLE [dbo].[spb_Advertisings] ADD  CONSTRAINT [DF_spb_Advertisings_PresentAreaID]  DEFAULT (10) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_Advertisings] ADD  CONSTRAINT [DF_spb_Advertisings_UseredPositions]  DEFAULT (0) FOR [UseredPositions]
GO
ALTER TABLE [dbo].[spb_Advertisings] ADD  CONSTRAINT [DF_spb_Advertisings_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_IsHyperLink]  DEFAULT (0) FOR [IsHyperLink]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_AnnouncementStatus]  DEFAULT (0) FOR [AnnouncementStatus]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_ReleaseDate]  DEFAULT (getdate()) FOR [ReleaseDate]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_DateExpired]  DEFAULT (getdate()) FOR [DateExpired]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_IPAddress]  DEFAULT (N'000.000.000.000') FOR [IPAddress]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_IsSticky]  DEFAULT (0) FOR [IsSticky]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_DisplayOrder]  DEFAULT (100) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_Announcements] ADD  CONSTRAINT [DF_spb_Announcements_HyperLinkUrl]  DEFAULT ('') FOR [HyperLinkUrl]
GO
ALTER TABLE [dbo].[spb_AnnouncementsInPresentAreas] ADD  CONSTRAINT [DF_spb_AnnouncementsInPresentAreas_PresentAreaID]  DEFAULT (0) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_AnonymousUsers] ADD  CONSTRAINT [DF_spb_AnonymousUsers_LastLogin]  DEFAULT (getdate()) FOR [LastActivityDateTime]
GO
ALTER TABLE [dbo].[spb_AnonymousUsers] ADD  CONSTRAINT [DF_spb_AnonymousUsers_LastAction]  DEFAULT ('') FOR [LastAction]
GO
ALTER TABLE [dbo].[spb_AnonymousUsers] ADD  CONSTRAINT [DF_spb_AnonymousUsers_IPAddress]  DEFAULT (N'000.000.000.000') FOR [IPAddress]
GO
ALTER TABLE [dbo].[spb_ApplicationInAvailablePresentAreas] ADD  CONSTRAINT [DF_spb_ApplicationInAvailablePresentAreas_ApplicationID]  DEFAULT (0) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_ApplicationInAvailablePresentAreas] ADD  CONSTRAINT [DF_spb_ApplicationInAvailablePresentAreas_PresentAreaID]  DEFAULT (0) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_ApplicationInAvailablePresentAreas] ADD  CONSTRAINT [DF_spb_ApplicationInAvailablePresentAreas_IsBuiltIn]  DEFAULT (0) FOR [IsBuiltIn]
GO
ALTER TABLE [dbo].[spb_ApplicationInAvailablePresentAreas] ADD  CONSTRAINT [DF_spb_ApplicationInAvailablePresentAreas_IsDataEntry]  DEFAULT (0) FOR [IsDataEntry]
GO
ALTER TABLE [dbo].[spb_Applications] ADD  CONSTRAINT [DF_spb_Applications_ApplicationType]  DEFAULT (0) FOR [ApplicationType]
GO
ALTER TABLE [dbo].[spb_Applications] ADD  CONSTRAINT [DF_spb_Applications_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_Applications] ADD  CONSTRAINT [DF_spb_Applications_TotalCount]  DEFAULT (0) FOR [TotalCount]
GO
ALTER TABLE [dbo].[spb_Applications] ADD  CONSTRAINT [DF_spb_Applications_CountInPast24Hours]  DEFAULT (0) FOR [CountInPast24Hours]
GO
ALTER TABLE [dbo].[spb_Applications] ADD  CONSTRAINT [DF_spb_Applications_NewestID]  DEFAULT (0) FOR [NewestID]
GO
ALTER TABLE [dbo].[spb_Applications] ADD  CONSTRAINT [DF_spb_Applications_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_Applications] ADD  CONSTRAINT [DF_spb_Applications_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_Areas] ADD  CONSTRAINT [DF_spb_Areas_ParentCode]  DEFAULT ('') FOR [ParentCode]
GO
ALTER TABLE [dbo].[spb_Areas] ADD  CONSTRAINT [DF_spb_Areas_PostCode]  DEFAULT ('') FOR [PostCode]
GO
ALTER TABLE [dbo].[spb_Areas] ADD  CONSTRAINT [DF_spb_Areas_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_Areas] ADD  CONSTRAINT [DF_spb_Areas_Depth]  DEFAULT (0) FOR [Depth]
GO
ALTER TABLE [dbo].[spb_Areas] ADD  CONSTRAINT [DF_spb_Areas_ChildCount]  DEFAULT (0) FOR [ChildCount]
GO
ALTER TABLE [dbo].[spb_AuditingItems] ADD  CONSTRAINT [DF_spb_AuditingItems_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_AuditingItems] ADD  CONSTRAINT [DF_spb_AuditingItems_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_AuditingItems] ADD  CONSTRAINT [DF_spb_AuditingItems_EnabledInUserRole]  DEFAULT (0) FOR [EnabledInUserRole]
GO
ALTER TABLE [dbo].[spb_AuditingItems] ADD  CONSTRAINT [DF_spb_AuditingItems_EnabledInUserRank]  DEFAULT (0) FOR [EnabledInUserRank]
GO
ALTER TABLE [dbo].[spb_AuditingItemSettingsInUserRoles] ADD  CONSTRAINT [DF_spb_AuditingItemSettingsInUserRoles_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_BlogComments] ADD  CONSTRAINT [DF_spb_BlogPosts_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_BlogComments] ADD  CONSTRAINT [DF_spb_BlogPosts_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_BlogComments] ADD  CONSTRAINT [DF_spb_BlogComments_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_BlogComments] ADD  CONSTRAINT [DF_spb_BlogPosts_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_BlogComments] ADD  CONSTRAINT [DF_spb_BlogPosts_IsApproved]  DEFAULT (1) FOR [IsApproved]
GO
ALTER TABLE [dbo].[spb_BlogComments] ADD  CONSTRAINT [DF_spb_BlogPosts_AuditingStatus]  DEFAULT (0) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_BlogComments] ADD  CONSTRAINT [DF_spb_BlogPosts_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_BlogComments] ADD  CONSTRAINT [DF_spb_BlogPosts_TitleUrl]  DEFAULT ('') FOR [TitleUrl]
GO
ALTER TABLE [dbo].[spb_BlogComments] ADD  CONSTRAINT [DF__spb_BlogC__UserH__509F0A2B]  DEFAULT ('000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_BlogRatings] ADD  CONSTRAINT [DF_spb_BlogRatings_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_BlogRatings] ADD  CONSTRAINT [DF_spb_BlogRatings_Rating]  DEFAULT (0) FOR [Rate]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_SectionName]  DEFAULT ('') FOR [SectionName]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_IsActive]  DEFAULT (1) FOR [IsActive]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_IsSearchable]  DEFAULT (1) FOR [EnableSearch]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_CreateDate]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_PostCount]  DEFAULT (0) FOR [ThreadCount]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_Points]  DEFAULT (0) FOR [Points]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_BlogSections] ADD  CONSTRAINT [DF_spb_Weblogs_WeekHitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_BlogThreadAttachments] ADD  CONSTRAINT [DF_spb_BlogThreadAttments_FileName]  DEFAULT ('') FOR [FileName]
GO
ALTER TABLE [dbo].[spb_BlogThreadAttachments] ADD  CONSTRAINT [DF_spb_BlogThreadAttments_FriendlyFileName]  DEFAULT ('') FOR [FriendlyFileName]
GO
ALTER TABLE [dbo].[spb_BlogThreadAttachments] ADD  CONSTRAINT [DF_spb_BlogThreadAttments_ContentType]  DEFAULT ('') FOR [ContentType]
GO
ALTER TABLE [dbo].[spb_BlogThreadAttachments] ADD  CONSTRAINT [DF_spb_BlogThreadAttments_ContentSize]  DEFAULT (0) FOR [ContentSize]
GO
ALTER TABLE [dbo].[spb_BlogThreadAttachments] ADD  CONSTRAINT [DF_spb_BlogThreadAttments_Height]  DEFAULT (0) FOR [Height]
GO
ALTER TABLE [dbo].[spb_BlogThreadAttachments] ADD  CONSTRAINT [DF_spb_BlogThreadAttments_Width]  DEFAULT (0) FOR [Width]
GO
ALTER TABLE [dbo].[spb_BlogThreadAttachments] ADD  CONSTRAINT [DF_spb_BlogThreadAttments_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_BlogThreadAttachments] ADD  CONSTRAINT [DF_spb_BlogThreadAttments_DownloadCount]  DEFAULT (0) FOR [DownloadCount]
GO
ALTER TABLE [dbo].[spb_BlogThreadAttachments] ADD  CONSTRAINT [DF_spb_BlogThreadAttments_UserType]  DEFAULT (0) FOR [IsCreatedByAdministrator]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_Excerpt]  DEFAULT ('') FOR [Excerpt]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_PostAuthor]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_BlogThreadTypeID]  DEFAULT (0) FOR [BlogThreadTypeID]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_SiteCategoryID]  DEFAULT (0) FOR [SiteCategoryID]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_UserCategoryID]  DEFAULT (0) FOR [UserCategoryID]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_LastRepliedDate]  DEFAULT (getdate()) FOR [LastRepliedDate]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_IsPublic]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_IsEssential]  DEFAULT (0) FOR [IsEssential]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_SpecialOrder]  DEFAULT (0) FOR [SpecialOrder]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_StickyDate]  DEFAULT (getdate()) FOR [StickyDate]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_ReplyCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_RssViewTimes]  DEFAULT (0) FOR [RssViewTimes]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_RatingSum]  DEFAULT (0) FOR [RatingSum]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  CONSTRAINT [DF_spb_BlogThreads_TotalRatings]  DEFAULT (0) FOR [TotalRatings]
GO
ALTER TABLE [dbo].[spb_BlogThreads] ADD  DEFAULT ('000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_BlogThreadSiteTags] ADD  CONSTRAINT [DF_spb_BlogThreadSiteTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_BlogThreadSiteTags] ADD  CONSTRAINT [DF_spb_BlogThreadSiteTags_UserCount]  DEFAULT (1) FOR [UserCount]
GO
ALTER TABLE [dbo].[spb_BlogThreadSiteTags] ADD  CONSTRAINT [DF_spb_BlogThreadSiteTags_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_BlogThreadTypes] ADD  CONSTRAINT [DF_spb_BlogThreadTypes_TypeName]  DEFAULT ('') FOR [TypeName]
GO
ALTER TABLE [dbo].[spb_BlogThreadUserCategories] ADD  CONSTRAINT [DF_spb_BlogThreadUserCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_BlogThreadUserCategories] ADD  CONSTRAINT [DF_spb_BlogThreadUserCategories_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_BlogThreadUserCategories] ADD  CONSTRAINT [DF_spb_BlogThreadUserCategories_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_BlogThreadUserCategories] ADD  CONSTRAINT [DF_spb_BlogThreadUserCategories_MostRecentUpdateDate]  DEFAULT (getdate()) FOR [MostRecentUpdateDate]
GO
ALTER TABLE [dbo].[spb_BlogThreadUserCategories] ADD  CONSTRAINT [DF_spb_BlogThreadUserCategories_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_BlogThreadUserCategories] ADD  CONSTRAINT [DF_spb_BlogThreadUserCategories_AuditingStatus]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_BlogThreadUserTags] ADD  CONSTRAINT [DF_spb_BlogThreadUserTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_BlogThreadUserTags] ADD  CONSTRAINT [DF_spb_BlogThreadUserTags_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ClubActivities] ADD  CONSTRAINT [DF_spb_ClubActivities_ApplicationID]  DEFAULT (0) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_ClubActivities] ADD  CONSTRAINT [DF_spb_ClubActivities_LeadingActorUserID]  DEFAULT (0) FOR [LeadingActorUserID]
GO
ALTER TABLE [dbo].[spb_ClubActivities] ADD  CONSTRAINT [DF_spb_ClubActivities_LeadingActor]  DEFAULT ('') FOR [LeadingActor]
GO
ALTER TABLE [dbo].[spb_ClubActivities] ADD  CONSTRAINT [DF_spb_ClubActivities_RelativeItemID]  DEFAULT (0) FOR [RelativeItemID]
GO
ALTER TABLE [dbo].[spb_ClubActivities] ADD  CONSTRAINT [DF_spb_ClubActivities_RelativeItemName]  DEFAULT ('') FOR [RelativeItemName]
GO
ALTER TABLE [dbo].[spb_ClubActivities] ADD  CONSTRAINT [DF_spb_ClubActivities_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_ClubActivities] ADD  CONSTRAINT [DF_spb_ClubActivities_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_ClubActivities] ADD  CONSTRAINT [DF_spb_ClubActivities_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ClubActivityInbox] ADD  CONSTRAINT [DF_spb_ClubActivityInbox_ApplicationID]  DEFAULT (0) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_ClubAreaStatistics] ADD  CONSTRAINT [DF_spb_ClubAreaStatistics_AreaCode]  DEFAULT ('') FOR [AreaCode]
GO
ALTER TABLE [dbo].[spb_ClubAreaStatistics] ADD  CONSTRAINT [DF_spb_ClubAreaStatistics_ClubCount]  DEFAULT (0) FOR [TotalCount]
GO
ALTER TABLE [dbo].[spb_ClubLinkCategories] ADD  CONSTRAINT [DF_spb_ClubLinkCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_ClubLinkCategories] ADD  CONSTRAINT [DF_spb_ClubLinkCategories_DisplayOrder]  DEFAULT (100) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_ClubLinks] ADD  CONSTRAINT [DF_spb_ClubLinks_ImageUrl]  DEFAULT ('') FOR [ImageUrl]
GO
ALTER TABLE [dbo].[spb_ClubLinks] ADD  CONSTRAINT [DF_spb_ClubLinks_LinkTitle]  DEFAULT ('') FOR [LinkTitle]
GO
ALTER TABLE [dbo].[spb_ClubLinks] ADD  CONSTRAINT [DF_spb_ClubLinks_LinkType]  DEFAULT (1) FOR [LinkType]
GO
ALTER TABLE [dbo].[spb_ClubLinks] ADD  CONSTRAINT [DF_spb_ClubLinks_DisplayOrder]  DEFAULT (100) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_ClubLinks] ADD  CONSTRAINT [DF_spb_ClubLinks_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_ClubID]  DEFAULT (0) FOR [ClubID]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_Rank]  DEFAULT (0) FOR [Rank]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_Points]  DEFAULT (0) FOR [Points]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_ClubMemberRole]  DEFAULT (1) FOR [ClubMemberRole]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_Status]  DEFAULT (1) FOR [Status]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_ApplyRemark]  DEFAULT ('') FOR [ApplyRemark]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_InviteUserID]  DEFAULT (0) FOR [InviteUserID]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_InviteUserDisplayName]  DEFAULT ('') FOR [InviteUserDisplayName]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_EnableManagerNotification]  DEFAULT (0) FOR [EnableManagerNotification]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_EnableNotificationed]  DEFAULT (1) FOR [EnableNotificationed]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_JoinDate]  DEFAULT (getdate()) FOR [JoinDate]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_DisplayName]  DEFAULT ('') FOR [DisplayName]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_UserDisplayInformation]  DEFAULT ('') FOR [UserDisplayInformation]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_VisitTimes]  DEFAULT (0) FOR [VisitTimes]
GO
ALTER TABLE [dbo].[spb_ClubMembers] ADD  CONSTRAINT [DF_spb_ClubMembers_LastVisitTime]  DEFAULT (getdate()) FOR [LastVisitTime]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_ClubName]  DEFAULT ('') FOR [ClubName]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_DomainName]  DEFAULT ('') FOR [DomainName]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_Brief]  DEFAULT ('') FOR [Brief]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_CategoryID]  DEFAULT (0) FOR [CategoryID]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_AreaCode]  DEFAULT ('') FOR [AreaCode]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_IsPublic]  DEFAULT (1) FOR [IsPublic]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_IsMemberNeedAuthorize]  DEFAULT (0) FOR [IsMemberNeedAuthorize]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_News]  DEFAULT ('') FOR [News]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_AuditingStatus]  DEFAULT (0) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_Points]  DEFAULT (0) FOR [Points]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_MemberCount]  DEFAULT (0) FOR [MemberCount]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_RegisterCountByClub]  DEFAULT (0) FOR [RegisterCountByClub]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_WeekHitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_ClubOwnerUserID]  DEFAULT (0) FOR [ClubOwnerUserID]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_HasLogo]  DEFAULT (0) FOR [HasLogo]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_Theme]  DEFAULT ('') FOR [Theme]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_ThemeAppearance]  DEFAULT ('') FOR [ThemeAppearance]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  DEFAULT ('000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_Clubs] ADD  CONSTRAINT [DF_spb_Clubs_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_ThumbnailUrl]  DEFAULT ('') FOR [ThumbnailUrl]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_DetailsUrl]  DEFAULT ('') FOR [DetailsUrl]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_AuthorUserID]  DEFAULT (0) FOR [AuthorUserID]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_Sharer]  DEFAULT ('') FOR [Sharer]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_SharerUserID]  DEFAULT (0) FOR [SharerUserID]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_IsEssential]  DEFAULT (0) FOR [IsEssential]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_SpecialOrder]  DEFAULT (0) FOR [SpecialOrder]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_StickyDate]  DEFAULT (getdate()) FOR [StickyDate]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_ClubSharedContents] ADD  CONSTRAINT [DF_spb_ClubSharedContents_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ClubSharedContentTags] ADD  CONSTRAINT [DF_spb_ClubSharedContentTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_ClubSharedContentTags] ADD  CONSTRAINT [DF_spb_ClubSharedContentTags_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ClubSharedContentTags] ADD  CONSTRAINT [DF_spb_ClubSharedContentTags_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_ClubSharedContentTags] ADD  CONSTRAINT [DF_spb_ClubSharedContentTags_OwnerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_ClubUserDatas] ADD  CONSTRAINT [DF_spb_ClubUserDatas_CreatedClubCount]  DEFAULT (0) FOR [CreatedClubCount]
GO
ALTER TABLE [dbo].[spb_ClubUserDatas] ADD  CONSTRAINT [DF_spb_ClubUserDatas_JoinedClubCount]  DEFAULT (0) FOR [JoinedClubCount]
GO
ALTER TABLE [dbo].[spb_ClubUserDatas] ADD  CONSTRAINT [DF_spb_ClubUserDatas_ExperiencePoints]  DEFAULT (0) FOR [ExperiencePoints]
GO
ALTER TABLE [dbo].[spb_CodeItems] ADD  CONSTRAINT [DF_spb_CodeItems_ParentItemID]  DEFAULT (0) FOR [ParentItemID]
GO
ALTER TABLE [dbo].[spb_CodeItems] ADD  CONSTRAINT [DF_spb_CodeItems_Name]  DEFAULT ('') FOR [Name]
GO
ALTER TABLE [dbo].[spb_CodeItems] ADD  CONSTRAINT [DF_spb_CodeItems_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_CodeItems] ADD  CONSTRAINT [DF_spb_CodeItems_Depth]  DEFAULT (0) FOR [Depth]
GO
ALTER TABLE [dbo].[spb_CodeSets] ADD  CONSTRAINT [DF_spb_CodeSets_IsMultileve]  DEFAULT (0) FOR [IsMultileve]
GO
ALTER TABLE [dbo].[spb_CodeSets] ADD  CONSTRAINT [DF_spb_CodeSets_AllowAddDelete]  DEFAULT (0) FOR [AllowAddDelete]
GO
ALTER TABLE [dbo].[spb_CodeSets] ADD  CONSTRAINT [DF_spb_CodeSets_AllowEdit]  DEFAULT (0) FOR [AllowEdit]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_Licence]  DEFAULT ('') FOR [Licence]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_Trade]  DEFAULT ((-1)) FOR [Trade]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_Corpprop]  DEFAULT ((-1)) FOR [CompanyProperty]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_Fund]  DEFAULT ((-1)) FOR [Fund]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_Empnum]  DEFAULT ((-1)) FOR [EmployeeNum]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_Intro]  DEFAULT ('') FOR [Intro]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_linkman]  DEFAULT ('') FOR [Linkman]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_linkmanduty]  DEFAULT ('') FOR [LinkmanDuty]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_linkTel]  DEFAULT ('') FOR [LinkTel]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_linkTelPrivacy]  DEFAULT (1) FOR [LinkTelPrivacy]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_fax]  DEFAULT ('') FOR [Fax]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_FaxPrivacy]  DEFAULT (1) FOR [FaxPrivacy]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_Address]  DEFAULT ('') FOR [Address]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_ValidateStatus]  DEFAULT (1) FOR [ValidateStatus]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_Validatedate]  DEFAULT (getdate()) FOR [ValidateDate]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] ADD  CONSTRAINT [DF_spb_CompanyUserProfile_AreaCode]  DEFAULT ('') FOR [AreaCode]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_DisplayName]  DEFAULT ('') FOR [DisplayName]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_Gender]  DEFAULT (0) FOR [Gender]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_PersonEmail]  DEFAULT ('') FOR [PersonEmail]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_Mobile]  DEFAULT ('') FOR [Mobile]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_HomeTel]  DEFAULT ('') FOR [HomeTel]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_MsnIM]  DEFAULT ('') FOR [MsnIM]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_YahooIM]  DEFAULT ('') FOR [YahooIM]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_QQIM]  DEFAULT ('') FOR [QQIM]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_SkypeIM]  DEFAULT ('') FOR [SkypeIM]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_Title]  DEFAULT ('') FOR [Title]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_CompanyName]  DEFAULT ('') FOR [CompanyName]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_WorkTel]  DEFAULT ('') FOR [WorkTel]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_Contacts] ADD  CONSTRAINT [DF_spb_Contacts_Source]  DEFAULT (0) FOR [Source]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeApplies] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeApplies_GiftID]  DEFAULT (0) FOR [GiftID]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeApplies] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeApplies_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeApplies] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeApplies_UserDisplayName]  DEFAULT ('') FOR [UserDisplayName]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeApplies] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeApplies_ApplyStatus]  DEFAULT (0) FOR [ApplyStatus]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeApplies] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeApplies_Price]  DEFAULT (0) FOR [Price]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeApplies] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeApplies_TotalCount]  DEFAULT (0) FOR [TotalCount]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeApplies] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeApplies_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeApplies] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeApplies_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeRecords] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeRecords_GiftID]  DEFAULT (0) FOR [GiftID]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeRecords] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeRecords_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeRecords] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeRecords_UserDisplayName]  DEFAULT ('') FOR [UserDisplayName]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeRecords] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeRecords_Price]  DEFAULT (0) FOR [Price]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeRecords] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeRecords_TotalCount]  DEFAULT (0) FOR [TotalCount]
GO
ALTER TABLE [dbo].[spb_ConvertibleGift_ExchangeRecords] ADD  CONSTRAINT [DF_spb_ConvertibleGift_ExchangeRecords_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_Price]  DEFAULT (0) FOR [Price]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_TotalCount]  DEFAULT (0) FOR [TotalCount]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_ExchangedCount]  DEFAULT (0) FOR [ExchangedCount]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_ImageUrl]  DEFAULT ('') FOR [ImageFileName]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_ConvertibleGifts] ADD  CONSTRAINT [DF_spb_ConvertibleGifts_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_Navigations_ApplicationID]  DEFAULT (0) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_Navigations_NavigationText]  DEFAULT ('') FOR [NavigationText]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_Navigations_NavigationUrl]  DEFAULT ('') FOR [NavigationUrl]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_Navigations_NavigationTarget]  DEFAULT ('') FOR [NavigationTarget]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_Navigations_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_Navigations_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_DefaultNavigations_OnlyOwnerVisible]  DEFAULT (0) FOR [OnlyOwnerVisible]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_DefaultNavigations_PresentAreaID]  DEFAULT (0) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_DefaultNavigations_SecondaryID]  DEFAULT (0) FOR [SecondaryID]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_DefaultNavigations_UrlRouteName]  DEFAULT ('') FOR [UrlRouteName]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations] ADD  CONSTRAINT [DF_spb_DefaultNavigations_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_DefaultNavigations_Res] ADD  CONSTRAINT [DF_spb_Navigations_Res_Name]  DEFAULT ('') FOR [Name]
GO
ALTER TABLE [dbo].[spb_EmailQueue] ADD  CONSTRAINT [DF_spb_EmailQueue_EmailID]  DEFAULT (newid()) FOR [EmailID]
GO
ALTER TABLE [dbo].[spb_EmailQueue] ADD  CONSTRAINT [DF_spb_EmailQueue_IsBodyHtml]  DEFAULT (1) FOR [IsBodyHtml]
GO
ALTER TABLE [dbo].[spb_EmailQueue] ADD  CONSTRAINT [DF_spb_EmailQueue_EmailSubject]  DEFAULT ('') FOR [EmailSubject]
GO
ALTER TABLE [dbo].[spb_EmailQueue] ADD  CONSTRAINT [DF_spb_EmailQueue_NextTryTime]  DEFAULT ('1999-1-1') FOR [NextTryTime]
GO
ALTER TABLE [dbo].[spb_EmailQueue] ADD  CONSTRAINT [DF_spb_EmailQueue_NumberOfTries]  DEFAULT (0) FOR [NumberOfTries]
GO
ALTER TABLE [dbo].[spb_EventAreaStatistics] ADD  CONSTRAINT [DF__spb_EventAreaStatistics__AreaCode]  DEFAULT ('') FOR [AreaCode]
GO
ALTER TABLE [dbo].[spb_EventAreaStatistics] ADD  CONSTRAINT [DF_spb_EventAreaStatistics_PublishedCount]  DEFAULT (0) FOR [PublishedCount]
GO
ALTER TABLE [dbo].[spb_EventAreaStatistics] ADD  CONSTRAINT [DF_spb_EventAreaStatistics_FinishedCount]  DEFAULT (0) FOR [FinishedCount]
GO
ALTER TABLE [dbo].[spb_EventAreaStatistics] ADD  CONSTRAINT [DF_spb_EventAreaStatistics_TotalCount]  DEFAULT (0) FOR [TotalCount]
GO
ALTER TABLE [dbo].[spb_EventMembers] ADD  CONSTRAINT [DF_spb_EventMembers_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_EventMembers] ADD  CONSTRAINT [DF_spb_EventMembers_IsOwner]  DEFAULT (0) FOR [IsManager]
GO
ALTER TABLE [dbo].[spb_EventMembers] ADD  CONSTRAINT [DF_spb_EventMembers_IsApproved]  DEFAULT (0) FOR [IsApproved]
GO
ALTER TABLE [dbo].[spb_EventMembers] ADD  CONSTRAINT [DF_spb_EventMembers_BringCount]  DEFAULT (0) FOR [BringCount]
GO
ALTER TABLE [dbo].[spb_EventMembers] ADD  CONSTRAINT [DF_spb_EventMembers_SignUpDate]  DEFAULT (getdate()) FOR [SignUpDate]
GO
ALTER TABLE [dbo].[spb_EventPhotoComments] ADD  CONSTRAINT [DF_spb_ EventPhotoComments_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_EventPhotoComments] ADD  CONSTRAINT [DF_spb_ EventPhotoComments_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_EventPhotoComments] ADD  CONSTRAINT [DF_spb_ EventPhotoComments_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_FriendlyFileName]  DEFAULT ('') FOR [FriendlyFileName]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_Uploader]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_FileName]  DEFAULT ('') FOR [FileName]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_ContentType]  DEFAULT ('') FOR [ContentType]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_ContentSize]  DEFAULT (0) FOR [ContentSize]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_Height]  DEFAULT (0) FOR [Height]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_Width]  DEFAULT (0) FOR [Width]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_EventPhotos] ADD  CONSTRAINT [DF_spb_EventPhotos_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_EventPosts] ADD  CONSTRAINT [DF_spb_EventPosts_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_EventPosts] ADD  CONSTRAINT [DF_spb_EventPosts_ParentUserID]  DEFAULT (0) FOR [ParentUserID]
GO
ALTER TABLE [dbo].[spb_EventPosts] ADD  CONSTRAINT [DF_spb_EventPosts_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_EventPosts] ADD  CONSTRAINT [DF_spb_EventPosts_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_EventPosts] ADD  CONSTRAINT [DF_spb_EventPosts_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_EventPosts] ADD  CONSTRAINT [DF_spb_EventPosts_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_EventPosts] ADD  CONSTRAINT [DF_spb_EventPosts_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_EventRatings] ADD  CONSTRAINT [DF_EventRatings_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_EventRatings] ADD  CONSTRAINT [DF_EventRatings_Rating]  DEFAULT (0) FOR [Rate]
GO
ALTER TABLE [dbo].[spb_EventThreadFavorites] ADD  CONSTRAINT [DF_spb_EventThreadFavorites_DisplayName]  DEFAULT ('') FOR [DisplayName]
GO
ALTER TABLE [dbo].[spb_EventThreadFavorites] ADD  CONSTRAINT [DF_spb_EventThreadFavorites_PrivacyStatus]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_EventThreadFavorites] ADD  CONSTRAINT [DF_spb_EventThreadFavorites_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_EventName]  DEFAULT ('') FOR [EventName]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_ClubID]  DEFAULT (0) FOR [ClubID]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF__spb_Event__AreaCode]  DEFAULT ('') FOR [AreaCode]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_Location]  DEFAULT ('') FOR [Location]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_FeaturedPhotoID]  DEFAULT (0) FOR [FeaturedPhotoID]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_EventStatus]  DEFAULT (1) FOR [EventStatus]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_IsPublic]  DEFAULT (1) FOR [IsPublic]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_IsEssential]  DEFAULT (0) FOR [IsEssential]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_PayType]  DEFAULT (0) FOR [PayType]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_IsOnlyAllowClubMemberSignUp]  DEFAULT (1) FOR [IsOnlyAllowClubMemberSignUp]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_Points]  DEFAULT (0) FOR [Points]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_PointsEncashed]  DEFAULT (0) FOR [IsPointsEncashed]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_RatingSum]  DEFAULT (0) FOR [RatingSum]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_TotalRatings]  DEFAULT (0) FOR [TotalRatings]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_FaviteCount]  DEFAULT (0) FOR [FaviteCount]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_MemberCount]  DEFAULT (0) FOR [MemberCount]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_PhotoCount]  DEFAULT (0) FOR [PhotoCount]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF_spb_EventThreads_PostCount]  DEFAULT (0) FOR [PostCount]
GO
ALTER TABLE [dbo].[spb_EventThreads] ADD  CONSTRAINT [DF__spb_Event__UserH__51932E64]  DEFAULT ('000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_EventUserDatas] ADD  CONSTRAINT [DF_spb_EventUserDatas_CreatedThreadCount]  DEFAULT (0) FOR [CreatedThreadCount]
GO
ALTER TABLE [dbo].[spb_EventUserDatas] ADD  CONSTRAINT [DF_spb_EventUserDatas_JoinedThreadCount]  DEFAULT (0) FOR [JoinedThreadCount]
GO
ALTER TABLE [dbo].[spb_EventUserDatas] ADD  CONSTRAINT [DF_spb_EventUserDatas_FavoriteThreadCount]  DEFAULT (0) FOR [FavoriteThreadCount]
GO
ALTER TABLE [dbo].[spb_EventUserDatas] ADD  CONSTRAINT [DF_spb_EventUserDatas_PhotoCount]  DEFAULT (0) FOR [PhotoCount]
GO
ALTER TABLE [dbo].[spb_EventUserDatas] ADD  CONSTRAINT [DF_spb_EventUserDatas_PostCount]  DEFAULT (0) FOR [PostCount]
GO
ALTER TABLE [dbo].[spb_EventUserDatas] ADD  CONSTRAINT [DF_spb_EventUserDatas_PhotoCommentCount]  DEFAULT (0) FOR [PhotoCommentCount]
GO
ALTER TABLE [dbo].[spb_EventUserDatas] ADD  CONSTRAINT [DF_spb_EventUserDatas_ExperiencePoints]  DEFAULT (0) FOR [ExperiencePoints]
GO
ALTER TABLE [dbo].[spb_FileAttachments] ADD  CONSTRAINT [DF_spb_FileAttachments_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_FileComments] ADD  CONSTRAINT [DF_spb_FilePosts_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_FileComments] ADD  CONSTRAINT [DF_spb_FilePosts_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_FileComments] ADD  CONSTRAINT [DF_spb_FilePosts_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_FileComments] ADD  CONSTRAINT [DF_spb_FilePosts_IsApproved]  DEFAULT (1) FOR [IsApproved]
GO
ALTER TABLE [dbo].[spb_FileComments] ADD  CONSTRAINT [DF_spb_FilePosts_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_FileComments] ADD  CONSTRAINT [DF_spb_FilePosts_UserHostAddress]  DEFAULT (N'000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_FileComments] ADD  CONSTRAINT [DF_spb_FilePosts_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_FileDownLoadRecords] ADD  CONSTRAINT [DF_spb_FileDownLoadRecords_Author]  DEFAULT ('') FOR [UserDisplayName]
GO
ALTER TABLE [dbo].[spb_FileDownLoadRecords] ADD  CONSTRAINT [DF_spb_FileDownLoadRecords_Price]  DEFAULT (0) FOR [Price]
GO
ALTER TABLE [dbo].[spb_FileDownLoadRecords] ADD  CONSTRAINT [DF_spb_FileDownLoadRecords_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_FileDownLoadRecords] ADD  CONSTRAINT [DF_spb_FileDownLoadRecords_UserHostAddress]  DEFAULT ('') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_FileRatings] ADD  CONSTRAINT [DF_spb_FileRatings_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_FileRatings] ADD  CONSTRAINT [DF_spb_FileRatings_Rate]  DEFAULT (0) FOR [Rate]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_SectionName]  DEFAULT ('') FOR [SectionName]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_IsActive]  DEFAULT (1) FOR [IsActive]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_EnaleSearch]  DEFAULT (1) FOR [EnableSearch]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_FileCount]  DEFAULT (0) FOR [FileCount]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_DownloadFileCount]  DEFAULT (0) FOR [DownloadFileCount]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_Points]  DEFAULT (0) FOR [Points]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_FileSections] ADD  CONSTRAINT [DF_spb_FileSections_WeekHitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_FilesInUserTags] ADD  CONSTRAINT [DF_spb_FilesInUserTags_TagName]  DEFAULT ('') FOR [TagName]
GO
ALTER TABLE [dbo].[spb_FileSiteTags] ADD  CONSTRAINT [DF_spb_FileSiteTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_FileSiteTags] ADD  CONSTRAINT [DF_spb_FileSiteTags_UserCount]  DEFAULT (1) FOR [UserCount]
GO
ALTER TABLE [dbo].[spb_FileSiteTags] ADD  CONSTRAINT [DF_spb_FileSiteTags_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_FilesOfPendingDeletion] ADD  CONSTRAINT [DF_spb_FilesOfPendingDeletion_StorageProviderName]  DEFAULT ('') FOR [StorageProviderName]
GO
ALTER TABLE [dbo].[spb_FilesOfPendingDeletion] ADD  CONSTRAINT [DF_spb_FilesOfPendingDeletion_FullDirectory]  DEFAULT ('') FOR [FullDirectory]
GO
ALTER TABLE [dbo].[spb_FilesOfPendingDeletion] ADD  CONSTRAINT [DF_spb_FilesOfPendingDeletion_FileName]  DEFAULT ('') FOR [FileName]
GO
ALTER TABLE [dbo].[spb_FilesOfPendingDeletion] ADD  CONSTRAINT [DF_spb_FilesOfPendingDeletion_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_LastRepliedDate]  DEFAULT (getdate()) FOR [LastRepliedDate]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_IsPublic]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_Password]  DEFAULT ('') FOR [Password]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_IsEssential]  DEFAULT (0) FOR [IsEssential]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_Price]  DEFAULT (0) FOR [Price]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_Stage HitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_SpecialOrder]  DEFAULT (0) FOR [SpecialOrder]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_StickyDate]  DEFAULT (getdate()) FOR [StickyDate]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_RssViewTimes]  DEFAULT (0) FOR [RssViewTimes]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_DownloadCount]  DEFAULT (0) FOR [DownloadCount]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_StageDownloadCount]  DEFAULT (0) FOR [StageDownloadCount]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_RatingSum]  DEFAULT (0) FOR [RatingSum]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_TotalRatings]  DEFAULT (0) FOR [TotalRatings]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_SiteCategoryID]  DEFAULT (0) FOR [SiteCategoryID]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_UserCategoryID]  DEFAULT (0) FOR [UserCategoryID]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_UserHostAddress]  DEFAULT (N'000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_FileName]  DEFAULT ('') FOR [FileName]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_ContentType]  DEFAULT ('') FOR [ContentType]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_ContentSize]  DEFAULT (0) FOR [ContentSize]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_Height]  DEFAULT (0) FOR [Height]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_Width]  DEFAULT (0) FOR [Width]
GO
ALTER TABLE [dbo].[spb_FileThreads] ADD  CONSTRAINT [DF_spb_FileThreads_IsRemote]  DEFAULT (0) FOR [IsRemote]
GO
ALTER TABLE [dbo].[spb_FileUserCategories] ADD  CONSTRAINT [DF_spb_FileUserCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_FileUserCategories] ADD  CONSTRAINT [DF_spb_FileUserCategories_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_FileUserCategories] ADD  CONSTRAINT [DF_spb_FileUserCategories_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_FileUserCategories] ADD  CONSTRAINT [DF_spb_FileUserCategories_MostRecentUpdateDate]  DEFAULT (getdate()) FOR [MostRecentUpdateDate]
GO
ALTER TABLE [dbo].[spb_FileUserCategories] ADD  CONSTRAINT [DF_spb_FileUserCategories_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_FileUserCategories] ADD  CONSTRAINT [DF_spb_FileUserCategories_AuditingStatus]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_FileUserTags] ADD  CONSTRAINT [DF_spb_FileUserTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_FileUserTags] ADD  CONSTRAINT [DF_spb_FileUserTags_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_Footprints] ADD  CONSTRAINT [DF_spb_Footprints_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ForumModerators] ADD  CONSTRAINT [DF_spb_ForumModerators_Inherited]  DEFAULT (0) FOR [Inherited]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachmentExchanges] ADD  CONSTRAINT [DF_spb_ForumPostAttachmentExchanges_UserDisplayName]  DEFAULT ('') FOR [UserDisplayName]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachmentExchanges] ADD  CONSTRAINT [DF_spb_ForumPostAttachmentExchanges_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttachments_SectionID]  DEFAULT (0) FOR [SectionID]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttments_FileName]  DEFAULT ('') FOR [FileName]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttments_FriendlyFileName]  DEFAULT ('') FOR [FriendlyFileName]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttments_ContentType]  DEFAULT ('') FOR [ContentType]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttments_ContentSize]  DEFAULT (0) FOR [ContentSize]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttments_Height]  DEFAULT (0) FOR [Height]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttments_Width]  DEFAULT (0) FOR [Width]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttachments_IsRemote]  DEFAULT (0) FOR [IsRemote]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttachments_Price]  DEFAULT (0) FOR [Price]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttachments_IsHidden]  DEFAULT (0) FOR [IsHidden]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttments_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ForumPostAttachments] ADD  CONSTRAINT [DF_spb_ForumPostAttments_DownloadCount]  DEFAULT (0) FOR [DownloadCount]
GO
ALTER TABLE [dbo].[spb_ForumPosts] ADD  CONSTRAINT [DF_spb_ForumPosts_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_ForumPosts] ADD  CONSTRAINT [DF_spb_ForumPosts_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_ForumPosts] ADD  CONSTRAINT [DF_spb_ForumPosts_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ForumPosts] ADD  CONSTRAINT [DF_spb_ForumPosts_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_ForumPosts] ADD  CONSTRAINT [DF_spb_ForumPosts_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_ForumPosts] ADD  CONSTRAINT [DF_spb_ForumPosts_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_ForumPosts] ADD  CONSTRAINT [DF_spb_ForumPosts_UserHostAddress]  DEFAULT ('') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_ForumPosts] ADD  CONSTRAINT [DF_spb_ForumPosts_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_ForumPosts] ADD  CONSTRAINT [DF_spb_ForumPosts_HighlightStyle]  DEFAULT ('') FOR [HighlightStyle]
GO
ALTER TABLE [dbo].[spb_ForumRatings] ADD  CONSTRAINT [DF_spb_ForumRatings_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ForumSectionGroups] ADD  CONSTRAINT [DF_spb_ForumSectionGroups_GroupName]  DEFAULT ('') FOR [GroupName]
GO
ALTER TABLE [dbo].[spb_ForumSectionGroups] ADD  CONSTRAINT [DF_spb_ForumSectionGroups_PresentAreaID]  DEFAULT (0) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_ForumSectionGroups] ADD  CONSTRAINT [DF_spb_ForumSectionGroups_OwnerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_ForumSectionGroups] ADD  CONSTRAINT [DF_spb_ForumSectionGroups_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_ForumSectionGroups] ADD  CONSTRAINT [DF_spb_ForumSectionGroups_ThreadCount]  DEFAULT (0) FOR [ThreadCount]
GO
ALTER TABLE [dbo].[spb_ForumSectionGroups] ADD  CONSTRAINT [DF_spb_ForumSectionGroups_PostCount]  DEFAULT (0) FOR [PostCount]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_ParentIDList]  DEFAULT ('') FOR [ParentIDList]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_ChildCount]  DEFAULT (0) FOR [ChildCount]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_Depth]  DEFAULT (0) FOR [Depth]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_SectionName]  DEFAULT ('') FOR [SectionName]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_ForumType]  DEFAULT (0) FOR [ForumType]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_IsActive]  DEFAULT (1) FOR [IsActive]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_EnaleSearch]  DEFAULT (1) FOR [EnaleSearch]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_LogoUrl]  DEFAULT ('') FOR [LogoUrl]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_ThreadCategoryStatus]  DEFAULT (0) FOR [ThreadCategoryStatus]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_ThreadCount]  DEFAULT (0) FOR [ThreadCount]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_PostCount]  DEFAULT (0) FOR [PostCount]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_TodayPostCount]  DEFAULT (0) FOR [TodayPostCount]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_EnableAnonymousPosting]  DEFAULT (0) FOR [EnableAnonymousPosting]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_InheriteModerator]  DEFAULT (1) FOR [InheriteModerator]
GO
ALTER TABLE [dbo].[spb_ForumSections] ADD  CONSTRAINT [DF_spb_ForumSections_EnableRSS]  DEFAULT (1) FOR [EnableRSS]
GO
ALTER TABLE [dbo].[spb_ForumTags] ADD  CONSTRAINT [DF_spb_ForumTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_ForumTags] ADD  CONSTRAINT [DF_spb_ForumTags_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ForumTags] ADD  CONSTRAINT [DF_spb_ForumTags_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_ForumTags] ADD  CONSTRAINT [DF_spb_ForumTags_OwnerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_ForumThreadCategories] ADD  CONSTRAINT [DF_spb_ForumThreadCategories_CategoryDescription]  DEFAULT ('') FOR [CategoryDescription]
GO
ALTER TABLE [dbo].[spb_ForumThreadCategories] ADD  CONSTRAINT [DF_spb_ForumThreadCategories_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_ForumThreadCategories] ADD  CONSTRAINT [DF_spb_ForumThreadCategories_ThreadCount]  DEFAULT (0) FOR [ThreadCount]
GO
ALTER TABLE [dbo].[spb_ForumThreadExchanges] ADD  CONSTRAINT [DF_spb_ForumThreadExchanges_UserDisplayName]  DEFAULT ('') FOR [UserDisplayName]
GO
ALTER TABLE [dbo].[spb_ForumThreadExchanges] ADD  CONSTRAINT [DF_spb_ForumThreadExchanges_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_CategoryID]  DEFAULT (0) FOR [CategoryID]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_IsEssential]  DEFAULT (0) FOR [IsEssential]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_IsSticky]  DEFAULT (0) FOR [IsSticky]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_SpecialOrder]  DEFAULT (0) FOR [SpecialOrder]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_StickyDate]  DEFAULT (getdate()) FOR [StickyDate]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_IsHidden]  DEFAULT (0) FOR [IsHidden]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_HighlightDate]  DEFAULT (getdate()) FOR [HighlightDate]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_ThreadStatus]  DEFAULT (0) FOR [ThreadStatus]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_EmoticonID]  DEFAULT (0) FOR [EmoticonID]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_Price]  DEFAULT (0) FOR [Price]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_StageHitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_ReplyCount]  DEFAULT (0) FOR [ReplyCount]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_RssViewTimes]  DEFAULT (0) FOR [RssViewTimes]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_RatingSum]  DEFAULT (0) FOR [RatingSum]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_TotalRatings]  DEFAULT (0) FOR [TotalRatings]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_LastRepliedDate]  DEFAULT (getdate()) FOR [LastRepliedDate]
GO
ALTER TABLE [dbo].[spb_ForumThreads] ADD  CONSTRAINT [DF_spb_ForumThreads_StampID]  DEFAULT (0) FOR [StampID]
GO
ALTER TABLE [dbo].[spb_ForumUserDatas] ADD  CONSTRAINT [DF_spb_ForumUserDatas_Signature]  DEFAULT ('') FOR [Signature]
GO
ALTER TABLE [dbo].[spb_ForumUserDatas] ADD  CONSTRAINT [DF_spb_ForumUserDatas_ThreadCount]  DEFAULT (0) FOR [ThreadCount]
GO
ALTER TABLE [dbo].[spb_ForumUserDatas] ADD  CONSTRAINT [DF_spb_ForumUserDatas_PostCount]  DEFAULT (0) FOR [PostCount]
GO
ALTER TABLE [dbo].[spb_ForumUserDatas] ADD  CONSTRAINT [DF_spb_ForumUserDatas_ExperiencePoints]  DEFAULT (0) FOR [ExperiencePoints]
GO
ALTER TABLE [dbo].[spb_FriendActivities] ADD  CONSTRAINT [DF_spb_FriendActivities_RelativeItemID]  DEFAULT (0) FOR [RelativeItemID]
GO
ALTER TABLE [dbo].[spb_FriendActivities] ADD  CONSTRAINT [DF_spb_FriendActivities_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_FriendActivities] ADD  CONSTRAINT [DF_spb_FriendActivities_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_FriendActivityInbox] ADD  CONSTRAINT [DF_spb_FriendActivityInbox_ApplicationID]  DEFAULT (0) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_Friends] ADD  CONSTRAINT [DF_spb_Friends_Friendliness]  DEFAULT (2) FOR [Friendliness]
GO
ALTER TABLE [dbo].[spb_Friends] ADD  CONSTRAINT [DF_spb_Friends_IsHidden]  DEFAULT (0) FOR [IsHidden]
GO
ALTER TABLE [dbo].[spb_Friends] ADD  CONSTRAINT [DF_spb_Friends_CreateDate]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_FriendUserCategories] ADD  CONSTRAINT [DF_spb_FriendUserCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_FriendUserCategories] ADD  CONSTRAINT [DF_spb_FriendUserCategoriess_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_FriendUserCategories] ADD  CONSTRAINT [DF_spb_FriendUserCategories_TotalItems]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_FriendUserCategories] ADD  CONSTRAINT [DF_spb_FriendUserCategories_MostRecentUpdateDate]  DEFAULT (getdate()) FOR [MostRecentUpdateDate]
GO
ALTER TABLE [dbo].[spb_FriendUserCategories] ADD  CONSTRAINT [DF_spb_FriendUserCategories_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_FriendUserCategories] ADD  CONSTRAINT [DF_spb_FriendUserCategories_AuditingStatus]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_GlobalActivityItemSettings] ADD  CONSTRAINT [DF_spb_GlobalActivityItemSettings_IsAllowSending]  DEFAULT (1) FOR [IsAllowSending]
GO
ALTER TABLE [dbo].[spb_GlobalActivityItemSettings] ADD  CONSTRAINT [DF_spb_GlobalActivityItemSettings_IsAllowReceiving]  DEFAULT (1) FOR [IsAllowReceiving]
GO
ALTER TABLE [dbo].[spb_Identities] ADD  CONSTRAINT [DF_spb_Identities_Name]  DEFAULT ('') FOR [Name]
GO
ALTER TABLE [dbo].[spb_Identities] ADD  CONSTRAINT [DF_spb_Identities_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_ImpeachReports] ADD  CONSTRAINT [DF_spb_ImpeachReports_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ImpeachReports] ADD  CONSTRAINT [DF_spb_ImpeachReports_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ImpeachReports] ADD  CONSTRAINT [DF_spb_ImpeachReports_IsComplete]  DEFAULT (0) FOR [IsComplete]
GO
ALTER TABLE [dbo].[spb_IntegratedPointRules] ADD  CONSTRAINT [DF_spb_IntegratedPointRules_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_InvitationInbox] ADD  CONSTRAINT [DF_spb_InvitationInbox_ApplicationID]  DEFAULT (101) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_InvitationOutbox] ADD  CONSTRAINT [DF_spb_InvitationOutbox_ApplicationID]  DEFAULT (101) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_Sender]  DEFAULT ('') FOR [Sender]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_Receiver]  DEFAULT ('') FOR [Receiver]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_RelativeItemID]  DEFAULT (0) FOR [RelativeItemID]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_RelativeItemName]  DEFAULT ('') FOR [RelativeItemName]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_Status]  DEFAULT (0) FOR [Status]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_TransportMode]  DEFAULT (0) FOR [TransportMode]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_Invitations] ADD  CONSTRAINT [DF_spb_Invitations_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_ItemsForIndex] ADD  CONSTRAINT [DF_spb_ItemsForIndex_ClubID]  DEFAULT (0) FOR [ClubID]
GO
ALTER TABLE [dbo].[spb_ItemsForIndex] ADD  CONSTRAINT [DF_spb_ItemsForIndex_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ItemsInForumTags] ADD  CONSTRAINT [DF_spb_ItemsInForumTags_TagName]  DEFAULT ('') FOR [TagName]
GO
ALTER TABLE [dbo].[spb_ItemsInNewsTags] ADD  CONSTRAINT [DF_spb_ItemsInNewsTags_TagName]  DEFAULT ('') FOR [TagName]
GO
ALTER TABLE [dbo].[spb_JobSorts_Res] ADD  CONSTRAINT [DF_spb_JobSorts_Res_Name]  DEFAULT ('') FOR [Name]
GO
ALTER TABLE [dbo].[spb_Languages] ADD  CONSTRAINT [DF_spb_Languages_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_LayoutPages] ADD  CONSTRAINT [DF_spb_LayoutPages_OwnerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_LayoutPages] ADD  CONSTRAINT [DF_spb_LayoutPages_PageName]  DEFAULT ('') FOR [PageName]
GO
ALTER TABLE [dbo].[spb_LayoutPages] ADD  CONSTRAINT [DF_spb_LayoutPages_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_ThreadID]  DEFAULT (0) FOR [ThreadID]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_FileName]  DEFAULT ('') FOR [FileName]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_FriendlyFileName]  DEFAULT ('') FOR [FriendlyFileName]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_ContentType]  DEFAULT ('') FOR [ContentType]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_ContentSize]  DEFAULT (0) FOR [ContentSize]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_Height]  DEFAULT (0) FOR [Height]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_Width]  DEFAULT (0) FOR [Width]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_IsRemote]  DEFAULT (0) FOR [IsRemote]
GO
ALTER TABLE [dbo].[spb_MicroBlogAttachments] ADD  CONSTRAINT [DF_spb_MiniBlogAttachments_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_MicroBlogComments] ADD  CONSTRAINT [DF_spb_MicroBlogComments_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_MicroBlogComments] ADD  CONSTRAINT [DF_spb_MicroBlogComments_ThreadID]  DEFAULT (0) FOR [ThreadID]
GO
ALTER TABLE [dbo].[spb_MicroBlogComments] ADD  CONSTRAINT [DF_spb_MicroBlogComments_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_MicroBlogComments] ADD  CONSTRAINT [DF_spb_MicroBlogComments_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_MicroBlogComments] ADD  CONSTRAINT [DF_spb_MicroBlogComments_PostMode]  DEFAULT (0) FOR [PostMode]
GO
ALTER TABLE [dbo].[spb_MicroBlogComments] ADD  CONSTRAINT [DF_spb_MicroBlogComments_PostSource]  DEFAULT ('') FOR [PostSource]
GO
ALTER TABLE [dbo].[spb_MicroBlogComments] ADD  CONSTRAINT [DF_spb_MicroBlogComments_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_MicroBlogFeaturedTopics] ADD  CONSTRAINT [DF_spb_MicroBlogFeaturedTopics_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_MicroBlogFeaturedTopics] ADD  CONSTRAINT [DF_spb_MicroBlogFeaturedTopics_FileName]  DEFAULT ('') FOR [FileName]
GO
ALTER TABLE [dbo].[spb_MicroBlogFeaturedTopics] ADD  CONSTRAINT [DF_spb_MicroBlogFeaturedTopics_UserIDs]  DEFAULT ('') FOR [UserNames]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollows] ADD  CONSTRAINT [DF_spb_MicroBlogFollows_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollows] ADD  CONSTRAINT [DF_spb_MicroBlogFollows_DisplayName]  DEFAULT ('') FOR [DisplayName]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollows] ADD  CONSTRAINT [DF_spb_MicroBlogFollows_ItemID]  DEFAULT (0) FOR [ItemID]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollows] ADD  CONSTRAINT [DF_spb_MicroBlogFollows_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollowUserCategories] ADD  CONSTRAINT [DF_spb_MicroBlogFollowsUserCategories_CategoryName]  DEFAULT ('') FOR [CategoryName]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollowUserCategories] ADD  CONSTRAINT [DF_spb_MicroBlogFollowsUserCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollowUserCategories] ADD  CONSTRAINT [DF_spb_MicroBlogFollowsUserCategories_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollowUserCategories] ADD  CONSTRAINT [DF_spb_MicroBlogFollowsUserCategories_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollowUserCategories] ADD  CONSTRAINT [DF_spb_MicroBlogFollowsUserCategories_MostRecentUpdateDate]  DEFAULT (getdate()) FOR [MostRecentUpdateDate]
GO
ALTER TABLE [dbo].[spb_MicroBlogFollowUserCategories] ADD  CONSTRAINT [DF_spb_MicroBlogFollowsUserCategories_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreenFavorites] ADD  CONSTRAINT [DF_spb_MicroBlogScreenFavorites_ScreenID]  DEFAULT (0) FOR [ScreenID]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreenFavorites] ADD  CONSTRAINT [DF_spb_MicroBlogScreenFavorites_SerialNumber]  DEFAULT (1) FOR [SerialNumber]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreenFavorites] ADD  CONSTRAINT [DF_spb_MicroBlogScreenFavorites_ThreadID]  DEFAULT (0) FOR [ThreadID]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_ScreenName]  DEFAULT ('') FOR [ScreenName]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_Keyword]  DEFAULT ('') FOR [Keyword]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_IsFilter]  DEFAULT (1) FOR [IsFilter]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_IsDeadline]  DEFAULT (1) FOR [IsDeadline]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_IsPause]  DEFAULT (0) FOR [IsPause]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_StartDate]  DEFAULT (getdate()) FOR [StartDate]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_EndDate]  DEFAULT (getdate()) FOR [EndDate]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_MicroBlogScreens] ADD  CONSTRAINT [DF_spb_MicroBlogScreens_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_MicroBlogsOfScreens] ADD  CONSTRAINT [DF_spb_MicroBlogsOfScreens_ThreadID]  DEFAULT (0) FOR [ThreadID]
GO
ALTER TABLE [dbo].[spb_MicroBlogsOfScreens] ADD  CONSTRAINT [DF_spb_MicroBlogsOfScreens_status]  DEFAULT (0) FOR [Status]
GO
ALTER TABLE [dbo].[spb_MicroBlogsOfScreens] ADD  CONSTRAINT [DF_spb_MicroBlogsOfScreens_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_OriginalThreadID]  DEFAULT (0) FOR [OriginalThreadID]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_FollowedThreadID]  DEFAULT (0) FOR [ForwardedThreadID]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_ReplyCount]  DEFAULT (0) FOR [ReplyCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_ForwardedCount]  DEFAULT (0) FOR [ForwardedCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_HasPhoto]  DEFAULT (0) FOR [HasPhoto]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_HasVideo]  DEFAULT (0) FOR [HasVideo]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_HasMusic]  DEFAULT (0) FOR [HasMusic]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MiniBlogThreads_MiniBlogTypes]  DEFAULT (0) FOR [MicroBlogTypes]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_PostMode]  DEFAULT (0) FOR [PostMode]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_PostSource]  DEFAULT ('') FOR [PostSource]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreads] ADD  CONSTRAINT [DF_spb_MicroBlogThreads_PostDate]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreadsReferUsers] ADD  CONSTRAINT [DF_spb_MicroblogThreadsReferUsers_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_MicroBlogThreadsReferUsers] ADD  CONSTRAINT [DF_spb_MicroBlogThreadsReferUsers_ThreadID]  DEFAULT (0) FOR [ThreadID]
GO
ALTER TABLE [dbo].[spb_MicroBlogTimeLines] ADD  CONSTRAINT [DF_spb_MicroBlogTimeLines_OriginalThreadID]  DEFAULT (0) FOR [OriginalThreadID]
GO
ALTER TABLE [dbo].[spb_MicroBlogTimeLines] ADD  CONSTRAINT [DF_spb_MicroBlogTimeLine_FollowUserID]  DEFAULT (0) FOR [FollowUserID]
GO
ALTER TABLE [dbo].[spb_MicroBlogTimeLines] ADD  CONSTRAINT [DF_spb_MicroBlogTimeLines_HasPhoto]  DEFAULT (0) FOR [HasPhoto]
GO
ALTER TABLE [dbo].[spb_MicroBlogTimeLines] ADD  CONSTRAINT [DF_spb_MicroBlogTimeLines_HasVideo]  DEFAULT (0) FOR [HasVideo]
GO
ALTER TABLE [dbo].[spb_MicroBlogTimeLines] ADD  CONSTRAINT [DF_spb_MicroBlogTimeLines_HasMusic]  DEFAULT (0) FOR [HasMusic]
GO
ALTER TABLE [dbo].[spb_MicroBlogTimeLines] ADD  CONSTRAINT [DF_spb_MicroBlogTimeLine_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_MicroBlogTopicesFavorites] ADD  CONSTRAINT [DF_spb_MicroBlogTopicesFavorites_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_MicroBlogTopicesFavorites] ADD  CONSTRAINT [DF_spb_MicroBlogTopicesFavorites_Keyword]  DEFAULT ('') FOR [Keyword]
GO
ALTER TABLE [dbo].[spb_MicroBlogTopics] ADD  CONSTRAINT [DF_spb_MicroBlogTopics_Title]  DEFAULT ('') FOR [Title]
GO
ALTER TABLE [dbo].[spb_MicroBlogTopics] ADD  CONSTRAINT [DF_spb_MicroBlogTopices_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_MicroBlogTopics] ADD  CONSTRAINT [DF_spb_MicroBlogTopices_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_MicroBlogTopics] ADD  CONSTRAINT [DF_spb_MicroBlogTopics_IsFeatured]  DEFAULT (0) FOR [IsFeatured]
GO
ALTER TABLE [dbo].[spb_MicroBlogTopics] ADD  CONSTRAINT [DF_spb_MicroBlogTopices_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogTopics] ADD  CONSTRAINT [DF_spb_MicroBlogTopices_StageItemCount]  DEFAULT (0) FOR [StageItemCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogTopics] ADD  CONSTRAINT [DF_spb_MicroBlogTopices_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_MicroBlogUserDatas] ADD  CONSTRAINT [DF_spb_MicroBlogUserDatas_ThreadCount]  DEFAULT (0) FOR [ThreadCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogUserDatas] ADD  CONSTRAINT [DF_spb_MicroBlogUserDatas_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogUserDatas] ADD  CONSTRAINT [DF_spb_MicroBlogUserDatas_FollowerCount]  DEFAULT (0) FOR [FollowerCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogUserDatas] ADD  CONSTRAINT [DF_spb_MicroBlogUserDatas_FollowCount]  DEFAULT (0) FOR [FollowCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogUserDatas] ADD  CONSTRAINT [DF_spb_MicroBlogUserDatas_StageFollowerCount]  DEFAULT (0) FOR [StageFollowerCount]
GO
ALTER TABLE [dbo].[spb_MicroBlogUserDatas] ADD  CONSTRAINT [DF_spb_MicroBlogUserDatas_Theme]  DEFAULT ('') FOR [Theme]
GO
ALTER TABLE [dbo].[spb_MicroBlogUserDatas] ADD  CONSTRAINT [DF_spb_MicroBlogUserDatas_ThemeAppearance]  DEFAULT ('') FOR [ThemeAppearance]
GO
ALTER TABLE [dbo].[spb_MicroBlogUserDatas] ADD  CONSTRAINT [DF_spb_MicroBlogUserDatas_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_NewsAttachments] ADD  CONSTRAINT [DF_spb_NewsAttachments_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_NewsAttachments] ADD  CONSTRAINT [DF_spb_NewsAttachments_DownloadCount]  DEFAULT (0) FOR [DownloadCount]
GO
ALTER TABLE [dbo].[spb_NewsComments] ADD  CONSTRAINT [DF_spb_NewsComments_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_NewsComments] ADD  CONSTRAINT [DF_spb_NewsComments_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_NewsComments] ADD  CONSTRAINT [DF_spb_NewsComments_Title]  DEFAULT ('') FOR [Title]
GO
ALTER TABLE [dbo].[spb_NewsComments] ADD  CONSTRAINT [DF_spb_NewsComments_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_NewsReaders] ADD  CONSTRAINT [DF_spb_NewsReaders_ReaderDisplayName]  DEFAULT ('') FOR [ReaderDisplayName]
GO
ALTER TABLE [dbo].[spb_NewsReaders] ADD  CONSTRAINT [DF_spb_NewsReaders_LastReadDate]  DEFAULT (getdate()) FOR [ReadDate]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_SectionName]  DEFAULT ('') FOR [SectionName]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_ParentIDList]  DEFAULT ('') FOR [ParentIDList]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_ChildCount]  DEFAULT (0) FOR [ChildCount]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_Depth]  DEFAULT (0) FOR [Depth]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_NewsSectionType]  DEFAULT (0) FOR [NewsSectionType]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_IsActive]  DEFAULT (1) FOR [IsActive]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_EnaleSearch]  DEFAULT (1) FOR [EnaleSearch]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_ThreadCount]  DEFAULT (0) FOR [ThreadCount]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_PageList]  DEFAULT ('') FOR [PageList]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_PageDetail]  DEFAULT ('') FOR [PageDetail]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_PageShowSection]  DEFAULT ('') FOR [PageShowSection]
GO
ALTER TABLE [dbo].[spb_NewsSections] ADD  CONSTRAINT [DF_spb_NewsSections_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_NewsTags] ADD  CONSTRAINT [DF_spb_NewsTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_NewsTags] ADD  CONSTRAINT [DF_spb_NewsTags_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_NewsTags] ADD  CONSTRAINT [DF_spb_NewsTags_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_NewsTags] ADD  CONSTRAINT [DF_spb_NewsTags_OwnerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_Contributor]  DEFAULT ('') FOR [Contributor]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_Title]  DEFAULT ('') FOR [Title]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_Subtitle]  DEFAULT ('') FOR [Subtitle]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_PrefixID]  DEFAULT (0) FOR [PrefixID]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_LastRepliedDate]  DEFAULT (getdate()) FOR [LastRepliedDate]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_IsEssential]  DEFAULT (0) FOR [IsEssential]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_IsContributed]  DEFAULT (0) FOR [IsContributed]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_SpecialOrder]  DEFAULT (0) FOR [SpecialOrder]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_RssViewTimes]  DEFAULT (0) FOR [RssViewTimes]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_StageCommentCount]  DEFAULT (0) FOR [StageCommentCount]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_StageHitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_RatingSum]  DEFAULT (0) FOR [RatingSum]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_TotalRatings]  DEFAULT (0) FOR [TotalRatings]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_UserHostAddress]  DEFAULT (N'000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_NewsThreads] ADD  CONSTRAINT [DF_spb_NewsThreads_PointConsumption]  DEFAULT (0) FOR [PointConsumption]
GO
ALTER TABLE [dbo].[spb_NewsUserDatas] ADD  CONSTRAINT [DF_spb_NewsUserDatas_TotalThreadCount]  DEFAULT (0) FOR [TotalThreadCount]
GO
ALTER TABLE [dbo].[spb_NoticeItems] ADD  CONSTRAINT [DF_spb_NoticeItems_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_NoticeItems] ADD  CONSTRAINT [DF_spb_NoticeItems_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_NoticeItems] ADD  CONSTRAINT [DF_spb_NoticeItems_AllowPersonUser]  DEFAULT (1) FOR [AllowPersonUser]
GO
ALTER TABLE [dbo].[spb_NoticeItems] ADD  CONSTRAINT [DF_spb_NoticeItems_AllowCompanyUser]  DEFAULT (0) FOR [AllowCompanyUser]
GO
ALTER TABLE [dbo].[spb_NoticeItems_Res] ADD  CONSTRAINT [DF_spb_NoticeItems_Res_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_NoticeRecords] ADD  CONSTRAINT [DF_spb_Notices_LeadingActor]  DEFAULT ('') FOR [LeadingActor]
GO
ALTER TABLE [dbo].[spb_NoticeRecords] ADD  CONSTRAINT [DF_spb_Notices_RelativeItemID]  DEFAULT (0) FOR [RelativeItemID]
GO
ALTER TABLE [dbo].[spb_NoticeRecords] ADD  CONSTRAINT [DF_spb_Notices_RelativeItemName]  DEFAULT ('') FOR [RelativeItemName]
GO
ALTER TABLE [dbo].[spb_NoticeRecords] ADD  CONSTRAINT [DF_spb_Notices_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_NoticeRecords] ADD  CONSTRAINT [DF_spb_Notices_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_NoticeRecords] ADD  CONSTRAINT [DF_spb_Notices_IsReaded]  DEFAULT (0) FOR [IsReaded]
GO
ALTER TABLE [dbo].[spb_NoticeRecords] ADD  CONSTRAINT [DF_spb_Notices_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_OwnerApplicationInPresentAreas] ADD  CONSTRAINT [DF_spb_OwnerApplicationInPresentAreas_OnwerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_OwnerApplicationInPresentAreas] ADD  CONSTRAINT [DF_spb_OwnerApplicationInPresentAreas_ApplicationID]  DEFAULT (0) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_OwnerApplicationInPresentAreas] ADD  CONSTRAINT [DF_spb_OwnerApplicationInPresentAreas_PresentAreaID]  DEFAULT (0) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_DefaultNavigationID]  DEFAULT (0) FOR [DefaultNavigationID]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_PresentAreaID]  DEFAULT (1) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_ApplicationID]  DEFAULT (0) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_secondaryID]  DEFAULT (0) FOR [secondaryID]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_OnlyOwnerVisible]  DEFAULT (1) FOR [OnlyOwnerVisible]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_NavigationText]  DEFAULT ('') FOR [NavigationText]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_UrlRouteName]  DEFAULT ('') FOR [UrlRouteName]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_NavigationTarget]  DEFAULT ('') FOR [NavigationTarget]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_OwnerNavigations] ADD  CONSTRAINT [DF_spb_OwnerNavigations_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_PermissionItemRolesInUserRanks] ADD  CONSTRAINT [DF_spb_PermissionItemRolesInUserRanks_IsAllowed]  DEFAULT (1) FOR [AllowType]
GO
ALTER TABLE [dbo].[spb_PermissionItemRolesInUserRanks] ADD  CONSTRAINT [DF_spb_PermissionItemRolesInUserRanks_AllowedValue]  DEFAULT (0) FOR [AllowedValue]
GO
ALTER TABLE [dbo].[spb_PermissionItemRolesInUserRoles] ADD  CONSTRAINT [DF_spb_PermissionItemRolesInUserRoles_IsAllowed]  DEFAULT (1) FOR [AllowType]
GO
ALTER TABLE [dbo].[spb_PermissionItemRolesInUserRoles] ADD  CONSTRAINT [DF_spb_PermissionItemRolesInUserRoles_AllowedValue]  DEFAULT (0) FOR [AllowedValue]
GO
ALTER TABLE [dbo].[spb_PermissionItemRolesInUserRoles] ADD  CONSTRAINT [DF_spb_PermissionItemRolesInUserRoles_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_PermissionItems] ADD  CONSTRAINT [DF_spb_PermissionItems_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_PermissionItems] ADD  CONSTRAINT [DF_spb_PermissionItems_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_PermissionItems] ADD  CONSTRAINT [DF_spb_PermissionItems_EnabledPermissionLine]  DEFAULT (0) FOR [EnabledPermissionLine]
GO
ALTER TABLE [dbo].[spb_PermissionItems] ADD  CONSTRAINT [DF_spb_PermissionItems_EnabledInUserRole]  DEFAULT (0) FOR [EnabledInUserRole]
GO
ALTER TABLE [dbo].[spb_PermissionItems] ADD  CONSTRAINT [DF_spb_PermissionItems_OnlyEnabledInRoles]  DEFAULT (0) FOR [EnabledInUserRank]
GO
ALTER TABLE [dbo].[spb_PersonSiteTags] ADD  CONSTRAINT [DF_spb_PersonsSiteTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_PersonSiteTags] ADD  CONSTRAINT [DF_spb_PersonsSiteTags_UserCount]  DEFAULT (1) FOR [UserCount]
GO
ALTER TABLE [dbo].[spb_PersonSiteTags] ADD  CONSTRAINT [DF_spb_PersonsSiteTags_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_sex]  DEFAULT (1) FOR [Gender]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_Stature]  DEFAULT (0) FOR [Stature]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_Weight]  DEFAULT (0) FOR [Weight]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_Shape]  DEFAULT (0) FOR [Shape]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_Blood]  DEFAULT (0) FOR [Blood]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_Degree]  DEFAULT (0) FOR [Degree]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_School]  DEFAULT ('') FOR [School]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_SchoolID]  DEFAULT (0) FOR [SchoolID]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_NowSalary]  DEFAULT (0) FOR [NowSalary]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_Interest]  DEFAULT ('') FOR [Interest]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_Expertise]  DEFAULT ('') FOR [Expertise]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_Marriage]  DEFAULT (0) FOR [Marriage]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_CardType]  DEFAULT (1) FOR [CardType]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_CardID]  DEFAULT ('') FOR [CardID]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_title]  DEFAULT ('') FOR [Title]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_TitleLevel]  DEFAULT (0) FOR [TitleLevel]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_JobSort]  DEFAULT ('') FOR [JobSort]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_CompanyName]  DEFAULT ('') FOR [CompanyName]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_CompanyTrade]  DEFAULT (0) FOR [CompanyTrade]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_NowAreaCode]  DEFAULT ('') FOR [NowAreaCode]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_HomeAreaCode]  DEFAULT ('') FOR [HomeAreaCode]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] ADD  CONSTRAINT [DF_spb_PersonUserProfile_CompanyAreaCode]  DEFAULT ('') FOR [CompanyAreaCode]
GO
ALTER TABLE [dbo].[spb_PersonUserTags] ADD  CONSTRAINT [DF_spb_PersonsUserTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_PersonUserTags] ADD  CONSTRAINT [DF_spb_PersonsUserTags_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_PhotoComments] ADD  CONSTRAINT [DF_spb_PhotoComments_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_PhotoComments] ADD  CONSTRAINT [DF_spb_PhotoComments_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_PhotoComments] ADD  CONSTRAINT [DF_spb_PhotoComments_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_PhotoComments] ADD  CONSTRAINT [DF_spb_PhotoComments_IsApproved]  DEFAULT (1) FOR [IsApproved]
GO
ALTER TABLE [dbo].[spb_PhotoComments] ADD  CONSTRAINT [DF_spb_PhotoComments_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_PhotoComments] ADD  CONSTRAINT [DF_spb_PhotoComments_IPAddress]  DEFAULT (N'000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_PhotoComments] ADD  CONSTRAINT [DF_spb_PhotoComments_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_PhotoRatings] ADD  CONSTRAINT [DF_spb_PhotoRatings_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_PhotoRatings] ADD  CONSTRAINT [DF_spb_PhotoRatings_Rating]  DEFAULT (0) FOR [Rate]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_SectionID]  DEFAULT (0) FOR [OwnerUserID]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_CategoryID]  DEFAULT (0) FOR [UserCategoryID]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_SiteCategoryID]  DEFAULT (0) FOR [SiteCategoryID]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_PostAuthor]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_LastRepliedDate]  DEFAULT (getdate()) FOR [LastRepliedDate]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_IsPublic]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_IsLocked]  DEFAULT (1) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_Password]  DEFAULT ('') FOR [Password]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_IsEssential]  DEFAULT (0) FOR [IsEssential]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_SpecialOrder]  DEFAULT (0) FOR [SpecialOrder]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_StickyDate]  DEFAULT (getdate()) FOR [StickyDate]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_ReplyCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_RssViewTimes]  DEFAULT (0) FOR [RssViewTimes]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_RatingSum]  DEFAULT (0) FOR [RatingSum]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_TotalRatings]  DEFAULT (0) FOR [TotalRatings]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_UserHostAddress]  DEFAULT (N'000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_FileName]  DEFAULT ('') FOR [FileName]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_ContentType]  DEFAULT ('') FOR [ContentType]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_ContentSize]  DEFAULT (0) FOR [ContentSize]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_Height]  DEFAULT (0) FOR [Height]
GO
ALTER TABLE [dbo].[spb_Photos] ADD  CONSTRAINT [DF_spb_Photos_Width]  DEFAULT (0) FOR [Width]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_SectionName]  DEFAULT ('') FOR [SectionName]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_IsActive]  DEFAULT (1) FOR [IsActive]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_IsSearchable]  DEFAULT (1) FOR [EnableSearch]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_CreateDate]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_PostCount]  DEFAULT (0) FOR [PhotoCount]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_Points]  DEFAULT (0) FOR [Points]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_PhotoSections] ADD  CONSTRAINT [DF_spb_PhotoSections_WeekHitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_PhotoSiteTags] ADD  CONSTRAINT [DF_spb_PhotoSiteTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_PhotoSiteTags] ADD  CONSTRAINT [DF_spb_PhotoSiteTags_UserCount]  DEFAULT (1) FOR [UserCount]
GO
ALTER TABLE [dbo].[spb_PhotoSiteTags] ADD  CONSTRAINT [DF_spb_PhotoSiteTags_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_PhotoUserCategories] ADD  CONSTRAINT [DF_spb_PhotoUserCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_PhotoUserCategories] ADD  CONSTRAINT [DF_spb_PhotoUserCategories_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_PhotoUserCategories] ADD  CONSTRAINT [DF_spb_PhotoUserCategories_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_PhotoUserCategories] ADD  CONSTRAINT [DF_spb_PhotoUserCategories_MostRecentUpdateDate]  DEFAULT (getdate()) FOR [MostRecentUpdateDate]
GO
ALTER TABLE [dbo].[spb_PhotoUserCategories] ADD  CONSTRAINT [DF_spb_PhotoUserCategories_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_PhotoUserCategories] ADD  CONSTRAINT [DF_spb_PhotoUserCategories_AuditingStatus]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_PhotoUserTags] ADD  CONSTRAINT [DF_spb_PhotoUserTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_PhotoUserTags] ADD  CONSTRAINT [DF_spb_PhotoUserTags_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_PresentAreas] ADD  CONSTRAINT [DF_spb_PresentAreas_Name]  DEFAULT ('') FOR [Name]
GO
ALTER TABLE [dbo].[spb_PresentAreas] ADD  CONSTRAINT [DF_spb_PresentAreas_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_PresentAreas] ADD  CONSTRAINT [DF_spb_PresentAreas_CanAssignOwner]  DEFAULT (0) FOR [CanAssignOwner]
GO
ALTER TABLE [dbo].[spb_PresentAreas] ADD  CONSTRAINT [DF_spb_PresentAreas_EnableThemes]  DEFAULT (0) FOR [EnableThemes]
GO
ALTER TABLE [dbo].[spb_PresentAreas] ADD  CONSTRAINT [DF_spb_PresentAreas_DefaultTheme]  DEFAULT (N'default') FOR [DefaultTheme]
GO
ALTER TABLE [dbo].[spb_PresentAreas] ADD  CONSTRAINT [DF_spb_PresentAreas_DefaultAppearance]  DEFAULT (N'default') FOR [DefaultAppearance]
GO
ALTER TABLE [dbo].[spb_PresentAreas] ADD  CONSTRAINT [DF_spb_PresentAreas_ThemeLocation]  DEFAULT ('') FOR [ThemeLocation]
GO
ALTER TABLE [dbo].[spb_PresentAreas] ADD  CONSTRAINT [DF_spb_PresentAreas_WidgetLocation]  DEFAULT ('') FOR [WidgetLocation]
GO
ALTER TABLE [dbo].[spb_PrivacyItems] ADD  CONSTRAINT [DF_spb_PrivacyItems_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_PrivacyItems] ADD  CONSTRAINT [DF_spb_PrivacyItems_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_PrivacyItems] ADD  CONSTRAINT [DF_spb_PrivacyItems_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_PrivacyItems_Res] ADD  CONSTRAINT [DF_spb_ PrivacyItems_Res_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_PrivacyItems_Res] ADD  CONSTRAINT [DF_spb_ PrivacyItems_Res_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_PrivateMessageInbox] ADD  CONSTRAINT [DF_spb_PrivateMessageInbox_MessageType]  DEFAULT (0) FOR [MessageType]
GO
ALTER TABLE [dbo].[spb_PrivateMessageInbox] ADD  CONSTRAINT [DF_spb_PrivateMessageInbox_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_PrivateMessageInbox] ADD  CONSTRAINT [DF_spb_PrivateMessageInbox_Sender]  DEFAULT ('') FOR [Sender]
GO
ALTER TABLE [dbo].[spb_PrivateMessageInbox] ADD  CONSTRAINT [DF_spb_PrivateMessageInbox_MostRecentPostID]  DEFAULT (0) FOR [MostRecentPostID]
GO
ALTER TABLE [dbo].[spb_PrivateMessageInbox] ADD  CONSTRAINT [DF_spb_PrivateMessageInbox_IsRead]  DEFAULT (0) FOR [IsRead]
GO
ALTER TABLE [dbo].[spb_PrivateMessageOutbox] ADD  CONSTRAINT [DF_spb_PrivateMessageOutbox_ThreadID]  DEFAULT (0) FOR [ThreadID]
GO
ALTER TABLE [dbo].[spb_PrivateMessageOutbox] ADD  CONSTRAINT [DF_spb_PrivateMessageOutbox_MessageType]  DEFAULT (0) FOR [MessageType]
GO
ALTER TABLE [dbo].[spb_PrivateMessageOutbox] ADD  CONSTRAINT [DF_spb_PrivateMessageOutbox_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_PrivateMessageOutbox] ADD  CONSTRAINT [DF_spb_PrivateMessageOutbox_ReceiverUserID]  DEFAULT ('') FOR [ReceiverUserID]
GO
ALTER TABLE [dbo].[spb_PrivateMessageOutbox] ADD  CONSTRAINT [DF_spb_PrivateMessageOutbox_Receiver]  DEFAULT ('') FOR [Receiver]
GO
ALTER TABLE [dbo].[spb_PrivateMessageOutbox] ADD  CONSTRAINT [DF_spb_PrivateMessageOutbox_MostRecentPostID]  DEFAULT (0) FOR [MostRecentPostID]
GO
ALTER TABLE [dbo].[spb_PrivateMessagePosts] ADD  CONSTRAINT [DF_spb_PrivateMessagePosts_ParentID]  DEFAULT (0) FOR [ParentPostID]
GO
ALTER TABLE [dbo].[spb_PrivateMessagePosts] ADD  CONSTRAINT [DF_spb_PrivateMessagePosts_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_PrivateMessagePosts] ADD  CONSTRAINT [DF_spb_PrivateMessagePosts_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_PrivateMessagePosts] ADD  CONSTRAINT [DF_spb_PrivateMessagePosts_UserHostAddress]  DEFAULT ('') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_PrivateMessagePosts] ADD  CONSTRAINT [DF_spb_PrivateMessagePosts_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_ PrivateMessageThreads_Sender]  DEFAULT ('') FOR [Sender]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_ PrivateMessageThreads_ReceiverUserID]  DEFAULT (0) FOR [ReceiverUserID]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_ PrivateMessageThreads_Receiver]  DEFAULT ('') FOR [Receiver]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_ PrivateMessageThreads_RelativeItemID]  DEFAULT (0) FOR [RelativeItemID]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_ PrivateMessageThreads_RelativeItemName]  DEFAULT ('') FOR [RelativeItemName]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_ PrivateMessageThreads_MessageType]  DEFAULT (0) FOR [MessageType]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_ PrivateMessageThreads_IsLocked]  DEFAULT (0) FOR [IsLocked]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_ PrivateMessageThreads_ReplyCount]  DEFAULT (0) FOR [ReplyCount]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_PrivateMessageThreads_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_PrivateMessageThreads] ADD  CONSTRAINT [DF_spb_PrivateMessageThreads_LastRepliedDate]  DEFAULT (getdate()) FOR [LastRepliedDate]
GO
ALTER TABLE [dbo].[spb_RecommendedItems] ADD  CONSTRAINT [DF_spb_RecommendedItems_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_RecommendedItems] ADD  CONSTRAINT [DF_spb_RecommendedItems_Deadline]  DEFAULT (getdate()) FOR [Deadline]
GO
ALTER TABLE [dbo].[spb_RecommendedItems] ADD  CONSTRAINT [DF_spb_RecommendedItems_DisplayOrder]  DEFAULT (100) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_Roles] ADD  CONSTRAINT [DF_spb_Roles_FriendlyRoleName]  DEFAULT ('') FOR [FriendlyRoleName]
GO
ALTER TABLE [dbo].[spb_Roles] ADD  CONSTRAINT [DF_spb_Roles_IsBuiltIn]  DEFAULT (0) FOR [IsBuiltIn]
GO
ALTER TABLE [dbo].[spb_Roles] ADD  CONSTRAINT [DF_spb_Roles_IsPublic]  DEFAULT (0) FOR [IsPublic]
GO
ALTER TABLE [dbo].[spb_Roles] ADD  CONSTRAINT [DF_spb_Roles_ConnectToUser]  DEFAULT (0) FOR [ConnectToUser]
GO
ALTER TABLE [dbo].[spb_Roles] ADD  CONSTRAINT [DF_spb_Roles_ApplicationID]  DEFAULT (0) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_Roles] ADD  CONSTRAINT [DF_spb_Roles_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_Roles] ADD  CONSTRAINT [DF_spb_Roles_Enabled]  DEFAULT (1) FOR [Enabled]
GO
ALTER TABLE [dbo].[spb_Schools] ADD  CONSTRAINT [DF_spb_Schools_SchoolType]  DEFAULT (0) FOR [SchoolType]
GO
ALTER TABLE [dbo].[spb_Schools] ADD  CONSTRAINT [DF_spb_Schools_AreaCode]  DEFAULT ('') FOR [AreaCode]
GO
ALTER TABLE [dbo].[spb_Schools] ADD  CONSTRAINT [DF_spb_Schools_AreaName]  DEFAULT ('') FOR [AreaName]
GO
ALTER TABLE [dbo].[spb_Schools] ADD  CONSTRAINT [DF_spb_Schools_SortOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_ShareComments] ADD  CONSTRAINT [DF_spb_ShareComments_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_ShareComments] ADD  CONSTRAINT [DF_spb_ShareComments_UserThreadID]  DEFAULT (0) FOR [UserThreadID]
GO
ALTER TABLE [dbo].[spb_ShareComments] ADD  CONSTRAINT [DF_spb_ShareComments_OwnerUserID]  DEFAULT (0) FOR [OwnerUserID]
GO
ALTER TABLE [dbo].[spb_ShareComments] ADD  CONSTRAINT [DF_spb_ShareComments_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_ShareComments] ADD  CONSTRAINT [DF_spb_ShareComments_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ShareComments] ADD  CONSTRAINT [DF_spb_ShareComments_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_ShareComments] ADD  CONSTRAINT [DF_spb_ShareComments_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_ShareComments] ADD  CONSTRAINT [DF_spb_ShareComments_UserHostAddress]  DEFAULT (N'000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_ShareComments] ADD  CONSTRAINT [DF_spb_ShareComments_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_ThumbnailUrl]  DEFAULT ('') FOR [ThumbnailUrl]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_ShareType]  DEFAULT (0) FOR [SiteCategoryID]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_MediaTypeID]  DEFAULT (0) FOR [MediaType]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_ApplicationID]  DEFAULT (0) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_PrivacyStatus]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_DayHitTimes]  DEFAULT (0) FOR [DayHitTimes]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_WeekHitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_BackerCount]  DEFAULT (0) FOR [BackerCount]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_DissenterCount]  DEFAULT (0) FOR [DissenterCount]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_UserCount]  DEFAULT (0) FOR [UserCount]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_DayUserCount]  DEFAULT (0) FOR [DayUserCount]
GO
ALTER TABLE [dbo].[spb_ShareThreads] ADD  CONSTRAINT [DF_spb_ShareThreads_WeekUserCount]  DEFAULT (0) FOR [StageUserCount]
GO
ALTER TABLE [dbo].[spb_SiteCategories] ADD  CONSTRAINT [DF_spb_SiteCategories_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_SiteCategories] ADD  CONSTRAINT [DF_spb_SiteCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_SiteCategories] ADD  CONSTRAINT [DF_spb_SiteCategories_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_SiteCategories] ADD  CONSTRAINT [DF_spb_SiteCategories_Depth]  DEFAULT (0) FOR [Depth]
GO
ALTER TABLE [dbo].[spb_SiteCategories] ADD  CONSTRAINT [DF_spb_SiteCategories_ChildCount]  DEFAULT (0) FOR [ChildCount]
GO
ALTER TABLE [dbo].[spb_SiteCategories] ADD  CONSTRAINT [DF_spb_SiteCategories_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_SiteCategories_Res] ADD  CONSTRAINT [DF_spb_SiteCategories_Res_Name]  DEFAULT ('') FOR [Name]
GO
ALTER TABLE [dbo].[spb_SiteLinkCategories] ADD  CONSTRAINT [DF_spb_SiteLinkCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_SiteLinkCategories] ADD  CONSTRAINT [DF_spb_SiteLinkCategories_DisplayOrder]  DEFAULT (100) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_SiteLinks] ADD  CONSTRAINT [DF_spb_SiteLinks_ImageUrl]  DEFAULT ('') FOR [ImageUrl]
GO
ALTER TABLE [dbo].[spb_SiteLinks] ADD  CONSTRAINT [DF_spb_SiteLinks_LinkTitle]  DEFAULT ('') FOR [LinkTitle]
GO
ALTER TABLE [dbo].[spb_SiteLinks] ADD  CONSTRAINT [DF_spb_SiteLinks_LinkType]  DEFAULT (1) FOR [LinkType]
GO
ALTER TABLE [dbo].[spb_SiteLinks] ADD  CONSTRAINT [DF_spb_SiteLinks_DisplayOrder]  DEFAULT (100) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_SiteLinks] ADD  CONSTRAINT [DF_spb_SiteLinks_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_SiteSettings] ADD  CONSTRAINT [DF_spb_SiteSettings_SettingsKey]  DEFAULT (newid()) FOR [SettingsKey]
GO
ALTER TABLE [dbo].[spb_SiteSettings] ADD  CONSTRAINT [DF_spb_SiteSettings_version]  DEFAULT ('') FOR [version]
GO
ALTER TABLE [dbo].[spb_SystemData] ADD  CONSTRAINT [DF_spb_ SystemData_TradePoints]  DEFAULT (0) FOR [TradePoints]
GO
ALTER TABLE [dbo].[spb_TagUsersInPhotos] ADD  CONSTRAINT [DF_spb_TagUsersInPhotos_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_TagUsersInPhotos] ADD  CONSTRAINT [DF_spb_TagUsersInPhotos_DisplayName]  DEFAULT ('') FOR [DisplayName]
GO
ALTER TABLE [dbo].[spb_TagUsersInPhotos] ADD  CONSTRAINT [DF_spb_TagUsersInPhotos_ThreadID]  DEFAULT (0) FOR [ThreadID]
GO
ALTER TABLE [dbo].[spb_TagUsersInPhotos] ADD  CONSTRAINT [DF_spb_TagUsersInPhotos_OperatorUserID]  DEFAULT (0) FOR [OperatorUserID]
GO
ALTER TABLE [dbo].[spb_TagUsersInPhotos] ADD  CONSTRAINT [DF_spb_TagUsersInPhotos_AreaX]  DEFAULT (0) FOR [AreaX]
GO
ALTER TABLE [dbo].[spb_TagUsersInPhotos] ADD  CONSTRAINT [DF_spb_TagUsersInPhotos_AreaY]  DEFAULT (0) FOR [AreaY]
GO
ALTER TABLE [dbo].[spb_TagUsersInPhotos] ADD  CONSTRAINT [DF_spb_TagUsersInPhotos_AreaWidth]  DEFAULT (0) FOR [AreaWidth]
GO
ALTER TABLE [dbo].[spb_TagUsersInPhotos] ADD  CONSTRAINT [DF_spb_TagUsersInPhotos_AreaHeight]  DEFAULT (0) FOR [AreaHeight]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_Title]  DEFAULT ('') FOR [Title]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_PreviewLargeImage]  DEFAULT ('') FOR [PreviewLargeImage]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_LogoUrl]  DEFAULT ('') FOR [LogoUrl]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_Roles]  DEFAULT ('') FOR [Roles]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_MinUserRank]  DEFAULT (0) FOR [RequiredRank]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_TypeName]  DEFAULT ('') FOR [TypeName]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_Copyright]  DEFAULT ('') FOR [Copyright]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_ThemeVersion]  DEFAULT ('') FOR [ThemeVersion]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_ForProductVersion]  DEFAULT ('') FOR [ForProductVersion]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_DateCreated]  DEFAULT ('') FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] ADD  CONSTRAINT [DF_spb_ThemeAppearances_UserCount]  DEFAULT (0) FOR [UserCount]
GO
ALTER TABLE [dbo].[spb_Themes] ADD  CONSTRAINT [DF_spb_Themes_Parent]  DEFAULT ('') FOR [Parent]
GO
ALTER TABLE [dbo].[spb_Themes] ADD  CONSTRAINT [DF_spb_Themes_EnableChangeLayout]  DEFAULT (0) FOR [EnableChangeLayout]
GO
ALTER TABLE [dbo].[spb_Themes] ADD  CONSTRAINT [DF_spb_Themes_EnablePrintCSS]  DEFAULT (0) FOR [EnablePrintCSS]
GO
ALTER TABLE [dbo].[spb_Themes] ADD  CONSTRAINT [DF_spb_Themes_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_UrlInfos] ADD  CONSTRAINT [DF_spb_UrlInfo_Url]  DEFAULT ('') FOR [Url]
GO
ALTER TABLE [dbo].[spb_UrlInfos] ADD  CONSTRAINT [DF_spb_UrlInfos_UrlSalt]  DEFAULT ('') FOR [UrlSalt]
GO
ALTER TABLE [dbo].[spb_UrlInfos] ADD  CONSTRAINT [DF_spb_UrlInfo_ThumbnailUrl]  DEFAULT ('') FOR [ThumbnailUrl]
GO
ALTER TABLE [dbo].[spb_UrlInfos] ADD  CONSTRAINT [DF_spb_UrlInfo_PlayUrl]  DEFAULT ('') FOR [PlayUrl]
GO
ALTER TABLE [dbo].[spb_UrlInfos] ADD  CONSTRAINT [DF_spb_UrlInfo_MediaType]  DEFAULT (9999) FOR [MediaType]
GO
ALTER TABLE [dbo].[spb_UrlInfos] ADD  CONSTRAINT [DF_spb_UrlInfo_dataCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_UserActivities] ADD  CONSTRAINT [DF_spb_UserActivities_RelativeItemID]  DEFAULT (0) FOR [RelativeItemID]
GO
ALTER TABLE [dbo].[spb_UserActivities] ADD  CONSTRAINT [DF_spb_UserActivities_RelativeItemName]  DEFAULT ('') FOR [RelativeItemName]
GO
ALTER TABLE [dbo].[spb_UserActivities] ADD  CONSTRAINT [DF_spb_UserActivities_IsPublic]  DEFAULT (0) FOR [IsPublic]
GO
ALTER TABLE [dbo].[spb_UserActivities] ADD  CONSTRAINT [DF_spb_UserActivities_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_UserActivityItemSettings] ADD  CONSTRAINT [DF_spb_UserActivityItemSettings_IsAllowSending]  DEFAULT (1) FOR [IsAllowSending]
GO
ALTER TABLE [dbo].[spb_UserActivityItemSettings] ADD  CONSTRAINT [DF_spb_UserActivityItemSettings_IsAllowReceiving]  DEFAULT (1) FOR [IsAllowReceiving]
GO
ALTER TABLE [dbo].[spb_UserActivitySettings] ADD  CONSTRAINT [DF_spb_UserActivitySettings_IgnoredFriendUserIDsForReceiveActivities]  DEFAULT ('') FOR [IgnoredFriendUsersForReceiveActivities]
GO
ALTER TABLE [dbo].[spb_UserActivitySettings] ADD  CONSTRAINT [DF_spb_UserActivitySettings_IgnoredClubsForReceiveClubActivities]  DEFAULT ('') FOR [IgnoredClubsForReceiveClubActivities]
GO
ALTER TABLE [dbo].[spb_UserGuestbookPosts] ADD  CONSTRAINT [DF_spb_UserGuestbookPosts_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_UserGuestbookPosts] ADD  CONSTRAINT [DF_spb_UserGuestbookPosts_ParentUserID]  DEFAULT (0) FOR [ParentUserID]
GO
ALTER TABLE [dbo].[spb_UserGuestbookPosts] ADD  CONSTRAINT [DF_spb_UserGuestbookPosts_IsPrivate]  DEFAULT (0) FOR [IsPrivate]
GO
ALTER TABLE [dbo].[spb_UserGuestbookPosts] ADD  CONSTRAINT [DF_spb_UserGuestbookPosts_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_UserGuestbookPosts] ADD  CONSTRAINT [DF_spb_UserGuestbookPosts_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_UserGuestbookPosts] ADD  CONSTRAINT [DF_spb_UserGuestbookPosts_IsApproved]  DEFAULT (1) FOR [IsApproved]
GO
ALTER TABLE [dbo].[spb_UserGuestbookPosts] ADD  CONSTRAINT [DF_spb_UserGuestbookPosts_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_UserGuestbookPosts] ADD  CONSTRAINT [DF_spb_UserGuestbookPosts_UserHostAddress]  DEFAULT (N'000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_UserGuestbookPosts] ADD  CONSTRAINT [DF_spb_UserGuestbookPosts_PostDate]  DEFAULT (getdate()) FOR [PostDate]
GO
ALTER TABLE [dbo].[spb_UserGuestbooks] ADD  CONSTRAINT [DF_spb_UserGuestbooks_IsActive]  DEFAULT (1) FOR [IsActive]
GO
ALTER TABLE [dbo].[spb_UserGuestbooks] ADD  CONSTRAINT [DF_spb_UserGuestbooks_EnableAnonymousPosting]  DEFAULT (1) FOR [EnableAnonymousPosting]
GO
ALTER TABLE [dbo].[spb_UserGuestbooks] ADD  CONSTRAINT [DF_spb_UserGuestbooks_PostCount]  DEFAULT (0) FOR [PostCount]
GO
ALTER TABLE [dbo].[spb_UserIdentities] ADD  CONSTRAINT [DF_spb_UserIdentities_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_UserIdentities] ADD  CONSTRAINT [DF_spb_UserIdentities_IdentityID]  DEFAULT (0) FOR [IdentityID]
GO
ALTER TABLE [dbo].[spb_UserIdentities] ADD  CONSTRAINT [DF_spb_UserIdentities_IdentityDescription]  DEFAULT ('') FOR [IdentityDescription]
GO
ALTER TABLE [dbo].[spb_UserLinkCategories] ADD  CONSTRAINT [DF_spb_UserLinkCategories_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_UserLinkCategories] ADD  CONSTRAINT [DF_spb_UserLinkCategories_DisplayOrder]  DEFAULT (100) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_UserLinks] ADD  CONSTRAINT [DF_spb_UserLinks_ImageUrl]  DEFAULT ('') FOR [ImageUrl]
GO
ALTER TABLE [dbo].[spb_UserLinks] ADD  CONSTRAINT [DF_spb_UserLinks_LinkTitle]  DEFAULT ('') FOR [LinkTitle]
GO
ALTER TABLE [dbo].[spb_UserLinks] ADD  CONSTRAINT [DF_spb_UserLinks_LinkType]  DEFAULT (1) FOR [LinkType]
GO
ALTER TABLE [dbo].[spb_UserLinks] ADD  CONSTRAINT [DF_spb_UserLinks_DisplayOrder]  DEFAULT (100) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_UserLinks] ADD  CONSTRAINT [DF_spb_UserLinks_IsEnabled]  DEFAULT (1) FOR [IsEnabled]
GO
ALTER TABLE [dbo].[spb_UserPointItemRules] ADD  CONSTRAINT [DF_spb_UserPointItemRules_BasicPoints]  DEFAULT (0) FOR [BasicPoints]
GO
ALTER TABLE [dbo].[spb_UserPointItemRules] ADD  CONSTRAINT [DF_spb_UserPointItemRules_ReportPoints]  DEFAULT (0) FOR [ReportPoints]
GO
ALTER TABLE [dbo].[spb_UserPointItemRules] ADD  CONSTRAINT [DF_spb_UserPointItemRules_CreditPoints]  DEFAULT (0) FOR [CreditPoints]
GO
ALTER TABLE [dbo].[spb_UserPointItemRules] ADD  CONSTRAINT [DF_spb_UserPointItemRules_TradePoints]  DEFAULT (0) FOR [TradePoints]
GO
ALTER TABLE [dbo].[spb_UserPointItemRules] ADD  CONSTRAINT [DF_spb_UserPointItemRules_BasicPointQuota]  DEFAULT (0) FOR [BasicPointQuota]
GO
ALTER TABLE [dbo].[spb_UserPointItemRules] ADD  CONSTRAINT [DF_spb_UserPointItemRules_ReportPointQuota]  DEFAULT (0) FOR [ReportPointQuota]
GO
ALTER TABLE [dbo].[spb_UserPointItemRules] ADD  CONSTRAINT [DF_spb_UserPointItemRules_CreditPointQuota]  DEFAULT (0) FOR [CreditPointQuota]
GO
ALTER TABLE [dbo].[spb_UserPointItemRules] ADD  CONSTRAINT [DF_spb_UserPointItemRules_TradePointQuota]  DEFAULT (0) FOR [TradePointQuota]
GO
ALTER TABLE [dbo].[spb_UserPointItems] ADD  CONSTRAINT [DF_spb_UserPointItems_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_UserPointItems] ADD  CONSTRAINT [DF_spb_UserPointItems_DisplayOrder]  DEFAULT (0) FOR [DisplayOrder]
GO
ALTER TABLE [dbo].[spb_UserPointItems_Res] ADD  CONSTRAINT [DF_spb_UserPointItems_Res_ItemName]  DEFAULT ('') FOR [ItemName]
GO
ALTER TABLE [dbo].[spb_UserPointRecords] ADD  CONSTRAINT [DF_spb_UserPointRecords_PointCategory]  DEFAULT (0) FOR [PointCategory]
GO
ALTER TABLE [dbo].[spb_UserPointRecords] ADD  CONSTRAINT [DF_spb_UserPointRecords_Points]  DEFAULT (0) FOR [Points]
GO
ALTER TABLE [dbo].[spb_UserPointRecords] ADD  CONSTRAINT [DF_spb_UserPointRecords_Description]  DEFAULT ('') FOR [Description]
GO
ALTER TABLE [dbo].[spb_UserPointRecords] ADD  CONSTRAINT [DF_spb_UserPointRecords_IsIncome]  DEFAULT (1) FOR [IsIncome]
GO
ALTER TABLE [dbo].[spb_UserPointRecords] ADD  CONSTRAINT [DF_spb_UserPointRecords_CreateDate]  DEFAULT (getdate()) FOR [CreateDate]
GO
ALTER TABLE [dbo].[spb_UserPointStatisticsPerDay] ADD  CONSTRAINT [DF_spb_UserPointStatisticsPerDay_BasicPoints]  DEFAULT (0) FOR [BasicPoints]
GO
ALTER TABLE [dbo].[spb_UserPointStatisticsPerDay] ADD  CONSTRAINT [DF_spb_UserPointStatisticsPerDay_ReportPoints]  DEFAULT (0) FOR [ReportPoints]
GO
ALTER TABLE [dbo].[spb_UserPointStatisticsPerDay] ADD  CONSTRAINT [DF_spb_UserPointStatisticsPerDay_CreditPoints]  DEFAULT (0) FOR [CreditPoints]
GO
ALTER TABLE [dbo].[spb_UserPointStatisticsPerDay] ADD  CONSTRAINT [DF_spb_UserPointStatisticsPerDay_TradePoints]  DEFAULT (0) FOR [TradePoints]
GO
ALTER TABLE [dbo].[spb_UserRanks] ADD  CONSTRAINT [DF_spb_UserRanks_PointUpper]  DEFAULT (0) FOR [PointUpper]
GO
ALTER TABLE [dbo].[spb_UserRanks] ADD  CONSTRAINT [DF_spb_UserRanks_PointLower]  DEFAULT (0) FOR [PointLower]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName1]  DEFAULT ('') FOR [RankName1]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName2]  DEFAULT ('') FOR [RankName2]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName3]  DEFAULT ('') FOR [RankName3]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName4]  DEFAULT ('') FOR [RankName4]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName5]  DEFAULT ('') FOR [RankName5]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName6]  DEFAULT ('') FOR [RankName6]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName7]  DEFAULT ('') FOR [RankName7]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName8]  DEFAULT ('') FOR [RankName8]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName9]  DEFAULT ('') FOR [RankName9]
GO
ALTER TABLE [dbo].[spb_UserRanks_Res] ADD  CONSTRAINT [DF_spb_UserRanks_Res_RankName10]  DEFAULT ('') FOR [RankName10]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_PasswordSalt]  DEFAULT ('') FOR [PasswordSalt]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_PasswordFormat]  DEFAULT (2) FOR [PasswordFormat]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_PasswordQuestion]  DEFAULT ('') FOR [PasswordQuestion]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_PasswordAnswer]  DEFAULT ('') FOR [PasswordAnswer]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_PrivateEmail]  DEFAULT ('') FOR [PrivateEmail]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_MembershipID]  DEFAULT (newid()) FOR [MembershipID]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_CommonName]  DEFAULT ('') FOR [CommonName]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_Nickname]  DEFAULT ('') FOR [Nickname]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_ForceLogin]  DEFAULT (0) FOR [ForceLogin]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_UserAccountStatus]  DEFAULT (1) FOR [UserAccountStatus]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_LastActivity]  DEFAULT (getdate()) FOR [LastActivity]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_LastAction]  DEFAULT ('') FOR [LastAction]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_IPCreated]  DEFAULT (N'000.000.000.000') FOR [IPCreated]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_IPLastActivity]  DEFAULT (N'000.000.000.000') FOR [IPLastActivity]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_DatabaseQuota]  DEFAULT (102400) FOR [DatabaseQuota]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_DatabaseQuotaUsed]  DEFAULT (0) FOR [DatabaseQuotaUsed]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_IsModerated]  DEFAULT (1) FOR [IsModerated]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_IsForceModerated]  DEFAULT (0) FOR [IsForceModerated]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_EnableAvatar]  DEFAULT (1) FOR [EnableAvatar]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_EnableDisplayInMemberList]  DEFAULT (1) FOR [EnableDisplayInMemberList]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_EnableOnlineStatus]  DEFAULT (1) FOR [EnableOnlineStatus]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_EnableEmail]  DEFAULT (1) FOR [EnableEmail]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_EnableHtmlEmail]  DEFAULT (1) FOR [EnableHtmlEmail]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_IsEmailVerified]  DEFAULT (0) FOR [IsEmailVerified]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_IsAvatarApproved]  DEFAULT (1) FOR [IsAvatarApproved]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_HonorType]  DEFAULT (1) FOR [UserRankType]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_UserType]  DEFAULT (1) FOR [UserType]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_PublicEmail]  DEFAULT ('') FOR [PublicEmail]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_mobile]  DEFAULT ('') FOR [Mobile]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_MsnIM]  DEFAULT ('') FOR [MsnIM]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_QQIM]  DEFAULT ('') FOR [QQIM]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_YahooIM]  DEFAULT ('') FOR [YahooIM]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_SkypeIM]  DEFAULT ('') FOR [SkypeIM]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_WebAddress]  DEFAULT ('') FOR [PersonalHomepage]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_InviteUserID]  DEFAULT (0) FOR [InviteUserID]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_InviteClubID]  DEFAULT (0) FOR [InviteClubID]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_Theme]  DEFAULT ('') FOR [Theme]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_ThemeAppearance]  DEFAULT ('') FOR [ThemeAppearance]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_FileCount]  DEFAULT (0) FOR [MemberLevel]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_BasicPoints]  DEFAULT (0) FOR [BasicPoints]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_TradePoints]  DEFAULT (0) FOR [TradePoints]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_PrepayTradePoints]  DEFAULT (0) FOR [PrepayTradePoints]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_ReportPoints]  DEFAULT (0) FOR [ReportPoints]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_CreditPoints]  DEFAULT (0) FOR [CreditPoints]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_ExpertPoints]  DEFAULT (0) FOR [ExpertPoints]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_Rank]  DEFAULT (0) FOR [Rank]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_RMBMoney]  DEFAULT (0) FOR [RMBMoney]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_PrepayRMBMoney]  DEFAULT (0) FOR [PrepayRMBMoney]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_ProfileIntegrity]  DEFAULT (0) FOR [ProfileIntegrity]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_FriendCount]  DEFAULT (0) FOR [FriendCount]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_InviteFriendCount]  DEFAULT (0) FOR [InviteFriendCount]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_loginTimes]  DEFAULT (0) FOR [loginTimes]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_Users] ADD  CONSTRAINT [DF_spb_Users_WeekHitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_UsersFavorites] ADD  CONSTRAINT [DF_spb_UsersFavorites_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_UsersFavorites] ADD  CONSTRAINT [DF_spb_UsersFavorites_DisplayName]  DEFAULT ('') FOR [DisplayName]
GO
ALTER TABLE [dbo].[spb_UsersFavorites] ADD  CONSTRAINT [DF_spb_UsersFavorites_ItemID]  DEFAULT (0) FOR [ItemID]
GO
ALTER TABLE [dbo].[spb_UsersFavorites] ADD  CONSTRAINT [DF_spb_UsersFavorites_PrivacyStatus]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_UsersFavorites] ADD  CONSTRAINT [DF_spb_UsersFavorites_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_UserShareThreads] ADD  CONSTRAINT [DF_spb_UserShareThreads_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_UserShareThreads] ADD  CONSTRAINT [DF_spb_UserShareThreads_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_UserShareThreads] ADD  CONSTRAINT [DF_spb_UserShareThreads_CommentBody]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_UserShareThreads] ADD  CONSTRAINT [DF_spb_UserShareThreads_PrivacyStatus]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_UserShareThreads] ADD  CONSTRAINT [DF_spb_UserShareThreads_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_UserShareThreads] ADD  CONSTRAINT [DF_spb_UserShareThreads_UserHostAddress]  DEFAULT (N'000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_UserShareThreads] ADD  CONSTRAINT [DF_spb_UserShareThreads_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_UserShareThreads] ADD  CONSTRAINT [DF_spb_UserShareThreads_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_UserShareThreadsInUserTags] ADD  CONSTRAINT [DF_spb_UserShareThreadsInUserTags_TagName]  DEFAULT ('') FOR [TagName]
GO
ALTER TABLE [dbo].[spb_UserShareThreadSiteTags] ADD  CONSTRAINT [DF_spb_UserShareThreadSiteTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_UserShareThreadSiteTags] ADD  CONSTRAINT [DF_spb_UserShareThreadSiteTags_UserCount]  DEFAULT (0) FOR [UserCount]
GO
ALTER TABLE [dbo].[spb_UserShareThreadSiteTags] ADD  CONSTRAINT [DF_spb_UserShareThreadSiteTags_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_UserShareThreadUserTags] ADD  CONSTRAINT [DF_spb_UserShareThreadUserTags_ItemCount]  DEFAULT (0) FOR [ItemCount]
GO
ALTER TABLE [dbo].[spb_UserShareThreadUserTags] ADD  CONSTRAINT [DF_spb_UserShareThreadUserTags_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_UsersOnline] ADD  CONSTRAINT [DF_spb_UsersOnline_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_UsersOnline] ADD  CONSTRAINT [DF_spb_UsersOnline_DisplayName]  DEFAULT ('') FOR [DisplayName]
GO
ALTER TABLE [dbo].[spb_UsersOnline] ADD  CONSTRAINT [DF_spb_UsersOnline_LastActivityDateTime]  DEFAULT (getdate()) FOR [LastActivityDateTime]
GO
ALTER TABLE [dbo].[spb_UsersOnline] ADD  CONSTRAINT [DF_spb_UsersOnline_LastAction]  DEFAULT ('') FOR [LastAction]
GO
ALTER TABLE [dbo].[spb_UsersOnline] ADD  CONSTRAINT [DF_spb_UsersOnline_IPAddress]  DEFAULT (N'000.000.000.000') FOR [IPAddress]
GO
ALTER TABLE [dbo].[spb_UserVisits] ADD  CONSTRAINT [DF_spb_UserVisits_FromUserDisplayName]  DEFAULT ('') FOR [FromUserDisplayName]
GO
ALTER TABLE [dbo].[spb_UserVisits] ADD  CONSTRAINT [DF_spb_UserVisits_FromUserType]  DEFAULT (1) FOR [FromUserType]
GO
ALTER TABLE [dbo].[spb_UserVisits] ADD  CONSTRAINT [DF_spb_UserVisits_ToUserDisplayName]  DEFAULT ('') FOR [ToUserDisplayName]
GO
ALTER TABLE [dbo].[spb_UserVisits] ADD  CONSTRAINT [DF_spb_UserVisits_ToUserType]  DEFAULT (1) FOR [ToUserType]
GO
ALTER TABLE [dbo].[spb_UserVisits] ADD  CONSTRAINT [DF_spb_UserVisits_VisitTimes]  DEFAULT (0) FOR [VisitTimes]
GO
ALTER TABLE [dbo].[spb_UserVisits] ADD  CONSTRAINT [DF_spb_UserVisits_LastVisitTime]  DEFAULT (getdate()) FOR [LastVisitTime]
GO
ALTER TABLE [dbo].[spb_UserVisits] ADD  CONSTRAINT [DF_spb_UserVisits_Visible]  DEFAULT (1) FOR [IsVisible]
GO
ALTER TABLE [dbo].[spb_VoteComments] ADD  CONSTRAINT [DF_spb_UserVoteComments_ParentID]  DEFAULT (0) FOR [ParentID]
GO
ALTER TABLE [dbo].[spb_VoteComments] ADD  CONSTRAINT [DF_spb_VoteComments_PresentAreaID]  DEFAULT (0) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_VoteComments] ADD  CONSTRAINT [DF_spb_UserVoteComments_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_VoteComments] ADD  CONSTRAINT [DF_spb_UserVoteComments_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_VoteComments] ADD  CONSTRAINT [DF_spb_UserVoteComments_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_VoteComments] ADD  CONSTRAINT [DF_spb_UserVoteComments_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_VoteOptions] ADD  CONSTRAINT [DF_spb_UserVoteOptions_ThreadID]  DEFAULT (0) FOR [ThreadID]
GO
ALTER TABLE [dbo].[spb_VoteOptions] ADD  CONSTRAINT [DF_spb_UserVoteOptions_VoteCount]  DEFAULT (0) FOR [VoteCount]
GO
ALTER TABLE [dbo].[spb_VoteOptions] ADD  CONSTRAINT [DF_spb_UserVoteOptions_OptionName]  DEFAULT ('') FOR [OptionName]
GO
ALTER TABLE [dbo].[spb_VoteRecords] ADD  CONSTRAINT [DF_spb_UserVoteRecords_UserID]  DEFAULT (0) FOR [UserID]
GO
ALTER TABLE [dbo].[spb_VoteRecords] ADD  CONSTRAINT [DF_spb_UserVoteRecords_UserDisplayName]  DEFAULT ('') FOR [UserDisplayName]
GO
ALTER TABLE [dbo].[spb_VoteRecords] ADD  CONSTRAINT [DF_spb_UserVoteRecords_OptionID]  DEFAULT (0) FOR [OptionID]
GO
ALTER TABLE [dbo].[spb_VoteRecords] ADD  CONSTRAINT [DF_spb_UserVoteRecords_ThreadID]  DEFAULT (0) FOR [ThreadID]
GO
ALTER TABLE [dbo].[spb_VoteRecords] ADD  CONSTRAINT [DF_spb_UserVoteRecords_IsAnonymousVote]  DEFAULT (0) FOR [IsAnonymousVote]
GO
ALTER TABLE [dbo].[spb_VoteRecords] ADD  CONSTRAINT [DF_spb_UserVoteRecords_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_VoteSections] ADD  CONSTRAINT [DF_spb_VoteSections_PresentAreaID]  DEFAULT (0) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_VoteSections] ADD  CONSTRAINT [DF_spb_VoteSections_OwnerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_VoteSections] ADD  CONSTRAINT [DF_spb_VoteSections_TotalThreadCount]  DEFAULT (0) FOR [TotalThreadCount]
GO
ALTER TABLE [dbo].[spb_VoteSections] ADD  CONSTRAINT [DF_spb_VoteSections_OverdueThreadCount]  DEFAULT (0) FOR [OverdueThreadCount]
GO
ALTER TABLE [dbo].[spb_VoteSections] ADD  CONSTRAINT [DF_spb_VoteSections_ProgressThreadCount]  DEFAULT (0) FOR [ProgressThreadCount]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_VoteThreads_Owner]  DEFAULT ('') FOR [Owner]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_Owner]  DEFAULT (0) FOR [PresentAreaID]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_Author]  DEFAULT ('') FOR [Author]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_Subject]  DEFAULT ('') FOR [Subject]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_Body]  DEFAULT ('') FOR [Body]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_AuditingStatus]  DEFAULT (40) FOR [AuditingStatus]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_VoteStaus]  DEFAULT (0) FOR [VoteStaus]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_IsMultiple]  DEFAULT (0) FOR [IsMultiple]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_MaxChooseCount]  DEFAULT (0) FOR [MaxChooseCount]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_PrivacyStatus]  DEFAULT (30) FOR [PrivacyStatus]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_HitTimes]  DEFAULT (0) FOR [HitTimes]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_WeekHitTimes]  DEFAULT (0) FOR [StageHitTimes]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_VoterCount]  DEFAULT (0) FOR [VoterCount]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_CommentCount]  DEFAULT (0) FOR [CommentCount]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_UserHostAddress]  DEFAULT (N'000.000.000.000') FOR [UserHostAddress]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_DateCreated]  DEFAULT (getdate()) FOR [DateCreated]
GO
ALTER TABLE [dbo].[spb_VoteThreads] ADD  CONSTRAINT [DF_spb_UserVoteThreads_LastModified]  DEFAULT (getdate()) FOR [LastModified]
GO
ALTER TABLE [dbo].[spb_VoteUserDatas] ADD  CONSTRAINT [DF_spb_VoteUserDatas_TotalThreadCount]  DEFAULT (0) FOR [TotalThreadCount]
GO
ALTER TABLE [dbo].[spb_VoteUserDatas] ADD  CONSTRAINT [DF_spb_VoteUserDatas_OverdueThreadCount]  DEFAULT (0) FOR [OverdueThreadCount]
GO
ALTER TABLE [dbo].[spb_VoteUserDatas] ADD  CONSTRAINT [DF_spb_VoteUserDatas_ProgressThreadCount]  DEFAULT (0) FOR [ProgressThreadCount]
GO
ALTER TABLE [dbo].[spb_VoteUserDatas] ADD  CONSTRAINT [DF_spb_VoteUserDatas_MostRecentThreadID]  DEFAULT (0) FOR [MostRecentThreadID]
GO
ALTER TABLE [dbo].[spb_VoteUserDatas] ADD  CONSTRAINT [DF_spb_VoteUserDatas_MostRecent Subject]  DEFAULT ('') FOR [MostRecentSubject]
GO
ALTER TABLE [dbo].[spb_VoteUserDatas] ADD  CONSTRAINT [DF_spb_VoteUserDatas_MostRecentDateCreated]  DEFAULT (getdate()) FOR [MostRecentDateCreated]
GO
ALTER TABLE [dbo].[spb_Widgets] ADD  CONSTRAINT [DF_spb_Widgets_OwnerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_Widgets] ADD  CONSTRAINT [DF_spb_Widgets_IsBuiltIn]  DEFAULT (0) FOR [IsBuiltIn]
GO
ALTER TABLE [dbo].[spb_Widgets] ADD  CONSTRAINT [DF_spb_Widgets_ApplicationID]  DEFAULT (9999) FOR [ApplicationID]
GO
ALTER TABLE [dbo].[spb_Widgets] ADD  CONSTRAINT [DF_spb_Widgets_WidgetXml]  DEFAULT ('') FOR [WidgetXml]
GO
ALTER TABLE [dbo].[spb_WidgetsInZones] ADD  CONSTRAINT [DF_spb_WidgetsInZones_OwnerID]  DEFAULT (0) FOR [OwnerID]
GO
ALTER TABLE [dbo].[spb_WidgetsInZones] ADD  CONSTRAINT [DF_spb_WidgetsInZones_WidgetXml]  DEFAULT ('') FOR [WidgetXml]
GO
ALTER TABLE [dbo].[spb_WidgetZones] ADD  CONSTRAINT [DF_spb_WidgetZones_IsFrozen]  DEFAULT (0) FOR [IsFrozen]
GO
ALTER TABLE [dbo].[spb_BlogComments]  WITH NOCHECK ADD  CONSTRAINT [FK_spb_BlogPosts_spb_BlogThreads] FOREIGN KEY([ThreadID])
REFERENCES [dbo].[spb_BlogThreads] ([ThreadID])
GO
ALTER TABLE [dbo].[spb_BlogComments] CHECK CONSTRAINT [FK_spb_BlogPosts_spb_BlogThreads]
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile]  WITH NOCHECK ADD  CONSTRAINT [FK_spb_CompanyUserProfile_spb_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[spb_Users] ([UserID])
GO
ALTER TABLE [dbo].[spb_CompanyUserProfile] CHECK CONSTRAINT [FK_spb_CompanyUserProfile_spb_Users]
GO
ALTER TABLE [dbo].[spb_PersonUserProfile]  WITH NOCHECK ADD  CONSTRAINT [FK_spb_PersonUserProfile_spb_Users] FOREIGN KEY([UserID])
REFERENCES [dbo].[spb_Users] ([UserID])
GO
ALTER TABLE [dbo].[spb_PersonUserProfile] CHECK CONSTRAINT [FK_spb_PersonUserProfile_spb_Users]
GO
ALTER TABLE [dbo].[spb_ThemeAppearances]  WITH NOCHECK ADD  CONSTRAINT [FK_spb_ThemeAppearances_spb_ThemeAppearances] FOREIGN KEY([PresentAreaID], [Theme], [DirectoryName])
REFERENCES [dbo].[spb_ThemeAppearances] ([PresentAreaID], [Theme], [DirectoryName])
GO
ALTER TABLE [dbo].[spb_ThemeAppearances] CHECK CONSTRAINT [FK_spb_ThemeAppearances_spb_ThemeAppearances]
GO
